/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.chunk.LevelChunk;

public class Misc {
    public static double getMouseX(Minecraft mc, boolean raw) {
        if (raw) {
            return mc.mouseHandler.xpos();
        }
        return mc.mouseHandler.xpos() * (double)mc.getWindow().getWidth() / (double)mc.getWindow().getScreenWidth();
    }

    public static double getMouseY(Minecraft mc, boolean raw) {
        if (raw) {
            return mc.mouseHandler.ypos();
        }
        return mc.mouseHandler.ypos() * (double)mc.getWindow().getHeight() / (double)mc.getWindow().getScreenHeight();
    }

    public static void drawNormalText(PoseStack matrices, String name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Minecraft.getInstance().font.drawInBatch(name, x, y, color, shadow, matrices.last().pose(), (MultiBufferSource)renderTypeBuffer, false, 0, 0xF000F0);
    }

    public static void drawNormalText(PoseStack matrices, Component name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Minecraft.getInstance().font.drawInBatch(name, x, y, color, shadow, matrices.last().pose(), (MultiBufferSource)renderTypeBuffer, false, 0, 0xF000F0);
    }

    public static void drawPiercingText(PoseStack matrices, String name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Minecraft.getInstance().font.drawInBatch(name, x, y, color, shadow, matrices.last().pose(), (MultiBufferSource)renderTypeBuffer, true, 0, 0xF000F0);
    }

    public static void drawPiercingText(PoseStack matrices, Component name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Minecraft.getInstance().font.drawInBatch(name, x, y, color, shadow, matrices.last().pose(), (MultiBufferSource)renderTypeBuffer, true, 0, 0xF000F0);
    }

    public static void drawCenteredPiercingText(PoseStack matrices, String name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.getInstance().font.width(name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static void drawCenteredPiercingText(PoseStack matrices, Component name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.getInstance().font.width((FormattedText)name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static long getChunkPosAsLong(LevelChunk chunk) {
        return chunk.getPos().toLong();
    }

    public static boolean hasItem(Player player, Item item) {
        return Misc.hasItem((NonNullList<ItemStack>)player.getInventory().offhand, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.getInventory().armor, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.getInventory().items, 9, item);
    }

    public static boolean hasItem(NonNullList<ItemStack> inventory, int limit, Item item) {
        for (int i = 0; i < inventory.size() && (limit == -1 || i < limit); ++i) {
            if (inventory.get(i) == null || ((ItemStack)inventory.get(i)).getItem() != item) continue;
            return true;
        }
        return false;
    }

    public static Component getFixedDisplayName(Entity e) {
        Component baseName = e.getName();
        if (baseName == null) {
            return null;
        }
        return e.getTeam() == null ? baseName.copy() : e.getTeam().getFormattedName((Component)baseName.copy());
    }

    public static boolean hasEffect(Player player, MobEffect effect) {
        return effect != null && player.hasEffect(effect);
    }

    public static boolean hasEffect(MobEffect effect) {
        return Misc.hasEffect((Player)Minecraft.getInstance().player, effect);
    }
}

