/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui.entry;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector4f;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.category.ui.entry.EditorListEntry;
import xaero.hud.category.ui.entry.EditorListEntryWithRootReference;
import xaero.hud.category.ui.entry.EditorListRootEntry;
import xaero.hud.category.ui.entry.widget.EditorTextField;
import xaero.lib.client.gui.widget.Tooltip;

public class EditorListEntryWidget
extends EditorListEntryWithRootReference {
    protected AbstractWidget widget;
    private static final PoseStack WORKAROUND_IDENTITY_MATRIX_STACK = new PoseStack();
    private boolean widgetPressed;

    public EditorListEntryWidget(int entryX, int entryY, int entryW, int entryH, int index, GuiCategoryEditor.SettingRowList rowList, EditorListRootEntry root, AbstractWidget widget, Supplier<Tooltip> tooltipSupplier) {
        super(entryX, entryY, entryW, entryH, index, rowList, root, tooltipSupplier);
        this.widget = widget;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @Override
    public boolean mouseClicked(GuiCategoryEditor.SettingRowList.Entry entry, double relativeMouseX, double relativeMouseY, int i) {
        boolean result = super.mouseClicked(entry, relativeMouseX, relativeMouseY, i);
        if (result) {
            return true;
        }
        if (this.widget instanceof AbstractButton) {
            return false;
        }
        if (!this.widget.isMouseOver(relativeMouseX, relativeMouseY)) {
            return false;
        }
        this.widgetPressed = true;
        return this.widget.mouseClicked(relativeMouseX, relativeMouseY, i);
    }

    @Override
    public boolean mouseReleased(double relativeMouseX, double relativeMouseY, int i) {
        if (this.widgetPressed) {
            this.widget.mouseReleased(relativeMouseX, relativeMouseY, i);
        }
        this.widgetPressed = false;
        super.mouseReleased(relativeMouseX, relativeMouseY, i);
        return false;
    }

    @Override
    public boolean mouseDragged(double relativeMouseX, double relativeMouseY, int i, double f, double g) {
        if (this.widgetPressed && this.widget.mouseDragged(relativeMouseX, relativeMouseY, i, f, g)) {
            return true;
        }
        return super.mouseDragged(relativeMouseX, relativeMouseY, i, f, g);
    }

    @Override
    public boolean mouseScrolled(double relativeMouseX, double relativeMouseY, double f) {
        if (this.widget.isMouseOver(relativeMouseX, relativeMouseY) && this.widget.mouseScrolled(relativeMouseX, relativeMouseY, f)) {
            return true;
        }
        return super.mouseScrolled(relativeMouseX, relativeMouseY, f);
    }

    @Override
    public void mouseMoved(double relativeMouseX, double relativeMouseY) {
        this.widget.mouseMoved(relativeMouseX, relativeMouseY);
        super.mouseMoved(relativeMouseX, relativeMouseY);
    }

    @Override
    public boolean keyPressed(int i, int j, int k, boolean isRoot) {
        if (this.widget.keyPressed(i, j, k)) {
            return true;
        }
        return super.keyPressed(i, j, k, isRoot);
    }

    @Override
    public boolean keyReleased(int i, int j, int k) {
        if (this.widget.keyReleased(i, j, k)) {
            return true;
        }
        return super.keyReleased(i, j, k);
    }

    @Override
    public boolean charTyped(char c, int i) {
        if (this.widget.charTyped(c, i)) {
            return true;
        }
        return super.charTyped(c, i);
    }

    @Override
    public void tick() {
        if (this.widget instanceof EditBox) {
            ((EditBox)this.widget).tick();
        }
        super.tick();
    }

    @Override
    public String getNarration() {
        return super.getNarration();
    }

    @Override
    public String getHoverNarration() {
        return this.getNarration();
    }

    @Override
    public Component getMessage() {
        return this.widget.getMessage();
    }

    @Override
    public Component getNarrationMessage() {
        if (this.widget instanceof EditorTextField) {
            return ((EditorTextField)this.widget).createNarrationMessage();
        }
        if (this.widget instanceof AbstractSliderButton) {
            return Component.translatable((String)"gui.narrate.slider", (Object[])new Object[]{this.getMessage()});
        }
        return Component.translatable((String)"gui.narrate.button", (Object[])new Object[]{this.getMessage()});
    }

    @Override
    public EditorListEntry render(PoseStack poseStack, int index, int rowWidth, int rowHeight, int relativeMouseX, int relativeMouseY, boolean isMouseOver, float partialTicks, Font font, int globalMouseX, int globalMouseY, boolean includesSelected, boolean isRoot) {
        EditorListEntry result = super.render(poseStack, index, rowWidth, rowHeight, relativeMouseX, relativeMouseY, isMouseOver, partialTicks, font, globalMouseX, globalMouseY, includesSelected, isRoot);
        Vector4f widgetPos = new Vector4f((float)this.widget.x, (float)this.widget.y, 0.0f, 1.0f);
        widgetPos.transform(poseStack.last().pose());
        int xBU = this.widget.x;
        int yBU = this.widget.y;
        this.widget.x = (int)widgetPos.x();
        this.widget.y = (int)widgetPos.y();
        this.widget.render(WORKAROUND_IDENTITY_MATRIX_STACK, globalMouseX, globalMouseY, partialTicks);
        this.widget.x = xBU;
        this.widget.y = yBU;
        return this.widgetPressed ? null : result;
    }

    @Override
    public void changeFocus(boolean bl) {
        if (this.widget.active && this.widget.visible && this.widget.isFocused() != bl) {
            this.widget.changeFocus(bl);
        }
        super.changeFocus(bl);
    }

    @Override
    protected boolean selectAction() {
        if (!(this.widget instanceof AbstractButton) || !this.widget.active) {
            return false;
        }
        ((AbstractButton)this.widget).onPress();
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        return false;
    }
}

