/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.armor;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArmorStatusInventoryHelper {
    int getFullItemCount(Item item, LocalPlayer player) {
        int count = 0;
        for (ItemStack stack : player.getInventory().getNonEquipmentItems()) {
            if (stack == null || stack.getItem() != item) continue;
            count += stack.getCount();
        }
        ItemStack offhand = player.getItemBySlot(EquipmentSlot.OFFHAND);
        if (offhand != null && offhand.getItem() == item) {
            count += offhand.getCount();
        }
        return count;
    }

    ItemStack getArrowStack(Player player) {
        if (this.isArrows(player.getItemInHand(InteractionHand.OFF_HAND))) {
            return player.getItemInHand(InteractionHand.OFF_HAND);
        }
        if (this.isArrows(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            return player.getItemInHand(InteractionHand.MAIN_HAND);
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack itemstack = player.getInventory().getItem(i);
            if (!this.isArrows(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    boolean isArrows(ItemStack stack) {
        return stack != null && (stack.getItem() instanceof ArrowItem || stack.is(ItemTags.ARROWS));
    }

    EquipmentSlot getBowHand(LocalPlayer player) {
        ItemStack offhand = player.getItemBySlot(EquipmentSlot.OFFHAND);
        ItemStack mainhand = player.getItemBySlot(EquipmentSlot.MAINHAND);
        if (offhand != null && offhand.getItem() instanceof BowItem && (mainhand == null || !(mainhand.getItem() instanceof BowItem))) {
            return EquipmentSlot.OFFHAND;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack == null || !(stack.getItem() instanceof BowItem)) continue;
            return EquipmentSlot.MAINHAND;
        }
        return null;
    }
}

