/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.entityinfo;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.Collection;
import java.util.Random;
import net.minecraft.class_10017;
import net.minecraft.class_1058;
import net.minecraft.class_10725;
import net.minecraft.class_10799;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.joml.Matrix3x2fStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import xaero.common.misc.Misc;
import xaero.hud.pvp.module.entityinfo.EntityInfoSession;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;
import xaero.lib.client.render.util.GuiRenderUtil;
import xaero.pvp.BetterPVP;

public class EntityInfoRenderer
implements IModuleRenderer<EntityInfoSession> {
    public static final class_2960 HEART_CONTANER = class_2960.method_60654((String)"hud/heart/container_blinking");
    public static final class_2960 NORMAL_HEART_FULL = class_2960.method_60654((String)"hud/heart/full");
    public static final class_2960 NORMAL_HEART_HALF = class_2960.method_60654((String)"hud/heart/half");
    public static final class_2960 ABSORBING_HEART_FULL = class_2960.method_60654((String)"hud/heart/absorbing_full");
    public static final class_2960 ABSORBING_HEART_HALF = class_2960.method_60654((String)"hud/heart/absorbing_half");
    public static final class_2960 ARMOR_EMPTY = class_2960.method_60654((String)"hud/armor_empty");
    public static final class_2960 ARMOR_HALF = class_2960.method_60654((String)"hud/armor_half");
    public static final class_2960 ARMOR_FULL = class_2960.method_60654((String)"hud/armor_full");
    private final Random random = new Random();

    @Override
    public void render(EntityInfoSession session, ModuleRenderContext c, class_332 guiGraphics, float partialTicks) {
        class_1309 displayedEntity;
        class_310 mc = class_310.method_1551();
        long time = System.currentTimeMillis();
        class_3966 objectMouseOver = session.getDetector().getMouseOver(mc, (class_1937)mc.field_1687, session.getEntityInfoDistance(), partialTicks);
        if (objectMouseOver != null && objectMouseOver.method_17782() instanceof class_1309) {
            class_3218 serverWorld;
            session.setDisplayedEntity((class_1309)objectMouseOver.method_17782());
            if (mc.method_1576() != null && (serverWorld = mc.method_1576().method_3847(mc.field_1687.method_27983())) != null) {
                session.setDisplayedServerEntity((class_1309)serverWorld.method_66347(objectMouseOver.method_17782().method_5667()));
            }
            session.setLastDetection(time);
        }
        if ((displayedEntity = session.getDisplayedEntity()) == null) {
            return;
        }
        if (time - session.getLastDetection() > 1000L * (long)session.getEntityInfoStay()) {
            return;
        }
        if (System.currentTimeMillis() - session.getLastEffectBlink() > 500L) {
            session.setLastEffectBlink(System.currentTimeMillis());
            session.setEffectBlink(!session.getEffectBlink());
        }
        try {
            int healthOff;
            boolean flippedVer = c.flippedVertically;
            boolean flippedHor = c.flippedHorizontally;
            float resize = 1.0f;
            if (displayedEntity.method_17681() > resize) {
                resize = displayedEntity.method_17681();
            }
            if (displayedEntity.method_17682() > resize * 2.0f) {
                resize = displayedEntity.method_17682() / 2.0f;
            }
            if (session.getEntityInfoShowEntityModel()) {
                this.drawEntityOnScreen(mc, guiGraphics, c.x + (flippedHor ? c.w - 25 : 25), c.y + 35, (int)(30.0f / resize), displayedEntity, flippedHor);
            }
            class_1309 displayedServerEntity = session.getDisplayedServerEntity();
            int n = healthOff = session.getEntityInfoShowEntityModel() ? 55 : 5;
            if (mc.method_1576() != null && session.getEntityInfoEffects() && displayedServerEntity != null) {
                int effectsOffset = (int)this.drawPotionEffects(mc, guiGraphics, session, displayedServerEntity, c.x + (flippedHor ? c.w - 3 : 3), c.y + (flippedVer ? c.h - 5 : 5), flippedVer ? c.y + c.h : c.screenHeight - c.y, flippedHor, flippedVer, c.screenScale);
                if (!session.getEntityInfoShowEntityModel() && effectsOffset != -1) {
                    healthOff += 3 + effectsOffset;
                }
            }
            boolean renderedArmor = session.getEntityInfoShowArmour() && this.drawArmourBar(mc, guiGraphics, session, displayedEntity, c.x + (flippedHor ? c.w - healthOff : healthOff), c.y + 15 + (flippedVer ? 31 : 0), flippedHor);
            this.drawHealthBar(mc, guiGraphics, session, displayedEntity, c.x + (flippedHor ? c.w - healthOff : healthOff), c.y + 15 + (flippedVer ? 31 : 0) + (renderedArmor ? 10 : 0) * (flippedVer ? -1 : 1), flippedHor, flippedVer);
            class_2561 component = Misc.getFixedDisplayName((class_1297)displayedEntity);
            if (component != null) {
                String name = component.getString();
                int xCoord = c.x + (flippedHor ? c.w - healthOff - mc.field_1772.method_1727(name) : healthOff);
                guiGraphics.method_25303(mc.field_1772, name, xCoord, c.y + 5 + (flippedVer ? 52 : 0), -1);
            }
        }
        catch (Exception e) {
            BetterPVP.LOGGER.error("Please report this to Xaero96 on PlanetMinecraft/MinecraftForums/CurseForge!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawEntityOnScreen(class_310 mc, class_332 guiGraphics, int x, int y, int scale, class_1309 entity, boolean flip) {
        double cos;
        if (entity == null) {
            return;
        }
        class_898 rendermanager = mc.method_1561();
        if (rendermanager.field_4686 == null) {
            return;
        }
        float yBodyRotBU = entity.field_6283;
        float yRotBU = entity.method_36454();
        float yHeadRotBU = entity.field_6241;
        entity.field_6283 = 0.0f;
        entity.method_36456(0.0f);
        entity.field_6241 = yHeadRotBU - yBodyRotBU;
        Quaternionf rotation = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf xRotation = new Quaternionf().rotateX(-0.5235988f);
        rotation.mul((Quaternionfc)xRotation);
        float width = entity.method_17681() * (float)scale / 30.0f;
        if (width < 1.0f) {
            width = 1.0f;
        }
        if ((cos = Math.sqrt(2.0) / 2.0 / (double)width) > 1.0) {
            cos = 1.0;
        }
        float yAngle = (float)Math.toDegrees(Math.acos(cos));
        Quaternionf yRotation = new Quaternionf().rotateY((float)((double)(180.0f + (flip ? -yAngle : yAngle)) * (Math.PI / 180)));
        rotation.mul((Quaternionfc)yRotation);
        Vector3f translation = new Vector3f(0.0f, entity.method_17682() / 2.0f, 0.0f);
        class_897 entityRenderer = rendermanager.method_3953((class_1297)entity);
        try {
            class_10017 entityRenderState = entityRenderer.method_62425((class_1297)entity, 1.0f);
            guiGraphics.method_70856(entityRenderState, (float)scale / entity.method_55693(), translation, rotation, null, x - 25, y - 35, x + 25, y + 35);
        }
        finally {
            entity.field_6283 = yBodyRotBU;
            entity.method_36456(yRotBU);
            entity.field_6241 = yHeadRotBU;
        }
    }

    public boolean drawArmourBar(class_310 mc, class_332 guiGraphics, EntityInfoSession session, class_1309 e, int x, int y, boolean flip) {
        int armorValue = e.method_6096();
        if (armorValue > 0) {
            if (session.getEntityInfoArmourNumbers()) {
                guiGraphics.method_52706(class_10799.field_56883, ARMOR_FULL, x - (flip ? 8 : 0), y, 9, 9);
                guiGraphics.method_25303(mc.field_1772, armorValue + "/20", x + (flip ? -11 - mc.field_1772.method_1727(armorValue + "/20") : 11), y, -1);
            } else {
                for (int iconIndex = 0; iconIndex < 10; ++iconIndex) {
                    int iconX = x + (flip ? -8 - iconIndex * 8 : iconIndex * 8);
                    if (iconIndex * 2 + 1 < armorValue) {
                        guiGraphics.method_52706(class_10799.field_56883, ARMOR_FULL, iconX, y, 9, 9);
                        continue;
                    }
                    if (iconIndex * 2 + 1 == armorValue) {
                        guiGraphics.method_52706(class_10799.field_56883, ARMOR_HALF, iconX, y, 9, 9);
                        continue;
                    }
                    if (iconIndex * 2 + 1 <= armorValue) continue;
                    guiGraphics.method_52706(class_10799.field_56883, ARMOR_EMPTY, iconX, y, 9, 9);
                }
            }
            return true;
        }
        return false;
    }

    public void drawHealthBar(class_310 mc, class_332 guiGraphics, EntityInfoSession session, class_1309 e, int x, int y, boolean flip, boolean vertFlipped) {
        int health = class_3532.method_15386((float)e.method_6032());
        float maxHealth = class_3532.method_15384((double)e.method_45325(class_5134.field_23716));
        float absorptionAmount = class_3532.method_15386((float)e.method_6067());
        if (session.getEntityInfoHealthNumbers()) {
            String text = health + "/" + (int)maxHealth;
            if (absorptionAmount > 0.0f) {
                text = text + "+" + absorptionAmount;
                health = 0;
                maxHealth = 0.0f;
                absorptionAmount = 2.0f;
            } else {
                health = 2;
                maxHealth = 2.0f;
                absorptionAmount = 0.0f;
            }
            guiGraphics.method_25303(mc.field_1772, text, x + (flip ? -11 - mc.field_1772.method_1727(text) : 11), y, -1);
        }
        int regularHalvesToRender = (int)(maxHealth + 1.0f) / 2 * 2;
        int regularFilledHalves = health;
        int absorptionHalvesToRender = (int)(absorptionAmount + 1.0f) / 2 * 2;
        int absorptionFilledHalves = (int)absorptionAmount;
        int limit = (int)session.getEntityInfoMaxHearts() * 2;
        if (regularHalvesToRender > limit) {
            regularHalvesToRender = limit;
            int n = regularFilledHalves = maxHealth == 0.0f ? 0 : Math.round((float)(health * regularHalvesToRender) / maxHealth);
        }
        if (absorptionHalvesToRender > limit) {
            absorptionHalvesToRender = absorptionFilledHalves = limit;
        }
        int totalHalvesToRender = regularHalvesToRender + absorptionHalvesToRender;
        int rows = class_3532.method_15386((float)((float)totalHalvesToRender / 20.0f));
        int rowStep = Math.max(10 - (rows - 2), 3);
        boolean shake = maxHealth != 0.0f && (double)health <= (double)maxHealth * 0.4;
        int absorptionLeft = absorptionFilledHalves;
        for (int heartIndex = totalHalvesToRender / 2 - 1; heartIndex >= 0; --heartIndex) {
            int rowIndex = (int)Math.ceil((float)(heartIndex + 1) / 10.0f) - 1;
            int xcoord = heartIndex % 10 * 8;
            int heartX = x + (flip ? -xcoord - 9 : xcoord);
            int heartY = y + rowIndex * rowStep * (vertFlipped ? -1 : 1);
            if (shake) {
                heartY += this.random.nextInt(2);
            }
            this.blitFlippable(mc, guiGraphics, HEART_CONTANER, heartX, heartY, 9, 9, flip);
            if (absorptionLeft > 0) {
                if (absorptionLeft == absorptionFilledHalves && absorptionFilledHalves % 2 == 1) {
                    this.blitFlippable(mc, guiGraphics, ABSORBING_HEART_HALF, heartX, heartY, 9, 9, flip);
                } else {
                    this.blitFlippable(mc, guiGraphics, ABSORBING_HEART_FULL, heartX, heartY, 9, 9, flip);
                }
                absorptionLeft -= 2;
                continue;
            }
            if (heartIndex * 2 + 1 < regularFilledHalves) {
                this.blitFlippable(mc, guiGraphics, NORMAL_HEART_FULL, heartX, heartY, 9, 9, flip);
            }
            if (heartIndex * 2 + 1 != regularFilledHalves) continue;
            this.blitFlippable(mc, guiGraphics, NORMAL_HEART_HALF, heartX, heartY, 9, 9, flip);
        }
    }

    public double drawPotionEffects(class_310 mc, class_332 guiGraphics, EntityInfoSession session, class_1309 e, int x, int y, int h, boolean flippedHor, boolean flippedVer, double scale) {
        Collection effects = e.method_6026();
        if (effects.isEmpty()) {
            return -1.0;
        }
        effects = Ordering.natural().sortedCopy((Iterable)effects);
        Matrix3x2fStack matrixStack = guiGraphics.method_51448();
        matrixStack.pushMatrix();
        matrixStack.translate((float)x, (float)y);
        double pixelSize = (double)session.getEntityInfoEffectsScale() / scale * session.getAutoUIScale() / 2.0;
        double effectSize = 25.0 * pixelSize;
        int perColumn = (int)((double)h / effectSize);
        int place = 0;
        for (class_1293 pe : effects) {
            class_2960 sprite;
            if (pe == null || (sprite = class_329.method_71644((class_6880)pe.method_5579())) == null) continue;
            matrixStack.pushMatrix();
            matrixStack.scale((float)pixelSize, (float)pixelSize);
            int column = place / perColumn;
            int row = place % perColumn;
            matrixStack.translate(flippedHor ? (float)(-18 - 25 * column) : (float)(25 * column), flippedVer ? (float)(-18 - 25 * row) : (float)(25 * row));
            int color = -1;
            if (!pe.method_48559() && pe.method_5584() <= 200 && !session.getEffectBlink()) {
                color = 0x66FFFFFF;
            }
            guiGraphics.method_52707(class_10799.field_56883, sprite, 0, 0, 18, 18, color);
            ++place;
            matrixStack.popMatrix();
        }
        matrixStack.popMatrix();
        int rows = (effects.size() + perColumn - 1) / perColumn;
        return effectSize * (double)rows - 7.0 * pixelSize;
    }

    public void blitFlippable(class_310 mc, class_332 guiGraphics, class_2960 sprite, int x, int y, int width, int height, boolean flip) {
        class_1058 textureAtlasSprite = mc.method_72703().method_73025(class_10725.field_56385).method_4608(sprite);
        class_2960 textureLocation = textureAtlasSprite.method_45852();
        GpuTextureView texture = mc.method_1531().method_4619(textureLocation).method_71659();
        float u0 = flip ? textureAtlasSprite.method_4577() : textureAtlasSprite.method_4594();
        float u1 = flip ? textureAtlasSprite.method_4594() : textureAtlasSprite.method_4577();
        GuiRenderUtil.submitBlit((class_332)guiGraphics, (RenderPipeline)class_10799.field_56883, (GpuTextureView)texture, (int)x, (int)y, (int)(x + width), (int)(y + height), (float)u0, (float)u1, (float)textureAtlasSprite.method_4593(), (float)textureAtlasSprite.method_4575(), (int)-1);
    }
}

