/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.effect;

import com.google.common.collect.Ordering;
import java.util.Collection;
import net.minecraft.class_10799;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import xaero.hud.pvp.module.effect.StatusEffectSession;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class StatusEffectRenderer
implements IModuleRenderer<StatusEffectSession> {
    @Override
    public void render(StatusEffectSession session, ModuleRenderContext c, class_332 guiGraphics, float partialTicks) {
        class_310 mc = class_310.method_1551();
        if (!mc.field_1724.method_6026().isEmpty()) {
            this.renderEffects(session, guiGraphics, c, mc);
        }
    }

    private void renderEffects(StatusEffectSession session, class_332 guiGraphics, ModuleRenderContext c, class_310 mc) {
        Collection effects;
        if (c.flippedVertically) {
            c.y = c.y + c.h - 30;
        }
        if ((effects = mc.field_1724.method_6026()).isEmpty()) {
            return;
        }
        effects = Ordering.natural().sortedCopy((Iterable)effects);
        if (session.isBlinkEnabled() && System.currentTimeMillis() - session.getLastBlink() > 500L) {
            session.setLastBlink(System.currentTimeMillis());
            session.setBlink(!session.getBlink());
        }
        if (session.isCentered()) {
            this.renderCentered(session, guiGraphics, c, mc, effects);
            return;
        }
        this.renderNormal(session, guiGraphics, c, mc, effects);
    }

    private void renderCentered(StatusEffectSession session, class_332 guiGraphics, ModuleRenderContext c, class_310 mc, Collection<class_1293> effects) {
        int columnWidth = 27;
        int defaultEffectAmount = 182 / columnWidth;
        if (effects.size() > defaultEffectAmount) {
            columnWidth = 182 / effects.size();
        }
        int totalSize = effects.size() * columnWidth;
        int firstColumn = c.x + c.w / 2 + totalSize / 2 * (c.flippedHorizontally ? 1 : -1);
        if (c.flippedHorizontally) {
            firstColumn -= columnWidth;
        }
        int currentX = firstColumn + (columnWidth - 18) / 2;
        int currentY = c.y + 7;
        for (class_1293 effectInstance : effects) {
            class_6880 effect;
            class_2960 effectSprite;
            int duration = effectInstance.method_5584();
            int color = -1;
            if (!effectInstance.method_48559() && duration <= 200 && !session.getBlink() && session.isBlinkEnabled()) {
                color = 0x33FFFFFF;
            }
            if ((effectSprite = class_329.method_71644((class_6880)(effect = effectInstance.method_5579()))) != null) {
                guiGraphics.method_52707(class_10799.field_56883, effectSprite, currentX, currentY, 18, 18, color);
            }
            class_2561 durationString = class_1292.method_5577((class_1293)effectInstance, (float)1.0f, (float)mc.field_1687.method_54719().method_54748());
            int amplifier = effectInstance.method_5578();
            String levelString = amplifier > 0 ? "" + (effectInstance.method_5578() + 1) : "";
            guiGraphics.method_25303(mc.field_1772, levelString, currentX, currentY, -1);
            guiGraphics.method_27535(mc.field_1772, durationString, currentX + 10 - mc.field_1772.method_27525((class_5348)durationString) / 2, currentY + 15, -1);
            currentX += columnWidth * (c.flippedHorizontally ? -1 : 1);
        }
    }

    private void renderNormal(StatusEffectSession session, class_332 guiGraphics, ModuleRenderContext c, class_310 mc, Collection<class_1293> effects) {
        int rowHeight = 25;
        if (effects.size() > 6) {
            rowHeight = 135 / (effects.size() - 1);
        }
        for (class_1293 effectInstance : effects) {
            class_2561 potionName;
            class_6880 effect;
            class_2960 effectSprite;
            int duration = effectInstance.method_5584();
            int color = -1;
            if (!effectInstance.method_48559() && duration <= 200 && !session.getBlink() && session.isBlinkEnabled()) {
                color = 0x33FFFFFF;
            }
            if ((effectSprite = class_329.method_71644((class_6880)(effect = effectInstance.method_5579()))) != null) {
                guiGraphics.method_52707(class_10799.field_56883, effectSprite, c.flippedHorizontally ? c.x + c.w - 24 : c.x + 6, c.y + 7, 18, 18, color);
            }
            class_2561 durationString = class_1292.method_5577((class_1293)effectInstance, (float)1.0f, (float)mc.field_1687.method_54719().method_54748());
            if (!session.shouldShowNames()) {
                potionName = durationString;
                durationString = null;
            } else {
                potionName = class_2561.method_43471((String)((class_1291)effect.comp_349()).method_5567());
                if (effectInstance.method_5578() >= 1 && effectInstance.method_5578() <= 9) {
                    potionName.method_10855().add(class_2561.method_43470((String)" "));
                    potionName.method_10855().add(class_2561.method_43471((String)("enchantment.level." + (effectInstance.method_5578() + 1))));
                }
            }
            int amplifier = effectInstance.method_5578();
            String levelString = amplifier > 0 ? "" + (effectInstance.method_5578() + 1) : "";
            guiGraphics.method_25303(mc.field_1772, levelString, c.flippedHorizontally ? c.x + c.w - 24 : c.x + 6, c.y + 7, -1);
            guiGraphics.method_27535(mc.field_1772, potionName, c.flippedHorizontally ? c.x + c.w - 28 - mc.field_1772.method_27525((class_5348)potionName) : c.x + 10 + 18, c.y + 7, -1);
            if (durationString != null) {
                guiGraphics.method_27535(mc.field_1772, durationString, c.flippedHorizontally ? c.x + c.w - 28 - mc.field_1772.method_27525((class_5348)durationString) : c.x + 10 + 18, c.y + 7 + 10, -1);
            }
            c.y = c.y + (c.flippedVertically ? -rowHeight : rowHeight);
        }
    }
}

