/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.icon.XaeroIcon;
import xaero.common.icon.XaeroIconAtlas;
import xaero.common.icon.XaeroIconAtlasManager;
import xaero.common.misc.Misc;
import xaero.hud.compat.mods.ImmediatelyFastHelper;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.RadarIconManager;
import xaero.hud.minimap.radar.icon.creator.render.form.IRadarIconFormPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.trace.EntityRenderTracer;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.hud.minimap.radar.icon.definition.form.RadarIconForm;
import xaero.hud.minimap.radar.icon.definition.form.model.config.RadarIconModelConfig;
import xaero.lib.client.graphics.util.ImmediateRenderUtil;

public class RadarIconCreator {
    private static final int PREFERRED_ATLAS_WIDTH = 1024;
    public static final int ICON_WIDTH = 64;
    public static final int FAR_PLANE = 500;
    private MatrixStack matrixStack = new MatrixStack();
    private ImprovedFramebuffer formRenderFramebuffer;
    private ImprovedFramebuffer iconRenderFramebuffer;
    private ImprovedFramebuffer atlasRenderFramebuffer;
    private final EntityRenderTracer renderTracer = new EntityRenderTracer();
    private final XaeroIconAtlasManager iconAtlasManager;

    public RadarIconCreator() {
        int maxTextureSize = GlStateManager.func_227612_D_((int)3379);
        int atlasTextureSize = Math.min(maxTextureSize, 1024) / 64 * 64;
        this.iconAtlasManager = new XaeroIconAtlasManager(64, atlasTextureSize, new ArrayList<XaeroIconAtlas>());
        this.initFramebuffers(atlasTextureSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entity> XaeroIcon create(EntityRenderer<? super T> entityRenderer, T entity, Framebuffer defaultFramebuffer, Parameters parameters) {
        IRadarIconFormPrerenderer formPrerenderer = parameters.form.getPrerenderer();
        if (formPrerenderer == null) {
            MinimapLogs.LOGGER.error("Tried prerendering radar icon for {} variant {} but the icon form used doesn't have a prerenderer!", (Object)EntityType.func_200718_a((EntityType)entity.func_200600_R()), parameters.variant);
            return RadarIconManager.FAILED;
        }
        OpenGLException.checkGLError();
        MatrixStack matrixStack = this.matrixStack;
        Minecraft.func_71410_x().func_228019_au_().func_228487_b_().func_228461_a_();
        ImmediatelyFastHelper.triggerBatchingBuffersFlush(matrixStack);
        this.formRenderFramebuffer.bindAsMainTarget(true);
        this.setupMatrices(64, 500);
        OpenGLException.checkGLError();
        List<ModelRenderTrace> traceResult = null;
        EntityModel<? super T> entityModel = null;
        if (formPrerenderer.requiresEntityModel()) {
            GlStateManager.func_227771_z_();
            if (Minecraft.func_71410_x().func_175598_ae().field_217783_c != null) {
                traceResult = this.renderTracer.trace(matrixStack, entity, entityRenderer);
                this.formRenderFramebuffer.bindAsMainTarget(true);
            } else {
                MinimapLogs.LOGGER.info("Render info was null for entity " + entity.func_195047_I_());
            }
            entityModel = this.renderTracer.getEntityRendererModel(entityRenderer);
            if (entityModel == null) {
                this.endFormRendering();
                this.bindDefaultFramebuffer(defaultFramebuffer);
                this.restoreMatrices(defaultFramebuffer);
                return RadarIconManager.FAILED;
            }
        }
        boolean formRenderResult = false;
        MatrixStack.Entry matrixEntryToRestore = matrixStack.func_227866_c_();
        matrixStack.func_227860_a_();
        try {
            GlStateManager.func_227700_d_();
            GlStateManager.func_227673_b_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_227658_a_((int)16640, (boolean)Minecraft.field_142025_a);
            GlStateManager.func_227734_k_();
            formRenderResult = formPrerenderer.prerender(matrixStack, entityRenderer, entityModel, entity, traceResult, parameters);
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("Exception using the radar icon form prerenderer for entity {} variant {}!", (Object)EntityType.func_200718_a((EntityType)entity.func_200600_R()), parameters.variant, (Object)t);
        }
        finally {
            Minecraft.func_71410_x().func_228019_au_().func_228487_b_().func_228461_a_();
            while (matrixStack.func_227866_c_() != matrixEntryToRestore) {
                matrixStack.func_227865_b_();
            }
        }
        this.endFormRendering();
        XaeroIcon icon = parameters.form.getFailureResult();
        if (formRenderResult) {
            icon = this.getFinalIcon(matrixStack, entity, formPrerenderer, parameters);
        }
        this.restoreMatrices(defaultFramebuffer);
        this.atlasRenderFramebuffer.func_147609_e();
        this.bindDefaultFramebuffer(defaultFramebuffer);
        return icon;
    }

    private XaeroIcon getFinalIcon(MatrixStack matrixStack, Entity entity, IRadarIconFormPrerenderer formPrerenderer, Parameters parameters) {
        this.iconRenderFramebuffer.bindAsMainTarget(true);
        GlStateManager.func_227673_b_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_227658_a_((int)16384, (boolean)Minecraft.field_142025_a);
        GlStateManager.func_227737_l_();
        if (parameters.debug) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(18.0, 10.0, -10.0);
            matrixStack.func_227862_a_(1.0f, 1.0f, 1.0f);
            ImmediateRenderUtil.coloredRectangle((MatrixStack)matrixStack, (float)0.0f, (float)0.0f, (float)9.0f, (float)9.0f, (int)-16776961);
            matrixStack.func_227865_b_();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        }
        this.formRenderFramebuffer.func_147612_c();
        boolean outlined = formPrerenderer.isOutlined();
        boolean flipped = formPrerenderer.isFlipped();
        if (outlined) {
            this.renderOutline(matrixStack);
        }
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227737_l_();
        ImmediateRenderUtil.texturedRect((MatrixStack)matrixStack, (float)0.0f, (float)0.0f, (int)0, (int)0, (float)64.0f, (float)64.0f, (float)64.0f, (float)64.0f);
        RenderSystem.defaultAlphaFunc();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        if (parameters.debug) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(27.0, 10.0, -10.0);
            matrixStack.func_227862_a_(1.0f, 1.0f, 1.0f);
            ImmediateRenderUtil.coloredRectangle((MatrixStack)matrixStack, (float)0.0f, (float)0.0f, (float)9.0f, (float)9.0f, (int)-16711681);
            matrixStack.func_227865_b_();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        }
        GlStateManager.func_227740_m_();
        this.iconRenderFramebuffer.func_147609_e();
        this.iconRenderFramebuffer.func_147612_c();
        this.iconRenderFramebuffer.generateMipmaps();
        GlStateManager.func_227760_t_((int)0);
        XaeroIcon icon = null;
        try {
            XaeroIconAtlas atlas = this.getCurrentAtlas();
            icon = atlas.createIcon();
            this.atlasRenderFramebuffer.bindAsMainTarget(false);
            GlStateManager.func_227714_e_((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)64, (int)64);
            this.atlasRenderFramebuffer.setFramebufferTexture(atlas.getTextureId());
            this.atlasRenderFramebuffer.func_147611_b();
            this.iconRenderFramebuffer.func_147612_c();
            GlStateManager.func_227700_d_();
            GlStateManager.func_227737_l_();
            if (flipped) {
                ImmediateRenderUtil.texturedRect((MatrixStack)matrixStack, (float)0.0f, (float)0.0f, (int)0, (int)64, (float)64.0f, (float)64.0f, (float)-64.0f, (float)64.0f);
            } else {
                ImmediateRenderUtil.texturedRect((MatrixStack)matrixStack, (float)0.0f, (float)0.0f, (int)0, (int)0, (float)64.0f, (float)64.0f, (float)64.0f, (float)64.0f);
            }
            if (parameters.debug) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(36.0, 10.0, -10.0);
                matrixStack.func_227862_a_(1.0f, 1.0f, 1.0f);
                ImmediateRenderUtil.coloredRectangle((MatrixStack)matrixStack, (float)0.0f, (float)0.0f, (float)9.0f, (float)9.0f, (int)-256);
                matrixStack.func_227865_b_();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("Exception rendering to a entity icon atlas for {} {}!", (Object)EntityType.func_200718_a((EntityType)entity.func_200600_R()), parameters.variant, (Object)t);
        }
        GlStateManager.func_227709_e_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227760_t_((int)0);
        return icon;
    }

    private void renderOutline(MatrixStack matrixStack) {
        GlStateManager.func_227702_d_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_227709_e_();
        GlStateManager.func_227639_a_((int)516, (float)0.05f);
        GlStateManager.func_227740_m_();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)1);
        for (int shadowOffsetX = -1; shadowOffsetX < 2; ++shadowOffsetX) {
            for (int shadowOffsetY = -1; shadowOffsetY < 2; ++shadowOffsetY) {
                if (shadowOffsetX == 0 && shadowOffsetY == 0) continue;
                ImmediateRenderUtil.drawOutlineLayer((MatrixStack)matrixStack, (float)shadowOffsetX, (float)shadowOffsetY, (int)0, (int)0, (float)64.0f, (float)64.0f, (float)64.0f, (float)64.0f);
            }
        }
    }

    private void setupMatrices(int finalIconSize, int farPlane) {
        GlStateManager.func_227768_x_((int)5889);
        GlStateManager.func_227625_M_();
        GlStateManager.func_227633_a_((double)0.0, (double)finalIconSize, (double)finalIconSize, (double)0.0, (double)-1.0, (double)farPlane);
        GlStateManager.func_227768_x_((int)5888);
        GlStateManager.func_227626_N_();
        GlStateManager.func_227625_M_();
    }

    private void restoreMatrices(Framebuffer framebuffer) {
        GlStateManager.func_227627_O_();
        GlStateManager.func_227768_x_((int)5889);
        Misc.defaultOrtho(framebuffer, false);
        GlStateManager.func_227768_x_((int)5888);
    }

    private void endFormRendering() {
        this.formRenderFramebuffer.func_147609_e();
        GlStateManager.func_227740_m_();
        RenderHelper.func_227784_d_();
        RenderHelper.func_74518_a();
        GlStateManager.func_227709_e_();
        GlStateManager.func_227639_a_((int)516, (float)0.0f);
    }

    private void bindDefaultFramebuffer(Framebuffer defaultFramebuffer) {
        if (defaultFramebuffer != null) {
            if (defaultFramebuffer instanceof ImprovedFramebuffer) {
                ((ImprovedFramebuffer)defaultFramebuffer).bindAsMainTarget(true);
                return;
            }
            ImprovedFramebuffer.restoreMainRenderTarget();
            defaultFramebuffer.func_147610_a(true);
            return;
        }
        ImprovedFramebuffer.bindDefaultFramebuffer(this.atlasRenderFramebuffer.getType(), 36160, Minecraft.func_71410_x());
        GlStateManager.func_227714_e_((int)0, (int)0, (int)Minecraft.func_71410_x().func_228018_at_().func_198109_k(), (int)Minecraft.func_71410_x().func_228018_at_().func_198091_l());
    }

    public void clearAtlases() {
        this.iconAtlasManager.clearAtlases();
        this.atlasRenderFramebuffer.setFramebufferTexture(0);
    }

    public EntityRenderTracer getRenderTracer() {
        return this.renderTracer;
    }

    private XaeroIconAtlas getCurrentAtlas() {
        return this.iconAtlasManager.getCurrentAtlas();
    }

    private void initFramebuffers(int atlasTextureSize) {
        this.formRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
        OpenGLException.checkGLError();
        this.iconRenderFramebuffer = new ImprovedFramebuffer(512, 512, false);
        OpenGLException.checkGLError();
        this.formRenderFramebuffer.func_147612_c();
        OpenGLException.checkGLError();
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.func_227647_a_((int)3553, (int)0, (int)32856, (int)this.formRenderFramebuffer.field_147621_c, (int)this.formRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.func_227760_t_((int)0);
        this.iconRenderFramebuffer.func_147612_c();
        GL11.glTexParameteri((int)3553, (int)33085, (int)3);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        if (!GL.getCapabilities().OpenGL30) {
            GL11.glTexParameteri((int)3553, (int)33169, (int)1);
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.func_227647_a_((int)3553, (int)0, (int)32856, (int)this.iconRenderFramebuffer.field_147621_c, (int)this.iconRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.func_227760_t_((int)0);
        this.atlasRenderFramebuffer = new ImprovedFramebuffer(atlasTextureSize, atlasTextureSize, false);
        OpenGLException.checkGLError();
        GlStateManager.func_227758_s_((int)this.atlasRenderFramebuffer.getFramebufferTexture());
        this.atlasRenderFramebuffer.setFramebufferTexture(0);
        OpenGLException.checkGLError();
    }

    public static class Parameters {
        public final Object variant;
        public final float scale;
        public final RadarIconModelConfig defaultModelConfig;
        public final RadarIconForm form;
        public final boolean debug;

        public Parameters(Object variant, RadarIconModelConfig defaultModelConfig, RadarIconForm form, float scale, boolean debug) {
            this.variant = variant;
            this.scale = scale;
            this.defaultModelConfig = defaultModelConfig;
            this.form = form;
            this.debug = debug;
        }
    }
}

