/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui;

import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.text.ITextComponent;
import xaero.hud.category.ObjectCategory;
import xaero.hud.category.setting.ObjectCategorySetting;
import xaero.hud.category.ui.node.options.range.setting.EditorCompactSettingNode;
import xaero.hud.category.ui.setting.EditorSettingType;
import xaero.lib.client.gui.CustomSettingEntry;

public class RootCategorySettingEntry<T>
extends CustomSettingEntry<T> {
    private final Supplier<ObjectCategory<?, ?>> rootCategorySupplier;

    public RootCategorySettingEntry(ObjectCategorySetting<T> setting, Supplier<ObjectCategory<?, ?>> rootCategorySupplier, BooleanSupplier allowNull) {
        this(rootCategorySupplier, allowNull, setting, null);
    }

    public RootCategorySettingEntry(Supplier<ObjectCategory<?, ?>> rootCategorySupplier, BooleanSupplier allowNull, ObjectCategorySetting<T> setting, ITextComponent customName) {
        this(rootCategorySupplier, allowNull, setting, customName, null);
    }

    public RootCategorySettingEntry(final Supplier<ObjectCategory<?, ?>> rootCategorySupplier, BooleanSupplier allowNull, final ObjectCategorySetting<T> setting, ITextComponent customName, final BiConsumer<T, T> onValueChange) {
        super(allowNull, customName == null ? setting.getDisplayName() : customName, setting.getTooltip(), setting.getSettingUIType() == EditorSettingType.SLIDER, new Supplier<T>(){

            @Override
            public T get() {
                ObjectCategory editedCategory = (ObjectCategory)rootCategorySupplier.get();
                if (editedCategory == null) {
                    return null;
                }
                return editedCategory.getSettingValue(setting);
            }
        }, setting.getUiFirstOption(), setting.getUiLastOption(), setting.getIndexReader(), new Function<T, ITextComponent>(){

            @Override
            public ITextComponent apply(T v) {
                return EditorCompactSettingNode.getValueName(setting, v);
            }
        }, new BiConsumer<T, T>(){

            @Override
            public void accept(T oldValue, T newValue) {
                ObjectCategory editedCategory = (ObjectCategory)rootCategorySupplier.get();
                editedCategory.setSettingValue(setting, newValue);
                if (onValueChange != null) {
                    onValueChange.accept(oldValue, newValue);
                }
            }
        }, new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return rootCategorySupplier.get() != null;
            }
        });
        this.rootCategorySupplier = rootCategorySupplier;
    }

    public String getStringForSearch() {
        ObjectCategory<?, ?> editedCategory = this.rootCategorySupplier.get();
        if (editedCategory == null) {
            return "";
        }
        return super.getStringForSearch();
    }

    public GuiButton createWidget(int x, int y, int w, int screenWidth) {
        ObjectCategory<?, ?> editedCategory = this.rootCategorySupplier.get();
        if (editedCategory == null) {
            return null;
        }
        return super.createWidget(x, y, w, screenWidth);
    }
}

