/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui.node;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.common.misc.ListFactory;
import xaero.common.misc.MapFactory;
import xaero.hud.category.setting.ObjectCategorySetting;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.category.ui.entry.EditorListEntry;
import xaero.hud.category.ui.entry.EditorListEntryWidget;
import xaero.hud.category.ui.entry.EditorListRootEntry;
import xaero.hud.category.ui.entry.EditorListRootEntryFactory;
import xaero.hud.category.ui.entry.widget.EditorButton;
import xaero.hud.category.ui.node.EditorCategoryNode;
import xaero.hud.category.ui.node.EditorNode;
import xaero.hud.category.ui.node.options.EditorOptionsNode;
import xaero.hud.category.ui.node.options.EditorSimpleButtonNode;
import xaero.hud.category.ui.node.options.range.setting.IEditorSettingNode;
import xaero.hud.category.ui.node.options.range.setting.IEditorSettingNodeBuilder;
import xaero.hud.category.ui.node.options.text.EditorTextFieldOptionsNode;
import xaero.hud.category.ui.node.tooltip.IEditorDataTooltipSupplier;
import xaero.hud.category.ui.setting.SettingNodeBuilderFactoryManager;
import xaero.lib.client.gui.widget.Tooltip;

public class EditorSettingsNode<SETTING_DATA extends EditorOptionsNode<?>>
extends EditorNode {
    private final Map<ObjectCategorySetting<?>, SETTING_DATA> settings;
    private final List<SETTING_DATA> settingList;
    private boolean toBeDeleted;
    private final EditorSimpleButtonNode deleteButton;
    private final EditorSimpleButtonNode protectionButton;
    private final EditorTextFieldOptionsNode nameOption;
    private final ListFactory listFactory;
    private final boolean rootSettings;
    private boolean protection;

    protected EditorSettingsNode(@Nonnull Map<ObjectCategorySetting<?>, SETTING_DATA> settings, @Nonnull List<SETTING_DATA> settingList, @Nonnull EditorSimpleButtonNode deleteButton, @Nonnull EditorSimpleButtonNode protectionButton, @Nonnull EditorTextFieldOptionsNode nameOption, @Nonnull ListFactory listFactory, boolean rootSettings, boolean movable, @Nonnull EditorListRootEntryFactory listEntryFactory, IEditorDataTooltipSupplier tooltipSupplier, boolean protection) {
        super(movable, listEntryFactory, tooltipSupplier);
        this.settings = settings;
        this.settingList = settingList;
        this.listFactory = listFactory;
        this.rootSettings = rootSettings;
        this.deleteButton = deleteButton;
        this.protectionButton = protectionButton;
        this.nameOption = nameOption;
        this.protection = protection;
    }

    public Map<ObjectCategorySetting<?>, SETTING_DATA> getSettings() {
        return this.settings;
    }

    public IEditorSettingNode<?> getSettingData(ObjectCategorySetting<?> setting) {
        return (IEditorSettingNode)this.settings.get(setting);
    }

    public boolean isRootSettings() {
        return this.rootSettings;
    }

    public boolean isToBeDeleted() {
        return this.toBeDeleted;
    }

    public void setToBeDeleted() {
        this.toBeDeleted = true;
    }

    public boolean getProtection() {
        return this.protection;
    }

    public void setProtected(boolean protection) {
        this.protection = protection;
    }

    @Override
    public List<EditorNode> getSubNodes() {
        List<EditorNode> result = this.listFactory.get();
        result.addAll(this.settingList);
        if (!this.protection) {
            result.add(this.nameOption);
        }
        result.add(this.deleteButton);
        result.add(this.protectionButton);
        return result;
    }

    @Override
    public ITextComponent getDisplayName() {
        return new TextComponentTranslation("gui.xaero_category_settings", new Object[0]);
    }

    public EditorTextFieldOptionsNode getNameOption() {
        return this.nameOption;
    }

    public static final class FinalBuilder
    extends Builder<EditorSettingsNode<?>, FinalBuilder> {
        private FinalBuilder(MapFactory mapFactory, ListFactory listFactory, List<ObjectCategorySetting<?>> allSettings, SettingNodeBuilderFactoryManager settingNodeBuilderFactoryManager) {
            super(mapFactory, listFactory, allSettings, settingNodeBuilderFactoryManager);
        }

        @Override
        protected EditorSettingsNode<?> buildInternally(List<IEditorSettingNode<?>> builtSettingData, Map<ObjectCategorySetting<?>, IEditorSettingNode<?>> builtSettingsDataMap) {
            EditorSettingsNode result = new EditorSettingsNode(builtSettingsDataMap, builtSettingData, this.deleteButtonBuilder.build(), this.protectionButtonBuilder.build(), this.nameOptionBuilder.build(), this.listFactory, this.rootSettings, this.movable, this.listEntryFactory, this.tooltipSupplier, this.protection);
            return result;
        }
    }

    public static abstract class Builder<SD extends EditorSettingsNode<?>, SDB extends Builder<SD, SDB>>
    extends EditorNode.Builder<Builder<SD, SDB>> {
        protected final SDB self = this;
        protected final Map<ObjectCategorySetting<?>, IEditorSettingNodeBuilder<?, ?>> settingMap;
        protected final List<IEditorSettingNodeBuilder<?, ?>> settingList;
        protected final EditorSimpleButtonNode.Builder deleteButtonBuilder;
        protected final EditorSimpleButtonNode.Builder protectionButtonBuilder;
        protected final EditorTextFieldOptionsNode.Builder nameOptionBuilder;
        protected final MapFactory mapFactory;
        protected final ListFactory listFactory;
        protected boolean rootSettings;
        protected boolean protection;

        protected Builder(MapFactory mapFactory, ListFactory listFactory, List<ObjectCategorySetting<?>> allSettings, SettingNodeBuilderFactoryManager settingNodeBuilderFactoryManager) {
            this.settingMap = mapFactory.get();
            this.settingList = listFactory.get();
            this.deleteButtonBuilder = EditorSimpleButtonNode.Builder.begin();
            this.protectionButtonBuilder = EditorSimpleButtonNode.Builder.begin();
            this.nameOptionBuilder = EditorTextFieldOptionsNode.Builder.begin(listFactory);
            this.mapFactory = mapFactory;
            this.listFactory = listFactory;
            for (ObjectCategorySetting<?> setting : allSettings) {
                this.addSetting(setting, settingNodeBuilderFactoryManager);
            }
        }

        private <V> void addSetting(ObjectCategorySetting<V> setting, SettingNodeBuilderFactoryManager settingNodeBuilderFactoryManager) {
            IEditorSettingNodeBuilder builder = settingNodeBuilderFactoryManager.get(setting).apply(this.listFactory).setSetting(setting);
            this.settingMap.put(setting, builder);
            this.settingList.add(builder);
        }

        @Override
        public SDB setDefault() {
            super.setDefault();
            for (IEditorSettingNodeBuilder<?, ?> builder : this.settingList) {
                builder.setSettingValue(null);
            }
            this.setRootSettings(false);
            this.nameOptionBuilder.setDefault();
            this.deleteButtonBuilder.setDefault().setDisplayName((ITextComponent)new TextComponentTranslation("gui.xaero_category_delete", new Object[0])).setCallback(new EditorSimpleButtonNode.ISimpleButtonCallback(){

                @Override
                public void onButtonPress(EditorNode parent, EditorSimpleButtonNode bd, GuiCategoryEditor.SettingRowList rl) {
                    final EditorSettingsNode settings = (EditorSettingsNode)parent;
                    final Minecraft mc = Minecraft.func_71410_x();
                    final GuiScreen configScreen = mc.field_71462_r;
                    String confirmSecondLine = "\u00a7c" + I18n.func_135052_a((String)settings.getNameOption().getResult(), (Object[])new Object[0]);
                    mc.func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

                        public void func_73878_a(boolean result, int i) {
                            if (result) {
                                settings.setToBeDeleted();
                            }
                            mc.func_147108_a(configScreen);
                        }
                    }, I18n.func_135052_a((String)"gui.xaero_category_delete_confirm", (Object[])new Object[0]), confirmSecondLine, 0));
                }
            }).setIsActiveSupplier(new EditorSimpleButtonNode.ISimpleButtonIsActiveSupplier(){

                @Override
                public boolean get(EditorNode parent, EditorSimpleButtonNode data, GuiCategoryEditor.SettingRowList rowList) {
                    return !rowList.readOnly && !((EditorSettingsNode)parent).getProtection();
                }
            });
            this.protectionButtonBuilder.setDefault().setDisplayName((ITextComponent)new TextComponentString("")).setCallback(new EditorSimpleButtonNode.ISimpleButtonCallback(){

                @Override
                public void onButtonPress(EditorNode parent, EditorSimpleButtonNode bd, GuiCategoryEditor.SettingRowList rl) {
                    final EditorSettingsNode settings = (EditorSettingsNode)parent;
                    boolean currentlyProtected = settings.getProtection();
                    final Minecraft mc = Minecraft.func_71410_x();
                    final GuiScreen configScreen = mc.field_71462_r;
                    String confirmFirstLine = I18n.func_135052_a((String)(currentlyProtected ? "gui.xaero_category_disable_protection_confirm" : "gui.xaero_category_enable_protection_confirm"), (Object[])new Object[0]);
                    String confirmSecondLineColor = currentlyProtected ? "\u00a7c" : "\u00a7a";
                    String confirmSecondLine = confirmSecondLineColor + I18n.func_135052_a((String)settings.getNameOption().getResult(), (Object[])new Object[0]);
                    mc.func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

                        public void func_73878_a(boolean result, int i) {
                            if (result) {
                                settings.setProtected(!settings.getProtection());
                            }
                            mc.func_147108_a(configScreen);
                        }
                    }, confirmFirstLine, confirmSecondLine, 0));
                }
            }).setMessageSupplier(new EditorSimpleButtonNode.ISimpleButtonMessageSupplier(){

                @Override
                public Supplier<ITextComponent> get(final EditorNode parent, EditorSimpleButtonNode bd) {
                    return new Supplier<ITextComponent>(){

                        @Override
                        public ITextComponent get() {
                            return new TextComponentTranslation(((EditorSettingsNode)parent).getProtection() ? "gui.xaero_category_disable_protection" : "gui.xaero_category_enable_protection", new Object[0]);
                        }
                    };
                }
            }).setIsActiveSupplier(new EditorSimpleButtonNode.ISimpleButtonIsActiveSupplier(){

                @Override
                public boolean get(EditorNode parent, EditorSimpleButtonNode bd, GuiCategoryEditor.SettingRowList rowList) {
                    return !rowList.readOnly && !((EditorSettingsNode)parent).isRootSettings();
                }
            }).setTooltipSupplier(new IEditorDataTooltipSupplier(){

                @Override
                public Supplier<Tooltip> apply(EditorNode parent, EditorNode bd) {
                    return new Tooltip((ITextComponent)new TextComponentTranslation("gui.xaero_box_category_protection", new Object[0]));
                }
            });
            this.setTooltipSupplier(new IEditorDataTooltipSupplier(){

                @Override
                public Supplier<Tooltip> apply(EditorNode parent, EditorNode data) {
                    if (!(parent instanceof EditorCategoryNode)) {
                        return null;
                    }
                    EditorCategoryNode category = (EditorCategoryNode)parent;
                    ITextComponent displayNameComponent = category.getDisplayName();
                    Tooltip tooltip = new Tooltip((ITextComponent)new TextComponentTranslation("gui.xaero_box_category_settings", new Object[]{displayNameComponent}));
                    tooltip.setAutoLinebreak(false);
                    return tooltip;
                }
            });
            return this.self;
        }

        @Override
        protected EditorListRootEntry.CenteredEntryFactory getCenteredEntryFactory(final EditorNode data, final EditorNode parent, final int index, final GuiCategoryEditor.SettingRowList rowList) {
            return new EditorListRootEntry.CenteredEntryFactory(){

                @Override
                public EditorListEntry get(int x, int y, int width, int height, EditorListRootEntry root) {
                    EditorButton button = new EditorButton(parent, true, 216, 20, data, rowList);
                    return new EditorListEntryWidget(x, y, width, height, index, rowList, root, button, data.getTooltipSupplier(parent));
                }
            };
        }

        public <T> SDB setSettingValue(ObjectCategorySetting<T> setting, T value) {
            IEditorSettingNodeBuilder<?, ?> settingBuilder = this.settingMap.get(setting);
            settingBuilder.setSettingValue(value);
            return this.self;
        }

        public SDB setRootSettings(boolean rootSettings) {
            this.rootSettings = rootSettings;
            return this.self;
        }

        public SDB setProtection(boolean protection) {
            this.protection = protection;
            return this.self;
        }

        public EditorTextFieldOptionsNode.Builder getNameOptionBuilder() {
            return this.nameOptionBuilder;
        }

        public EditorSimpleButtonNode.Builder getDeleteButtonBuilder() {
            return this.deleteButtonBuilder;
        }

        @Override
        protected EditorNode buildInternally() {
            if (this.nameOptionBuilder.needsInputStringValidator()) {
                this.nameOptionBuilder.setInputStringValidator(new Predicate<String>(){

                    @Override
                    public boolean test(String s) {
                        return true;
                    }
                });
            }
            List builtSettingData = (List)this.settingList.stream().map(new Function<IEditorSettingNodeBuilder<?, ?>, IEditorSettingNodeBuilder<?, ?>>(){

                @Override
                public IEditorSettingNodeBuilder<?, ?> apply(IEditorSettingNodeBuilder<?, ?> b) {
                    return b.setRootSettings(Builder.this.rootSettings);
                }
            }).map(new Function<IEditorSettingNodeBuilder<?, ?>, IEditorSettingNode<?>>(){

                @Override
                public IEditorSettingNode<?> apply(IEditorSettingNodeBuilder<?, ?> b) {
                    return (IEditorSettingNode)b.build();
                }
            }).collect(new Supplier<List<IEditorSettingNode<?>>>(){

                @Override
                public List<IEditorSettingNode<?>> get() {
                    return Builder.this.listFactory.get();
                }
            }, new BiConsumer<List<IEditorSettingNode<?>>, IEditorSettingNode<?>>(){

                @Override
                public void accept(List<IEditorSettingNode<?>> l, IEditorSettingNode<?> e) {
                    l.add(e);
                }
            }, new BiConsumer<List<IEditorSettingNode<?>>, List<IEditorSettingNode<?>>>(){

                @Override
                public void accept(List<IEditorSettingNode<?>> l1, List<IEditorSettingNode<?>> l2) {
                    l1.addAll(l2);
                }
            });
            Map<ObjectCategorySetting<?>, IEditorSettingNode<?>> builtSettingsDataMap = this.mapFactory.get();
            for (IEditorSettingNode sd : builtSettingData) {
                if (!(sd instanceof EditorOptionsNode)) {
                    throw new IllegalStateException("illegal setting data class! " + sd.getClass());
                }
                builtSettingsDataMap.put(sd.getSetting(), sd);
            }
            return this.buildInternally(builtSettingData, builtSettingsDataMap);
        }

        protected abstract SD buildInternally(List<IEditorSettingNode<?>> var1, Map<ObjectCategorySetting<?>, IEditorSettingNode<?>> var2);
    }
}

