/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui.node.options;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.text.ITextComponent;
import xaero.hud.category.ui.entry.EditorListRootEntryFactory;
import xaero.hud.category.ui.node.EditorNode;
import xaero.hud.category.ui.node.options.EditorOptionNode;
import xaero.hud.category.ui.node.tooltip.IEditorDataTooltipSupplier;
import xaero.lib.common.config.util.ConfigUtils;

public abstract class EditorOptionsNode<V>
extends EditorNode {
    protected EditorOptionNode<V> currentValue;
    protected Supplier<ITextComponent> messageSupplier;
    protected final ITextComponent displayName;
    private final IOptionsNodeIsActiveSupplier isActiveSupplier;

    protected EditorOptionsNode(@Nonnull ITextComponent displayName, boolean movable, EditorListRootEntryFactory listEntryFactory, IEditorDataTooltipSupplier tooltipSupplier, IOptionsNodeIsActiveSupplier isActiveSupplier) {
        super(movable, listEntryFactory, tooltipSupplier);
        this.displayName = displayName;
        this.isActiveSupplier = isActiveSupplier;
    }

    public EditorOptionNode<V> getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(EditorOptionNode<V> currentValue) {
        this.currentValue = currentValue;
    }

    public final Supplier<ITextComponent> getMessageSupplier() {
        if (this.messageSupplier == null) {
            this.messageSupplier = new Supplier<ITextComponent>(){

                @Override
                public ITextComponent get() {
                    return EditorOptionsNode.this.isExpanded() ? EditorOptionsNode.this.displayName : ConfigUtils.optionNameValue((ITextComponent)EditorOptionsNode.this.displayName, (ITextComponent)EditorOptionsNode.this.currentValue.getDisplayName());
                }
            };
        }
        return this.messageSupplier;
    }

    public IOptionsNodeIsActiveSupplier getIsActiveSupplier() {
        return this.isActiveSupplier;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @FunctionalInterface
    public static interface IOptionsNodeIsActiveSupplier {
        public boolean get(EditorNode var1, EditorOptionsNode<?> var2);
    }

    public static abstract class Builder<V, B extends Builder<V, B>>
    extends EditorNode.Builder<B> {
        protected B self = this;
        protected V currentValue;
        protected ITextComponent displayName;
        protected IOptionsNodeIsActiveSupplier isActiveSupplier;

        protected Builder() {
        }

        @Override
        public B setDefault() {
            super.setDefault();
            this.setCurrentValue(null);
            this.setDisplayName(null);
            this.setIsActiveSupplier(new IOptionsNodeIsActiveSupplier(){

                @Override
                public boolean get(EditorNode p, EditorOptionsNode<?> d) {
                    return true;
                }
            });
            return this.self;
        }

        public B setCurrentValue(V currentValue) {
            this.currentValue = currentValue;
            return this.self;
        }

        public B setDisplayName(ITextComponent displayName) {
            this.displayName = displayName;
            return this.self;
        }

        public B setIsActiveSupplier(IOptionsNodeIsActiveSupplier isActiveSupplier) {
            this.isActiveSupplier = isActiveSupplier;
            return this.self;
        }

        @Override
        public EditorOptionsNode<V> build() {
            if (this.displayName == null) {
                throw new IllegalStateException("required fields not set!");
            }
            EditorOptionsNode result = (EditorOptionsNode)super.build();
            return result;
        }

        @Override
        protected abstract EditorOptionsNode<V> buildInternally();
    }
}

