/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.common.config.option.value.type.sync.serialization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import xaero.common.HudMod;
import xaero.hud.minimap.common.config.info.config.InfoDisplayConfigData;
import xaero.hud.minimap.common.config.info.config.InfoDisplayManagerConfigData;
import xaero.hud.minimap.radar.category.serialization.data.EntityRadarCategoryData;
import xaero.lib.common.config.option.value.sync.serialization.ConfigValueSyncCodec;

public class MinimapValueSyncCodecs {
    public static final ConfigValueSyncCodec<EntityRadarCategoryData, NBTTagCompound> ENTITY_RADAR_CATEGORIES = new ConfigValueSyncCodec((Function)new Function<EntityRadarCategoryData, NBTTagCompound>(){

        @Override
        public NBTTagCompound apply(EntityRadarCategoryData rootCategory) {
            return HudMod.INSTANCE.getEntityRadarCategorySerializers().getNbt().serialize(rootCategory);
        }
    }, (Function)new Function<NBTTagCompound, EntityRadarCategoryData>(){

        @Override
        public EntityRadarCategoryData apply(NBTTagCompound serializedData) {
            return HudMod.INSTANCE.getEntityRadarCategorySerializers().getNbt().deserialize(serializedData);
        }
    });
    public static final ConfigValueSyncCodec<InfoDisplayManagerConfigData, NBTTagCompound> INFO_DISPLAY_CONFIG = new ConfigValueSyncCodec((Function)new Function<InfoDisplayManagerConfigData, NBTTagCompound>(){

        @Override
        public NBTTagCompound apply(final InfoDisplayManagerConfigData config) {
            NBTTagCompound encodedData = new NBTTagCompound();
            final NBTTagList orderTag = new NBTTagList();
            config.getOrderStream().forEach(new Consumer<String>(){

                @Override
                public void accept(String s) {
                    orderTag.func_74742_a((NBTBase)new NBTTagString(s));
                }
            });
            encodedData.func_74782_a("o", (NBTBase)orderTag);
            final NBTTagCompound configsTag = new NBTTagCompound();
            config.getOrderStream().forEach(new Consumer<String>(){

                @Override
                public void accept(String id) {
                    InfoDisplayConfigData infoDisplayConfig = config.get(id);
                    if (infoDisplayConfig == null) {
                        return;
                    }
                    NBTTagCompound infoDisplayTag = new NBTTagCompound();
                    if (infoDisplayConfig.getState() != null) {
                        infoDisplayTag.func_74778_a("s", infoDisplayConfig.getState());
                    }
                    if (infoDisplayConfig.getBackgroundColor() != null) {
                        infoDisplayTag.func_74768_a("b", infoDisplayConfig.getBackgroundColor().intValue());
                    }
                    if (infoDisplayConfig.getTextColor() != null) {
                        infoDisplayTag.func_74768_a("t", infoDisplayConfig.getTextColor().intValue());
                    }
                    if (infoDisplayTag.func_82582_d()) {
                        return;
                    }
                    configsTag.func_74782_a(id, (NBTBase)infoDisplayTag);
                }
            });
            encodedData.func_74782_a("c", (NBTBase)configsTag);
            return encodedData;
        }
    }, (Function)new Function<NBTTagCompound, InfoDisplayManagerConfigData>(){

        @Override
        public InfoDisplayManagerConfigData apply(NBTTagCompound encodedData) {
            NBTTagList orderTag = encodedData.func_150295_c("o", 8);
            ArrayList<String> order = new ArrayList<String>();
            if (!orderTag.func_82582_d()) {
                for (int i = 0; i < orderTag.func_74745_c(); ++i) {
                    order.add(orderTag.func_150307_f(i));
                }
            }
            final NBTTagCompound configsTag = encodedData.func_74775_l("c");
            final HashMap<String, InfoDisplayConfigData> configs = new HashMap<String, InfoDisplayConfigData>();
            order.forEach(new Consumer<String>(){

                @Override
                public void accept(String id) {
                    NBTTagCompound infoDisplayTag = configsTag.func_74775_l(id);
                    if (infoDisplayTag.func_82582_d()) {
                        configs.put(id, new InfoDisplayConfigData(null, null, null));
                        return;
                    }
                    String state = infoDisplayTag.func_150297_b("s", 8) ? infoDisplayTag.func_74779_i("s") : null;
                    Integer backgroundColor = infoDisplayTag.func_150297_b("b", 99) ? Integer.valueOf(infoDisplayTag.func_74762_e("b")) : null;
                    Integer textColor = infoDisplayTag.func_150297_b("t", 99) ? Integer.valueOf(infoDisplayTag.func_74762_e("t")) : null;
                    configs.put(id, new InfoDisplayConfigData(backgroundColor, textColor, state));
                }
            });
            return new InfoDisplayManagerConfigData(order, configs);
        }
    });
}

