/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.packet.basic;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import xaero.common.XaeroMinimapSession;
import xaero.common.server.player.ServerPlayerData;
import xaero.lib.common.packet.XaeroPacket;

public class HandshakePacket
extends XaeroPacket {
    public static final int NETWORK_COMPATIBILITY = 3;
    private int networkVersion;

    public HandshakePacket(int networkVersion) {
        this.networkVersion = networkVersion;
    }

    public HandshakePacket() {
        this(3);
    }

    protected void write(PacketBuffer buf) {
        buf.writeInt(this.networkVersion);
    }

    protected void read(PacketBuffer buf) {
        this.networkVersion = buf.readInt();
    }

    public static class ServerHandler
    implements BiConsumer<HandshakePacket, EntityPlayerMP> {
        @Override
        public void accept(HandshakePacket message, EntityPlayerMP player) {
            ServerPlayerData playerData = ServerPlayerData.get(player);
            playerData.setClientModNetworkVersion(message.networkVersion);
        }
    }

    public static class ClientHandler
    implements Consumer<HandshakePacket> {
        @Override
        public void accept(HandshakePacket message) {
            XaeroMinimapSession session = XaeroMinimapSession.getCurrentSession();
            if (session == null) {
                return;
            }
            session.getMinimapProcessor().setServerModNetworkVersion(message.networkVersion);
            session.getModMain().getMessageHandler().sendToServer((XaeroPacket)new HandshakePacket());
        }
    }
}

