/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.player.tracker;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.hud.entity.EntityUtils;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.config.util.MinimapConfigClientUtils;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.MinimapElementRenderer;
import xaero.hud.minimap.player.tracker.PlayerTrackerIconRenderer;
import xaero.hud.minimap.player.tracker.PlayerTrackerMinimapElement;
import xaero.hud.minimap.player.tracker.PlayerTrackerMinimapElementCollector;
import xaero.hud.minimap.player.tracker.PlayerTrackerMinimapElementReader;
import xaero.hud.minimap.player.tracker.PlayerTrackerMinimapElementRenderContext;
import xaero.hud.minimap.player.tracker.PlayerTrackerMinimapElementRenderProvider;
import xaero.hud.render.util.RenderBufferUtil;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.option.IndexedConfigOption;

public final class PlayerTrackerMinimapElementRenderer
extends MinimapElementRenderer<PlayerTrackerMinimapElement<?>, PlayerTrackerMinimapElementRenderContext> {
    private final double WORLD_MINIMUM_DISTANCE = 10.0;
    private final double WORLD_FADING_LENGTH = 10.0;
    private MultiBufferSource.BufferSource minimapBufferSource;
    private final PlayerTrackerMinimapElementCollector elementCollector;
    private final PlayerTrackerIconRenderer playerTrackerIconRenderer;
    private final IXaeroMinimap modMain;
    private float nameScale;

    private PlayerTrackerMinimapElementRenderer(PlayerTrackerMinimapElementCollector elementCollector, IXaeroMinimap modMain, PlayerTrackerMinimapElementRenderContext context, PlayerTrackerMinimapElementRenderProvider<PlayerTrackerMinimapElementRenderContext> provider, PlayerTrackerMinimapElementReader reader, PlayerTrackerIconRenderer playerTrackerIconRenderer) {
        super(reader, provider, context);
        this.elementCollector = elementCollector;
        this.modMain = modMain;
        this.playerTrackerIconRenderer = playerTrackerIconRenderer;
    }

    public ResourceLocation getPlayerSkin(Player player, PlayerInfo info) {
        ResourceLocation skinTextureLocation;
        ResourceLocation resourceLocation = skinTextureLocation = player instanceof AbstractClientPlayer ? ((AbstractClientPlayer)player).m_108560_() : info.m_105337_();
        if (skinTextureLocation == null) {
            skinTextureLocation = DefaultPlayerSkin.m_118627_((UUID)player.m_142081_());
        }
        return skinTextureLocation;
    }

    @Override
    public void preRender(MinimapElementRenderInfo renderInfo, MultiBufferSource.BufferSource vanillaBufferSource, MultiTextureRenderTypeRendererProvider rendererProvider) {
        RenderSystem.m_69465_();
        vanillaBufferSource.m_109911_();
        this.minimapBufferSource = this.modMain.getHudRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
        ((PlayerTrackerMinimapElementRenderContext)this.context).coloredBackgroundConsumer = this.minimapBufferSource.m_6299_(CustomRenderTypes.COLORED_WAYPOINTS_BGS);
        ((PlayerTrackerMinimapElementRenderContext)this.context).uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(t -> RenderSystem.m_157453_((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_NEAREST);
        ((PlayerTrackerMinimapElementRenderContext)this.context).renderEntityDimId = renderInfo.renderEntityDimension;
        ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimId = renderInfo.mapDimension;
        ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        float trackedPlayerWorldIconScale = MinimapConfigClientUtils.getUIScale(configManager, (IndexedConfigOption<Integer>)MinimapProfiledConfigOptions.TRACKED_PLAYER_WORLD_ICON_SCALE);
        float trackedPlayerMinimapIconScale = MinimapConfigClientUtils.getUIScale(configManager, (IndexedConfigOption<Integer>)MinimapProfiledConfigOptions.TRACKED_PLAYER_MINIMAP_ICON_SCALE);
        ((PlayerTrackerMinimapElementRenderContext)this.context).iconScale = renderInfo.location == MinimapElementRenderLocation.IN_WORLD ? trackedPlayerWorldIconScale : trackedPlayerMinimapIconScale;
        this.nameScale = MinimapConfigClientUtils.getUIScale(configManager, (IndexedConfigOption<Integer>)MinimapProfiledConfigOptions.TRACKED_PLAYER_WORLD_NAME_SCALE);
    }

    @Override
    public void postRender(MinimapElementRenderInfo renderInfo, MultiBufferSource.BufferSource vanillaBufferSource, MultiTextureRenderTypeRendererProvider rendererProvider) {
        rendererProvider.draw(((PlayerTrackerMinimapElementRenderContext)this.context).uniqueTextureUIObjectRenderer);
        this.minimapBufferSource.m_109911_();
        RenderSystem.m_69482_();
        RenderSystem.m_69456_((int)515);
        this.elementCollector.resetRenderedOnRadarFlags();
    }

    @Override
    public boolean renderElement(PlayerTrackerMinimapElement<?> e, boolean highlighted, boolean outOfBounds, double optionalDepth, float optionalScale, double partialX, double partialY, MinimapElementRenderInfo renderInfo, PoseStack matrixStack, MultiBufferSource.BufferSource vanillaBufferSource) {
        float alpha;
        double trackedZ;
        double offZ;
        double trackedY;
        double offY;
        if (!outOfBounds && renderInfo.location != MinimapElementRenderLocation.IN_WORLD && e.wasRenderedOnRadar()) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        PlayerInfo info = mc.m_91403_().m_104949_(e.getPlayerId());
        if (info == null) {
            return false;
        }
        Player clientPlayer = mc.f_91073_.m_46003_(e.getPlayerId());
        double trackedX = clientPlayer == null ? e.getX() : EntityUtils.getEntityX((Entity)clientPlayer, renderInfo.partialTicks);
        double offX = trackedX - renderInfo.renderEntityPos.f_82479_;
        double distance = Math.sqrt(offX * offX + (offY = (trackedY = clientPlayer == null ? e.getY() : EntityUtils.getEntityY((Entity)clientPlayer, renderInfo.partialTicks)) - renderInfo.renderEntityPos.f_82480_) * offY + (offZ = (trackedZ = clientPlayer == null ? e.getZ() : EntityUtils.getEntityZ((Entity)clientPlayer, renderInfo.partialTicks)) - renderInfo.renderEntityPos.f_82481_) * offZ);
        if (distance < 10.0) {
            return false;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, optionalDepth);
        boolean inWorld = renderInfo.location == MinimapElementRenderLocation.IN_WORLD;
        float f = alpha = inWorld ? 0.5f : 1.0f;
        if (highlighted && inWorld) {
            alpha = 0.8f;
        }
        if (!highlighted && inWorld && distance < 20.0) {
            alpha *= (float)((distance - 10.0) / 10.0);
        }
        matrixStack.m_85837_(0.0, 0.0, 0.01);
        matrixStack.m_85836_();
        matrixStack.m_85841_(((PlayerTrackerMinimapElementRenderContext)this.context).iconScale, ((PlayerTrackerMinimapElementRenderContext)this.context).iconScale, 1.0f);
        RenderBufferUtil.addColoredRect(matrixStack.m_85850_().m_85861_(), ((PlayerTrackerMinimapElementRenderContext)this.context).coloredBackgroundConsumer, -5.0f, -5.0f, 10, 10, 1.0f, 1.0f, 1.0f, alpha);
        this.playerTrackerIconRenderer.renderIcon(mc, ((PlayerTrackerMinimapElementRenderContext)this.context).uniqueTextureUIObjectRenderer, matrixStack, clientPlayer, this.getPlayerSkin(clientPlayer, info), alpha);
        matrixStack.m_85849_();
        if (highlighted && inWorld) {
            matrixStack.m_85837_((double)(-5.0f * ((PlayerTrackerMinimapElementRenderContext)this.context).iconScale), 0.0, 0.0);
            matrixStack.m_85841_(this.nameScale, this.nameScale, 1.0f);
            String playerName = info.m_105312_().getName();
            int playerNameWidth = mc.f_91062_.m_92895_(playerName);
            float labelAlpha = 0.3529412f;
            RenderBufferUtil.addColoredRect(matrixStack.m_85850_().m_85861_(), ((PlayerTrackerMinimapElementRenderContext)this.context).coloredBackgroundConsumer, -playerNameWidth - 1, -5.0f, playerNameWidth + 1, 10, 0.0f, 0.0f, 0.0f, labelAlpha);
            mc.f_91062_.m_92811_(playerName, (float)(-playerNameWidth), -4.0f, -1, false, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)this.minimapBufferSource, false, 0, 0xF000F0);
        }
        matrixStack.m_85849_();
        return true;
    }

    @Override
    public boolean shouldRender(MinimapElementRenderLocation location) {
        ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        return location != MinimapElementRenderLocation.IN_WORLD && (Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.TRACKED_PLAYERS_ON_MINIMAP) != false || location == MinimapElementRenderLocation.IN_WORLD && (Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.TRACKED_PLAYERS_IN_WORLD) != false;
    }

    @Override
    public int getOrder() {
        return 100;
    }

    public PlayerTrackerMinimapElementCollector getCollector() {
        return this.elementCollector;
    }

    public static final class Builder {
        private final IXaeroMinimap modMain;

        private Builder(IXaeroMinimap modMain) {
            this.modMain = modMain;
        }

        private Builder setDefault() {
            return this;
        }

        public PlayerTrackerMinimapElementRenderer build() {
            PlayerTrackerMinimapElementCollector collector = new PlayerTrackerMinimapElementCollector(this.modMain.getPlayerTrackerSystemManager());
            return new PlayerTrackerMinimapElementRenderer(collector, this.modMain, new PlayerTrackerMinimapElementRenderContext(), new PlayerTrackerMinimapElementRenderProvider<PlayerTrackerMinimapElementRenderContext>(collector), new PlayerTrackerMinimapElementReader(), new PlayerTrackerIconRenderer());
        }

        public static Builder begin(IXaeroMinimap modMain) {
            return new Builder(modMain).setDefault();
        }
    }
}

