/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiClearSet;
import xaero.common.gui.GuiDeleteSet;
import xaero.common.gui.GuiNewSet;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.GuiWaypointsOptions;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsSort;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.config.primary.option.MinimapPrimaryClientConfigOptions;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.MinimapWorldManager;
import xaero.hud.path.XaeroPath;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.controls.util.KeyMappingUtils;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.widget.MyTinyButton;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.client.gui.widget.dropdown.IDropDownContainer;
import xaero.lib.client.gui.widget.dropdown.IDropDownWidgetCallback;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.single.SingleConfigManager;
import xaero.lib.common.util.KeySortableByOther;

public class GuiWaypoints
extends ScreenBase
implements IDropDownWidgetCallback {
    private static final int FRAME_TOP_SIZE = 58;
    private static final int FRAME_BOTTOM_SIZE = 61;
    public static double distanceDivided;
    private List list;
    private MinimapWorld displayedWorld;
    private ConcurrentSkipListSet<Integer> selectedListSet;
    private GuiWaypointContainers containers;
    private GuiWaypointWorlds worlds;
    private GuiWaypointSets sets;
    private DropDownWidget containersDD;
    private DropDownWidget worldsDD;
    private DropDownWidget setsDD;
    private MinimapSession session;
    private MinimapWorldManager manager;
    private int draggingFromX;
    private int draggingFromY;
    private int draggingFromSlot;
    private Waypoint draggingWaypoint;
    private boolean displayingTeleportableWorld;
    private int shiftSelectFirst;
    private ArrayList<Waypoint> waypointsSorted;
    private final XaeroPath frozenAutoWorldPath;
    private Button deleteButton;
    private Button editButton;
    private Button teleportButton;
    private Button disableEnableButton;
    private Button clearButton;
    private Button shareButton;
    private final HudMod modMain;

    @Deprecated
    public GuiWaypoints(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, Screen par1GuiScreen) {
        this(modMain, minimapSession, par1GuiScreen, null);
    }

    @Deprecated
    public GuiWaypoints(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, Screen par1GuiScreen, Screen escapeScreen) {
        this((HudMod)modMain, BuiltInHudModules.MINIMAP.getCurrentSession(), par1GuiScreen, escapeScreen);
    }

    public GuiWaypoints(HudMod modMain, MinimapSession session, Screen par1GuiScreen, Screen escapeScreen) {
        super(par1GuiScreen, escapeScreen, (Component)Component.m_237115_((String)"gui.xaero_waypoints"));
        this.modMain = modMain;
        this.session = session;
        this.manager = session.getWorldManager();
        this.selectedListSet = new ConcurrentSkipListSet();
        this.draggingFromX = -1;
        this.draggingFromY = -1;
        this.draggingFromSlot = -1;
        this.frozenAutoWorldPath = session.getWorldState().getAutoWorldPath();
        this.displayedWorld = this.manager.getCurrentWorld(this.frozenAutoWorldPath);
        XaeroPath currentContainer = this.displayedWorld.getContainer().getRoot().getPath();
        this.containers = new GuiWaypointContainers(modMain, this.manager, currentContainer, this.frozenAutoWorldPath);
        this.worlds = new GuiWaypointWorlds(this.manager.getRootWorldContainer((String)this.containers.getCurrentKey()), session, this.displayedWorld.getFullPath(), this.frozenAutoWorldPath);
        this.displayingTeleportableWorld = session.getWaypointSession().getTeleport().isWorldTeleportable(this.displayedWorld);
        this.waypointsSorted = new ArrayList();
    }

    public void m_7856_() {
        super.m_7856_();
        this.updateSortedList();
        this.list = new List();
        this.sets = new GuiWaypointSets(true, this.displayedWorld, this.displayedWorld.getCurrentWaypointSetId());
        this.m_7787_((GuiEventListener)this.list);
        this.deleteButton = new MyTinyButton(this.f_96543_ / 2 + 129, this.f_96544_ - 53, (Component)Component.m_237115_((String)"gui.xaero_delete"), b -> {
            Waypoint w;
            if (!this.isSomethingSelected()) {
                return;
            }
            this.undrag();
            boolean shouldRestore = true;
            for (int i : this.selectedListSet) {
                w = this.list.getWaypoint(i);
                if (w.isTemporary()) continue;
                shouldRestore = false;
                w.setTemporary(true);
            }
            if (shouldRestore) {
                for (int i : this.selectedListSet) {
                    w = this.list.getWaypoint(i);
                    w.setTemporary(false);
                }
            }
            try {
                this.session.getWorldManagerIO().saveWorld(this.displayedWorld);
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        });
        this.m_142416_((GuiEventListener)this.deleteButton);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237110_((String)"gui.done", (Object[])new Object[0]), b -> this.goBack()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 29, 200, 20).m_253136_());
        this.editButton = new MyTinyButton(this.f_96543_ / 2 - 203, this.f_96544_ - 53, (Component)Component.m_237110_((String)"gui.xaero_add_edit", (Object[])new Object[0]), b -> {
            if (!this.isAddEditEnabled()) {
                return;
            }
            ArrayList selectedWaypoints = this.getSelectedWaypointsList().stream().filter(w -> !w.isServerWaypoint()).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            this.f_96541_.m_91152_((Screen)new GuiAddWaypoint(this.modMain, this.session, (Screen)this, this.escape, (ArrayList<Waypoint>)selectedWaypoints, this.displayedWorld.getContainer().getRoot().getPath(), this.displayedWorld, this.displayedWorld.getCurrentWaypointSetId(), selectedWaypoints.isEmpty()));
            this.list.setSelected(null);
        });
        this.m_142416_((GuiEventListener)this.editButton);
        this.teleportButton = new MyTinyButton(this.f_96543_ / 2 - 120, this.f_96544_ - 53, (Component)Component.m_237113_((String)(I18n.m_118938_((String)"gui.xaero_waypoint_teleport", (Object[])new Object[0]) + " (T)")), b -> {
            if (!this.canTeleport()) {
                return;
            }
            this.displayingTeleportableWorld = this.session.getWaypointSession().getTeleport().isWorldTeleportable(this.displayedWorld);
            this.session.getWaypointSession().getTeleport().teleportToWaypoint(this.list.getWaypoint(this.selectedListSet.first()), this.displayedWorld, (Screen)this);
        });
        this.m_142416_((GuiEventListener)this.teleportButton);
        this.disableEnableButton = new MyTinyButton(this.f_96543_ / 2 + 46, this.f_96544_ - 53, (Component)Component.m_237110_((String)"gui.xaero_disable_enable", (Object[])new Object[0]), b -> {
            if (!this.isSomethingSelected()) {
                return;
            }
            ArrayList<Waypoint> selectedWaypoints = this.getSelectedWaypointsList();
            if (GuiWaypoints.allWaypointsAre(selectedWaypoints, Waypoint::isTemporary)) {
                for (Waypoint selected : selectedWaypoints) {
                    this.displayedWorld.getCurrentWaypointSet().remove(selected);
                }
                this.selectedListSet.clear();
            } else if (GuiWaypoints.allWaypointsAre(selectedWaypoints, Waypoint::isDisabled)) {
                for (Waypoint selected : selectedWaypoints) {
                    selected.setDisabled(false);
                }
            } else {
                for (Waypoint selected : selectedWaypoints) {
                    selected.setDisabled(true);
                }
            }
            this.updateSortedList();
            try {
                this.session.getWorldManagerIO().saveWorld(this.displayedWorld);
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        });
        this.m_142416_((GuiEventListener)this.disableEnableButton);
        this.clearButton = new MyTinyButton(this.f_96543_ / 2 + 130, 32, (Component)Component.m_237110_((String)"gui.xaero_clear", (Object[])new Object[0]), b -> {
            XaeroPath worldKeys = (XaeroPath)this.worlds.getCurrentKey();
            String name = this.sets.getOptions()[this.sets.getCurrentSet()];
            if (this.shouldDeleteSet()) {
                this.f_96541_.m_91152_((Screen)new GuiDeleteSet(I18n.m_118938_((String)name, (Object[])new Object[0]), worldKeys, name, (Screen)this, this.escape, this.modMain, this.session));
            } else {
                this.f_96541_.m_91152_((Screen)new GuiClearSet(I18n.m_118938_((String)name, (Object[])new Object[0]), worldKeys, name, this, this.escape, this.modMain, this.session));
            }
        });
        this.m_142416_((GuiEventListener)this.clearButton);
        this.m_142416_((GuiEventListener)new MyTinyButton(this.f_96543_ / 2 - 203, 32, (Component)Component.m_237110_((String)"gui.xaero_options", (Object[])new Object[0]), b -> this.f_96541_.m_91152_((Screen)new GuiWaypointsOptions(this.modMain, this.session, (Screen)this, this.escape, this.displayedWorld, this.frozenAutoWorldPath))));
        this.shareButton = new MyTinyButton(this.f_96543_ / 2 - 37, this.f_96544_ - 53, (Component)Component.m_237110_((String)"gui.xaero_share", (Object[])new Object[0]), b -> {
            Waypoint selected;
            if (!this.isOneSelected()) {
                return;
            }
            Waypoint waypoint = selected = this.selectedListSet.isEmpty() ? null : this.list.getWaypoint(this.selectedListSet.first());
            if (selected != null) {
                this.session.getWaypointSession().getSharing().shareWaypoint((Screen)this, selected, this.displayedWorld);
            }
        });
        this.m_142416_((GuiEventListener)this.shareButton);
        this.containersDD = this.createContainersDropdown();
        this.m_7787_((GuiEventListener)this.containersDD);
        this.worldsDD = this.createWorldsDropdown();
        this.m_7787_((GuiEventListener)this.worldsDD);
        this.setsDD = this.createSetsDropdown();
        this.m_7787_((GuiEventListener)this.setsDD);
    }

    private DropDownWidget createSetsDropdown() {
        return DropDownWidget.Builder.begin().setOptions(this.sets.getOptions()).setX(this.f_96543_ / 2 - 100).setY(33).setW(200).setSelected(Integer.valueOf(this.sets.getCurrentSet())).setCallback((IDropDownWidgetCallback)this).setContainer((IDropDownContainer)this).setNarrationTitle((Component)Component.m_237115_((String)"gui.xaero_dropdown_waypoint_set")).build();
    }

    private DropDownWidget createContainersDropdown() {
        return DropDownWidget.Builder.begin().setOptions(this.containers.options).setX(this.f_96543_ / 2 - 202).setY(17).setW(200).setSelected(Integer.valueOf(this.containers.current)).setCallback((IDropDownWidgetCallback)this).setContainer((IDropDownContainer)this).setNarrationTitle((Component)Component.m_237115_((String)"gui.xaero_dropdown_waypoint_container")).build();
    }

    private DropDownWidget createWorldsDropdown() {
        return DropDownWidget.Builder.begin().setOptions(this.worlds.options).setX(this.f_96543_ / 2 + 2).setY(17).setW(200).setSelected(Integer.valueOf(this.worlds.current)).setCallback((IDropDownWidgetCallback)this).setContainer((IDropDownContainer)this).setNarrationTitle((Component)Component.m_237115_((String)"gui.xaero_dropdown_waypoint_world")).build();
    }

    private ArrayList<Waypoint> getSelectedWaypointsList() {
        return this.selectedListSet.stream().map(i -> this.list.getWaypoint((int)i)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public static boolean allWaypointsAre(ArrayList<Waypoint> waypoints, Predicate<Waypoint> predicate) {
        boolean allTrue = true;
        for (Waypoint w : waypoints) {
            if (predicate.test(w)) continue;
            allTrue = false;
            break;
        }
        return allTrue;
    }

    public boolean shouldDeleteSet() {
        return !this.sets.getOptions()[this.sets.getCurrentSet()].equals("gui.xaero_default") && this.displayedWorld.getCurrentWaypointSet().isEmpty();
    }

    private void undrag() {
        this.draggingFromX = -1;
        this.draggingFromY = -1;
        this.draggingFromSlot = -1;
        this.draggingWaypoint = null;
    }

    public boolean m_6375_(double par1, double par2, int par3) {
        if (this.openDropdown == null) {
            if (KeyMappingUtils.inputMatches((InputConstants.Type)InputConstants.Type.MOUSE, (int)par3, (KeyMapping)ModSettings.keyWaypoints, (int)0)) {
                this.goBack();
                return true;
            }
            if (par3 == 0) {
                if (par2 >= 58.0 && par2 < (double)(this.f_96544_ - 61) && this.displayedWorld.getRootConfig().getSortType() == WaypointsSort.NONE) {
                    this.draggingFromX = (int)par1;
                    this.draggingFromY = (int)par2;
                    this.draggingFromSlot = this.list.getEntryAt(par1, par2);
                    if (this.draggingFromSlot >= this.displayedWorld.getCurrentWaypointSet().size()) {
                        this.draggingFromSlot = -1;
                    }
                }
            } else {
                this.list.setSelected(null);
            }
        }
        return super.m_6375_(par1, par2, par3);
    }

    public boolean m_6348_(double par1, double par2, int par3) {
        try {
            if (this.draggingWaypoint != null) {
                this.session.getWorldManagerIO().saveWorld(this.displayedWorld);
            }
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        this.undrag();
        if (!super.m_6348_(par1, par2, par3)) {
            return this.list.m_6348_(par1, par2, par3);
        }
        return true;
    }

    public boolean m_7920_(int par1, int par2, int par3) {
        switch (par1) {
            case 261: {
                if (this.disableEnableButton.f_93623_) {
                    for (int i : this.selectedListSet) {
                        this.list.getWaypoint(i).setTemporary(true);
                    }
                    this.disableEnableButton.m_5716_(0.0, 0.0);
                }
                return true;
            }
            case 84: {
                if (this.teleportButton.f_93623_) {
                    this.teleportButton.m_5716_(0.0, 0.0);
                }
                return true;
            }
        }
        return super.m_7920_(par1, par2, par3);
    }

    public void m_280273_(GuiGraphics guiGraphics, int par1, int par2, float par3) {
        this.m_280039_(guiGraphics);
        this.list.m_88315_(guiGraphics, par1, par2, par3);
    }

    public void m_88315_(GuiGraphics guiGraphics, int par1, int par2, float par3) {
        if (this.f_96541_.f_91074_ == null) {
            this.f_96541_.m_91152_(null);
            return;
        }
        this.updateButtons();
        super.m_88315_(guiGraphics, par1, par2, par3);
    }

    protected void renderPreDropdown(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.renderPreDropdown(guiGraphics, mouseX, mouseY, partial);
        guiGraphics.m_280137_(this.f_96547_, I18n.m_118938_((String)"gui.xaero_world_server", (Object[])new Object[0]), this.f_96543_ / 2 - 102, 5, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, I18n.m_118938_((String)"gui.xaero_subworld_dimension", (Object[])new Object[0]), this.f_96543_ / 2 + 102, 5, 0xFFFFFF);
        if (this.draggingFromSlot != -1) {
            int distance = (int)Math.sqrt(Math.pow(mouseX - this.draggingFromX, 2.0) + Math.pow(mouseY - this.draggingFromY, 2.0));
            int toSlot = Math.min(this.displayedWorld.getCurrentWaypointSet().size() - 1, this.list.getEntryAt(mouseX, mouseY));
            if (distance > 4 && this.draggingWaypoint == null) {
                this.draggingWaypoint = this.displayedWorld.getCurrentWaypointSet().get(this.draggingFromSlot);
                this.list.setSelected(null);
            }
            if (this.draggingWaypoint != null && this.draggingFromSlot != toSlot && toSlot != -1) {
                int direction = toSlot > this.draggingFromSlot ? 1 : -1;
                for (int i = this.draggingFromSlot; i != toSlot; i += direction) {
                    this.displayedWorld.getCurrentWaypointSet().set(i, this.displayedWorld.getCurrentWaypointSet().get(i + direction));
                }
                this.displayedWorld.getCurrentWaypointSet().set(toSlot, this.draggingWaypoint);
                this.draggingFromSlot = toSlot;
                this.updateSortedList();
            }
            int fromCenter = this.draggingFromX - this.list.m_5711_() / 2;
            this.list.drawWaypointSlot(guiGraphics, this.draggingWaypoint, mouseX - 108 - fromCenter, mouseY - this.list.getItemHeight() / 4);
        }
    }

    private void updateButtons() {
        this.deleteButton.f_93623_ = this.disableEnableButton.f_93623_ = this.isSomethingSelected();
        this.shareButton.f_93623_ = this.isOneSelected();
        this.teleportButton.f_93623_ = this.canTeleport();
        this.editButton.f_93623_ = this.isAddEditEnabled();
        this.clearButton.m_93666_((Component)Component.m_237110_((String)(this.shouldDeleteSet() ? "gui.xaero_delete_set" : "gui.xaero_clear"), (Object[])new Object[0]));
        ArrayList<Waypoint> selectedWaypointsList = this.getSelectedWaypointsList();
        if (this.isSomethingSelected() && GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isTemporary)) {
            this.disableEnableButton.m_93666_((Component)Component.m_237115_((String)"gui.xaero_delete"));
            this.deleteButton.m_93666_((Component)Component.m_237115_((String)"gui.xaero_restore"));
        } else {
            this.deleteButton.m_93666_((Component)Component.m_237115_((String)"gui.xaero_delete"));
            String[] enabledisable = I18n.m_118938_((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
            this.disableEnableButton.m_93666_((Component)Component.m_237113_((String)enabledisable[!GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isDisabled) ? 0 : 1]));
        }
    }

    private boolean isAddEditEnabled() {
        ArrayList<Waypoint> selectedWaypointsList = this.getSelectedWaypointsList();
        return selectedWaypointsList.isEmpty() || !GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isServerWaypoint);
    }

    private boolean isSomethingSelected() {
        return !this.selectedListSet.isEmpty();
    }

    private boolean isOneSelected() {
        return this.selectedListSet.size() == 1;
    }

    private boolean canTeleport() {
        if (!this.isOneSelected()) {
            return false;
        }
        if (!this.displayedWorld.getRootConfig().isTeleportationEnabled()) {
            return false;
        }
        if (this.displayingTeleportableWorld) {
            return true;
        }
        ClientConfigManager configManager = this.modMain.getHudConfigs().getClientConfigManager();
        SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
        return (Boolean)primaryConfigManager.getEffective((ConfigOption)MinimapPrimaryClientConfigOptions.WRONG_WORLD_TELEPORT);
    }

    public boolean onSelected(DropDownWidget menu, int selectedIndex) {
        if (menu == this.containersDD || menu == this.worldsDD) {
            if (menu == this.containersDD) {
                this.containers.current = selectedIndex;
                if (this.containers.current != this.containers.auto) {
                    WaypointWorld firstWorld = this.manager.getRootWorldContainer((String)this.containers.getCurrentKey()).getFirstWorld();
                    this.session.getWorldState().setCustomWorldPath(firstWorld.getFullPath());
                } else {
                    this.session.getWorldState().setCustomWorldPath(null);
                }
                this.displayedWorld = this.manager.getCurrentWorld(this.frozenAutoWorldPath);
                this.updateSortedList();
                this.worlds = new GuiWaypointWorlds(this.manager.getRootWorldContainer((String)this.containers.getCurrentKey()), this.session, this.displayedWorld.getFullPath(), this.frozenAutoWorldPath);
                this.worldsDD = this.createWorldsDropdown();
                this.replaceWidget((AbstractWidget)this.worldsDD, (AbstractWidget)this.worldsDD);
            } else {
                this.worlds.current = selectedIndex;
                if (this.worlds.current != this.worlds.auto) {
                    XaeroPath selectedWorldPath = (XaeroPath)this.worlds.getCurrentKey();
                    this.session.getWorldState().setCustomWorldPath(selectedWorldPath);
                } else {
                    this.session.getWorldState().setCustomWorldPath(null);
                }
                this.displayedWorld = this.manager.getCurrentWorld(this.frozenAutoWorldPath);
                this.updateSortedList();
            }
            this.displayingTeleportableWorld = this.session.getWaypointSession().getTeleport().isWorldTeleportable(this.displayedWorld);
            this.list.setSelected(null);
            this.sets = new GuiWaypointSets(true, this.displayedWorld, this.displayedWorld.getCurrentWaypointSetId());
            this.setsDD = this.createSetsDropdown();
            this.replaceWidget((AbstractWidget)this.setsDD, (AbstractWidget)this.setsDD);
            return true;
        }
        if (menu == this.setsDD) {
            this.list.setSelected(null);
            if (selectedIndex == menu.size() - 1) {
                MinimapLogs.LOGGER.info("New waypoint set gui");
                this.f_96541_.m_91152_((Screen)new GuiNewSet((IXaeroMinimap)this.modMain, this.session, (Screen)this, this.escape, this.displayedWorld));
                return false;
            }
            this.sets.setCurrentSet(selectedIndex);
            this.displayedWorld.setCurrentWaypointSetId(this.sets.getCurrentSetKey());
            this.updateSortedList();
            try {
                this.session.getWorldManagerIO().saveWorld(this.displayedWorld);
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    private void updateSortedList() {
        WaypointsSort sortType = this.displayedWorld.getRootConfig().getSortType();
        this.waypointsSorted = new ArrayList();
        if (sortType == WaypointsSort.NONE) {
            for (Waypoint waypoint : this.displayedWorld.getCurrentWaypointSet().getWaypoints()) {
                this.waypointsSorted.add(waypoint);
            }
            return;
        }
        distanceDivided = this.session.getDimensionHelper().getDimensionDivision(this.displayedWorld);
        ArrayList<KeySortableByOther> sortableKeys = new ArrayList<KeySortableByOther>();
        Camera camera = this.f_96541_.f_91063_.m_109153_();
        for (Waypoint w : this.displayedWorld.getCurrentWaypointSet().getWaypoints()) {
            sortableKeys.add(new KeySortableByOther((Object)w, new Comparable[]{sortType == WaypointsSort.COLOR ? w.getWaypointColor() : (sortType == WaypointsSort.ANGLE ? Double.valueOf(-w.getComparisonAngleCos(camera, distanceDivided)) : (sortType == WaypointsSort.NAME ? w.getComparisonName() : (sortType == WaypointsSort.SYMBOL ? w.getInitials() : Double.valueOf(w.getComparisonDistance(camera, distanceDivided)))))}));
        }
        Collections.sort(sortableKeys);
        for (KeySortableByOther k : sortableKeys) {
            this.waypointsSorted.add((Waypoint)k.getKey());
        }
        if (this.displayedWorld.getRootConfig().isSortReversed()) {
            Collections.reverse(this.waypointsSorted);
        }
    }

    public boolean m_7933_(int par1, int par2, int par3) {
        if (!super.m_7933_(par1, par2, par3)) {
            if (KeyMappingUtils.inputMatches((InputConstants.Type)(par1 != -1 ? InputConstants.Type.KEYSYM : InputConstants.Type.SCANCODE), (int)(par1 != -1 ? par1 : par2), (KeyMapping)ModSettings.keyWaypoints, (int)0)) {
                this.goBack();
                return true;
            }
            return false;
        }
        return true;
    }

    class List
    extends ObjectSelectionList<WaypointEntry> {
        private int createdCount;

        public List() {
            super(GuiWaypoints.this.f_96541_, GuiWaypoints.this.f_96543_, Math.max(4, GuiWaypoints.this.f_96544_ - 61 - 58), 58, 18);
            this.createEntries(this.getWaypointCount());
        }

        protected int getWaypointCount() {
            int size = GuiWaypoints.this.displayedWorld.getCurrentWaypointSet().size();
            return size += GuiWaypoints.this.displayedWorld.getContainer().getServerWaypointManager().size();
        }

        private Waypoint getWaypoint(int slotIndex) {
            if (slotIndex < GuiWaypoints.this.displayedWorld.getCurrentWaypointSet().size()) {
                return GuiWaypoints.this.waypointsSorted.get(slotIndex);
            }
            int serverWPIndex = slotIndex - GuiWaypoints.this.displayedWorld.getCurrentWaypointSet().size();
            if (serverWPIndex < GuiWaypoints.this.displayedWorld.getContainer().getServerWaypointManager().size()) {
                return GuiWaypoints.this.displayedWorld.getContainer().getServerWaypointManager().getBySlot(serverWPIndex);
            }
            return null;
        }

        protected boolean m_7987_(int p_148131_1_) {
            return !GuiWaypoints.this.selectedListSet.isEmpty() && GuiWaypoints.this.selectedListSet.contains(p_148131_1_);
        }

        private void createEntries(int count) {
            this.m_93516_();
            this.createdCount = count;
            for (int i = 0; i < count; ++i) {
                WaypointEntry entry = new WaypointEntry(i);
                this.m_7085_((AbstractSelectionList.Entry)entry);
            }
        }

        public void m_87963_(GuiGraphics guiGraphics, int p_render_1_, int p_render_2_, float p_render_3_) {
            int currentCount = this.getWaypointCount();
            if (currentCount != this.createdCount) {
                this.createEntries(currentCount);
                this.m_93410_(this.m_93517_());
            }
            super.m_87963_(guiGraphics, p_render_1_, p_render_2_, p_render_3_);
        }

        public boolean m_93696_() {
            if (GuiWaypoints.this.openDropdown != null || GuiWaypoints.this.draggingWaypoint != null) {
                return false;
            }
            return GuiWaypoints.this.m_7222_() == this;
        }

        public void setSelected(WaypointEntry e) {
            if (e == null) {
                GuiWaypoints.this.selectedListSet.clear();
                GuiWaypoints.this.shiftSelectFirst = -1;
                return;
            }
            Waypoint waypoint = this.getWaypoint(e.index);
            int currentSize = GuiWaypoints.this.selectedListSet.size();
            boolean shiftPressed = Screen.m_96638_();
            if ((currentSize > 1 || currentSize == 1 && GuiWaypoints.this.selectedListSet.first() != e.index) && !Screen.m_96637_() && !shiftPressed) {
                GuiWaypoints.this.selectedListSet.clear();
            }
            if (currentSize > 0 && shiftPressed) {
                int direction = e.index > GuiWaypoints.this.shiftSelectFirst ? 1 : -1;
                GuiWaypoints.this.selectedListSet.clear();
                for (int i = GuiWaypoints.this.shiftSelectFirst; i != e.index + direction; i += direction) {
                    GuiWaypoints.this.selectedListSet.add(i);
                }
            } else if (GuiWaypoints.this.selectedListSet.contains(e.index)) {
                GuiWaypoints.this.selectedListSet.remove(e.index);
            } else {
                GuiWaypoints.this.shiftSelectFirst = e.index;
                GuiWaypoints.this.selectedListSet.add(e.index);
            }
            super.m_6987_((AbstractSelectionList.Entry)(GuiWaypoints.this.selectedListSet.isEmpty() ? null : e));
        }

        public int getItemHeight() {
            return this.f_93387_;
        }

        public void drawWaypointSlot(GuiGraphics guiGraphics, Waypoint w, int p_180791_2_, int p_180791_3_) {
            PoseStack matrixStack = guiGraphics.m_280168_();
            if (w == null) {
                return;
            }
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
            guiGraphics.m_280137_(GuiWaypoints.this.f_96547_, w.getLocalizedName() + (String)(w.isDisabled() ? " \u00a74" + I18n.m_118938_((String)"gui.xaero_disabled", (Object[])new Object[0]) : (w.isTemporary() ? " \u00a74" + I18n.m_118938_((String)"gui.xaero_temporary", (Object[])new Object[0]) : "")), p_180791_2_ + 110, p_180791_3_ + 1, 0xFFFFFF);
            int rectX = p_180791_2_ + 8 + 4;
            int rectY = p_180791_3_ + 6;
            if (w.isGlobal()) {
                guiGraphics.m_280137_(GuiWaypoints.this.f_96547_, "*", rectX - 25, rectY - 3, 0xFFFFFF);
            }
            int opacity = 90;
            MultiBufferSource.BufferSource renderTypeBuffers = GuiWaypoints.this.modMain.getHudRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
            GuiWaypoints.this.modMain.getMinimap().getWaypointGuiRenderer().drawIconOnGUI(guiGraphics, GuiWaypoints.this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().getHelper(), w, rectX, rectY, opacity, renderTypeBuffers, renderTypeBuffers.m_6299_(CustomRenderTypes.COLORED_WAYPOINTS_BGS), renderTypeBuffers.m_6299_(CustomRenderTypes.GUI_NEAREST));
            renderTypeBuffers.m_109911_();
            matrixStack.m_85849_();
        }

        public int getEntryAt(double x, double y) {
            WaypointEntry entry = (WaypointEntry)this.m_93412_(x, y);
            return entry == null ? -1 : entry.index;
        }

        public class WaypointEntry
        extends ObjectSelectionList.Entry<WaypointEntry> {
            private int index;

            public WaypointEntry(int index) {
                this.index = index;
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int p_render_6_, int p_render_7_, boolean p_render_8_, float p_render_9_) {
                Waypoint w = List.this.getWaypoint(index);
                if (w == GuiWaypoints.this.draggingWaypoint) {
                    return;
                }
                List.this.drawWaypointSlot(guiGraphics, w, p_render_3_, p_render_2_);
            }

            public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                return p_mouseClicked_5_ == 0;
            }

            public Component m_142172_() {
                Waypoint w = List.this.getWaypoint(this.index);
                Object narration = "";
                if (w != null) {
                    narration = (String)narration + I18n.m_118938_((String)"narrator.select", (Object[])new Object[]{w.getName()}) + (String)(w.isDisabled() ? " " + I18n.m_118938_((String)"gui.xaero_disabled", (Object[])new Object[0]) : "") + (String)(w.isTemporary() ? " " + I18n.m_118938_((String)"gui.xaero_temporary", (Object[])new Object[0]) : "") + ", ";
                }
                if (GuiWaypoints.this.selectedListSet.size() != 1) {
                    narration = (String)narration + I18n.m_118938_((String)"narrator.select", (Object[])new Object[]{I18n.m_118938_((String)"gui.xaero_waypoints", (Object[])new Object[0]) + " " + GuiWaypoints.this.selectedListSet.size()});
                }
                return Component.m_237113_((String)narration);
            }
        }
    }
}

