/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import com.mojang.authlib.GameProfile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import xaero.common.HudMod;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.events.ClientEvents;
import xaero.hud.minimap.Minimap;

public class ClientEventsForge
extends ClientEvents {
    public ClientEventsForge(HudMod modMain) {
        super(modMain);
    }

    @SubscribeEvent
    public boolean handleGuiOpenEvent(ScreenEvent.Opening event) {
        Screen guiBefore = event.getNewScreen();
        Screen gui = this.handleGuiOpen(guiBefore);
        if (guiBefore != null && gui == null) {
            return true;
        }
        event.setNewScreen(gui);
        return false;
    }

    @SubscribeEvent
    public boolean handleClientSendChatEvent(ClientChatEvent e) {
        return this.handleClientSendChatEvent(e.getMessage());
    }

    @SubscribeEvent
    public boolean handleClientChatReceivedEvent(ClientChatReceivedEvent e) {
        GameProfile gameProfile;
        if (e.getMessage() == null) {
            return false;
        }
        Component text = e.getMessage();
        PlayerInfo playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(e.getSender());
        GameProfile gameProfile2 = gameProfile = playerInfo == null ? null : playerInfo.getProfile();
        return gameProfile != null && this.handleClientPlayerChatReceivedEvent(e.getBoundChatType(), text, gameProfile);
    }

    @SubscribeEvent
    public void handleDrawScreenEventPost(ScreenEvent.Render.Post event) {
        this.handleDrawScreenEventPost(event.getScreen());
    }

    @SubscribeEvent
    public void worldUnload(LevelEvent.Unload event) {
        this.worldUnload(event.getLevel());
    }

    @SubscribeEvent
    public void handleClientTickEventPre(TickEvent.ClientTickEvent.Pre event) {
        this.handleClientTickStart();
    }

    @SubscribeEvent
    public void handlePlayerTickEventPre(TickEvent.PlayerTickEvent.Pre event) {
        this.handlePlayerTickStart(event.player());
    }

    @SubscribeEvent
    public void handleRenderTickEvent(TickEvent.RenderTickEvent.Pre event) {
        this.handleRenderTickStart();
    }

    @SubscribeEvent(priority=-128)
    public void handleBossHealthRender(CustomizeGuiOverlayEvent.BossEventProgress event) {
        XaeroMinimapCore.onBossHealthRender(event.getY() + event.getIncrement());
    }

    @SubscribeEvent
    public void handleTextureStitchEventPost(TextureStitchEvent.Post event) {
        this.handleTextureStitchEventPost(event.getAtlas());
    }

    @SubscribeEvent
    public void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        this.modMain.ensureControlsRegister();
        this.modMain.getControlsRegister().registerKeybindings(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0), c -> {});
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelEvent.BakingCompleted event) {
        Minimap minimap = this.modMain.getMinimap();
        if (minimap != null) {
            minimap.getMinimapFBORenderer().resetEntityIconsResources();
        }
    }

    @SubscribeEvent
    public void handleRegisterClientResourceReloadListeners(RegisterClientReloadListenersEvent event) {
    }
}

