/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import xaero.common.graphics.OpenGlHelper;
import xaero.lib.common.reflection.util.ReflectionUtils;

public class ImprovedFramebuffer
extends TextureTarget {
    private static Field MAIN_RENDER_TARGET_FIELD = ReflectionUtils.getFieldReflection(Minecraft.class, (String)"mainRenderTarget", (String)"field_1689", (String)"Lnet/minecraft/class_276;", (String)"f_91042_");
    private static RenderTarget mainRenderTargetBackup;

    public ImprovedFramebuffer(int width, int height, boolean useDepthIn) {
        super(null, width, height, useDepthIn);
    }

    public void bindDefaultFramebuffer(Minecraft mc) {
        ImprovedFramebuffer.restoreMainRenderTarget();
    }

    public void bindRead() {
        RenderSystem.setShaderTexture((int)0, (GpuTexture)this.colorTexture);
    }

    public void generateMipmaps() {
        OpenGlHelper.bindTexture(0, this.colorTexture);
        OpenGlHelper.generateMipmaps();
    }

    private void forceAsMainRenderTarget() {
        if (mainRenderTargetBackup == null) {
            mainRenderTargetBackup = (RenderTarget)ReflectionUtils.getReflectFieldValue((Object)Minecraft.getInstance(), (Field)MAIN_RENDER_TARGET_FIELD);
        }
        ReflectionUtils.setReflectFieldValue((Object)Minecraft.getInstance(), (Field)MAIN_RENDER_TARGET_FIELD, (Object)((Object)this));
    }

    public static void restoreMainRenderTarget() {
        if (mainRenderTargetBackup != null) {
            ReflectionUtils.setReflectFieldValue((Object)Minecraft.getInstance(), (Field)MAIN_RENDER_TARGET_FIELD, (Object)mainRenderTargetBackup);
            mainRenderTargetBackup = null;
        }
    }

    public void bindAsMainTarget(boolean viewport) {
        this.forceAsMainRenderTarget();
    }

    public void setColorTexture(GpuTexture texture) {
        this.colorTexture = texture;
    }

    public void setDepthTexture(GpuTexture depthTexture) {
        this.depthTexture = depthTexture;
    }
}

