/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.hud.Hud;
import xaero.hud.module.HudModule;
import xaero.hud.module.ModuleSession;
import xaero.hud.preset.HudPreset;
import xaero.hud.pushbox.PushboxHandler;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public final class HudRenderer {
    private final PushboxHandler pushboxHandler;
    private final CustomVertexConsumers customVertexConsumers;

    public HudRenderer(PushboxHandler pushboxHandler) {
        this.pushboxHandler = pushboxHandler;
        this.customVertexConsumers = new CustomVertexConsumers();
    }

    public void render(Hud hud, MatrixStack matrixStack, float partialTicks) {
        Minecraft.func_71410_x().func_228019_au_().func_228487_b_().func_228461_a_();
        while (GL11.glGetError() != 0) {
        }
        GlStateManager.func_227673_b_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Minecraft mc = Minecraft.func_71410_x();
        int screenWidth = mc.func_228018_at_().func_198107_o();
        int screenHeight = mc.func_228018_at_().func_198087_p();
        double screenScale = mc.func_228018_at_().func_198100_s();
        ModuleRenderContext renderContext = new ModuleRenderContext(screenWidth, screenHeight, screenScale);
        this.pushboxHandler.updateAll(hud.getPushboxManager());
        if (mc.field_71462_r == null) {
            for (HudPreset hudPreset : hud.getPresetManager().getPresets()) {
                hudPreset.cancel();
            }
        }
        for (HudModule hudModule : hud.getModuleManager().getModules()) {
            this.renderModule(hudModule, hud, renderContext, matrixStack, partialTicks);
        }
        this.pushboxHandler.postUpdateAll(hud.getPushboxManager());
        RenderSystem.enableDepthTest();
    }

    private <MS extends ModuleSession<MS>> void renderModule(HudModule<MS> module, Hud hud, ModuleRenderContext c, MatrixStack matrixStack, float partialTicks) {
        MS session = module.getCurrentSession();
        ((ModuleSession)session).prePotentialRender();
        if (!((ModuleSession)session).isActive()) {
            return;
        }
        if (module.getUsedTransform().fromOldSystem) {
            hud.getOldSystemCompatibility().convertTransform(module.getUsedTransform(), (ModuleSession<?>)session, c);
        }
        IModuleRenderer<MS> renderer = module.getRenderer();
        PushboxHandler.State currentPushState = module.getPushState();
        currentPushState.resetForModule((ModuleSession<?>)session, c.screenWidth, c.screenHeight, c.screenScale);
        this.pushboxHandler.applyScreenEdges(currentPushState, c.screenWidth, c.screenHeight, c.screenScale);
        this.pushboxHandler.applyPushboxes(hud.getPushboxManager(), currentPushState, c.screenWidth, c.screenHeight, c.screenScale);
        c.x = currentPushState.x;
        c.y = currentPushState.y;
        c.w = ((ModuleSession)session).getWidth(c.screenScale);
        c.h = ((ModuleSession)session).getHeight(c.screenScale);
        c.flippedVertically = ((ModuleSession)session).shouldFlipVertically(c.screenHeight, c.screenScale);
        c.flippedHorizontally = ((ModuleSession)session).shouldFlipHorizontally(c.screenWidth, c.screenScale);
        renderer.render(session, c, matrixStack, partialTicks);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
    }

    public PushboxHandler getPushboxHandler() {
        return this.pushboxHandler;
    }

    public CustomVertexConsumers getCustomVertexConsumers() {
        return this.customVertexConsumers;
    }
}

