/*
 * Decompiled with CFR 0.152.
 */
package xaero.pvp.gui;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiEditMode;
import xaero.common.gui.GuiReset;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.ScreenSwitchSettingEntry;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.radar.category.EntityRadarCategoryManager;
import xaero.hud.pvp.common.config.option.BetterPVPProfiledConfigOptions;
import xaero.hud.pvp.controls.key.BetterPVPKeyMappings;
import xaero.lib.client.controls.util.KeyMappingUtils;
import xaero.lib.client.gui.GuiConstants;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.config.EditConfigScreen;
import xaero.lib.client.gui.config.context.IEditConfigScreenContext;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.common.config.Config;
import xaero.lib.common.config.option.BuiltInProfiledConfigOptions;
import xaero.lib.common.config.option.ConfigOption;
import xaero.pvp.gui.GuiCustomization;

public class GuiPvpSettings
extends EditConfigScreen {
    public GuiPvpSettings(IXaeroMinimap modMain, Screen par1GuiScreen, Screen escScreen, IEditConfigScreenContext context) {
        super((Component)Component.translatable((String)"gui.xaero_better_pvp_settings"), par1GuiScreen, escScreen, context, HudMod.INSTANCE.getHudConfigs());
        ScreenSwitchSettingEntry customizationEntry = new ScreenSwitchSettingEntry("gui.xaero_custom_settings", (current, escape) -> new GuiCustomization(modMain, (Screen)current, (Screen)escape, context), null, true);
        ScreenSwitchSettingEntry resetEntry = new ScreenSwitchSettingEntry("gui.xaero_reset_config_profile_default", (current, escape) -> new GuiReset(this::resetConfirmResult, par1GuiScreen, (Screen)escape), null, true, false);
        ScreenSwitchSettingEntry editEntry = new ScreenSwitchSettingEntry("gui.xaero_edit_mode", (current, escape) -> new GuiEditMode(modMain, (Screen)current, (Screen)escape, true, (Component)Component.translatable((String)"gui.xaero_welcome_edit_mode")), context.isClientSide() ? null : new Tooltip(GuiConstants.SETTING_ENTRY_WRONG_CONTEXT_COMPONENT), context.isClientSide());
        ScreenSwitchSettingEntry waypointsEntry = new ScreenSwitchSettingEntry("gui.xaero_waypoints", (current, escape) -> {
            MinimapSession minimapSession2 = BuiltInHudModules.MINIMAP.getCurrentSession();
            if (minimapSession2 != null && modMain.getSettings().waypointsGUI(minimapSession2)) {
                return new GuiWaypoints((HudMod)modMain, minimapSession2, (Screen)this, (Screen)escape);
            }
            return null;
        }, context.isClientSide() ? null : new Tooltip(GuiConstants.SETTING_ENTRY_WRONG_CONTEXT_COMPONENT), () -> {
            if (!context.isClientSide()) {
                return false;
            }
            MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
            return minimapSession != null && modMain.getSettings().waypointsGUI(minimapSession);
        });
        this.entries = new ISettingEntry[]{this.createProfileIDEntry(), this.optionEntry(BuiltInProfiledConfigOptions.PROFILE_NAME), customizationEntry, editEntry, this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.DISPLAY_MINIMAP), waypointsEntry, this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.ARMOR_STATUS), this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.STATUS_EFFECTS), this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.NOTIFICATIONS), this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.XP_DROPS), this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.BETTER_SPRINT), this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.TOGGLED_SNEAK), this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.QUICK_USE), this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.ENTITY_INFO), this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.ITEM_TOOLTIP), resetEntry, this.optionEntry((ConfigOption)BuiltInProfiledConfigOptions.IGNORE_ENFORCEMENT_IF_EDITOR)};
        this.canSearch = false;
        this.canSkipWorldRender = false;
        this.shouldRenderEscapeScreen = false;
    }

    protected void onEditedProfileSwitch() {
        super.onEditedProfileSwitch();
        EntityRadarCategoryManager categoryManager = HudMod.INSTANCE.getEntityRadarCategoryManager();
        categoryManager.forgetEditedCategory();
    }

    private void resetConfirmResult(boolean b) {
        if (b) {
            EntityRadarCategoryManager categoryManager = HudMod.INSTANCE.getEntityRadarCategoryManager();
            if (categoryManager.getEditedCategory() == null) {
                categoryManager.loadEditedCategory((Config)this.context.getCurrentProfile(this.channel), this.context.isClientSide());
            }
            categoryManager.resetRootCategorySettings(this.context);
            this.resetProfileToDefaults();
        }
        this.minecraft.setScreen((Screen)this);
    }

    public boolean keyPressed(int key, int scancode, int mods) {
        if (super.keyPressed(key, scancode, mods)) {
            return true;
        }
        if (this.context.isClientSide() && KeyMappingUtils.inputMatches((InputConstants.Type)InputConstants.Type.KEYSYM, (int)key, (KeyMapping)BetterPVPKeyMappings.SETTINGS, (int)0) || !this.context.isClientSide() && KeyMappingUtils.inputMatches((InputConstants.Type)InputConstants.Type.KEYSYM, (int)key, (KeyMapping)BetterPVPKeyMappings.SERVER_PROFILES, (int)0)) {
            this.onExit(this.escape);
            return true;
        }
        return false;
    }

    public void init() {
        super.init();
        this.screenTitle = this.title;
        if (ModSettings.serverSettings != ModSettings.defaultSettings) {
            this.screenTitle = Component.literal((String)("\u00a7e" + I18n.get((String)"gui.xaero_server_disabled", (Object[])new Object[0])));
        }
    }
}

