/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.effect;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import xaero.hud.pvp.module.effect.StatusEffectSession;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class StatusEffectRenderer
implements IModuleRenderer<StatusEffectSession> {
    @Override
    public void render(StatusEffectSession session, ModuleRenderContext c, GuiGraphics guiGraphics, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        if (!mc.player.getActiveEffects().isEmpty()) {
            this.renderEffects(session, guiGraphics, c, mc);
        }
    }

    private void renderEffects(StatusEffectSession session, GuiGraphics guiGraphics, ModuleRenderContext c, Minecraft mc) {
        Collection effects;
        if (c.flippedVertically) {
            c.y = c.y + c.h - 30;
        }
        if ((effects = mc.player.getActiveEffects()).isEmpty()) {
            return;
        }
        effects = Ordering.natural().sortedCopy((Iterable)effects);
        RenderSystem.enableBlend();
        if (session.isBlinkEnabled() && System.currentTimeMillis() - session.getLastBlink() > 500L) {
            session.setLastBlink(System.currentTimeMillis());
            session.setBlink(!session.getBlink());
        }
        if (session.isCentered()) {
            this.renderCentered(session, guiGraphics, c, mc, effects);
            return;
        }
        this.renderNormal(session, guiGraphics, c, mc, effects);
    }

    private void renderCentered(StatusEffectSession session, GuiGraphics guiGraphics, ModuleRenderContext c, Minecraft mc, Collection<MobEffectInstance> effects) {
        MobEffectTextureManager potionspriteuploader = mc.getMobEffectTextures();
        int columnWidth = 27;
        int defaultEffectAmount = 182 / columnWidth;
        if (effects.size() > defaultEffectAmount) {
            columnWidth = 182 / effects.size();
        }
        int totalSize = effects.size() * columnWidth;
        int firstColumn = c.x + c.w / 2 + totalSize / 2 * (c.flippedHorizontally ? 1 : -1);
        if (c.flippedHorizontally) {
            firstColumn -= columnWidth;
        }
        int currentX = firstColumn + (columnWidth - 18) / 2;
        int currentY = c.y + 7;
        for (MobEffectInstance effectInstance : effects) {
            Holder effect;
            TextureAtlasSprite effectSprite;
            int duration = effectInstance.getDuration();
            float alpha = 1.0f;
            if (!effectInstance.isInfiniteDuration() && duration <= 200 && !session.getBlink() && session.isBlinkEnabled()) {
                alpha = 0.2f;
            }
            if ((effectSprite = potionspriteuploader.get(effect = effectInstance.getEffect())) != null) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)effectSprite.atlasLocation());
                guiGraphics.blit(currentX, currentY, 0, 18, 18, effectSprite, 1.0f, 1.0f, 1.0f, alpha);
            }
            Component durationString = MobEffectUtil.formatDuration((MobEffectInstance)effectInstance, (float)1.0f, (float)mc.level.tickRateManager().tickrate());
            int amplifier = effectInstance.getAmplifier();
            String levelString = amplifier > 0 ? "" + (effectInstance.getAmplifier() + 1) : "";
            guiGraphics.drawString(mc.font, levelString, currentX, currentY, 0xFFFFFF);
            guiGraphics.drawString(mc.font, durationString, currentX + 10 - mc.font.width((FormattedText)durationString) / 2, currentY + 15, 0xFFFFFF);
            RenderSystem.enableBlend();
            currentX += columnWidth * (c.flippedHorizontally ? -1 : 1);
        }
    }

    private void renderNormal(StatusEffectSession session, GuiGraphics guiGraphics, ModuleRenderContext c, Minecraft mc, Collection<MobEffectInstance> effects) {
        int rowHeight = 25;
        if (effects.size() > 6) {
            rowHeight = 135 / (effects.size() - 1);
        }
        MobEffectTextureManager potionspriteuploader = mc.getMobEffectTextures();
        for (MobEffectInstance effectInstance : effects) {
            Component potionName;
            Holder effect;
            TextureAtlasSprite effectSprite;
            int duration = effectInstance.getDuration();
            float alpha = 1.0f;
            if (!effectInstance.isInfiniteDuration() && duration <= 200 && !session.getBlink() && session.isBlinkEnabled()) {
                alpha = 0.2f;
            }
            if ((effectSprite = potionspriteuploader.get(effect = effectInstance.getEffect())) != null) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)effectSprite.atlasLocation());
                guiGraphics.blit(c.flippedHorizontally ? c.x + c.w - 24 : c.x + 6, c.y + 7, 0, 18, 18, effectSprite, 1.0f, 1.0f, 1.0f, alpha);
            }
            Component durationString = MobEffectUtil.formatDuration((MobEffectInstance)effectInstance, (float)1.0f, (float)mc.level.tickRateManager().tickrate());
            if (!session.shouldShowNames()) {
                potionName = durationString;
                durationString = null;
            } else {
                potionName = Component.translatable((String)((MobEffect)effect.value()).getDescriptionId());
                if (effectInstance.getAmplifier() >= 1 && effectInstance.getAmplifier() <= 9) {
                    potionName.getSiblings().add(Component.literal((String)" "));
                    potionName.getSiblings().add(Component.translatable((String)("enchantment.level." + (effectInstance.getAmplifier() + 1))));
                }
            }
            int amplifier = effectInstance.getAmplifier();
            String levelString = amplifier > 0 ? "" + (effectInstance.getAmplifier() + 1) : "";
            guiGraphics.drawString(mc.font, levelString, c.flippedHorizontally ? c.x + c.w - 24 : c.x + 6, c.y + 7, 0xFFFFFF);
            guiGraphics.drawString(mc.font, potionName, c.flippedHorizontally ? c.x + c.w - 28 - mc.font.width((FormattedText)potionName) : c.x + 10 + 18, c.y + 7, 0xFFFFFF);
            if (durationString != null) {
                guiGraphics.drawString(mc.font, durationString, c.flippedHorizontally ? c.x + c.w - 28 - mc.font.width((FormattedText)durationString) : c.x + 10 + 18, c.y + 7 + 10, 0xFFFFFF);
            }
            RenderSystem.enableBlend();
            c.y = c.y + (c.flippedVertically ? -rowHeight : rowHeight);
        }
    }
}

