/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.config.util;

import java.util.List;
import java.util.Set;
import net.minecraft.class_1132;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import xaero.common.HudMod;
import xaero.common.effect.Effects;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.misc.Misc;
import xaero.hud.gui.util.GuiUtils;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.option.IndexedConfigOption;
import xaero.lib.common.config.profile.ConfigProfile;

public class MinimapConfigClientUtils {
    public static float getUIScale(ClientConfigManager configManager, IndexedConfigOption<Integer> option) {
        List validValues = option.getValidValues();
        return MinimapConfigClientUtils.getUIScale(configManager, option, (Integer)validValues.get(0), (Integer)validValues.get(validValues.size() - 1), 1.0);
    }

    public static float getUIScale(ClientConfigManager configManager, IndexedConfigOption<Integer> option, double autoScale) {
        List validValues = option.getValidValues();
        return MinimapConfigClientUtils.getUIScale(configManager, option, (Integer)validValues.get(0), (Integer)validValues.get(validValues.size() - 1), autoScale);
    }

    public static float getUIScale(ClientConfigManager configManager, ConfigOption<Integer> option, int auto, int max, double autoScale) {
        int configValue = (Integer)configManager.getEffective(option);
        float configBasedScale = GuiUtils.getUIScale(configValue, auto, max);
        if (configValue == auto && autoScale != 1.0) {
            return (float)Math.ceil((double)configBasedScale * autoScale);
        }
        return configBasedScale;
    }

    public static double getWaypointsClampDepth(ClientConfigManager configManager, double fov, int height) {
        int baseIconScale = (int)MinimapConfigClientUtils.getUIScale(configManager, (IndexedConfigOption<Integer>)MinimapProfiledConfigOptions.WAYPOINT_ICON_SCALE_IN_WORLD);
        double ingameCloseScale = (Double)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINT_CLOSE_SCALE_IN_WORLD);
        double frameSizeAtClampDepth = ingameCloseScale * 0.02133333496749401 * (double)height / (double)baseIconScale;
        double fovMultiplier = 2.0 * Math.tan(Math.toRadians(fov / 2.0));
        return frameSizeAtClampDepth / fovMultiplier;
    }

    public static void addAutoUIScaleValueToComponent(class_5250 component, double autoScale) {
        component.method_10855().add(class_2561.method_43470((String)(" (" + (int)Math.ceil((double)GuiUtils.getAutoUIScale() * autoScale) + ")")));
    }

    public static void addAutoMCScaleValueToComponent(class_5250 component) {
        component.method_10855().add(class_2561.method_43470((String)(" (" + class_310.method_1551().method_22683().method_4495() + ")")));
    }

    public static int getAutoMinimapSize() {
        int width;
        int height = class_310.method_1551().method_22683().method_4506();
        int size = (int)((float)(height <= (width = class_310.method_1551().method_22683().method_4489()) ? height : width) / GuiUtils.getMinimapScale(HudMod.INSTANCE.getHudConfigs().getClientConfigManager()));
        return Math.min(Math.max(55, 2 * size * 130 / 1080), 250);
    }

    public static int getEffectiveMinimapSize() {
        ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        int minimapSizeConfig = (Integer)configManager.getEffective(MinimapProfiledConfigOptions.SIZE);
        if (minimapSizeConfig > 0) {
            return minimapSizeConfig;
        }
        return MinimapConfigClientUtils.getAutoMinimapSize();
    }

    public static boolean getEffectiveNorthLocked(int mapSize, int shape) {
        if (mapSize > 180 && shape == 0) {
            return true;
        }
        ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        boolean northLockedConfig = (Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.NORTH_LOCKED);
        MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession == null) {
            return northLockedConfig;
        }
        return northLockedConfig || (Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.KEEP_ENLARGED_UNLOCKED) == false && minimapSession.getProcessor().isEnlargedMap();
    }

    private static void changeZoomUnchecked(ClientConfigManager configManager, int direction) {
        ConfigProfile currentProfile = configManager.getCurrentProfile();
        currentProfile.set((ConfigOption)MinimapProfiledConfigOptions.ZOOM, (Object)(1 + class_3532.method_15387((int)((Integer)currentProfile.get((ConfigOption)MinimapProfiledConfigOptions.ZOOM) - 1 + direction), (int)5)));
    }

    public static void changeZoom(int direction) {
        ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession == null) {
            MinimapConfigClientUtils.changeZoomUnchecked(configManager, direction);
            return;
        }
        double targetBefore = minimapSession.getProcessor().getTargetZoom();
        int attempts = 0;
        do {
            MinimapConfigClientUtils.changeZoomUnchecked(configManager, direction);
        } while (++attempts < 5 && targetBefore == minimapSession.getProcessor().getTargetZoom());
        if (attempts == 5) {
            MinimapConfigClientUtils.changeZoomUnchecked(configManager, direction);
        }
    }

    public static boolean getEffectiveSlimeChunks(MinimapSession session) {
        ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        boolean slimeChunksConfig = (Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.SLIME_CHUNKS);
        if (session == null) {
            return slimeChunksConfig;
        }
        if (!slimeChunksConfig) {
            return false;
        }
        if (class_310.method_1551().method_1576() != null) {
            return true;
        }
        MinimapWorld autoWorld = session.getWorldManager().getAutoWorld();
        return autoWorld != null && autoWorld.getSlimeChunkSeed() != null;
    }

    public static Long getEffectiveSlimeChunksSeed(MinimapWorld currentWorld) {
        class_1132 server = class_310.method_1551().method_1576();
        if (server != null) {
            if (class_310.method_1551().field_1687.method_27983() != class_1937.field_25179) {
                return null;
            }
            return server.method_3847(class_1937.field_25179).method_8412();
        }
        if (currentWorld == null) {
            return null;
        }
        return currentWorld.getSlimeChunkSeed();
    }

    public static boolean isFairPlayForCaveMode() {
        boolean fairplay = HudMod.INSTANCE.isFairPlay();
        if (!fairplay) {
            return false;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return true;
        }
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (session == null) {
            return true;
        }
        MinimapProcessor processor = session.getProcessor();
        return !processor.isConsideringNetherFairPlayMessage() || level.method_27983() != class_1937.field_25180;
    }

    public static boolean hasNoCaveModeEffect() {
        class_310 mc = class_310.method_1551();
        return Misc.hasEffect((class_1657)mc.field_1724, Effects.NO_CAVE_MAPS) || Misc.hasEffect((class_1657)mc.field_1724, Effects.NO_CAVE_MAPS_HARMFUL);
    }

    public static boolean getEffectiveCaveModeAllowed() {
        ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        if (!((Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.CAVE_MODE_ALLOWED)).booleanValue()) {
            return false;
        }
        Set allowedDimensionsLocal = (Set)configManager.getEffective(MinimapProfiledConfigOptions.CAVE_MODE_ALLOWED_DIMENSIONS);
        Set allowedDimensionsServer = (Set)configManager.getServerSynced().getEffective(MinimapProfiledConfigOptions.CAVE_MODE_ALLOWED_DIMENSIONS);
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return allowedDimensionsLocal.isEmpty() && allowedDimensionsServer.isEmpty();
        }
        class_2960 currentDimensionId = level.method_27983().method_29177();
        if (!allowedDimensionsLocal.isEmpty() && !allowedDimensionsLocal.contains(currentDimensionId)) {
            return false;
        }
        return allowedDimensionsServer == null || allowedDimensionsServer.isEmpty() || allowedDimensionsServer.contains(currentDimensionId);
    }
}

