/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_10366;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_276;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_583;
import net.minecraft.class_897;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.icon.XaeroIcon;
import xaero.common.icon.XaeroIconAtlas;
import xaero.common.icon.XaeroIconAtlasManager;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.hud.compat.mods.ImmediatelyFastHelper;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.RadarIconManager;
import xaero.hud.minimap.radar.icon.creator.render.form.IRadarIconFormPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.trace.EntityRenderTracer;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.hud.minimap.radar.icon.definition.form.RadarIconForm;
import xaero.hud.minimap.radar.icon.definition.form.model.config.RadarIconModelConfig;
import xaero.lib.client.graphics.util.ImmediateRenderUtil;

public class RadarIconCreator {
    private static final int PREFERRED_ATLAS_WIDTH = 1024;
    public static final int ICON_WIDTH = 64;
    public static final int FAR_PLANE = 500;
    private ImprovedFramebuffer formRenderFramebuffer;
    private ImprovedFramebuffer iconRenderFramebuffer;
    private ImprovedFramebuffer atlasRenderFramebuffer;
    private final EntityRenderTracer renderTracer = new EntityRenderTracer();
    private final XaeroIconAtlasManager iconAtlasManager;
    private Matrix4f projectionMatrixBackup;
    private class_10366 projectionTypeBackup;

    public RadarIconCreator() {
        int maxTextureSize = GlStateManager._getInteger((int)3379);
        int atlasTextureSize = Math.min(maxTextureSize, 1024) / 64 * 64;
        this.iconAtlasManager = new XaeroIconAtlasManager(64, atlasTextureSize, new ArrayList<XaeroIconAtlas>());
        this.initFramebuffers(atlasTextureSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends class_10017> XaeroIcon create(class_332 guiGraphics, class_897<?, ? super S> entityRenderer, S entityRenderState, class_1297 entity, class_276 defaultFramebuffer, Parameters parameters) {
        IRadarIconFormPrerenderer formPrerenderer = parameters.form.getPrerenderer();
        if (formPrerenderer == null) {
            MinimapLogs.LOGGER.error("Tried prerendering radar icon for {} variant {} but the icon form used doesn't have a prerenderer!", (Object)class_1299.method_5890((class_1299)entity.method_5864()), parameters.variant);
            return RadarIconManager.FAILED;
        }
        OpenGLException.checkGLError();
        class_4587 matrixStack = guiGraphics.method_51448();
        guiGraphics.method_51452();
        ImmediatelyFastHelper.triggerBatchingBuffersFlush(guiGraphics);
        this.formRenderFramebuffer.bindAsMainTarget(true);
        this.setupMatrices(matrixStack, 64, 500);
        OpenGLException.checkGLError();
        if (entityRenderState instanceof class_10042) {
            class_10042 livingEntityRenderState = (class_10042)entityRenderState;
            livingEntityRenderState.field_53457 = false;
        }
        List<ModelRenderTrace> traceResult = null;
        class_583<? super S> entityModel = null;
        if (formPrerenderer.requiresEntityModel()) {
            GlStateManager._enableCull();
            if (class_310.method_1551().method_1561().field_4686 != null) {
                traceResult = this.renderTracer.trace(matrixStack, entity, entityRenderer, entityRenderState);
                this.formRenderFramebuffer.bindAsMainTarget(true);
            } else {
                MinimapLogs.LOGGER.info("Render info was null for entity " + entity.method_5820());
            }
            entityModel = this.renderTracer.getEntityRendererModel(entityRenderer);
            if (entityModel == null) {
                this.endFormRendering();
                this.bindDefaultFramebuffer(defaultFramebuffer);
                this.restoreMatrices(matrixStack);
                return RadarIconManager.FAILED;
            }
        }
        boolean formRenderResult = false;
        class_4587.class_4665 matrixEntryToRestore = matrixStack.method_23760();
        matrixStack.method_22903();
        try {
            GlStateManager._clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager._clear((int)16640);
            formRenderResult = formPrerenderer.prerender(guiGraphics, entityRenderer, entityRenderState, entityModel, entity, traceResult, parameters);
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("Exception using the radar icon form prerenderer for entity {} variant {}!", (Object)class_1299.method_5890((class_1299)entity.method_5864()), parameters.variant, (Object)t);
        }
        finally {
            guiGraphics.method_51452();
            while (matrixStack.method_23760() != matrixEntryToRestore) {
                matrixStack.method_22909();
            }
        }
        this.endFormRendering();
        XaeroIcon icon = parameters.form.getFailureResult();
        if (formRenderResult) {
            icon = this.getFinalIcon(matrixStack, entity, formPrerenderer, parameters);
        }
        this.restoreMatrices(matrixStack);
        this.atlasRenderFramebuffer.method_1240();
        this.bindDefaultFramebuffer(defaultFramebuffer);
        return icon;
    }

    private XaeroIcon getFinalIcon(class_4587 matrixStack, class_1297 entity, IRadarIconFormPrerenderer formPrerenderer, Parameters parameters) {
        this.iconRenderFramebuffer.bindAsMainTarget(true);
        GlStateManager._clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager._clear((int)16384);
        GlStateManager._disableBlend();
        if (parameters.debug) {
            matrixStack.method_22903();
            matrixStack.method_46416(18.0f, 10.0f, -10.0f);
            matrixStack.method_22905(1.0f, 1.0f, 1.0f);
            ImmediateRenderUtil.coloredRectangle((class_4587)matrixStack, (float)0.0f, (float)0.0f, (float)9.0f, (float)9.0f, (int)-16776961);
            matrixStack.method_22909();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        }
        this.formRenderFramebuffer.method_35610();
        boolean outlined = formPrerenderer.isOutlined();
        boolean flipped = formPrerenderer.isFlipped();
        if (outlined) {
            this.renderOutline(matrixStack);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager._disableBlend();
        ImmediateRenderUtil.texturedRect((class_4587)matrixStack, (float)0.0f, (float)0.0f, (int)0, (int)0, (float)64.0f, (float)64.0f, (float)64.0f, (float)64.0f, (float)0.05f);
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        if (parameters.debug) {
            matrixStack.method_22903();
            matrixStack.method_46416(27.0f, 10.0f, -10.0f);
            matrixStack.method_22905(1.0f, 1.0f, 1.0f);
            ImmediateRenderUtil.coloredRectangle((class_4587)matrixStack, (float)0.0f, (float)0.0f, (float)9.0f, (float)9.0f, (int)-16711681);
            matrixStack.method_22909();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        }
        GlStateManager._enableBlend();
        this.iconRenderFramebuffer.method_1240();
        this.iconRenderFramebuffer.method_35610();
        this.iconRenderFramebuffer.generateMipmaps();
        GlStateManager._bindTexture((int)0);
        XaeroIcon icon = null;
        try {
            XaeroIconAtlas atlas = this.getCurrentAtlas();
            icon = atlas.createIcon();
            this.atlasRenderFramebuffer.bindAsMainTarget(false);
            GlStateManager._viewport((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)64, (int)64);
            this.atlasRenderFramebuffer.setFramebufferTexture(atlas.getTextureId());
            this.atlasRenderFramebuffer.method_1239();
            this.iconRenderFramebuffer.method_35610();
            GlStateManager._disableBlend();
            if (flipped) {
                ImmediateRenderUtil.texturedRect((class_4587)matrixStack, (float)0.0f, (float)0.0f, (int)0, (int)64, (float)64.0f, (float)64.0f, (float)-64.0f, (float)64.0f, (float)-1.0f);
            } else {
                ImmediateRenderUtil.texturedRect((class_4587)matrixStack, (float)0.0f, (float)0.0f, (int)0, (int)0, (float)64.0f, (float)64.0f, (float)64.0f, (float)64.0f, (float)-1.0f);
            }
            if (parameters.debug) {
                matrixStack.method_22903();
                matrixStack.method_46416(36.0f, 10.0f, -10.0f);
                matrixStack.method_22905(1.0f, 1.0f, 1.0f);
                ImmediateRenderUtil.coloredRectangle((class_4587)matrixStack, (float)0.0f, (float)0.0f, (float)9.0f, (float)9.0f, (int)-256);
                matrixStack.method_22909();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            }
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("Exception rendering to a entity icon atlas for {} {}!", (Object)class_1299.method_5890((class_1299)entity.method_5864()), parameters.variant, (Object)t);
        }
        GlStateManager._enableBlend();
        GlStateManager._bindTexture((int)0);
        MinimapRendererHelper.restoreDefaultShaderBlendState();
        return icon;
    }

    private void renderOutline(class_4587 matrixStack) {
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager._enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)1);
        for (int shadowOffsetX = -1; shadowOffsetX < 2; ++shadowOffsetX) {
            for (int shadowOffsetY = -1; shadowOffsetY < 2; ++shadowOffsetY) {
                if (shadowOffsetX == 0 && shadowOffsetY == 0) continue;
                ImmediateRenderUtil.drawOutlineLayer((class_4587)matrixStack, (float)shadowOffsetX, (float)shadowOffsetY, (int)0, (int)0, (float)64.0f, (float)64.0f, (float)64.0f, (float)64.0f, (float)0.05f);
            }
        }
    }

    private void setupMatrices(class_4587 matrixStack, int finalIconSize, int farPlane) {
        this.projectionMatrixBackup = RenderSystem.getProjectionMatrix();
        this.projectionTypeBackup = RenderSystem.getProjectionType();
        matrixStack.method_22903();
        matrixStack.method_34426();
        Matrix4f ortho = new Matrix4f().setOrtho(0.0f, (float)finalIconSize, (float)finalIconSize, 0.0f, -1.0f, (float)farPlane);
        RenderSystem.setProjectionMatrix((Matrix4f)ortho, (class_10366)class_10366.field_54954);
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().identity();
    }

    private void restoreMatrices(class_4587 matrixStack) {
        matrixStack.method_22909();
        RenderSystem.setProjectionMatrix((Matrix4f)this.projectionMatrixBackup, (class_10366)this.projectionTypeBackup);
        RenderSystem.getModelViewStack().popMatrix();
    }

    private void endFormRendering() {
        this.formRenderFramebuffer.method_1240();
        GlStateManager._enableBlend();
        class_308.method_24211();
        class_308.method_24210();
    }

    private void bindDefaultFramebuffer(class_276 defaultFramebuffer) {
        if (defaultFramebuffer != null) {
            if (defaultFramebuffer instanceof ImprovedFramebuffer) {
                ((ImprovedFramebuffer)defaultFramebuffer).bindAsMainTarget(true);
                return;
            }
            ImprovedFramebuffer.restoreMainRenderTarget();
            defaultFramebuffer.method_1235(true);
            return;
        }
        this.atlasRenderFramebuffer.bindDefaultFramebuffer(class_310.method_1551());
        GlStateManager._viewport((int)0, (int)0, (int)class_310.method_1551().method_22683().method_4489(), (int)class_310.method_1551().method_22683().method_4506());
    }

    public void clearAtlases() {
        this.iconAtlasManager.clearAtlases();
        this.atlasRenderFramebuffer.setFramebufferTexture(0);
    }

    public EntityRenderTracer getRenderTracer() {
        return this.renderTracer;
    }

    private XaeroIconAtlas getCurrentAtlas() {
        return this.iconAtlasManager.getCurrentAtlas();
    }

    private void initFramebuffers(int atlasTextureSize) {
        this.formRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
        OpenGLException.checkGLError();
        this.iconRenderFramebuffer = new ImprovedFramebuffer(512, 512, false);
        OpenGLException.checkGLError();
        this.formRenderFramebuffer.method_35610();
        OpenGLException.checkGLError();
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager._texImage2D((int)3553, (int)0, (int)32856, (int)this.formRenderFramebuffer.field_1480, (int)this.formRenderFramebuffer.field_1477, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager._bindTexture((int)0);
        this.iconRenderFramebuffer.method_35610();
        GL11.glTexParameteri((int)3553, (int)33085, (int)3);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager._texImage2D((int)3553, (int)0, (int)32856, (int)this.iconRenderFramebuffer.field_1480, (int)this.iconRenderFramebuffer.field_1477, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager._bindTexture((int)0);
        this.atlasRenderFramebuffer = new ImprovedFramebuffer(atlasTextureSize, atlasTextureSize, false);
        OpenGLException.checkGLError();
        GlStateManager._deleteTexture((int)this.atlasRenderFramebuffer.getFramebufferTexture());
        this.atlasRenderFramebuffer.setFramebufferTexture(0);
        OpenGLException.checkGLError();
    }

    public static class Parameters {
        public final Object variant;
        public final float scale;
        public final RadarIconModelConfig defaultModelConfig;
        public final RadarIconForm form;
        public final boolean debug;

        public Parameters(Object variant, RadarIconModelConfig defaultModelConfig, RadarIconForm form, float scale, boolean debug) {
            this.variant = variant;
            this.scale = scale;
            this.defaultModelConfig = defaultModelConfig;
            this.form = form;
            this.debug = debug;
        }
    }
}

