/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import xaero.common.HudMod;
import xaero.hud.minimap.common.config.MinimapConfigConstants;
import xaero.hud.minimap.common.config.info.config.InfoDisplayConfigData;
import xaero.hud.minimap.common.config.info.config.InfoDisplayManagerConfigData;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.info.InfoDisplay;
import xaero.hud.minimap.info.InfoDisplayManager;
import xaero.hud.minimap.info.config.InfoDisplayConfigClientUtils;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.config.EditConfigScreen;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.client.gui.widget.dropdown.IDropDownContainer;
import xaero.lib.client.gui.widget.dropdown.IDropDownWidgetCallback;
import xaero.lib.common.config.Config;

public class GuiInfoDisplayEdit
extends ScreenBase {
    private static final int FRAME_TOP_SIZE = 30;
    private static final int FRAME_BOTTOM_SIZE = 61;
    private static final int SELECTION_ITEM_HEIGHT = 24;
    private static final ITextComponent HELP_COMPONENT = new TextComponentTranslation("gui.xaero_minimap_info_display_manager_help", new Object[0]);
    private static final ITextComponent SERVER_ENFORCED_COMPONENT = new TextComponentTranslation("gui.xaero_info_display_editor_server_enforced", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
    private SelectionList selectionList;
    private final InfoDisplayManager manager;
    private List<String> currentOrder;
    private int selected;
    private final Map<String, MoveableEntry<?>> moveableEntries;
    private final boolean clientSide;
    private InfoDisplayManagerConfigData inputConfig;
    private final Config config;
    private final Runnable onChange;
    private final boolean viewingEnforced;
    private boolean madeChanges;
    private GuiButton doneButton;

    public GuiInfoDisplayEdit(EditConfigScreen parent, GuiScreen escape, Config config, Runnable onChange, boolean viewingEnforced) {
        super((GuiScreen)parent, escape, (ITextComponent)new TextComponentTranslation("gui.xaero_minimap_info_display_manager", new Object[0]));
        this.config = config;
        this.onChange = onChange;
        this.clientSide = parent.getContext().isClientSide();
        this.viewingEnforced = viewingEnforced;
        this.manager = HudMod.INSTANCE.getMinimap().getInfoDisplays().getManager();
        this.inputConfig = (InfoDisplayManagerConfigData)config.get(MinimapProfiledConfigOptions.INFO_DISPLAY_CONFIG);
        if (this.inputConfig == null || this.inputConfig == InfoDisplayManagerConfigData.EMPTY) {
            this.inputConfig = InfoDisplayConfigClientUtils.createDefaultConfig(this.manager, null, this.clientSide);
        }
        this.currentOrder = this.manager.adaptOrder(this.inputConfig.getOrderStream());
        this.moveableEntries = new HashMap();
        this.selected = -1;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.title = new TextComponentTranslation("gui.xaero_minimap_info_display_manager", new Object[0]);
        this.selectionList = new SelectionList();
        this.doneButton = new GuiButton(-1, this.field_146294_l / 2 - 100, this.field_146295_m - 34, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.func_189646_b(this.doneButton);
        if (this.moveableEntries.isEmpty()) {
            for (String id : this.currentOrder) {
                InfoDisplay<?> infoDisplay = this.manager.get(id);
                MoveableEntry<?> moveable = this.createEntryFor(infoDisplay);
                this.moveableEntries.put(id, moveable);
            }
        }
        this.moveableEntries.values().forEach(new Consumer<MoveableEntry<?>>(){

            @Override
            public void accept(MoveableEntry<?> e) {
                GuiInfoDisplayEdit.this.refreshEntry(e);
            }
        });
    }

    private <T> MoveableEntry<T> createEntryFor(InfoDisplay<T> infoDisplay) {
        MoveableEntry<T> moveable = new MoveableEntry<T>(infoDisplay);
        InfoDisplayConfigData infoDisplayConfig = this.inputConfig.get(infoDisplay.getId());
        if (infoDisplayConfig == null) {
            infoDisplayConfig = InfoDisplayConfigClientUtils.createDefaultConfig(infoDisplay, null, this.clientSide);
        }
        String configStateString = infoDisplayConfig.getState();
        ((MoveableEntry)moveable).textColor = infoDisplayConfig.getTextColor();
        ((MoveableEntry)moveable).backgroundColor = infoDisplayConfig.getBackgroundColor();
        ((MoveableEntry)moveable).state = configStateString == null ? null : infoDisplay.getCodec().decode(configStateString, null, null);
        return moveable;
    }

    private <T> void refreshEntry(MoveableEntry<T> moveable) {
        ((MoveableEntry)moveable).clearSubElements();
        this.addSubElements(moveable);
    }

    public void onExit(GuiScreen screen) {
        super.onExit(screen);
        if (this.madeChanges) {
            this.onChange.run();
        }
    }

    private void saveToConfigProfile() {
        InfoDisplayManagerConfigData.Builder builder = InfoDisplayManagerConfigData.Builder.begin();
        for (String id : this.currentOrder) {
            MoveableEntry<?> editorEntry = this.moveableEntries.get(id);
            String stateString = this.encodeState(editorEntry);
            builder.add(id, new InfoDisplayConfigData(((MoveableEntry)editorEntry).backgroundColor, ((MoveableEntry)editorEntry).textColor, stateString));
        }
        InfoDisplayManagerConfigData outputConfig = builder.build();
        this.config.set(MinimapProfiledConfigOptions.INFO_DISPLAY_CONFIG, (Object)outputConfig);
        this.madeChanges = true;
    }

    private <T> String encodeState(MoveableEntry<T> editorEntry) {
        return ((MoveableEntry)editorEntry).state == null ? null : ((MoveableEntry)editorEntry).infoDisplay.getCodec().encode(((MoveableEntry)editorEntry).state, null, null);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.doneButton) {
            this.goBack();
        }
    }

    public String[] createColorOptions(String symbol, boolean noneOption, boolean nullOption) {
        int firstColorIndex = (noneOption ? 1 : 0) + (nullOption ? 1 : 0);
        String[] options = new String[MinimapConfigConstants.COLOR_NAMES.length + firstColorIndex];
        if (nullOption) {
            options[0] = "~";
        }
        if (noneOption) {
            options[firstColorIndex - 1] = "\u25a1\u25a1";
        }
        for (int i = 0; i < MinimapConfigConstants.COLOR_NAMES.length; ++i) {
            options[i + firstColorIndex] = "\u00a7" + MinimapConfigConstants.COLOR_CODES[i] + symbol;
        }
        return options;
    }

    private <T> void addSubElements(final MoveableEntry<T> moveable) {
        int currentSelectedBackground;
        int currentSelectedTextColor;
        boolean includeNull;
        boolean bl = includeNull = !this.clientSide || this.viewingEnforced;
        if (!(includeNull || ((MoveableEntry)moveable).state != null && ((MoveableEntry)moveable).textColor != null && ((MoveableEntry)moveable).backgroundColor != null)) {
            throw new IllegalArgumentException();
        }
        GuiButton stateWidget = ((MoveableEntry)moveable).infoDisplay.createWidget(this.field_146294_l / 2 + 150 - 102, 0, 100, 20, moveable, new Runnable(){

            @Override
            public void run() {
                GuiInfoDisplayEdit.this.saveToConfigProfile();
            }
        }, includeNull);
        if (stateWidget != null) {
            moveable.addSubElement(stateWidget);
        }
        int n = currentSelectedTextColor = ((MoveableEntry)moveable).textColor == null ? -1 : ((MoveableEntry)moveable).textColor % MinimapConfigConstants.COLOR_NAMES.length;
        if (includeNull) {
            ++currentSelectedTextColor;
        }
        if (currentSelectedTextColor < 0) {
            currentSelectedTextColor = 0;
            ((MoveableEntry)moveable).textColor = includeNull ? null : Integer.valueOf(0);
        }
        DropDownWidget textColorWidget = DropDownWidget.Builder.begin().setOptions(this.createColorOptions("Aa", false, includeNull)).setX(this.field_146294_l / 2 - 147).setW(20).setSelected(Integer.valueOf(currentSelectedTextColor)).setContainer((IDropDownContainer)this).setCallback(new IDropDownWidgetCallback(){

            public boolean onSelected(DropDownWidget menu, int index) {
                if (includeNull && index == 0) {
                    moveable.textColor = null;
                } else {
                    moveable.textColor = index - (includeNull ? 1 : 0);
                }
                GuiInfoDisplayEdit.this.saveToConfigProfile();
                return true;
            }
        }).build();
        moveable.addSubElement((GuiButton)textColorWidget);
        int n2 = ((MoveableEntry)moveable).backgroundColor == null ? 0 : (currentSelectedBackground = (((MoveableEntry)moveable).backgroundColor < 0 ? ((MoveableEntry)moveable).backgroundColor : ((MoveableEntry)moveable).backgroundColor % MinimapConfigConstants.COLOR_NAMES.length) + 1 + (includeNull ? 1 : 0));
        if (currentSelectedBackground < 0) {
            currentSelectedBackground = 0;
            ((MoveableEntry)moveable).backgroundColor = includeNull ? null : Integer.valueOf(-1);
        }
        DropDownWidget backgroundColorWidget = DropDownWidget.Builder.begin().setOptions(this.createColorOptions("\u25a0\u25a0", true, includeNull)).setX(this.field_146294_l / 2 - 124).setW(20).setSelected(Integer.valueOf(currentSelectedBackground)).setContainer((IDropDownContainer)this).setCallback(new IDropDownWidgetCallback(){

            public boolean onSelected(DropDownWidget menu, int index) {
                if (includeNull && index == 0) {
                    moveable.backgroundColor = null;
                } else {
                    moveable.backgroundColor = index - 1 - (includeNull ? 1 : 0);
                }
                GuiInfoDisplayEdit.this.saveToConfigProfile();
                return true;
            }
        }).build();
        moveable.addSubElement((GuiButton)backgroundColorWidget);
        if (this.viewingEnforced) {
            if (stateWidget != null) {
                stateWidget.field_146124_l = false;
            }
            textColorWidget.field_146124_l = false;
            backgroundColorWidget.field_146124_l = false;
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.handledMouseInput) {
            return;
        }
        if (this.selectionList != null) {
            this.selectionList.func_178039_p();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        if (this.handledMouseInput) {
            return;
        }
        if (this.selectionList != null && this.selectionList.mouseClicked(mouseX, mouseY, button)) {
            this.handledMouseInput = true;
            return;
        }
    }

    protected void func_146286_b(int d, int e, int i) {
        if (this.selectionList != null) {
            this.selectionList.releaseDrag();
            if (this.selectionList.mouseReleased(d, e, i)) {
                this.handledMouseInput = true;
                return;
            }
        }
        if (this.handledMouseInput) {
            return;
        }
        super.func_146286_b(d, e, i);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.selectionList.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, this.title.func_150254_d(), this.field_146294_l / 2, 5, -1);
        if (this.clientSide) {
            this.func_73732_a(this.field_146289_q, HELP_COMPONENT.func_150254_d(), this.field_146294_l / 2, this.field_146295_m - 52, -1);
        }
        if (this.viewingEnforced) {
            this.func_73732_a(this.field_146289_q, SERVER_ENFORCED_COMPONENT.func_150254_d(), this.field_146294_l / 2, 15, -1);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    class SelectionList
    extends GuiSlot {
        private List<Entry> entries;
        private boolean dragging;
        private int dragStartX;
        private int dragStartY;
        private int dragged;
        private int draggedOffsetX;
        private int draggedOffsetY;

        public SelectionList() {
            super(GuiInfoDisplayEdit.this.field_146297_k, GuiInfoDisplayEdit.this.field_146294_l, GuiInfoDisplayEdit.this.field_146295_m, 30, GuiInfoDisplayEdit.this.field_146295_m - 61, 24);
            this.entries = new ArrayList<Entry>();
            this.createEntries();
            if (GuiInfoDisplayEdit.this.selected != -1) {
                this.setSelected(GuiInfoDisplayEdit.this.selected);
            }
            this.dragged = -1;
        }

        private void addEntry(Entry entry) {
            this.entries.add(entry);
        }

        private Entry getEntry(int index) {
            if (index < 0 || index >= this.entries.size()) {
                return null;
            }
            return this.entries.get(index);
        }

        private Entry getSelected() {
            return this.getEntry(GuiInfoDisplayEdit.this.selected);
        }

        public void setSelected(int index) {
            Entry entry = this.getEntry(index);
            GuiInfoDisplayEdit.this.selected = entry == null ? -1 : entry.index;
        }

        private void createEntries() {
            for (int i = 0; i < GuiInfoDisplayEdit.this.currentOrder.size(); ++i) {
                Entry entry = new Entry(i);
                this.addEntry(entry);
            }
        }

        private void releaseDrag() {
            this.dragging = false;
            this.dragged = -1;
        }

        protected int func_148137_d() {
            return this.field_148155_a / 2 + 164;
        }

        public int func_148139_c() {
            return 300;
        }

        public void func_148128_a(int mouseXIn, int mouseYIn, float partialTicks) {
            super.func_148128_a(mouseXIn, mouseYIn, partialTicks);
            if (this.dragging) {
                int hoveredIndex;
                Entry draggedEntry = this.getEntry(this.dragged);
                draggedEntry.renderNonInteractable(this.field_148150_g + this.draggedOffsetX, this.field_148162_h + this.draggedOffsetY);
                Entry hoveredEntry = this.getEntry(this.func_148124_c(this.field_148150_g, this.field_148162_h));
                int n = hoveredIndex = hoveredEntry == null ? -1 : hoveredEntry.index;
                if (hoveredIndex != -1 && hoveredIndex != this.dragged) {
                    String draggedId = (String)GuiInfoDisplayEdit.this.currentOrder.get(this.dragged);
                    int slideDirection = hoveredIndex < this.dragged ? 1 : -1;
                    for (int i = this.dragged; i != hoveredIndex; i -= slideDirection) {
                        GuiInfoDisplayEdit.this.currentOrder.set(i, GuiInfoDisplayEdit.this.currentOrder.get(i - slideDirection));
                    }
                    GuiInfoDisplayEdit.this.currentOrder.set(hoveredIndex, draggedId);
                    this.dragged = hoveredIndex;
                    GuiInfoDisplayEdit.this.saveToConfigProfile();
                }
            } else if (this.dragged != -1 && (Math.abs(this.field_148150_g - this.dragStartX) > 5 || Math.abs(this.field_148162_h - this.dragStartY) > 5)) {
                this.dragging = true;
                this.setSelected(-1);
            }
        }

        protected void func_192637_a(int slotIndex, int xPos, int yPos, int heightIn, int mouseXIn, int mouseYIn, float partialTicks) {
            this.getEntry(slotIndex).render(slotIndex, yPos, xPos, mouseXIn, mouseYIn, partialTicks);
        }

        protected int func_148127_b() {
            return this.entries.size();
        }

        protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
        }

        public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
            Entry e;
            int slotIndex;
            return this.func_148141_e(mouseY) && (slotIndex = this.func_148124_c(mouseX, mouseY)) >= 0 && slotIndex < this.entries.size() && (e = this.entries.get(slotIndex)).mouseClicked(mouseX, mouseY, mouseButton);
        }

        protected boolean func_148131_a(int slotIndex) {
            return GuiInfoDisplayEdit.this.selected == slotIndex;
        }

        protected void func_148123_a() {
            GuiInfoDisplayEdit.this.func_146276_q_();
        }

        public boolean mouseReleased(int d, int e, int i) {
            Entry entry = this.getEntry(this.func_148124_c(d, e));
            if (entry == null) {
                return false;
            }
            MoveableEntry moveableEntry = entry.getMoveable();
            for (GuiButton subElement : moveableEntry.subElements) {
                subElement.func_146118_a(d, e);
            }
            return false;
        }

        public boolean func_148125_i() {
            if (this.dragging) {
                return false;
            }
            return super.func_148125_i();
        }

        public class Entry {
            private final int index;
            private int lastRenderX;
            private int lastRenderY;

            public Entry(int index) {
                this.index = index;
            }

            private void renderNonInteractable(int x, int y) {
                String infoDisplayId = (String)GuiInfoDisplayEdit.this.currentOrder.get(this.index);
                InfoDisplay<?> infoDisplay = GuiInfoDisplayEdit.this.manager.get(infoDisplayId);
                GuiInfoDisplayEdit.this.func_73731_b(GuiInfoDisplayEdit.this.field_146289_q, infoDisplay.getName().func_150254_d(), x + 48, y + 6, -1);
            }

            private MoveableEntry<?> getMoveable() {
                String infoDisplayId = (String)GuiInfoDisplayEdit.this.currentOrder.get(this.index);
                return (MoveableEntry)GuiInfoDisplayEdit.this.moveableEntries.get(infoDisplayId);
            }

            public void render(int index, int y, int x, int mouseX, int mouseY, float partialTicks) {
                this.lastRenderX = x;
                this.lastRenderY = y;
                if (SelectionList.this.dragging && SelectionList.this.dragged == index) {
                    return;
                }
                this.renderNonInteractable(x, y);
                MoveableEntry<?> moveableEntry = this.getMoveable();
                for (GuiButton subElement : ((MoveableEntry)moveableEntry).subElements) {
                    subElement.field_146129_i = y - 2 + 12 - subElement.field_146121_g / 2;
                    if (subElement instanceof DropDownWidget) {
                        --subElement.field_146129_i;
                    }
                    subElement.func_191745_a(SelectionList.this.field_148161_k, mouseX, mouseY, partialTicks);
                }
            }

            public boolean mouseClicked(double d, double e, int i) {
                MoveableEntry<?> moveableEntry = this.getMoveable();
                for (GuiButton subElement : ((MoveableEntry)moveableEntry).subElements) {
                    if (!subElement.func_146115_a() || !subElement.func_146116_c(SelectionList.this.field_148161_k, (int)d, (int)e)) continue;
                    subElement.func_146113_a(SelectionList.this.field_148161_k.func_147118_V());
                    return true;
                }
                if (i == 0) {
                    SelectionList.this.setSelected(this.index);
                    SelectionList.this.dragging = false;
                    if (!GuiInfoDisplayEdit.this.clientSide || GuiInfoDisplayEdit.this.viewingEnforced) {
                        return true;
                    }
                    SelectionList.this.dragged = this.index;
                    SelectionList.this.draggedOffsetX = (int)((double)this.lastRenderX - d);
                    SelectionList.this.draggedOffsetY = (int)((double)this.lastRenderY - e);
                    SelectionList.this.dragStartX = (int)d;
                    SelectionList.this.dragStartY = (int)e;
                } else {
                    SelectionList.this.setSelected(-1);
                }
                return false;
            }

            public boolean mouseReleased(int d, int e, int i) {
                MoveableEntry<?> moveableEntry = this.getMoveable();
                for (GuiButton subElement : ((MoveableEntry)moveableEntry).subElements) {
                    subElement.func_146118_a(d, e);
                }
                return false;
            }
        }
    }

    public class MoveableEntry<T> {
        private final List<GuiButton> subElements;
        private final InfoDisplay<T> infoDisplay;
        private T state;
        private Integer textColor;
        private Integer backgroundColor;

        public MoveableEntry(InfoDisplay<T> infoDisplay) {
            this.infoDisplay = infoDisplay;
            this.subElements = new ArrayList<GuiButton>();
        }

        public void addSubElement(GuiButton widget) {
            this.subElements.add(widget);
        }

        public T getState() {
            return this.state;
        }

        public void setState(T state) {
            this.state = state;
        }

        private void clearSubElements() {
            this.subElements.clear();
        }
    }
}

