/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiEditMode;
import xaero.common.gui.GuiEntityRadarSettings;
import xaero.common.gui.GuiMinimapBlockMapSettings;
import xaero.common.gui.GuiMinimapInfoSettings;
import xaero.common.gui.GuiMinimapMiscSettings;
import xaero.common.gui.GuiMinimapOverlaysSettings;
import xaero.common.gui.GuiMinimapSettings;
import xaero.common.gui.GuiMinimapViewSettings;
import xaero.common.gui.GuiReset;
import xaero.common.gui.GuiWaypointSettings;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.ScreenSwitchSettingEntry;
import xaero.common.misc.BooleanConsumer;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.module.MinimapSession;
import xaero.lib.client.gui.GuiConstants;
import xaero.lib.client.gui.GuiSettings;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.config.context.BuiltInEditConfigScreenContexts;
import xaero.lib.client.gui.config.context.IEditConfigScreenContext;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.common.config.option.BuiltInProfiledConfigOptions;
import xaero.lib.common.config.option.ConfigOption;

public class GuiMinimapMain
extends GuiMinimapSettings {
    private ISettingEntry[] mainEntries;
    private ISettingEntry[] searchableEntries;

    public GuiMinimapMain(GuiScreen current) {
        this(HudMod.INSTANCE, current, ScreenBase.tryToGetEscape((GuiScreen)current), true, BuiltInEditConfigScreenContexts.CLIENT);
    }

    public GuiMinimapMain(final IXaeroMinimap modMain, final GuiScreen par1GuiScreen, GuiScreen escScreen, boolean profileOptions, final IEditConfigScreenContext context) {
        super((ITextComponent)new TextComponentTranslation("gui.xaero_minimap_settings", new Object[0]), par1GuiScreen, escScreen, context);
        ScreenSwitchSettingEntry changePositionEntry = new ScreenSwitchSettingEntry("gui.xaero_change_position", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen e) {
                return par1GuiScreen instanceof GuiEditMode ? par1GuiScreen : new GuiEditMode(modMain, current, GuiMinimapMain.this.escape, false, (ITextComponent)new TextComponentTranslation("gui.xaero_minimap_guide", new Object[0]));
            }
        }, context.isClientSide() ? null : new Tooltip(GuiConstants.SETTING_ENTRY_WRONG_CONTEXT_COMPONENT), context.isClientSide());
        ScreenSwitchSettingEntry viewSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_minimap_view_settings", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiMinimapViewSettings(modMain, current, escape, context);
            }
        }, null, true);
        ScreenSwitchSettingEntry entityRadarSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_entity_radar_settings", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiEntityRadarSettings(modMain, current, escape, context);
            }
        }, null, true);
        ScreenSwitchSettingEntry blockMapSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_minimap_block_map_settings", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiMinimapBlockMapSettings(modMain, current, escape, context);
            }
        }, null, true);
        ScreenSwitchSettingEntry overlaySettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_overlay_settings", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiMinimapOverlaysSettings(modMain, current, escape, context);
            }
        }, null, true);
        ScreenSwitchSettingEntry infoSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_minimap_info_settings", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiMinimapInfoSettings(modMain, current, escape, context);
            }
        }, null, true);
        ScreenSwitchSettingEntry waypointSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_waypoint_settings", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiWaypointSettings(modMain, current, escape, context);
            }
        }, null, true);
        ScreenSwitchSettingEntry miscSettingsEntry = new ScreenSwitchSettingEntry("gui.xaero_minimap_misc_settings", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiMinimapMiscSettings(current, escape, context);
            }
        }, null, true);
        ScreenSwitchSettingEntry waypointsEntry = new ScreenSwitchSettingEntry("gui.xaero_waypoints", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                MinimapSession minimapSession2 = BuiltInHudModules.MINIMAP.getCurrentSession();
                if (minimapSession2 != null && modMain.getSettings().waypointsGUI(minimapSession2)) {
                    return new GuiWaypoints((HudMod)modMain, minimapSession2, (GuiScreen)GuiMinimapMain.this, escape);
                }
                return null;
            }
        }, context.isClientSide() ? null : new Tooltip(GuiConstants.SETTING_ENTRY_WRONG_CONTEXT_COMPONENT), new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                if (!context.isClientSide()) {
                    return false;
                }
                MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
                return minimapSession != null && modMain.getSettings().waypointsGUI(minimapSession);
            }
        });
        ArrayList<Object> mainEntriesBuilder = new ArrayList<Object>();
        if (profileOptions) {
            mainEntriesBuilder.add(this.createProfileIDEntry());
            mainEntriesBuilder.add(this.optionEntry(BuiltInProfiledConfigOptions.PROFILE_NAME));
        }
        mainEntriesBuilder.addAll(Lists.newArrayList((Object[])new ISettingEntry[]{this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.DISPLAY_MINIMAP), changePositionEntry, viewSettingsEntry, blockMapSettingsEntry, entityRadarSettingsEntry, overlaySettingsEntry, infoSettingsEntry, waypointSettingsEntry, miscSettingsEntry, waypointsEntry, this.optionEntry((ConfigOption)BuiltInProfiledConfigOptions.IGNORE_ENFORCEMENT_IF_EDITOR)}));
        if (modMain.isStandalone()) {
            mainEntriesBuilder.add(new ScreenSwitchSettingEntry("gui.xaero_reset_config_profile_default", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

                @Override
                public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                    return new GuiReset(new BooleanConsumer(){

                        @Override
                        public void accept(boolean b) {
                            GuiMinimapMain.this.resetConfirmResult(b);
                        }
                    }, par1GuiScreen, escape);
                }
            }, null, true, false));
        }
        this.mainEntries = mainEntriesBuilder.toArray(new ISettingEntry[0]);
        this.updateSearchableEntries();
    }

    private void resetConfirmResult(boolean b) {
        if (b) {
            HudMod.INSTANCE.getEntityRadarCategoryManager().resetRootCategorySettings(this.context);
            this.resetProfileToDefaults();
        }
        this.field_146297_k.func_147108_a((GuiScreen)this);
    }

    private void updateSearchableEntries() {
        if (this.mainEntries == null) {
            return;
        }
        LinkedHashSet<ISettingEntry> searchableEntriesBuilder = new LinkedHashSet<ISettingEntry>();
        for (ISettingEntry entry : this.mainEntries) {
            if (entry instanceof ScreenSwitchSettingEntry) {
                ScreenSwitchSettingEntry screenSwitchEntry = (ScreenSwitchSettingEntry)entry;
                GuiScreen tempScreen = screenSwitchEntry.getScreenFactory().apply((GuiScreen)this, (GuiScreen)this);
                if (tempScreen instanceof GuiSettings) {
                    GuiSettings tempSettingsScreen = (GuiSettings)tempScreen;
                    ISettingEntry[] settingsScreenEntries = tempSettingsScreen.getEntriesCopy();
                    if (settingsScreenEntries == null) continue;
                    searchableEntriesBuilder.addAll(Arrays.asList(settingsScreenEntries));
                    continue;
                }
                searchableEntriesBuilder.add(entry);
                continue;
            }
            searchableEntriesBuilder.add(entry);
        }
        this.searchableEntries = searchableEntriesBuilder.toArray(new ISettingEntry[0]);
    }

    public void func_73866_w_() {
        this.entries = this.entryFilter.isEmpty() ? this.mainEntries : this.searchableEntries;
        super.func_73866_w_();
        if (ModSettings.serverSettings != ModSettings.defaultSettings) {
            this.screenTitle = new TextComponentString("\u00a7e" + I18n.func_135052_a((String)"gui.xaero_server_disabled", (Object[])new Object[0]));
        }
    }
}

