/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.widget.GuiActionButton;
import xaero.lib.client.gui.widget.Tooltip;

public class ScreenSwitchSettingEntry
implements ISettingEntry {
    private String name;
    private BiFunction<GuiScreen, GuiScreen, GuiScreen> screenFactory;
    private Supplier<Tooltip> tooltipSupplier;
    private BooleanSupplier activeSupplier;
    private final boolean consideredAnExit;

    public ScreenSwitchSettingEntry(String name, BiFunction<GuiScreen, GuiScreen, GuiScreen> screenFactoryFromCurrentAndEscape, Tooltip tooltip, boolean active) {
        this(name, screenFactoryFromCurrentAndEscape, tooltip, active, true);
    }

    public ScreenSwitchSettingEntry(String name, BiFunction<GuiScreen, GuiScreen, GuiScreen> screenFactoryFromCurrentAndEscape, Tooltip tooltip, BooleanSupplier activeSupplier) {
        this(name, screenFactoryFromCurrentAndEscape, tooltip, activeSupplier, true);
    }

    public ScreenSwitchSettingEntry(String name, BiFunction<GuiScreen, GuiScreen, GuiScreen> screenFactoryFromCurrentAndEscape, Tooltip tooltip, final boolean active, boolean consideredAnExit) {
        this(name, screenFactoryFromCurrentAndEscape, tooltip, new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return active;
            }
        }, consideredAnExit);
    }

    public ScreenSwitchSettingEntry(String name, BiFunction<GuiScreen, GuiScreen, GuiScreen> screenFactoryFromCurrentAndEscape, final Tooltip tooltip, BooleanSupplier activeSupplier, boolean consideredAnExit) {
        this.name = name;
        this.screenFactory = screenFactoryFromCurrentAndEscape;
        this.tooltipSupplier = new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return tooltip;
            }
        };
        this.activeSupplier = activeSupplier;
        this.consideredAnExit = consideredAnExit;
    }

    public String getStringForSearch() {
        Tooltip entryTooltip = this.tooltipSupplier == null ? null : this.tooltipSupplier.get();
        String tooltipFullCode = entryTooltip == null ? null : entryTooltip.getFullCode();
        return I18n.func_135052_a((String)this.name, (Object[])new Object[0]) + " " + this.name.replace("gui.xaero", "") + (tooltipFullCode != null ? " " + tooltipFullCode.replace("gui.xaero", "") : "") + (entryTooltip != null ? " " + entryTooltip.getPlainText() : "");
    }

    public GuiButton createWidget(int x, int y, int w, int screenWidth) {
        GuiActionButton button = new GuiActionButton(x, y, w, 20, I18n.func_135052_a((String)this.name, (Object[])new Object[0])){

            protected void onPress() {
                Minecraft mc = Minecraft.func_71410_x();
                GuiScreen current = mc.field_71462_r;
                GuiScreen currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
                GuiScreen targetScreen = (GuiScreen)ScreenSwitchSettingEntry.this.screenFactory.apply(current, currentEscScreen);
                if (ScreenSwitchSettingEntry.this.consideredAnExit && current instanceof ScreenBase) {
                    ((ScreenBase)current).onExit(targetScreen);
                } else {
                    mc.func_147108_a(targetScreen);
                }
            }
        };
        button.setXaero_tooltip(this.tooltipSupplier);
        button.field_146124_l = this.activeSupplier.getAsBoolean();
        return button;
    }

    public BiFunction<GuiScreen, GuiScreen, GuiScreen> getScreenFactory() {
        return this.screenFactory;
    }
}

