/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.category.setting;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.hud.category.setting.ObjectCategorySetting;
import xaero.hud.category.ui.setting.EditorSettingType;
import xaero.hud.category.util.CategoryConstants;
import xaero.hud.minimap.radar.category.EntityRadarCategoryConstants;
import xaero.hud.minimap.radar.color.RadarColor;
import xaero.lib.common.gui.widget.TooltipInfo;

public class EntityRadarCategorySettings {
    public static final String[] ENTITY_ICONS_OPTIONS = new String[]{"gui.xaero_icons_off", "gui.xaero_icons_list", "gui.xaero_icons_always", "-"};
    public static final String[] ENTITY_NAMES_OPTIONS = new String[]{"gui.xaero_names_off", "gui.xaero_names_list", "gui.xaero_names_always", "-"};
    public static final String[] RADAR_OVER_MAP_OPTIONS = new String[]{"gui.xaero_radar_over_map_never", "gui.xaero_radar_over_map_list", "gui.xaero_radar_over_map_always", "-"};
    public static final Map<String, ObjectCategorySetting<?>> SETTINGS = EntityRadarCategoryConstants.MAP_FACTORY.get();
    public static final List<ObjectCategorySetting<?>> SETTINGS_LIST = EntityRadarCategoryConstants.LIST_FACTORY.get();
    public static final ObjectCategorySetting<Boolean> DISPLAYED = ObjectCategorySetting.Builder.begin().setId("displayed").setDefaultValue(true).setDisplayName((ITextComponent)new TextComponentTranslation("gui.xaero_radar_displayed", new Object[0])).setSettingUIType(EditorSettingType.ITERATION_BUTTON).setUiFirstOption(0).setUiLastOption(1).setIndexReader(new IntFunction<Boolean>(){

        @Override
        public Boolean apply(int x) {
            return x == 1;
        }
    }).setIndexWriter(new Function<Boolean, Integer>(){

        @Override
        public Integer apply(Boolean x) {
            return x != false ? 1 : 0;
        }
    }).setUiValueNameProvider(new Function<Boolean, ITextComponent>(){

        @Override
        public ITextComponent apply(Boolean v) {
            return CategoryConstants.getBooleanComponent(v);
        }
    }).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> COLOR = ObjectCategorySetting.Builder.begin().setId("color").setDefaultValue(13.0).setDisplayName((ITextComponent)new TextComponentTranslation("gui.xaero_radar_dots_color", new Object[0])).setSettingUIType(EditorSettingType.EXPANDING).setUiFirstOption(-1).setUiLastOption(15).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return x;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return x.intValue();
        }
    }).setUiValueNameProvider(new Function<Double, ITextComponent>(){

        @Override
        public ITextComponent apply(Double x) {
            RadarColor color = RadarColor.fromIndex(x.intValue());
            if (color == null) {
                TextComponentString teamColorComponent = new TextComponentString("# ");
                teamColorComponent.func_150253_a().add(new TextComponentTranslation("gui.xaero_radar_dots_color_team_colour", new Object[0]));
                return teamColorComponent;
            }
            TextComponentString colorComponent = new TextComponentString("\u00a7" + color.getFormat() + "#\u00a7r ");
            colorComponent.func_150253_a().add(color.getName());
            return colorComponent;
        }
    }).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> ICONS = ObjectCategorySetting.Builder.begin().setId("icons").setDefaultValue(1.0).setDisplayName((ITextComponent)new TextComponentTranslation("gui.xaero_radar_icons_displayed", new Object[0])).setSettingUIType(EditorSettingType.ITERATION_BUTTON).setUiFirstOption(0).setUiLastOption(2).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return x;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return x.intValue();
        }
    }).setUiValueNameProvider(new Function<Double, ITextComponent>(){

        @Override
        public ITextComponent apply(Double x) {
            return new TextComponentTranslation(ENTITY_ICONS_OPTIONS[x.intValue()], new Object[0]);
        }
    }).setTooltip(new TooltipInfo("gui.xaero_box_entity_radar_icons")).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> NAMES = ObjectCategorySetting.Builder.begin().setId("names").setDefaultValue(0.0).setDisplayName((ITextComponent)new TextComponentTranslation("gui.xaero_radar_names_displayed", new Object[0])).setSettingUIType(EditorSettingType.ITERATION_BUTTON).setUiFirstOption(0).setUiLastOption(2).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return x;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return x.intValue();
        }
    }).setUiValueNameProvider(new Function<Double, ITextComponent>(){

        @Override
        public ITextComponent apply(Double x) {
            return new TextComponentTranslation(ENTITY_NAMES_OPTIONS[x.intValue()], new Object[0]);
        }
    }).setTooltip(new TooltipInfo("gui.xaero_box_entity_radar_names")).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> DOT_SIZE = ObjectCategorySetting.Builder.begin().setId("dotSize").setDefaultValue(2.0).setDisplayName((ITextComponent)new TextComponentTranslation("gui.xaero_dots_size", new Object[0])).setSettingUIType(EditorSettingType.SLIDER).setUiFirstOption(1).setUiLastOption(4).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return x;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return x.intValue();
        }
    }).setUiValueNameProvider(new Function<Double, ITextComponent>(){

        @Override
        public ITextComponent apply(Double x) {
            return new TextComponentString(x.intValue() + "");
        }
    }).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> ICON_SCALE = ObjectCategorySetting.Builder.begin().setId("iconScale").setDefaultValue(1.0).setDisplayName((ITextComponent)new TextComponentTranslation("gui.xaero_entity_heads_scale", new Object[0])).setSettingUIType(EditorSettingType.SLIDER).setUiFirstOption(5).setUiLastOption(40).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return (double)x * 0.05;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return (int)(x / 0.05);
        }
    }).setUiValueNameProvider(new Function<Double, ITextComponent>(){

        @Override
        public ITextComponent apply(Double x) {
            return new TextComponentString(String.format("%.2f", x));
        }
    }).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> HEIGHT_LIMIT = ObjectCategorySetting.Builder.begin().setId("heightLimit").setDefaultValue(20.0).setDisplayName((ITextComponent)new TextComponentTranslation("gui.xaero_height_limit", new Object[0])).setSettingUIType(EditorSettingType.SLIDER).setUiFirstOption(2).setUiLastOption(410).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return (double)x * 5.0;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return (int)(x / 5.0);
        }
    }).setUiValueNameProvider(new Function<Double, ITextComponent>(){

        @Override
        public ITextComponent apply(Double x) {
            return new TextComponentString(x.intValue() + "");
        }
    }).setTooltip(new TooltipInfo("gui.xaero_box_height_limit")).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Boolean> HEIGHT_FADE = ObjectCategorySetting.Builder.begin().setId("heightBasedFade").setDefaultValue(true).setDisplayName((ITextComponent)new TextComponentTranslation("gui.xaero_entity_depth", new Object[0])).setSettingUIType(EditorSettingType.ITERATION_BUTTON).setUiFirstOption(0).setUiLastOption(1).setIndexReader(new IntFunction<Boolean>(){

        @Override
        public Boolean apply(int x) {
            return x == 1;
        }
    }).setIndexWriter(new Function<Boolean, Integer>(){

        @Override
        public Integer apply(Boolean x) {
            return x != false ? 1 : 0;
        }
    }).setUiValueNameProvider(new Function<Boolean, ITextComponent>(){

        @Override
        public ITextComponent apply(Boolean v) {
            return CategoryConstants.getBooleanComponent(v);
        }
    }).setTooltip(new TooltipInfo("gui.xaero_box_entity_depth")).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> DISPLAY_Y = ObjectCategorySetting.Builder.begin().setId("displayHeight").setDefaultValue(0.0).setDisplayName((ITextComponent)new TextComponentTranslation("gui.xaero_entity_display_height", new Object[0])).setSettingUIType(EditorSettingType.ITERATION_BUTTON).setUiFirstOption(0).setUiLastOption(3).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return x;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return x.intValue();
        }
    }).setUiValueNameProvider(new Function<Double, ITextComponent>(){

        @Override
        public ITextComponent apply(Double x) {
            if (x.intValue() == 0) {
                return new TextComponentTranslation("gui.xaero_off", new Object[0]);
            }
            if (x.intValue() == 1) {
                return new TextComponentTranslation("gui.xaero_entity_display_height_actual", new Object[0]);
            }
            if (x.intValue() == 2) {
                return new TextComponentTranslation("gui.xaero_entity_display_height_relative", new Object[0]);
            }
            return new TextComponentTranslation("gui.xaero_entity_display_height_direction", new Object[0]);
        }
    }).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> START_FADING_AT = ObjectCategorySetting.Builder.begin().setId("startFadingAt").setDefaultValue(0.0).setDisplayName((ITextComponent)new TextComponentTranslation("gui.xaero_start_fading_at", new Object[0])).setSettingUIType(EditorSettingType.SLIDER).setUiFirstOption(0).setUiLastOption(256).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return x;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return (int)x.doubleValue();
        }
    }).setUiValueNameProvider(new Function<Double, ITextComponent>(){

        @Override
        public ITextComponent apply(Double x) {
            if (x.intValue() == 0) {
                return new TextComponentTranslation("gui.xaero_start_fading_at_auto", new Object[0]);
            }
            return new TextComponentString(x.intValue() + "");
        }
    }).setTooltip(new TooltipInfo("gui.xaero_box_start_fading_at")).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> ENTITY_NUMBER = ObjectCategorySetting.Builder.begin().setId("entityNumber").setDefaultValue(1000.0).setDisplayName((ITextComponent)new TextComponentTranslation("gui.xaero_entity_amount", new Object[0])).setSettingUIType(EditorSettingType.SLIDER).setUiFirstOption(0).setUiLastOption(10).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return (double)x * 100.0;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return (int)(x / 100.0);
        }
    }).setUiValueNameProvider(new Function<Double, ITextComponent>(){

        @Override
        public ITextComponent apply(Double x) {
            if (x.intValue() == 0) {
                return new TextComponentTranslation("gui.xaero_unlimited", new Object[0]);
            }
            return new TextComponentString(x.intValue() + "");
        }
    }).setTooltip(new TooltipInfo("gui.xaero_box_entity_amount")).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Boolean> ALWAYS_NAMETAGS = ObjectCategorySetting.Builder.begin().setId("alwaysDisplayNametags").setDefaultValue(false).setDisplayName((ITextComponent)new TextComponentTranslation("gui.xaero_always_entity_nametags", new Object[0])).setSettingUIType(EditorSettingType.ITERATION_BUTTON).setUiFirstOption(0).setUiLastOption(1).setIndexReader(new IntFunction<Boolean>(){

        @Override
        public Boolean apply(int x) {
            return x == 1;
        }
    }).setIndexWriter(new Function<Boolean, Integer>(){

        @Override
        public Integer apply(Boolean x) {
            return x != false ? 1 : 0;
        }
    }).setUiValueNameProvider(new Function<Boolean, ITextComponent>(){

        @Override
        public ITextComponent apply(Boolean v) {
            return CategoryConstants.getBooleanComponent(v);
        }
    }).setTooltip(new TooltipInfo("gui.xaero_box_always_entity_nametags2")).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Boolean> ICON_NAME_FALLBACK = ObjectCategorySetting.Builder.begin().setId("displayNameWhenIconFails").setDefaultValue(true).setDisplayName((ITextComponent)new TextComponentTranslation("gui.xaero_entity_icon_name_fallback", new Object[0])).setSettingUIType(EditorSettingType.ITERATION_BUTTON).setUiFirstOption(0).setUiLastOption(1).setIndexReader(new IntFunction<Boolean>(){

        @Override
        public Boolean apply(int x) {
            return x == 1;
        }
    }).setIndexWriter(new Function<Boolean, Integer>(){

        @Override
        public Integer apply(Boolean x) {
            return x != false ? 1 : 0;
        }
    }).setUiValueNameProvider(new Function<Boolean, ITextComponent>(){

        @Override
        public ITextComponent apply(Boolean v) {
            return CategoryConstants.getBooleanComponent(v);
        }
    }).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> RENDER_OVER_MINIMAP = ObjectCategorySetting.Builder.begin().setId("renderOverMinimapFrame").setDefaultValue(1.0).setDisplayName((ITextComponent)new TextComponentTranslation("gui.xaero_radar_render_over_minimap", new Object[0])).setSettingUIType(EditorSettingType.ITERATION_BUTTON).setUiFirstOption(0).setUiLastOption(2).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return x;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return x.intValue();
        }
    }).setUiValueNameProvider(new Function<Double, ITextComponent>(){

        @Override
        public ITextComponent apply(Double x) {
            return new TextComponentTranslation(RADAR_OVER_MAP_OPTIONS[x.intValue()], new Object[0]);
        }
    }).setTooltip(new TooltipInfo("gui.xaero_box_radar_render_over_minimap")).build(SETTINGS, SETTINGS_LIST);
    public static final ObjectCategorySetting<Double> RENDER_ORDER = ObjectCategorySetting.Builder.begin().setId("renderOrder").setDefaultValue(0.0).setDisplayName((ITextComponent)new TextComponentTranslation("gui.xaero_radar_render_order", new Object[0])).setSettingUIType(EditorSettingType.SLIDER).setUiFirstOption(0).setUiLastOption(1000).setIndexReader(new IntFunction<Double>(){

        @Override
        public Double apply(int x) {
            return x;
        }
    }).setIndexWriter(new Function<Double, Integer>(){

        @Override
        public Integer apply(Double x) {
            return x.intValue();
        }
    }).setUiValueNameProvider(new Function<Double, ITextComponent>(){

        @Override
        public ITextComponent apply(Double x) {
            return new TextComponentString(x.intValue() + "");
        }
    }).setTooltip(new TooltipInfo("gui.xaero_box_radar_render_order")).build(SETTINGS, SETTINGS_LIST);
}

