/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.trace;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import org.lwjgl.opengl.GL11;
import xaero.common.core.IXaeroMinimapModelRenderer;
import xaero.common.exception.OpenGLException;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.lib.common.reflection.util.ReflectionUtils;

public class EntityRenderTracer {
    public static boolean TRACING_MODEL_RENDERS;
    private Entity tracedEntity;
    private Render<?> tracedEntityRenderer;
    private Class<?> tracedEntityModelClass;
    private List<ModelRenderTrace> traceResultList;
    private ModelRenderTrace lastModelRenderDetected;
    private Field blendStateField;
    private Field colorMaskStateField;
    private Field depthStateField;
    private Field blendStateSrcFactorField;
    private Field blendStateDestFactorField;
    private Field blendStateAlphaSrcFactorField;
    private Field blendStateAlphaDestFactorField;
    private Field colorMaskStateRedField;
    private Field colorMaskStateGreenField;
    private Field colorMaskStateBlueField;
    private Field colorMaskStateAlphaField;
    private Field depthStateFuncField;
    private Field depthStateMaskField;
    private Field depthStateTestField;
    private Field booleanStateCurrentStateField;
    private Field cullStateField;
    private Field cullStateEnabledField;
    private Field cullStateModeField;
    private Field textureStatesField;
    private Field textureStateIdField;
    private Field activeTextureField;
    private Field colorStateField;
    private Field colorStateRedField;
    private Field colorStateGreenField;
    private Field colorStateBlueField;
    private Field colorStateAlphaField;

    public EntityRenderTracer() {
        this.initReflection();
        this.traceResultList = new ArrayList<ModelRenderTrace>();
    }

    public <T extends Entity> List<ModelRenderTrace> trace(T entity, Render<? super T> entityRenderer) {
        TRACING_MODEL_RENDERS = true;
        this.tracedEntity = entity;
        this.tracedEntityRenderer = entityRenderer;
        this.tracedEntityModelClass = null;
        this.traceResultList.clear();
        this.lastModelRenderDetected = null;
        GlStateManager.func_179094_E();
        try {
            Minecraft mc = Minecraft.func_71410_x();
            RenderManager rendermanager = mc.func_175598_ae();
            rendermanager.func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
            OpenGLException.checkGLError();
        }
        catch (Throwable e) {
            this.traceResultList.clear();
            MinimapLogs.LOGGER.error("Exception when calling the full entity renderer for {} before prerendering the icon.", (Object)EntityList.func_191301_a(entity), (Object)e);
        }
        TRACING_MODEL_RENDERS = false;
        this.tracedEntity = null;
        this.tracedEntityRenderer = null;
        GlStateManager.func_179121_F();
        while (GL11.glGetError() != 0) {
        }
        return this.traceResultList;
    }

    public void onModelRender(ModelBase model, float red, float green, float blue, float alpha) {
        ModelRenderTrace lastModelRenderDetectedBU = this.lastModelRenderDetected;
        this.lastModelRenderDetected = null;
        Object[] TEXTURES = (Object[])ReflectionUtils.getReflectFieldValue(null, (Field)this.textureStatesField);
        int textureId = (Integer)ReflectionUtils.getReflectFieldValue((Object)TEXTURES[(Integer)ReflectionUtils.getReflectFieldValue(null, (Field)this.activeTextureField)], (Field)this.textureStateIdField);
        Object BLEND = ReflectionUtils.getReflectFieldValue(null, (Field)this.blendStateField);
        Object DEPTH = ReflectionUtils.getReflectFieldValue(null, (Field)this.depthStateField);
        Object COLOR_MASK = ReflectionUtils.getReflectFieldValue(null, (Field)this.colorMaskStateField);
        Object CULL = ReflectionUtils.getReflectFieldValue(null, (Field)this.cullStateField);
        int blendSrcFactor = (Integer)ReflectionUtils.getReflectFieldValue((Object)BLEND, (Field)this.blendStateSrcFactorField);
        int blendDestFactor = (Integer)ReflectionUtils.getReflectFieldValue((Object)BLEND, (Field)this.blendStateDestFactorField);
        int blendAlphaSrcFactor = (Integer)ReflectionUtils.getReflectFieldValue((Object)BLEND, (Field)this.blendStateAlphaSrcFactorField);
        int blendAlphaDestFactor = (Integer)ReflectionUtils.getReflectFieldValue((Object)BLEND, (Field)this.blendStateAlphaDestFactorField);
        int depthFunc = (Integer)ReflectionUtils.getReflectFieldValue((Object)DEPTH, (Field)this.depthStateFuncField);
        boolean depthTest = (Boolean)ReflectionUtils.getReflectFieldValue((Object)ReflectionUtils.getReflectFieldValue((Object)DEPTH, (Field)this.depthStateTestField), (Field)this.booleanStateCurrentStateField);
        boolean depthMask = (Boolean)ReflectionUtils.getReflectFieldValue((Object)DEPTH, (Field)this.depthStateMaskField);
        boolean colorMaskR = (Boolean)ReflectionUtils.getReflectFieldValue((Object)COLOR_MASK, (Field)this.colorMaskStateRedField);
        boolean colorMaskG = (Boolean)ReflectionUtils.getReflectFieldValue((Object)COLOR_MASK, (Field)this.colorMaskStateGreenField);
        boolean colorMaskB = (Boolean)ReflectionUtils.getReflectFieldValue((Object)COLOR_MASK, (Field)this.colorMaskStateBlueField);
        boolean colorMaskA = (Boolean)ReflectionUtils.getReflectFieldValue((Object)COLOR_MASK, (Field)this.colorMaskStateAlphaField);
        boolean cullFace = (Boolean)ReflectionUtils.getReflectFieldValue((Object)ReflectionUtils.getReflectFieldValue((Object)CULL, (Field)this.cullStateEnabledField), (Field)this.booleanStateCurrentStateField);
        int cullMode = (Integer)ReflectionUtils.getReflectFieldValue((Object)CULL, (Field)this.cullStateModeField);
        if (lastModelRenderDetectedBU != null && lastModelRenderDetectedBU.hasProperties(model, textureId, blendSrcFactor, blendDestFactor, blendAlphaSrcFactor, blendAlphaDestFactor, depthTest, depthFunc, depthMask, colorMaskR, colorMaskG, colorMaskB, colorMaskA, cullFace, cullMode)) {
            this.lastModelRenderDetected = lastModelRenderDetectedBU;
            return;
        }
        this.lastModelRenderDetected = new ModelRenderTrace(model, textureId, blendSrcFactor, blendDestFactor, blendAlphaSrcFactor, blendAlphaDestFactor, depthTest, depthFunc, depthMask, colorMaskR, colorMaskG, colorMaskB, colorMaskA, red, green, blue, alpha, cullFace, cullMode);
        this.traceResultList.add(this.lastModelRenderDetected);
    }

    public void onModelPartRender(ModelRenderer modelRenderer) {
        ModelBase model = ((IXaeroMinimapModelRenderer)modelRenderer).getXaero_model();
        if (this.tracedEntityModelClass == null) {
            ModelBase currentMainModel = this.getEntityRendererModel(this.tracedEntityRenderer);
            Class<?> clazz = this.tracedEntityModelClass = currentMainModel == null ? null : currentMainModel.getClass();
            if (this.tracedEntityModelClass == null) {
                return;
            }
        }
        if (!model.getClass().isAssignableFrom(this.tracedEntityModelClass) && !this.tracedEntityModelClass.isAssignableFrom(model.getClass())) {
            return;
        }
        Object COLOR = ReflectionUtils.getReflectFieldValue(null, (Field)this.colorStateField);
        float red = ((Float)ReflectionUtils.getReflectFieldValue((Object)COLOR, (Field)this.colorStateRedField)).floatValue();
        float green = ((Float)ReflectionUtils.getReflectFieldValue((Object)COLOR, (Field)this.colorStateGreenField)).floatValue();
        float blue = ((Float)ReflectionUtils.getReflectFieldValue((Object)COLOR, (Field)this.colorStateBlueField)).floatValue();
        float alpha = ((Float)ReflectionUtils.getReflectFieldValue((Object)COLOR, (Field)this.colorStateAlphaField)).floatValue();
        this.onModelRender(model, red, green, blue, alpha);
        if (this.lastModelRenderDetected != null) {
            this.lastModelRenderDetected.addVisibleModelPart(modelRenderer, red, green, blue, alpha);
        }
    }

    public ModelBase getEntityRendererModel(Render<?> entityRenderer) {
        if (entityRenderer instanceof RenderLivingBase) {
            return ((RenderLivingBase)entityRenderer).func_177087_b();
        }
        return null;
    }

    private void initReflection() {
        this.blendStateField = ReflectionUtils.getFieldReflection(GlStateManager.class, (String)"blendState", null, null, (String)"field_179157_e");
        this.colorMaskStateField = ReflectionUtils.getFieldReflection(GlStateManager.class, (String)"colorMaskState", null, null, (String)"field_179171_s");
        this.depthStateField = ReflectionUtils.getFieldReflection(GlStateManager.class, (String)"depthState", null, null, (String)"field_179154_f");
        this.textureStatesField = ReflectionUtils.getFieldReflection(GlStateManager.class, (String)"textureState", null, null, (String)"field_179174_p");
        this.cullStateField = ReflectionUtils.getFieldReflection(GlStateManager.class, (String)"cullState", null, null, (String)"field_179167_h");
        try {
            Class blendStateClass = ReflectionUtils.getClassForName(null, (String)"net.minecraft.client.renderer.GlStateManager$BlendState");
            this.blendStateSrcFactorField = ReflectionUtils.getFieldReflection((Class)blendStateClass, (String)"srcFactor", null, null, (String)"field_179211_b");
            this.blendStateDestFactorField = ReflectionUtils.getFieldReflection((Class)blendStateClass, (String)"dstFactor", null, null, (String)"field_179212_c");
            this.blendStateAlphaSrcFactorField = ReflectionUtils.getFieldReflection((Class)blendStateClass, (String)"srcFactorAlpha", null, null, (String)"field_179209_d");
            this.blendStateAlphaDestFactorField = ReflectionUtils.getFieldReflection((Class)blendStateClass, (String)"dstFactorAlpha", null, null, (String)"field_179210_e");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class colorMaskStateClass = ReflectionUtils.getClassForName(null, (String)"net.minecraft.client.renderer.GlStateManager$ColorMask");
            this.colorMaskStateRedField = ReflectionUtils.getFieldReflection((Class)colorMaskStateClass, (String)"red", null, null, (String)"field_179188_a");
            this.colorMaskStateGreenField = ReflectionUtils.getFieldReflection((Class)colorMaskStateClass, (String)"green", null, null, (String)"field_179186_b");
            this.colorMaskStateBlueField = ReflectionUtils.getFieldReflection((Class)colorMaskStateClass, (String)"blue", null, null, (String)"field_179187_c");
            this.colorMaskStateAlphaField = ReflectionUtils.getFieldReflection((Class)colorMaskStateClass, (String)"alpha", null, null, (String)"field_179185_d");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class depthStateClass = ReflectionUtils.getClassForName(null, (String)"net.minecraft.client.renderer.GlStateManager$DepthState");
            this.depthStateTestField = ReflectionUtils.getFieldReflection((Class)depthStateClass, (String)"depthTest", null, null, (String)"field_179052_a");
            this.depthStateFuncField = ReflectionUtils.getFieldReflection((Class)depthStateClass, (String)"depthFunc", null, null, (String)"field_179051_c");
            this.depthStateMaskField = ReflectionUtils.getFieldReflection((Class)depthStateClass, (String)"maskEnabled", null, null, (String)"field_179050_b");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class cullStateClass = ReflectionUtils.getClassForName(null, (String)"net.minecraft.client.renderer.GlStateManager$CullState");
            this.cullStateEnabledField = ReflectionUtils.getFieldReflection((Class)cullStateClass, (String)"cullFace", null, null, (String)"field_179054_a");
            this.cullStateModeField = ReflectionUtils.getFieldReflection((Class)cullStateClass, (String)"mode", null, null, (String)"field_179053_b");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class booleanStateClass = ReflectionUtils.getClassForName(null, (String)"net.minecraft.client.renderer.GlStateManager$BooleanState");
            this.booleanStateCurrentStateField = ReflectionUtils.getFieldReflection((Class)booleanStateClass, (String)"currentState", null, null, (String)"field_179201_b");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class textureStateClass = ReflectionUtils.getClassForName(null, (String)"net.minecraft.client.renderer.GlStateManager$TextureState");
            this.textureStateIdField = ReflectionUtils.getFieldReflection((Class)textureStateClass, (String)"textureName", null, null, (String)"field_179059_b");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        this.activeTextureField = ReflectionUtils.getFieldReflection(GlStateManager.class, (String)"activeTextureUnit", null, null, (String)"field_179162_o");
        this.colorStateField = ReflectionUtils.getFieldReflection(GlStateManager.class, (String)"colorState", null, null, (String)"field_179170_t");
        try {
            Class colorStateClass = ReflectionUtils.getClassForName(null, (String)"net.minecraft.client.renderer.GlStateManager$Color");
            this.colorStateRedField = ReflectionUtils.getFieldReflection((Class)colorStateClass, (String)"red", null, null, (String)"field_179195_a");
            this.colorStateGreenField = ReflectionUtils.getFieldReflection((Class)colorStateClass, (String)"green", null, null, (String)"field_179193_b");
            this.colorStateBlueField = ReflectionUtils.getFieldReflection((Class)colorStateClass, (String)"blue", null, null, (String)"field_179194_c");
            this.colorStateAlphaField = ReflectionUtils.getFieldReflection((Class)colorStateClass, (String)"alpha", null, null, (String)"field_179192_d");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
    }
}

