/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.definition;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.definition.RadarIconDefinition;

public class RadarIconDefinitionReloader {
    private final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    public void reloadResources(Map<ResourceLocation, RadarIconDefinition> iconDefinitions) {
        MinimapLogs.LOGGER.info("Reloading radar icon resources...");
        Set entityIds = ForgeRegistries.ENTITIES.getKeys();
        int attempts = 5;
        for (int i = 0; i < attempts; ++i) {
            try {
                this.reloadResourcesAttempt(iconDefinitions, this.gson, entityIds);
                break;
            }
            catch (IOException ioe) {
                if (i != attempts - 1) continue;
                throw new RuntimeException(ioe);
            }
        }
        MinimapLogs.LOGGER.info("Reloaded radar icon resources!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadResourcesAttempt(Map<ResourceLocation, RadarIconDefinition> iconDefinitions, Gson gson, Set<ResourceLocation> entityIds) throws IOException {
        iconDefinitions.clear();
        for (ResourceLocation id : entityIds) {
            InputStream resourceInput = null;
            BufferedReader reader = null;
            String entityDefinitionJson = null;
            IResource resource = null;
            try {
                resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("xaerominimap", "entity/icon/definition/" + id.func_110624_b() + "/" + id.func_110623_a() + ".json"));
            }
            catch (FileNotFoundException fnfe) {
                if (reader != null) {
                    reader.close();
                }
                if (resourceInput == null) continue;
                resourceInput.close();
                continue;
            }
            try {
                if (resource == null) continue;
                resourceInput = resource.func_110527_b();
                reader = new BufferedReader(new InputStreamReader(resourceInput));
                final StringBuilder stringBuilder = new StringBuilder();
                reader.lines().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String line) {
                        stringBuilder.append(line);
                        stringBuilder.append('\n');
                    }
                });
                entityDefinitionJson = stringBuilder.toString();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (resourceInput == null) continue;
                resourceInput.close();
                continue;
            }
            try {
                RadarIconDefinition radarIconDefinition = (RadarIconDefinition)gson.fromJson(entityDefinitionJson, RadarIconDefinition.class);
                radarIconDefinition.construct(id);
                iconDefinitions.put(id, radarIconDefinition);
            }
            catch (JsonSyntaxException jse) {
                MinimapLogs.LOGGER.error("Json syntax exception when loading the radar icon definition for " + id + ".", (Throwable)jse);
            }
        }
    }
}

