/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import xaero.common.HudMod;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.MinimapSafeModeRenderer;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;
import xaero.hud.entity.EntityUtils;
import xaero.hud.gui.util.GuiUtils;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.Minimap;
import xaero.hud.minimap.common.config.MinimapConfigConstants;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.compass.render.CompassRenderer;
import xaero.hud.minimap.config.util.MinimapConfigClientUtils;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.radar.RadarSession;
import xaero.hud.minimap.radar.category.EntityRadarCategory;
import xaero.hud.minimap.radar.category.EntityRadarCategoryManager;
import xaero.hud.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.hud.minimap.radar.color.RadarColor;
import xaero.hud.minimap.waypoint.render.WaypointMapRenderer;
import xaero.hud.render.TextureLocations;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.option.IndexedConfigOption;

public abstract class MinimapRenderer {
    public static final int black = -16777216;
    public static final int slime = -2142047936;
    protected HudMod modMain;
    protected Minecraft mc;
    protected Minimap minimap;
    protected MinimapRendererHelper helper;
    protected WaypointMapRenderer waypointMapRenderer;
    private int lastMinimapSize;
    protected double zoom = 1.0;
    private BlockPos.MutableBlockPos mutableBlockPos;
    protected final CompassRenderer compassRenderer;

    public MinimapRenderer(HudMod modMain, Minecraft mc, WaypointMapRenderer waypointMapRenderer, Minimap minimap, CompassRenderer compassRenderer) {
        this.modMain = modMain;
        this.mc = mc;
        this.waypointMapRenderer = waypointMapRenderer;
        this.minimap = minimap;
        this.helper = new MinimapRendererHelper();
        this.mutableBlockPos = new BlockPos.MutableBlockPos();
        this.compassRenderer = compassRenderer;
    }

    public float getEntityYaw(Entity e, float partial) {
        if (e == this.mc.field_71439_g) {
            return e.field_70177_z;
        }
        if (e instanceof EntityLivingBase) {
            return ((EntityLivingBase)e).field_70758_at + (((EntityLivingBase)e).field_70759_as - ((EntityLivingBase)e).field_70758_at) * partial;
        }
        return e.field_70126_B + (e.field_70177_z - e.field_70126_B) * partial;
    }

    public double getRenderAngle(boolean lockedNorth) {
        if (lockedNorth) {
            return 90.0;
        }
        return this.getActualAngle();
    }

    private double getActualAngle() {
        double rotation = Math.toDegrees(Misc.getYawRadians());
        return -90.0 - rotation;
    }

    protected abstract void renderChunks(MinimapSession var1, MinimapProcessor var2, Vec3d var3, int var4, double var5, int var7, int var8, float var9, float var10, int var11, boolean var12, boolean var13, int var14, double var15, double var17, boolean var19, boolean var20, ScaledResolution var21, ModSettings var22);

    public void renderMinimap(MinimapSession minimapSession, MinimapProcessor minimap, int x, int y, int width, int height, ScaledResolution scaledRes, int size, float partial) {
        boolean crosshairDisplayed;
        int specW;
        int frameType;
        boolean renderFrame;
        ModSettings settings = this.modMain.getSettings();
        int scale = scaledRes.func_78325_e();
        int minimapSizeConfig = MinimapConfigClientUtils.getEffectiveMinimapSize(scale);
        if (minimapSizeConfig != this.lastMinimapSize) {
            this.lastMinimapSize = minimapSizeConfig;
            minimap.setToResetImage(true);
        }
        minimap.getRadarSession().getStateUpdater().setLastRenderViewEntity(this.mc.func_175606_aa());
        int mapSize = minimapSession.getProcessor().getMinimapSize(scale);
        int bufferSize = minimapSession.getProcessor().getMinimapBufferSize(mapSize);
        if (this.minimap.usingFBO()) {
            bufferSize = minimap.getFBOBufferSize();
        }
        ClientConfigManager configManager = this.modMain.getHudConfigs().getClientConfigManager();
        float minimapScale = GuiUtils.getMinimapScale(configManager, scale);
        float mapScale = (float)scale / minimapScale;
        minimap.updateZoom();
        this.zoom = minimap.getMinimapZoom();
        RenderHelper.func_74518_a();
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187425_g((int)3317, (int)4);
        GlStateManager.func_187425_g((int)3316, (int)0);
        GlStateManager.func_187425_g((int)3315, (int)0);
        GlStateManager.func_187425_g((int)3314, (int)0);
        float sizeFix = (float)bufferSize / 512.0f;
        int shape = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.SHAPE);
        boolean lockedNorth = MinimapConfigClientUtils.getEffectiveNorthLocked(mapSize / 2, shape);
        double angle = Math.toRadians(this.getRenderAngle(lockedNorth));
        double ps = Math.sin(Math.PI - angle);
        double pc = Math.cos(Math.PI - angle);
        boolean useWorldMap = this.modMain.getSupportMods().shouldUseWorldMapChunks() && !minimap.getMinimapWriter().isLoadedNonWorldMap();
        boolean lightingConfig = (Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.LIGHTING);
        int lightLevel = (int)((1.0f - Math.min(1.0f, this.getSunBrightness(minimap, lightingConfig))) * (float)(minimap.getMinimapWriter().getLoadedLevels() - 1));
        boolean cave = minimap.isCaveModeDisplayed();
        boolean circleShape = shape == 1;
        double playerX = EntityUtils.getEntityX(this.mc.func_175606_aa(), partial);
        double playerY = EntityUtils.getEntityY(this.mc.func_175606_aa(), partial);
        double playerZ = EntityUtils.getEntityZ(this.mc.func_175606_aa(), partial);
        double renderX = playerX;
        double renderZ = playerZ;
        double mapDimensionScale = Misc.getDimensionTypeScale((World)this.mc.field_71441_e);
        int mapDimension = this.mc.field_71441_e.field_73011_w.getDimension();
        double playerDimDiv = 1.0;
        if (useWorldMap) {
            double playerCoordinateScale = mapDimensionScale;
            mapDimensionScale = this.modMain.getSupportMods().worldmapSupport.getMapDimensionScale();
            mapDimension = this.modMain.getSupportMods().worldmapSupport.getMapDimension();
            if (mapDimensionScale == 0.0) {
                mapDimensionScale = minimap.getLastMapDimensionScale();
                mapDimension = minimap.getLastMapDimension();
            }
            playerDimDiv = mapDimensionScale / playerCoordinateScale;
            renderX /= playerDimDiv;
            renderZ /= playerDimDiv;
        }
        minimap.setLastMapDimensionScale(mapDimensionScale);
        minimap.setLastMapDimension(mapDimension);
        minimap.setLastPlayerDimDiv(playerDimDiv);
        Vec3d renderPos = new Vec3d(renderX, playerY, renderZ);
        this.renderChunks(minimapSession, minimap, renderPos, mapDimension, mapDimensionScale, mapSize, bufferSize, sizeFix, partial, lightLevel, useWorldMap, lockedNorth, shape, ps, pc, cave, circleShape, scaledRes, settings);
        if (this.minimap.usingFBO()) {
            sizeFix = 1.0f;
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GL11.glScalef((float)(1.0f / mapScale), (float)(1.0f / mapScale), (float)1.0f);
        int scaledX = (int)((float)x * mapScale);
        int scaledY = (int)((float)y * mapScale);
        int minimapFrameSize = (int)((float)(mapSize / 2) / sizeFix);
        int circleSides = Math.max(32, (int)Math.ceil(Math.PI * (double)(minimapFrameSize + 8) / 8.0 / 4.0) * 4);
        double circleSeamAngle = -0.7853981633974483;
        int circleSeamWidth = 32;
        int circleFrameThickness = 4;
        double circleStartAngle = 0.0;
        if (!circleShape) {
            this.getHelper().drawMyTexturedModalRect((int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, minimapFrameSize, 256.0f);
        } else {
            float outerRadius = mapSize / 4 + circleFrameThickness;
            circleStartAngle = circleSeamAngle - (double)((float)(circleSeamWidth / 2) / outerRadius);
            this.getHelper().drawTexturedElipseInsideRectangle(circleStartAngle, circleSides, (int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, 256.0f);
        }
        GlStateManager.func_179112_b((int)770, (int)771);
        if (!this.minimap.usingFBO()) {
            GL11.glScalef((float)(1.0f / sizeFix), (float)(1.0f / sizeFix), (float)1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        boolean bl = renderFrame = (frameType = ((Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.FRAME)).intValue()) < MinimapConfigConstants.FRAME_NAMES.length - 1;
        if (frameType > 0) {
            int frameColorConfig = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.FRAME_COLOR);
            int frameColor = MinimapConfigConstants.COLORS[frameColorConfig];
            GlStateManager.func_179131_c((float)((float)(frameColor >> 16 & 0xFF) / 255.0f), (float)((float)(frameColor >> 8 & 0xFF) / 255.0f), (float)((float)(frameColor & 0xFF) / 255.0f), (float)1.0f);
        }
        MinimapRendererHelper helper = this.getHelper();
        if (renderFrame) {
            this.mc.func_110434_K().func_110577_a(TextureLocations.MINIMAP_FRAME_TEXTURES);
        }
        if (renderFrame && !circleShape) {
            int rightCornerStartX = scaledX + 9 + mapSize / 2 + 4 - 16;
            int bottomCornerStartY = scaledY + 9 + mapSize / 2 + 4 - 16;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            int cornerTextureX = frameType == 0 ? 192 : (frameType == 1 ? 208 : 224);
            helper.addTexturedRectToExistingBuffer(vertexBuffer, scaledX + 9 - 4, scaledY + 9 - 4, cornerTextureX, 97, 16, 16);
            helper.addTexturedRectToExistingBuffer(vertexBuffer, rightCornerStartX, scaledY + 9 - 4, cornerTextureX, 113, 16, 16);
            helper.addTexturedRectToExistingBuffer(vertexBuffer, scaledX + 9 - 4, bottomCornerStartY, cornerTextureX, 129, 16, 16);
            helper.addTexturedRectToExistingBuffer(vertexBuffer, rightCornerStartX, bottomCornerStartY, cornerTextureX, 145, 16, 16);
            int horLineStartX = scaledX + 9 - 4 + 16;
            int horLineWidth = rightCornerStartX - horLineStartX;
            int horPieceTextureY = frameType == 0 ? 0 : (frameType == 1 ? 32 : 64);
            int horPieceWidth = 226;
            int horLineLength = (int)Math.ceil((double)horLineWidth / (double)horPieceWidth);
            for (int i = 0; i < horLineLength; ++i) {
                int pieceX = scaledX + 9 - 4 + 16 + i * horPieceWidth;
                int pieceW = horPieceWidth;
                if (i == horLineLength - 1 && pieceX + pieceW > rightCornerStartX) {
                    pieceW = rightCornerStartX - pieceX;
                }
                helper.addTexturedRectToExistingBuffer(vertexBuffer, pieceX, scaledY + 9 - 4, 0, horPieceTextureY, pieceW, 16);
                helper.addTexturedRectToExistingBuffer(vertexBuffer, pieceX, scaledY + 9 + mapSize / 2 - 12, 0, horPieceTextureY + 16, pieceW, 16);
            }
            int verLineStartY = scaledY + 9 - 4 + 16;
            int verLineHeight = bottomCornerStartY - verLineStartY;
            int verPieceTextureX = frameType == 0 ? 0 : (frameType == 1 ? 64 : 128);
            int verPieceHeight = 113;
            int vertLineLength = (int)Math.ceil((double)verLineHeight / (double)verPieceHeight);
            for (int i = 0; i < vertLineLength; ++i) {
                int pieceY = scaledY + 9 - 4 + 16 + i * verPieceHeight;
                int pieceU = verPieceTextureX + 32 * (i & 1);
                int pieceH = verPieceHeight;
                if (i == vertLineLength - 1 && pieceY + pieceH > bottomCornerStartY) {
                    pieceH = bottomCornerStartY - pieceY;
                }
                helper.addTexturedRectToExistingBuffer(vertexBuffer, scaledX + 9 - 4, pieceY, pieceU, 97, 16, pieceH);
                helper.addTexturedRectToExistingBuffer(vertexBuffer, scaledX + 9 + mapSize / 2 - 12, pieceY, pieceU + 16, 97, 16, pieceH);
            }
            tessellator.func_78381_a();
        } else if (renderFrame) {
            int frameTextureY = frameType == 0 ? 210 : (frameType == 1 ? 214 : 218);
            double shadeStartAngle = 0.7853981633974483 - circleStartAngle;
            int shadeStartIndex = (int)(shadeStartAngle / 2.0 / Math.PI * (double)circleSides);
            int circleLeftX = scaledX + 9;
            int circleTopY = scaledY + 9;
            int innerCircleDiameter = mapSize / 2;
            helper.drawTexturedElipseInsideRectangleFrame(false, false, circleStartAngle, 0, shadeStartIndex, circleSides, circleFrameThickness, circleLeftX, circleTopY, 0, frameTextureY, innerCircleDiameter, 73.0f, circleFrameThickness, circleSeamWidth, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(true, false, circleStartAngle, shadeStartIndex, shadeStartIndex + circleSides / 4, circleSides, circleFrameThickness, circleLeftX, circleTopY, 138, frameTextureY, innerCircleDiameter, 68.0f, circleFrameThickness, 20, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(true, true, circleStartAngle, shadeStartIndex + circleSides / 4, shadeStartIndex + circleSides / 2, circleSides, circleFrameThickness, circleLeftX, circleTopY, 138, frameTextureY, innerCircleDiameter, 68.0f, circleFrameThickness, 20, 256.0f);
            helper.drawTexturedElipseInsideRectangleFrame(false, false, circleStartAngle, shadeStartIndex + circleSides / 2, circleSides, circleSides, circleFrameThickness, circleLeftX, circleTopY, 0, frameTextureY, innerCircleDiameter, 73.0f, circleFrameThickness, circleSeamWidth, 256.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(scaledX + 9), (float)(scaledY + 9), (float)0.0f);
        GlStateManager.func_179152_a((float)(1.0f / minimapScale), (float)(1.0f / minimapScale), (float)1.0f);
        int halfFrame = (int)((float)mapSize * minimapScale / 2.0f / 2.0f);
        GlStateManager.func_179137_b((double)halfFrame, (double)halfFrame, (double)0.5);
        int specH = specW = halfFrame + (int)(3.0f * minimapScale);
        boolean safeMode = this instanceof MinimapSafeModeRenderer;
        double scaledZoom = this.zoom * (double)minimapScale / 2.0;
        boolean compassOverEverythingConfig = (Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.COMPASS_OVER_EVERYTHING);
        if (!compassOverEverythingConfig) {
            this.renderCompass(settings, configManager, specW, specH, halfFrame, ps, pc, circleShape, minimapScale, scale);
        }
        this.minimap.getOverMapRendererHandler().prepareRender(ps, pc, scaledZoom, specW, specH, halfFrame, halfFrame, circleShape, minimapScale);
        double overMapFinalDepth = this.minimap.getOverMapRendererHandler().render(renderPos, partial, null, scaledRes, mapDimensionScale, mapDimension);
        if (compassOverEverythingConfig) {
            this.renderCompass(settings, configManager, specW, specH, halfFrame, ps, pc, circleShape, minimapScale, scale);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        int depthClearerX = scaledX - 25;
        int depthClearerY = scaledY - 25;
        int depthClearerW = 18 + mapSize / 2 + 50;
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)516);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        Gui.func_73734_a((int)depthClearerX, (int)depthClearerY, (int)(depthClearerX + depthClearerW), (int)(depthClearerY + depthClearerW), (int)-16777216);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179147_l();
        int mainEntityAs = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.RADAR_MAIN_ENTITY);
        boolean bl2 = crosshairDisplayed = mainEntityAs == 0 && !lockedNorth;
        if (crosshairDisplayed) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(scaledX + 9), (float)(scaledY + 9), (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179109_b((float)(mapSize / 2), (float)(mapSize / 2), (float)0.0f);
            GlStateManager.func_179120_a((int)775, (int)0, (int)1, (int)0);
            this.getHelper().drawMyColoredRect(-5.0f, -1.0f, 5.0f, 1.0f);
            this.getHelper().drawMyColoredRect(-1.0f, 3.0f, 1.0f, 5.0f);
            this.getHelper().drawMyColoredRect(-1.0f, -5.0f, 1.0f, -3.0f);
            GlStateManager.func_179112_b((int)770, (int)771);
            RadarSession radarSession = minimap.getRadarSession();
            EntityRadarCategoryManager categoryManager = radarSession.getCategoryManager();
            EntityRadarCategory mainEntityCategory = categoryManager.getRuleResolver().resolve(categoryManager.getRootCategory(), this.mc.func_175606_aa(), this.mc.field_71439_g);
            if (mainEntityCategory == null) {
                mainEntityCategory = categoryManager.getRootCategory();
            }
            RadarColor crosshairRadarColor = RadarColor.fromIndex(mainEntityCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue());
            RadarColor crosshairFallbackColor = radarSession.getColorHelper().getFallbackColor(mainEntityCategory, null);
            int crosshairColor = radarSession.getColorHelper().getEntityColor(this.mc.func_175606_aa(), 0.0f, false, 100, 100, false, crosshairRadarColor, crosshairFallbackColor);
            GlStateManager.func_179131_c((float)((float)(crosshairColor >> 16 & 0xFF) / 255.0f), (float)((float)(crosshairColor >> 8 & 0xFF) / 255.0f), (float)((float)(crosshairColor & 0xFF) / 255.0f), (float)1.0f);
            this.getHelper().drawMyColoredRect(1.0f, -1.0f, 3.0f, 1.0f);
            this.getHelper().drawMyColoredRect(-3.0f, -1.0f, -1.0f, 1.0f);
            this.getHelper().drawMyColoredRect(-1.0f, 1.0f, 1.0f, 3.0f);
            this.getHelper().drawMyColoredRect(-1.0f, -3.0f, 1.0f, -1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
            GlStateManager.func_179147_l();
            GlStateManager.func_179121_F();
        }
        this.mc.func_110434_K().func_110577_a(TextureLocations.GUI_TEXTURES);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        double centerX = 2 * scaledX + 18 + mapSize / 2;
        double centerY = 2 * scaledY + 18 + mapSize / 2;
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GlStateManager.func_179137_b((double)centerX, (double)centerY, (double)0.0);
        Entity mainEntity = this.mc.func_175606_aa();
        if (!safeMode && !crosshairDisplayed) {
            this.minimap.getMinimapFBORenderer().renderMainEntityDot(mainEntity, cave, scaledRes);
        }
        GlStateManager.func_179147_l();
        if (lockedNorth || mainEntityAs == 2) {
            float a;
            float b;
            float g;
            float r;
            int arrowColour;
            this.mc.func_110434_K().func_110577_a(TextureLocations.GUI_TEXTURES);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            float arrowAngle = lockedNorth ? this.getEntityYaw(mainEntity, partial) : 180.0f;
            int arrowOpacityInt = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.ARROW_OPACITY);
            float arrowOpacity = (float)arrowOpacityInt / 100.0f;
            if (arrowOpacity == 1.0f) {
                this.drawArrow(arrowAngle, 0.0, 1.0, 0.0f, 0.0f, 0.0f, 0.5f, configManager);
            }
            if ((arrowColour = ((Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.ARROW_COLOR)).intValue()) != -1) {
                float[] c = MinimapConfigConstants.ARROW_COLORS[arrowColour];
                r = c[0];
                g = c[1];
                b = c[2];
                a = c[3];
            } else {
                int rgb = minimap.getRadarSession().getColorHelper().getTeamColor((Entity)(this.mc.field_71439_g == null ? mainEntity : this.mc.field_71439_g));
                if (rgb != -1) {
                    r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                    g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                    b = (float)(rgb & 0xFF) / 255.0f;
                    a = 1.0f;
                } else {
                    float[] c = MinimapConfigConstants.ARROW_COLORS[0];
                    r = c[0];
                    g = c[1];
                    b = c[2];
                    a = c[3];
                }
            }
            this.drawArrow(arrowAngle, 0.0, 0.0, r, g, b, a *= arrowOpacity, configManager);
        }
        GL11.glPopMatrix();
        GlStateManager.func_179121_F();
        this.mc.func_110434_K().func_110577_a(TextureLocations.GUI_TEXTURES);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        int playerBlockX = OptimizedMath.myFloor(mainEntity.field_70165_t);
        int playerBlockY = OptimizedMath.myFloor(mainEntity.field_70163_u);
        int playerBlockZ = OptimizedMath.myFloor(mainEntity.field_70161_v);
        BlockPos.MutableBlockPos pos = this.mutableBlockPos.func_181079_c(playerBlockX, playerBlockY, playerBlockZ);
        this.minimap.getInfoDisplays().getRenderer().render(minimapSession, this.minimap, height, size, (BlockPos)pos, scaledX, scaledY, mapScale);
        GL11.glScalef((float)mapScale, (float)mapScale, (float)1.0f);
    }

    private void renderCompass(ModSettings settings, ClientConfigManager configManager, int specW, int specH, int halfFrame, double ps, double pc, boolean circleShape, float minimapScale, double guiScale) {
        int compassScale = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.COMPASS_SCALE);
        int compassLocation = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.COMPASS_LOCATION);
        compassScale = compassScale <= 0 ? (compassLocation == 1 ? (int)Math.ceil(minimapScale / 2.0f) : (int)minimapScale) : (int)MinimapConfigClientUtils.getUIScale(configManager, (IndexedConfigOption<Integer>)MinimapProfiledConfigOptions.COMPASS_SCALE, guiScale);
        if (compassLocation == 1) {
            if (Minecraft.func_71410_x().func_152349_b()) {
                compassScale *= 2;
            }
            halfFrame = (int)((float)halfFrame - 7.0f * minimapScale / 2.0f);
            this.compassRenderer.drawCompass(halfFrame - 3 * compassScale, halfFrame - 3 * compassScale, ps, pc, 1.0, circleShape, compassScale, true);
        } else if (compassLocation == 2) {
            this.compassRenderer.drawCompass(specW, specH, ps, pc, this.zoom, circleShape, compassScale, false);
        }
    }

    private void drawArrow(float angle, double arrowX, double arrowY, float r, float g, float b, float a, ClientConfigManager configManager) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)arrowX, (double)arrowY, (double)0.0);
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        double arrowScale = (Double)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.ARROW_SCALE);
        GL11.glScaled((double)(0.5 * arrowScale), (double)(0.5 * arrowScale), (double)1.0);
        int offsetY = -6;
        int h = 28;
        int ty = 0;
        GL11.glTranslated((double)-13.0, (double)offsetY, (double)0.0);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.helper.drawMyTexturedModalRect(0.0f, 0.0f, 49, ty + h, 26.0f, h, -h, 256.0f);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public float getSunBrightness(MinimapProcessor minimap, boolean lighting) {
        WorldClient world = this.mc.field_71441_e;
        float sunBrightness = this.mc.field_71441_e.getSunBrightnessFactor(1.0f);
        float ambient = world.field_73011_w.func_177497_p()[0] * 24.0f / 15.0f;
        if (ambient > 1.0f) {
            ambient = 1.0f;
        }
        return ambient + (1.0f - ambient) * MathHelper.func_76131_a((float)sunBrightness, (float)0.0f, (float)1.0f);
    }

    public MinimapRendererHelper getHelper() {
        return this.helper;
    }

    @Deprecated
    public double getLastPlayerDimDiv() {
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (session == null) {
            return 1.0;
        }
        return session.getProcessor().getLastPlayerDimDiv();
    }
}

