/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui.entry;

import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.category.ui.entry.ConnectionLineType;
import xaero.hud.category.ui.entry.EditorListEntry;
import xaero.hud.category.ui.entry.EditorListTextButtonEntry;
import xaero.hud.category.ui.node.EditorNode;
import xaero.lib.client.gui.widget.Tooltip;

public abstract class EditorListRootEntry
extends EditorListEntry {
    private final ConnectionLineType lineType;
    protected final EditorNode node;

    public EditorListRootEntry(int screenWidth, int index, GuiCategoryEditor.SettingRowList rowList, ConnectionLineType lineType, EditorNode node) {
        super(0, 0, screenWidth, 24, index, rowList, new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return null;
            }
        });
        this.lineType = lineType;
        this.node = node;
    }

    protected void addHelpElement(final Supplier<Tooltip> helpTooltipSupplier) {
        if (helpTooltipSupplier == null) {
            return;
        }
        this.withSubEntry(new CenteredEntryFactory(){

            @Override
            public EditorListEntry get(int x, int y, int w, int h, EditorListRootEntry root) {
                return new EditorListTextButtonEntry(x - 24, y + 2, EditorListRootEntry.this.index, EditorListRootEntry.this.rowList, (ITextComponent)new TextComponentString("?"), -5592406, -1, 5, new Supplier<Boolean>(){

                    @Override
                    public Boolean get() {
                        return false;
                    }
                }, EditorListRootEntry.this, helpTooltipSupplier);
            }
        });
    }

    @Override
    public EditorListEntry render(int index, int rowWidth, int rowHeight, int relativeMouseX, int relativeMouseY, boolean isMouseOver, float partialTicks, FontRenderer font, int globalMouseX, int globalMouseY, boolean includesSelected, boolean isRoot) {
        EditorListEntry result = super.render(index, rowWidth, rowHeight, relativeMouseX, relativeMouseY, isMouseOver, partialTicks, font, globalMouseX, globalMouseY, includesSelected, isRoot);
        int xOffset = rowWidth / 2 - 110;
        int yOffset = 8;
        if (this.lineType == ConnectionLineType.TAIL_LEAF || this.lineType == ConnectionLineType.HEAD_LEAF) {
            int leftX = xOffset - 14;
            int rightX = xOffset - 2;
            int bottomY = yOffset + 4;
            int topY = yOffset - 24 + 4;
            this.func_73730_a(leftX, rightX, bottomY, -5592406);
            this.func_73728_b(leftX, topY, bottomY, -5592406);
            this.func_73728_b(rightX - 1, bottomY - 2, bottomY + 2, -5592406);
            this.func_73728_b(rightX - 2, bottomY - 3, bottomY + 3, -5592406);
            if (this.lineType == ConnectionLineType.HEAD_LEAF) {
                this.func_73730_a(leftX, rightX, topY, -5592406);
            }
            return result;
        }
        if (this.lineType != ConnectionLineType.PATH) {
            return result;
        }
        int topY = yOffset - 24 + 9;
        int bottomY = yOffset - 2;
        int lineX = xOffset + 12;
        this.func_73730_a(lineX - 2, lineX + 2, bottomY - 3, -5592406);
        this.func_73730_a(lineX - 1, lineX + 1, bottomY - 2, -5592406);
        this.func_73728_b(lineX, topY, bottomY, -5592406);
        return result;
    }

    public EditorListRootEntry withSubEntry(CenteredEntryFactory entryFactory) {
        super.withSubEntry(entryFactory.get(this.rowList.func_148139_c() / 2 - 110 - 1, 0, 220, 24, this));
        return this;
    }

    @Override
    protected boolean selectAction() {
        return false;
    }

    @FunctionalInterface
    public static interface CenteredEntryFactory {
        public EditorListEntry get(int var1, int var2, int var3, int var4, EditorListRootEntry var5);
    }
}

