/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.lwjgl.opengl.GL11;
import xaero.common.icon.XaeroIcon;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.cache.RadarIconCache;
import xaero.hud.minimap.radar.icon.cache.RadarIconEntityCache;
import xaero.hud.minimap.radar.icon.cache.id.RadarIconKey;
import xaero.hud.minimap.radar.icon.cache.id.armor.RadarIconArmor;
import xaero.hud.minimap.radar.icon.cache.id.armor.RadarIconArmorHandler;
import xaero.hud.minimap.radar.icon.cache.id.variant.RadarIconVariantHandler;
import xaero.hud.minimap.radar.icon.creator.RadarIconCreator;
import xaero.hud.minimap.radar.icon.definition.RadarIconDefinition;
import xaero.hud.minimap.radar.icon.definition.RadarIconDefinitionManager;
import xaero.hud.minimap.radar.icon.definition.form.RadarIconBasicForms;
import xaero.hud.minimap.radar.icon.definition.form.RadarIconForm;
import xaero.hud.minimap.radar.icon.definition.form.model.config.RadarIconModelConfig;

public class RadarIconManager {
    public static final XaeroIcon FAILED = new XaeroIcon(null, 0, 0);
    public static final XaeroIcon DOT = new XaeroIcon(null, 0, 0);
    private boolean canPrerender;
    private final RadarIconCreator iconCreator;
    private final RadarIconModelConfig defaultModelConfig;
    private final RadarIconDefinitionManager definitionManager;
    private final RadarIconVariantHandler variantHandler;
    private final RadarIconArmorHandler armorHandler;
    private final RadarIconCache iconCache;

    public RadarIconManager(RadarIconCreator iconCreator) {
        this.iconCreator = iconCreator;
        this.definitionManager = new RadarIconDefinitionManager();
        this.variantHandler = new RadarIconVariantHandler();
        this.iconCache = new RadarIconCache();
        this.definitionManager.reloadResources();
        this.defaultModelConfig = new RadarIconModelConfig();
        this.armorHandler = new RadarIconArmorHandler();
    }

    public <T extends Entity> XaeroIcon get(T entity, float scale, boolean debug, boolean debugEntityVariantIds, Framebuffer defaultFramebuffer, ScaledResolution scaledRes) {
        RadarIconForm iconForm;
        String entityVariantString;
        ResourceLocation entityType = EntityList.func_191301_a(entity);
        RadarIconDefinition iconDefinition = this.definitionManager.get(entityType);
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        Render entityRenderer = renderManager.func_78713_a(entity);
        Object variant = this.variantHandler.getEntityVariant(iconDefinition, entity, entityRenderer);
        while (GL11.glGetError() != 0) {
        }
        if (variant == null) {
            return null;
        }
        RadarIconArmor armor = null;
        if (entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer)) {
            armor = this.armorHandler.getArmor((EntityLivingBase)entity);
        }
        RadarIconEntityCache entityIconCache = this.iconCache.getEntityCache(entityType);
        RadarIconKey iconKey = new RadarIconKey(variant, armor);
        XaeroIcon cachedValue = entityIconCache.get(iconKey);
        if (entityIconCache.isInvalidVariantClass()) {
            return FAILED;
        }
        if (cachedValue != null) {
            return cachedValue;
        }
        String variantMapKey = entityVariantString = entityIconCache.getVariantString(iconKey);
        if (iconDefinition != null) {
            RadarIconForm radarIconForm = iconForm = variantMapKey == null ? null : iconDefinition.getVariantForm(variantMapKey);
            if (iconForm == null) {
                variantMapKey = "default";
                iconForm = iconDefinition.getVariantForm(variantMapKey);
            }
        } else {
            RadarIconForm radarIconForm = iconForm = entity instanceof EntityLivingBase ? RadarIconBasicForms.DEFAULT_MODEL : RadarIconBasicForms.SELF_ITEM;
        }
        if (debugEntityVariantIds && entityVariantString != null && (this.canPrerender || iconForm == RadarIconBasicForms.DOT)) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(entityVariantString));
        }
        if (iconForm == RadarIconBasicForms.DOT) {
            entityIconCache.add(iconKey, DOT);
            return DOT;
        }
        if (!this.canPrerender) {
            return null;
        }
        RadarIconCreator.Parameters parameters = new RadarIconCreator.Parameters(variant, this.defaultModelConfig, iconForm, scale, debug);
        cachedValue = this.iconCreator.create(entityRenderer, entity, defaultFramebuffer, parameters, scaledRes);
        entityIconCache.add(iconKey, cachedValue);
        this.canPrerender = false;
        return cachedValue;
    }

    public void reset() {
        this.iconCreator.clearAtlases();
        this.iconCache.clear();
        MinimapLogs.LOGGER.info("Radar icon manager reset!");
    }

    public void resetResources() {
        this.definitionManager.reloadResources();
    }

    public void allowPrerender() {
        this.canPrerender = true;
    }

    public void onModelPartRenderTrace(ModelRenderer modelRenderer) {
        this.iconCreator.getRenderTracer().onModelPartRender(modelRenderer);
    }
}

