/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.effect;

import com.google.common.collect.Ordering;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import xaero.hud.pvp.module.effect.StatusEffectSession;
import xaero.hud.render.TextureLocations;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class StatusEffectRenderer
implements IModuleRenderer<StatusEffectSession> {
    @Override
    public void render(StatusEffectSession session, ModuleRenderContext c, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        if (!mc.field_71439_g.func_70651_bq().isEmpty()) {
            this.renderEffects(session, c, mc);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderEffects(StatusEffectSession session, ModuleRenderContext c, Minecraft mc) {
        Collection effects;
        if (c.flippedVertically) {
            c.y = c.y + c.h - 30;
        }
        if ((effects = mc.field_71439_g.func_70651_bq()).isEmpty()) {
            return;
        }
        effects = Ordering.natural().sortedCopy((Iterable)effects);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        if (session.isBlinkEnabled() && System.currentTimeMillis() - session.getLastBlink() > 500L) {
            session.setLastBlink(System.currentTimeMillis());
            session.setBlink(!session.getBlink());
        }
        if (session.isCentered()) {
            this.renderCentered(session, c, mc, effects);
            return;
        }
        this.renderNormal(session, c, mc, effects);
    }

    private void renderCentered(StatusEffectSession session, ModuleRenderContext c, Minecraft mc, Collection<PotionEffect> effects) {
        int columnWidth = 27;
        int defaultEffectAmount = 182 / columnWidth;
        if (effects.size() > defaultEffectAmount) {
            columnWidth = 182 / effects.size();
        }
        int totalSize = effects.size() * columnWidth;
        int firstColumn = c.x + c.w / 2 + totalSize / 2 * (c.flippedHorizontally ? 1 : -1);
        if (c.flippedHorizontally) {
            firstColumn -= columnWidth;
        }
        int currentX = firstColumn + (columnWidth - 18) / 2;
        int currentY = c.y + 7;
        for (PotionEffect effectInstance : effects) {
            int duration = effectInstance.func_76459_b();
            if (duration <= 200 && !session.getBlink() && session.isBlinkEnabled()) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            Potion effect = effectInstance.func_188419_a();
            if (effect.func_76400_d()) {
                mc.func_110434_K().func_110577_a(TextureLocations.INV_TEXTURES);
                int iconIndex = effect.func_76392_e();
                mc.field_71456_v.func_73729_b(currentX, currentY, iconIndex % 8 * 18, 198 + iconIndex / 8 * 18, 18, 18);
            }
            String durationString = Potion.func_188410_a((PotionEffect)effectInstance, (float)1.0f);
            int amplifier = effectInstance.func_76458_c();
            String levelString = amplifier > 0 ? "" + (effectInstance.func_76458_c() + 1) : "";
            mc.field_71466_p.func_175063_a(levelString, (float)currentX, (float)currentY, 0xFFFFFF);
            mc.field_71466_p.func_175063_a(durationString, (float)(currentX + 10 - mc.field_71466_p.func_78256_a(durationString) / 2), (float)(currentY + 15), 0xFFFFFF);
            currentX += columnWidth * (c.flippedHorizontally ? -1 : 1);
        }
    }

    private void renderNormal(StatusEffectSession session, ModuleRenderContext c, Minecraft mc, Collection<PotionEffect> effects) {
        int rowHeight = 25;
        if (effects.size() > 6) {
            rowHeight = 135 / (effects.size() - 1);
        }
        for (PotionEffect effectInstance : effects) {
            String potionName;
            int duration = effectInstance.func_76459_b();
            if (duration <= 200 && !session.getBlink() && session.isBlinkEnabled()) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            Potion effect = effectInstance.func_188419_a();
            if (effect.func_76400_d()) {
                mc.func_110434_K().func_110577_a(TextureLocations.INV_TEXTURES);
                int iconIndex = effect.func_76392_e();
                mc.field_71456_v.func_73729_b(c.flippedHorizontally ? c.x + c.w - 24 : c.x + 6, c.y + 7, iconIndex % 8 * 18, 198 + iconIndex / 8 * 18, 18, 18);
            }
            String durationString = Potion.func_188410_a((PotionEffect)effectInstance, (float)1.0f);
            if (!session.shouldShowNames()) {
                potionName = durationString;
                durationString = null;
            } else {
                potionName = I18n.func_135052_a((String)effect.func_76393_a(), (Object[])new Object[0]);
                if (effectInstance.func_76458_c() == 1) {
                    potionName = potionName + " II";
                } else if (effectInstance.func_76458_c() == 2) {
                    potionName = potionName + " III";
                } else if (effectInstance.func_76458_c() == 3) {
                    potionName = potionName + " IV";
                }
            }
            int amplifier = effectInstance.func_76458_c();
            String levelString = amplifier > 0 ? "" + (effectInstance.func_76458_c() + 1) : "";
            mc.field_71466_p.func_175063_a(levelString, c.flippedHorizontally ? (float)(c.x + c.w - 24) : (float)(c.x + 6), (float)(c.y + 7), 0xFFFFFF);
            mc.field_71466_p.func_175063_a(potionName, c.flippedHorizontally ? (float)(c.x + c.w - 28 - mc.field_71466_p.func_78256_a(potionName)) : (float)(c.x + 10 + 18), (float)(c.y + 7), 0xFFFFFF);
            if (durationString != null) {
                mc.field_71466_p.func_175063_a(durationString, c.flippedHorizontally ? (float)(c.x + c.w - 28 - mc.field_71466_p.func_78256_a(durationString)) : (float)(c.x + 10 + 18), (float)(c.y + 7 + 10), 0xFFFFFF);
            }
            c.y = c.y + (c.flippedVertically ? -rowHeight : rowHeight);
        }
    }
}

