/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.serialization.data;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import xaero.hud.category.rule.ExcludeListMode;
import xaero.hud.category.serialization.data.FilterObjectCategoryData;
import xaero.hud.category.serialization.data.ObjectCategoryDataNbtSerializer;

public class FilterObjectCategoryDataNbtSerializer<D extends FilterObjectCategoryData<D>, DB extends FilterObjectCategoryData.Builder<D, DB>>
extends ObjectCategoryDataNbtSerializer<D, DB> {
    protected FilterObjectCategoryDataNbtSerializer(Supplier<DB> builderSupplier) {
        super(builderSupplier);
    }

    @Override
    public NBTTagCompound serialize(D data) {
        NBTTagCompound resultTag = super.serialize(data);
        resultTag.func_74778_a("h", ((FilterObjectCategoryData)data).getHardInclude());
        resultTag.func_74757_a("i", ((FilterObjectCategoryData)data).getIncludeListInSuperCategory());
        resultTag.func_74778_a("m", ((FilterObjectCategoryData)data).getExcludeMode().name());
        final NBTTagList includeListTag = new NBTTagList();
        ((FilterObjectCategoryData)data).getIncludeListIterator().forEachRemaining(new Consumer<String>(){

            @Override
            public void accept(String includeEntry) {
                includeListTag.func_74742_a((NBTBase)new NBTTagString(includeEntry));
            }
        });
        resultTag.func_74782_a("l", (NBTBase)includeListTag);
        final NBTTagList excludeListTag = new NBTTagList();
        ((FilterObjectCategoryData)data).getExcludeListIterator().forEachRemaining(new Consumer<String>(){

            @Override
            public void accept(String excludeEntry) {
                excludeListTag.func_74742_a((NBTBase)new NBTTagString(excludeEntry));
            }
        });
        resultTag.func_74782_a("e", (NBTBase)excludeListTag);
        return resultTag;
    }

    @Override
    protected DB getConfiguredBuilder(NBTTagCompound serializedData) {
        FilterObjectCategoryData.Builder builder = (FilterObjectCategoryData.Builder)super.getConfiguredBuilder(serializedData);
        builder.setHardInclude(serializedData.func_74779_i("h"));
        builder.setIncludeListInSuperCategory(serializedData.func_74767_n("i"));
        builder.setExcludeMode(ExcludeListMode.valueOf(serializedData.func_74779_i("m")));
        NBTTagList includeListTag = serializedData.func_150295_c("l", 8);
        for (NBTBase includeEntryTag : includeListTag) {
            builder.addToIncludeList(((NBTTagString)includeEntryTag).func_150285_a_());
        }
        NBTTagList excludeListTag = serializedData.func_150295_c("e", 8);
        for (NBTBase excludeEntryTag : excludeListTag) {
            builder.addToExcludeList(((NBTTagString)excludeEntryTag).func_150285_a_());
        }
        return (DB)builder;
    }

    public static final class FinalBuilder<D extends FilterObjectCategoryData<D>, DB extends FilterObjectCategoryData.Builder<D, DB>>
    extends Builder<D, DB, FinalBuilder<D, DB>> {
        private FinalBuilder() {
        }

        @Override
        protected FilterObjectCategoryDataNbtSerializer<D, DB> buildInternally() {
            return new FilterObjectCategoryDataNbtSerializer(this.builderSupplier);
        }

        public static <D extends FilterObjectCategoryData<D>, DB extends FilterObjectCategoryData.Builder<D, DB>> FinalBuilder<D, DB> begin() {
            return (FinalBuilder)new FinalBuilder<D, DB>().setDefault();
        }
    }

    public static abstract class Builder<D extends FilterObjectCategoryData<D>, DB extends FilterObjectCategoryData.Builder<D, DB>, B extends Builder<D, DB, B>>
    extends ObjectCategoryDataNbtSerializer.Builder<D, DB, B> {
        protected Builder() {
        }

        @Override
        public FilterObjectCategoryDataNbtSerializer<D, DB> build() {
            return (FilterObjectCategoryDataNbtSerializer)super.build();
        }
    }
}

