/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.category.rule;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xaero.hud.category.rule.ObjectCategoryListRuleType;
import xaero.hud.minimap.radar.category.EntityRadarCategoryConstants;
import xaero.hud.minimap.radar.category.PlaceholderEntityType;
import xaero.hud.minimap.radar.category.rule.EntityRadarCategoryHardRules;
import xaero.hud.minimap.radar.util.RadarUtils;

public class EntityRadarListRuleTypes {
    public static final List<ObjectCategoryListRuleType<Entity, EntityPlayer, ?>> TYPE_LIST = EntityRadarCategoryConstants.LIST_FACTORY.get();
    public static final Map<String, ObjectCategoryListRuleType<Entity, EntityPlayer, ?>> TYPE_MAP = EntityRadarCategoryConstants.MAP_FACTORY.get();
    private static final Iterable<EntityEntry> EXTENDED_ENTITY_REGISTRY = Iterables.concat((Iterable)ForgeRegistries.ENTITIES, (Iterable)Lists.newArrayList((Object[])new PlaceholderEntityType[]{EntityRadarCategoryConstants.PLAYER_ENTITY_ENTRY}));
    public static final ObjectCategoryListRuleType<Entity, EntityPlayer, EntityEntry> ENTITY_TYPE = new ObjectCategoryListRuleType<Entity, EntityPlayer, EntityEntry>("entity", new BiFunction<Entity, EntityPlayer, EntityEntry>(){

        @Override
        public EntityEntry apply(Entity e, EntityPlayer p) {
            if (e instanceof EntityPlayer) {
                return EntityRadarCategoryConstants.PLAYER_ENTITY_ENTRY;
            }
            return EntityRegistry.getEntry(e.getClass());
        }
    }, new Supplier<Iterable<EntityEntry>>(){

        @Override
        public Iterable<EntityEntry> get() {
            return EXTENDED_ENTITY_REGISTRY;
        }
    }, EntityRadarCategoryConstants.getDefaultElementResolver(EXTENDED_ENTITY_REGISTRY, new Function<String, EntityEntry>(){

        @Override
        public EntityEntry apply(String s) {
            if (s.equals(EntityRadarCategoryConstants.PLAYER_ENTITY_ENTRY.getHelpString())) {
                return EntityRadarCategoryConstants.PLAYER_ENTITY_ENTRY;
            }
            ResourceLocation resourceLocation = new ResourceLocation(s);
            return (EntityEntry)ForgeRegistries.ENTITIES.getValue(resourceLocation);
        }
    }, new Function<EntityEntry, ResourceLocation>(){

        @Override
        public ResourceLocation apply(EntityEntry et) {
            if (et == EntityRadarCategoryConstants.PLAYER_ENTITY_ENTRY) {
                return new ResourceLocation(EntityRadarCategoryConstants.PLAYER_ENTITY_ENTRY.getHelpString());
            }
            return ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)et);
        }
    }), EntityRadarCategoryConstants.DEFAULT_LIST_SERIALIZER, EntityRadarCategoryConstants.DEFAULT_LIST_STRING_VALIDATOR_FIXER, EntityRadarCategoryConstants.DEFAULT_LIST_STRING_VALIDATOR, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, EntityPlayer, Item> ITEM_TYPE = new ObjectCategoryListRuleType<Entity, EntityPlayer, Item>("item", new BiFunction<Entity, EntityPlayer, Item>(){

        @Override
        public Item apply(Entity e, EntityPlayer p) {
            return e instanceof EntityItem ? ((EntityItem)e).func_92059_d().func_77973_b() : null;
        }
    }, new Supplier<Iterable<Item>>(){

        @Override
        public Iterable<Item> get() {
            return ForgeRegistries.ITEMS;
        }
    }, EntityRadarCategoryConstants.getDefaultElementResolver(ForgeRegistries.ITEMS, new Function<String, Item>(){

        @Override
        public Item apply(String s) {
            return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
        }
    }, new Function<Item, ResourceLocation>(){

        @Override
        public ResourceLocation apply(Item i) {
            return ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)i);
        }
    }), new Function<Item, String>(){

        @Override
        public String apply(Item item) {
            return ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).toString();
        }
    }, EntityRadarCategoryConstants.DEFAULT_LIST_STRING_VALIDATOR_FIXER, EntityRadarCategoryConstants.DEFAULT_LIST_STRING_VALIDATOR, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, EntityPlayer, String> PLAYER_NAME = new ObjectCategoryListRuleType<Entity, EntityPlayer, String>("player", new BiFunction<Entity, EntityPlayer, String>(){

        @Override
        public String apply(Entity e, EntityPlayer p) {
            return e instanceof EntityPlayer ? ((EntityPlayer)e).func_146103_bH().getName() : null;
        }
    }, new Supplier<Iterable<String>>(){

        @Override
        public Iterable<String> get() {
            return Minecraft.func_71410_x().func_147114_u() == null ? new ArrayList() : new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return Minecraft.func_71410_x().func_147114_u().func_175106_d().stream().map(new Function<NetworkPlayerInfo, String>(){

                        @Override
                        public String apply(NetworkPlayerInfo pi) {
                            return pi.func_178845_a().getName();
                        }
                    }).iterator();
                }
            };
        }
    }, new Function<String, List<String>>(){

        @Override
        public List<String> apply(String s) {
            return Lists.newArrayList((Object[])new String[]{s});
        }
    }, new Function<String, String>(){

        @Override
        public String apply(String s) {
            return s;
        }
    }, EntityRadarCategoryConstants.PLAYER_NAME_VALIDATOR_FIXER, EntityRadarCategoryConstants.PLAYER_NAME_VALIDATOR, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, EntityPlayer, String> CUSTOM_NAME = new ObjectCategoryListRuleType<Entity, EntityPlayer, String>("custom-name", new BiFunction<Entity, EntityPlayer, String>(){

        @Override
        public String apply(Entity e, EntityPlayer p) {
            return RadarUtils.getCustomName(e, false);
        }
    }, new Supplier<Iterable<String>>(){

        @Override
        public Iterable<String> get() {
            if (Minecraft.func_71410_x().field_71441_e == null) {
                return Lists.newArrayList((Object[])new String[]{"example"});
            }
            List entities = Minecraft.func_71410_x().field_71441_e.field_72996_f;
            if (entities == null) {
                return Lists.newArrayList((Object[])new String[]{"example"});
            }
            Stream<String> nameStream = StreamSupport.stream(entities.spliterator(), false).map(new Function<Entity, String>(){

                @Override
                public String apply(Entity e) {
                    return RadarUtils.getCustomName(e, true);
                }
            }).filter(new Predicate<String>(){

                @Override
                public boolean test(String e) {
                    return Objects.nonNull(e);
                }
            });
            final Iterator iterator = nameStream.iterator();
            if (!iterator.hasNext()) {
                return Lists.newArrayList((Object[])new String[]{"example"});
            }
            return new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return iterator;
                }
            };
        }
    }, new Function<String, List<String>>(){

        @Override
        public List<String> apply(String s) {
            return Lists.newArrayList((Object[])new String[]{s});
        }
    }, new Function<String, String>(){

        @Override
        public String apply(String s) {
            return s;
        }
    }, new Function<String, String>(){

        @Override
        public String apply(String s) {
            return s;
        }
    }, new Predicate<String>(){

        @Override
        public boolean test(String s) {
            return true;
        }
    }, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, EntityPlayer, Boolean> LIVING = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_LIVING, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, EntityPlayer, Boolean> HOSTILE = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_HOSTILE, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, EntityPlayer, Boolean> TAMED = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_TAMED, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, EntityPlayer, Boolean> SAME_TEAM = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_SAME_TEAM, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, EntityPlayer, Boolean> BABY = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_BABY, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, EntityPlayer, Boolean> VANILLA = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_VANILLA, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, EntityPlayer, Boolean> ABOVE_GROUND = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_ABOVE_GROUND, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, EntityPlayer, Boolean> MY_GROUND = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_MY_GROUND, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, EntityPlayer, Boolean> LIT = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_LIT, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, EntityPlayer, Boolean> HAS_CUSTOM_NAME = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.HAS_CUSTOM_NAME, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, EntityPlayer, Boolean> IN_TEAM = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_IN_TEAM, TYPE_LIST, TYPE_MAP);
    public static final ObjectCategoryListRuleType<Entity, EntityPlayer, Boolean> TRACKED = EntityRadarCategoryConstants.createHardRuleBasedPredicateListRuleType(EntityRadarCategoryHardRules.IS_TRACKED, TYPE_LIST, TYPE_MAP);
}

