/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.form.model;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import xaero.common.exception.OpenGLException;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.cache.id.variant.RadarIconVariantHandler;
import xaero.hud.minimap.radar.icon.creator.RadarIconCreator;
import xaero.hud.minimap.radar.icon.creator.entity.LivingEntityPoseResetter;
import xaero.hud.minimap.radar.icon.creator.render.form.IRadarIconFormPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.form.model.RadarIconModelPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.form.model.custom.RadarIconCustomPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.form.model.part.RadarIconModelPartPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.hud.minimap.radar.icon.definition.BuiltInRadarIconDefinitions;
import xaero.hud.minimap.radar.icon.definition.form.model.RadarIconModelForm;
import xaero.hud.minimap.radar.icon.definition.form.model.config.RadarIconModelConfig;

public class RadarIconModelFormPrerenderer
implements IRadarIconFormPrerenderer {
    private final LivingEntityPoseResetter livingEntityPoseResetter = new LivingEntityPoseResetter();
    private ModelRenderTrace mainModelTrace;
    private final ArrayList<ModelRenderer> mainRenderedModels = new ArrayList();
    private final RadarIconModelPrerenderer modelPrerenderer = new RadarIconModelPrerenderer();
    private ModelRenderer mainPart;
    private List<String> hardcodedMainPartAliases;
    private List<String> hardcodedModelPartsFields;
    private boolean forceFieldCheck;
    private boolean fullModelIcon;

    @Override
    public boolean requiresEntityModel() {
        return true;
    }

    @Override
    public boolean isFlipped() {
        return false;
    }

    @Override
    public boolean isOutlined() {
        return true;
    }

    @Override
    public <T extends Entity> boolean prerender(Render<? super T> entityRenderer, @Nullable ModelBase entityModel, T entity, @Nullable List<ModelRenderTrace> traceList, RadarIconCreator.Parameters parameters) {
        EntityLivingBase livingEntity;
        RadarIconModelForm modelForm = (RadarIconModelForm)parameters.form;
        GlStateManager.func_179089_o();
        GlStateManager.func_179147_l();
        GlStateManager.func_179126_j();
        GlStateManager.func_179129_p();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        if (parameters.debug) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)-10.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-65536);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        }
        RadarIconModelConfig config = parameters.defaultModelConfig;
        RadarIconModelConfig variantModelConfig = modelForm.getConfig();
        if (variantModelConfig != null) {
            config = variantModelConfig;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)32.0f, (float)32.0f, (float)-450.0f);
        GlStateManager.func_179109_b((float)config.offsetX, (float)config.offsetY, (float)0.0f);
        int mainScale = 32;
        GlStateManager.func_179152_a((float)mainScale, (float)mainScale, (float)(-mainScale));
        float scale = parameters.scale;
        if (scale < 1.0f) {
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        }
        GlStateManager.func_179152_a((float)config.baseScale, (float)config.baseScale, (float)config.baseScale);
        GlStateManager.func_179114_b((float)config.rotationY, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)config.rotationX, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)config.rotationZ, (float)0.0f, (float)0.0f, (float)1.0f);
        BuiltInRadarIconDefinitions.defaultTransformation(entityModel, entity);
        EntityLivingBase entityLivingBase = livingEntity = entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        if (livingEntity != null) {
            this.livingEntityPoseResetter.storeAndReset(livingEntity);
        }
        boolean isChildBU = entityModel.field_78091_s;
        entityModel.field_78091_s = false;
        boolean result = this.renderLayers(entityRenderer, entityModel, traceList, entity, config, parameters.defaultModelConfig);
        entityModel.field_78091_s = isChildBU;
        if (livingEntity != null) {
            this.livingEntityPoseResetter.restore(livingEntity);
        }
        BuiltInRadarIconDefinitions.defaultPostIconModelRender(entityModel, entity);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        if (parameters.debug) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)9.0f, (float)10.0f, (float)-10.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-16711936);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        }
        return result;
    }

    private <T extends Entity> boolean renderLayers(Render<? super T> entityRenderer, ModelBase mainEntityModel, List<ModelRenderTrace> traceList, T entity, RadarIconModelConfig config, RadarIconModelConfig defaultConfig) {
        boolean bl = this.forceFieldCheck = !(config.renderingFullModel != null && config.renderingFullModel != false || config.modelPartsFields == null && !BuiltInRadarIconDefinitions.forceFieldCheck(mainEntityModel));
        this.fullModelIcon = config.renderingFullModel == null ? !this.forceFieldCheck && BuiltInRadarIconDefinitions.fullModelIcon(mainEntityModel) : config.renderingFullModel;
        boolean renderedSomething = false;
        if (traceList.isEmpty()) {
            this.addDefaultLayer(traceList, entityRenderer, mainEntityModel, entity);
        }
        boolean allEmpty = true;
        for (ModelRenderTrace mrt : traceList) {
            if (mrt.isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            for (ModelRenderTrace mrt : traceList) {
                mrt.allVisible = true;
            }
        }
        this.mainPart = null;
        this.mainModelTrace = null;
        this.hardcodedMainPartAliases = BuiltInRadarIconDefinitions.getMainModelPartFields(entityRenderer, mainEntityModel, entity);
        this.hardcodedModelPartsFields = BuiltInRadarIconDefinitions.getSecondaryModelPartsFields(entityRenderer, mainEntityModel, entity);
        this.mainRenderedModels.clear();
        for (ModelRenderTrace mrt : traceList) {
            if (mrt.isEmpty() || renderedSomething && !config.layersAllowed) continue;
            int result = this.renderLayer(mrt, mainEntityModel, entity, config, defaultConfig);
            if (result == -1) break;
            if (result != 1) continue;
            renderedSomething = true;
        }
        this.hardcodedMainPartAliases = null;
        this.hardcodedModelPartsFields = null;
        if (this.mainRenderedModels.isEmpty() || !config.layersAllowed) {
            return renderedSomething;
        }
        RadarIconCustomPrerenderer extraLayer = BuiltInRadarIconDefinitions.getCustomLayer(entityRenderer, entity);
        RadarIconModelPartPrerenderer partPrerenderer = this.modelPrerenderer.getPartPrerenderer();
        if (extraLayer != null) {
            this.mainPart = extraLayer.render(entityRenderer, entity, mainEntityModel, partPrerenderer, this.mainRenderedModels, this.mainPart, config, this.mainModelTrace);
        }
        return renderedSomething;
    }

    private <T extends Entity> void addDefaultLayer(List<ModelRenderTrace> traceList, Render<? super T> entityRenderer, ModelBase mainEntityModel, T entity) {
        ResourceLocation mainEntityTexture = null;
        try {
            mainEntityTexture = RadarIconVariantHandler.getEntityTexture(entityRenderer, entity);
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("Couldn't fetch main entity texture when prerendering an icon with nothing detected!", t);
        }
        if (mainEntityTexture == null) {
            return;
        }
        TextureManager textureManager = Minecraft.func_71410_x().field_71446_o;
        ITextureObject mainTextureObject = textureManager.func_110581_b(mainEntityTexture);
        traceList.add(new ModelRenderTrace(mainEntityModel, mainTextureObject == null ? 0 : mainTextureObject.func_110552_b(), 770, 771, 1, 771, true, 515, true, true, true, true, true, 1.0f, 1.0f, 1.0f, 1.0f, false, 1029));
    }

    private <T extends Entity> int renderLayer(ModelRenderTrace mrt, ModelBase mainEntityModel, T entity, RadarIconModelConfig config, RadarIconModelConfig defaultConfig) {
        boolean mainPartsVisibility;
        ModelBase traceModel = mrt.model;
        if (entity instanceof EntityPlayer && traceModel != mainEntityModel && traceModel instanceof ModelBiped) {
            return 0;
        }
        int traceTexture = mrt.renderTexture;
        boolean mainModel = traceModel == mainEntityModel;
        boolean bl = mainPartsVisibility = mainModel && this.mainModelTrace != null && mrt.sameVisibility(this.mainModelTrace);
        if (mainModel && !mainPartsVisibility) {
            if (traceTexture <= 0) {
                return 0;
            }
            if (!this.resetModelRotations(entity, traceModel)) {
                return -1;
            }
            this.mainRenderedModels.clear();
            RadarIconModelPrerenderer.Parameters parameters = new RadarIconModelPrerenderer.Parameters(config, defaultConfig, traceTexture, mrt, this.forceFieldCheck, this.fullModelIcon, this.hardcodedMainPartAliases, this.hardcodedModelPartsFields, this.mainRenderedModels);
            this.mainPart = this.modelPrerenderer.renderModel(traceModel, entity, this.mainPart, parameters);
            this.mainModelTrace = mrt;
            if (!this.mainRenderedModels.isEmpty()) {
                return 1;
            }
            return 0;
        }
        if (!mainModel) {
            if (traceTexture <= 0) {
                return 0;
            }
            if (!this.resetModelRotations(entity, traceModel)) {
                return -1;
            }
            ArrayList<ModelRenderer> renderedModels = new ArrayList<ModelRenderer>();
            RadarIconModelPrerenderer.Parameters parameters = new RadarIconModelPrerenderer.Parameters(config, defaultConfig, traceTexture, mrt, this.forceFieldCheck, this.fullModelIcon, this.hardcodedMainPartAliases, this.hardcodedModelPartsFields, renderedModels);
            this.mainPart = this.modelPrerenderer.renderModel(traceModel, entity, this.mainPart, parameters);
            if (!renderedModels.isEmpty()) {
                return 1;
            }
            return 0;
        }
        if (this.mainRenderedModels.isEmpty()) {
            return 0;
        }
        this.modelPrerenderer.setupModelRenderType(traceTexture, mrt);
        RadarIconModelPartPrerenderer.Parameters parameters = new RadarIconModelPartPrerenderer.Parameters(config, mrt, new ArrayList<ModelRenderer>());
        this.modelPrerenderer.getPartPrerenderer().renderPartsIterable(this.mainRenderedModels, this.mainPart, parameters);
        this.modelPrerenderer.clearModelRenderType();
        return 0;
    }

    private <T extends Entity> boolean resetModelRotations(Entity entity, ModelBase model) {
        try {
            if (entity instanceof EntityLivingBase) {
                model.func_78086_a((EntityLivingBase)entity, 0.0f, 0.0f, 1.0f);
            }
            model.func_78087_a(0.0f, 0.0f, (float)entity.field_70173_aa, 0.0f, 0.0f, 0.0625f, entity);
            OpenGLException.checkGLError();
            return true;
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("suppressed exception", t);
            return false;
        }
    }
}

