/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.element.render.world;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.World;
import xaero.common.HudMod;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.element.render.MinimapElementReader;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.MinimapElementRenderer;
import xaero.hud.minimap.element.render.MinimapElementRendererHandler;
import xaero.hud.minimap.module.MinimapSession;

public class MinimapElementWorldRendererHandler
extends MinimapElementRendererHandler {
    private static final float DEFAULT_SCALE = 0.8f;
    private static final float MINECRAFT_SCALE = 0.02666667f;
    private static final double ELEMENT_WORLD_SCALE = 0.02133333496749401;
    private final MatrixStack matrixStackWorld;
    private final Vector4f origin4f;
    private Matrix4f waypointsProjection;
    private Matrix4f worldModelView;
    private int screenWidth;
    private int screenHeight;
    private Object workingClosestHoveredElement;
    private float workingClosestHoveredElementDistance;
    private MinimapElementRenderer<?, ?> workingClosestHoveredElementRenderer;
    private Object previousClosestHoveredElement;
    private MinimapElementRenderer<?, ?> previousClosestHoveredElementRenderer;
    private boolean previousClosestHoveredElementPresent;
    private boolean renderingMainHighlightedElement;

    protected MinimapElementWorldRendererHandler(HudMod modMain, List<MinimapElementRenderer<?, ?>> renderers, MatrixStack matrixStackWorld, Vector4f origin4f) {
        super(modMain, renderers, MinimapElementRenderLocation.IN_WORLD, 19499);
        this.matrixStackWorld = matrixStackWorld;
        this.origin4f = origin4f;
    }

    public void prepareRender(Matrix4f waypointsProjection, Matrix4f worldModelView) {
        this.waypointsProjection = waypointsProjection;
        this.worldModelView = worldModelView;
    }

    @Override
    public void render(MatrixStack matrixStack, Vector3d renderPos, float partialTicks, Framebuffer framebuffer, double backgroundCoordinateScale, RegistryKey<World> mapDimension) {
        if (HudMod.INSTANCE.getSupportMods().vivecraft) {
            return;
        }
        this.renderingMainHighlightedElement = false;
        super.render(matrixStack, renderPos, partialTicks, framebuffer, backgroundCoordinateScale, mapDimension);
    }

    @Override
    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(E element, double elementX, double elementY, double elementZ, RR renderer, RRC context, int elementIndex, double optionalDepth, MinimapElementRenderInfo renderInfo, MatrixStack matrixStackOverlay, IRenderTypeBuffer.Impl vanillaBufferSource) {
        float partialTicks = renderInfo.partialTicks;
        Vector3d renderPos = renderInfo.renderPos;
        MinimapElementReader<E, RRC> elementReader = renderer.getElementReader();
        double offX = elementX - renderPos.field_72450_a;
        double offY = elementReader.getRenderY(element, context, partialTicks) - renderPos.field_72448_b;
        double offZ = elementZ - renderPos.field_72449_c;
        Vector3f lookVector = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_227996_l_().func_229195_e_();
        double depth = offX * (double)lookVector.func_195899_a() + offY * (double)lookVector.func_195900_b() + offZ * (double)lookVector.func_195902_c();
        if (depth < 0.05) {
            return false;
        }
        if (!this.renderingMainHighlightedElement && element == this.previousClosestHoveredElement) {
            this.previousClosestHoveredElementPresent = true;
            return false;
        }
        double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
        if (distance > 250000.0) {
            double offScaler = 250000.0 / distance;
            offX *= offScaler;
            offY *= offScaler;
            offZ *= offScaler;
        }
        matrixStackOverlay.func_227860_a_();
        this.matrixStackWorld.func_227860_a_();
        this.matrixStackWorld.func_227861_a_(offX, offY, offZ);
        this.origin4f.func_229372_a_(this.matrixStackWorld.func_227866_c_().func_227870_a_());
        this.matrixStackWorld.func_227865_b_();
        this.origin4f.func_229372_a_(this.waypointsProjection);
        float translateX = (1.0f + this.origin4f.func_195910_a() / this.origin4f.func_195915_d()) / 2.0f * (float)this.screenWidth;
        float translateY = (1.0f - this.origin4f.func_195913_b() / this.origin4f.func_195915_d()) / 2.0f * (float)this.screenHeight;
        this.origin4f.func_195911_a(0.0f, 0.0f, 0.0f, 1.0f);
        int roundedX = Math.round(translateX);
        int roundedY = Math.round(translateY);
        boolean outOfBounds = roundedX < 0 || roundedY < 0 || roundedX >= this.screenWidth || roundedY >= this.screenHeight;
        boolean renderingHoveredElement = this.isElementHovered(element, roundedX, roundedY, elementReader, context, renderInfo);
        double partialX = translateX - (float)roundedX;
        double partialY = translateY - (float)roundedY;
        matrixStackOverlay.func_227861_a_((double)roundedX, (double)roundedY, 0.0);
        boolean highlighted = this.renderingMainHighlightedElement;
        highlighted = highlighted || renderingHoveredElement && elementReader.isAlwaysHighlightedWhenHovered(element, context);
        boolean result = renderer.renderElement(element, highlighted, outOfBounds, optionalDepth, 1.0f, partialX, partialY, renderInfo, matrixStackOverlay, vanillaBufferSource);
        matrixStackOverlay.func_227865_b_();
        if (result && renderingHoveredElement) {
            this.handleClosestHovered(element, renderer, roundedX, roundedY);
        }
        return result;
    }

    private <E, RRC> boolean isElementHovered(E element, int roundedX, int roundedY, MinimapElementReader<E, RRC> elementReader, RRC context, MinimapElementRenderInfo renderInfo) {
        int centerX;
        if (!elementReader.isInteractable(this.location, element)) {
            return false;
        }
        float partialTicks = renderInfo.partialTicks;
        int interactionLeft = elementReader.getInteractionBoxLeft(element, context, partialTicks);
        int interactionRight = elementReader.getInteractionBoxRight(element, context, partialTicks);
        int interactionTop = elementReader.getInteractionBoxTop(element, context, partialTicks);
        int interactionBottom = elementReader.getInteractionBoxBottom(element, context, partialTicks);
        double boxScale = elementReader.getBoxScale(this.location, element, context);
        if (boxScale != 1.0) {
            interactionLeft = (int)((double)interactionLeft * boxScale);
            interactionRight = (int)((double)interactionRight * boxScale);
            interactionTop = (int)((double)interactionTop * boxScale);
            interactionBottom = (int)((double)interactionBottom * boxScale);
        }
        if ((centerX = this.screenWidth / 2) - roundedX < interactionLeft || centerX - roundedX >= interactionRight) {
            return false;
        }
        int centerY = this.screenHeight / 2;
        return centerY - roundedY >= interactionTop && centerY - roundedY < interactionBottom;
    }

    private <E, RRC, RR extends MinimapElementRenderer<E, RRC>> void handleClosestHovered(E element, RR renderer, int roundedX, int roundedY) {
        int centerX = this.screenWidth / 2;
        int centerY = this.screenHeight / 2;
        int screenOffX = roundedX - centerX;
        int screenOffY = roundedY - centerY;
        float squaredScreenDistance = screenOffX * screenOffX + screenOffY * screenOffY;
        if (this.workingClosestHoveredElement == null || squaredScreenDistance < this.workingClosestHoveredElementDistance || element == this.previousClosestHoveredElement && squaredScreenDistance <= this.workingClosestHoveredElementDistance) {
            this.workingClosestHoveredElement = element;
            this.workingClosestHoveredElementDistance = squaredScreenDistance;
            this.workingClosestHoveredElementRenderer = renderer;
        }
    }

    private <E, RR extends MinimapElementRenderer<E, RRC>, RRC> void renderMainHighlightedElement(MinimapElementRenderInfo renderInfo, MatrixStack matrixStack, IRenderTypeBuffer.Impl vanillaBufferSource) {
        if (!this.previousClosestHoveredElementPresent) {
            return;
        }
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers = session.getMultiTextureRenderTypeRenderers();
        Object element = this.previousClosestHoveredElement;
        MinimapElementRenderer<?, ?> renderer = this.previousClosestHoveredElementRenderer;
        this.renderingMainHighlightedElement = true;
        renderer.preRender(renderInfo, vanillaBufferSource, multiTextureRenderTypeRenderers);
        boolean result = this.transformAndRenderForRenderer(element, renderer, renderer.getContext(), 0, 0.0, renderInfo, matrixStack, vanillaBufferSource);
        renderer.postRender(renderInfo, vanillaBufferSource, multiTextureRenderTypeRenderers);
        this.renderingMainHighlightedElement = false;
        this.previousClosestHoveredElementPresent = false;
        if (!result) {
            return;
        }
        matrixStack.func_227861_a_(0.0, 0.0, this.getElementIndexDepth(1, 1));
    }

    @Override
    protected void beforeRender(MatrixStack matrixStackOverlay, MinimapElementRenderInfo renderInfo, IRenderTypeBuffer.Impl vanillaBufferSource) {
        this.screenWidth = Minecraft.func_71410_x().func_228018_at_().func_198109_k();
        this.screenHeight = Minecraft.func_71410_x().func_228018_at_().func_198091_l();
        this.matrixStackWorld.func_227860_a_();
        this.matrixStackWorld.func_227866_c_().func_227870_a_().func_226595_a_(this.worldModelView);
        matrixStackOverlay.func_227860_a_();
        matrixStackOverlay.func_227861_a_(0.0, 0.0, -2980.0);
    }

    @Override
    protected void afterRender(MatrixStack matrixStackOverlay, MinimapElementRenderInfo renderInfo, IRenderTypeBuffer.Impl vanillaBufferSource) {
        this.renderMainHighlightedElement(renderInfo, matrixStackOverlay, vanillaBufferSource);
        this.previousClosestHoveredElement = this.workingClosestHoveredElement;
        this.previousClosestHoveredElementRenderer = this.workingClosestHoveredElementRenderer;
        this.workingClosestHoveredElement = null;
        this.workingClosestHoveredElementRenderer = null;
        matrixStackOverlay.func_227865_b_();
        this.matrixStackWorld.func_227865_b_();
        CustomRenderTypes.DEPTH_CLEAR.func_228547_a_();
        RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
        CustomRenderTypes.DEPTH_CLEAR.func_228549_b_();
    }

    public static final class Builder {
        public MinimapElementWorldRendererHandler build() {
            ArrayList renderers = new ArrayList();
            return new MinimapElementWorldRendererHandler(HudMod.INSTANCE, renderers, new MatrixStack(), new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        }

        protected Builder setDefault() {
            return this;
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

