/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.armor;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import xaero.common.gui.component.CachedComponentSupplier;

public class ArmorStatusCachedComponents {
    static final CachedComponentSupplier ARROW_COUNT;
    static final CachedComponentSupplier[] FOOD_RESTORES;
    static final CachedComponentSupplier[] DURABILITY;
    static final CachedComponentSupplier[] LABEL_WITH_COUNT;
    static final CachedComponentSupplier[] ENCHANTS;

    private static void translateEchant(StringBuilder lineBuilder, String name, int count) {
        if (name == null || name.isEmpty()) {
            return;
        }
        if (count <= 1) {
            lineBuilder.append(name);
            return;
        }
        String[] words = name.split(" ");
        for (int i = 0; i < words.length; ++i) {
            String s1 = words[i];
            if (i == words.length - 1 || s1.length() <= 2) {
                lineBuilder.append(s1);
                continue;
            }
            lineBuilder.append(s1.substring(0, 1).toUpperCase()).append(s1.substring(1, 2).toLowerCase()).append("-");
        }
    }

    static {
        int i;
        ARROW_COUNT = new CachedComponentSupplier(args -> {
            int count = (Integer)args[0];
            int totalCount = (Integer)args[1];
            return new StringTextComponent(count + "/" + totalCount);
        });
        FOOD_RESTORES = new CachedComponentSupplier[32];
        DURABILITY = new CachedComponentSupplier[32];
        LABEL_WITH_COUNT = new CachedComponentSupplier[32];
        ENCHANTS = new CachedComponentSupplier[32];
        for (i = 0; i < FOOD_RESTORES.length; ++i) {
            ArmorStatusCachedComponents.FOOD_RESTORES[i] = new CachedComponentSupplier(args -> {
                double restoreValue = (Double)args[0];
                TranslationTextComponent result = new TranslationTextComponent("gui.xaero_restores");
                result.func_150253_a().add(new StringTextComponent(" " + restoreValue));
                return result;
            });
        }
        for (i = 0; i < DURABILITY.length; ++i) {
            ArmorStatusCachedComponents.DURABILITY[i] = new CachedComponentSupplier(args -> {
                int type = (Integer)args[0];
                if (type == 3) {
                    return new StringTextComponent("");
                }
                int maxDamage = (Integer)args[1];
                int currentDamage = (Integer)args[2];
                int durabilityLeft = maxDamage - currentDamage;
                int percent = durabilityLeft * 100 / maxDamage;
                StringTextComponent result = type == 0 ? new StringTextComponent(percent + "%") : (type == 1 ? new StringTextComponent(durabilityLeft + "/" + maxDamage) : new StringTextComponent(durabilityLeft + "/" + maxDamage + " (" + percent + "%)"));
                if (percent <= 5) {
                    result = (TextComponent)result.func_240699_a_(TextFormatting.LIGHT_PURPLE);
                } else if (percent <= 25) {
                    result = (TextComponent)result.func_240699_a_(TextFormatting.RED);
                } else if (percent <= 50) {
                    result = (TextComponent)result.func_240699_a_(TextFormatting.GOLD);
                } else if (percent <= 75) {
                    result = (TextComponent)result.func_240699_a_(TextFormatting.YELLOW);
                }
                return result;
            });
        }
        for (i = 0; i < LABEL_WITH_COUNT.length; ++i) {
            ArmorStatusCachedComponents.LABEL_WITH_COUNT[i] = new CachedComponentSupplier(args -> {
                ITextComponent label = (ITextComponent)args[0];
                int count = (Integer)args[1];
                boolean flipped = (Boolean)args[2];
                TranslationTextComponent result = flipped ? new TranslationTextComponent("(" + count + ") ") : new StringTextComponent("");
                result.func_150253_a().add(label);
                if (!flipped) {
                    result.func_150253_a().add(new StringTextComponent(" (" + count + ")"));
                }
                return result;
            });
        }
        for (int j = 0; j < ENCHANTS.length; ++j) {
            ArmorStatusCachedComponents.ENCHANTS[j] = new CachedComponentSupplier(args -> {
                ListNBT enchants = (ListNBT)args[0];
                int color = (Integer)args[1];
                int count = enchants.size();
                StringBuilder lineBuilder = new StringBuilder();
                for (int i = 0; i < count; ++i) {
                    String id = enchants.func_150305_b(i).func_74779_i("id");
                    short lvl = enchants.func_150305_b(i).func_74765_d("lvl");
                    String name = "";
                    Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.func_208304_a((String)id));
                    if (enchantment != null) {
                        name = enchantment.func_200305_d((int)lvl).getString();
                    }
                    if (i > 0) {
                        lineBuilder.append(", ");
                    }
                    ArmorStatusCachedComponents.translateEchant(lineBuilder, name, count);
                }
                String labelString = lineBuilder.toString();
                return new StringTextComponent(labelString).func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)color)));
            });
        }
    }
}

