/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.notification;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import xaero.hud.pvp.module.notification.Notification;
import xaero.hud.pvp.module.notification.NotificationSession;
import xaero.hud.render.TextureLocations;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class NotificationRenderer
implements IModuleRenderer<NotificationSession> {
    @Override
    public void render(NotificationSession session, ModuleRenderContext c, MatrixStack matrixStack, float partialTicks) {
        boolean air;
        if (System.currentTimeMillis() - session.getLastBlink() > 500L) {
            session.setLastBlink(System.currentTimeMillis());
            session.setBlink(!session.getBlink());
        }
        Minecraft mc = Minecraft.func_71410_x();
        int total = 0;
        boolean lowHunger = session.getNotificationHunger() && (float)mc.field_71439_g.func_71024_bL().func_75116_a() <= 2.0f * (float)session.getLowHunger();
        boolean lowHealth = session.getNotificationHP() && mc.field_71439_g.func_110143_aJ() <= 2.0f * (float)session.getLowHealth();
        boolean tnt = session.getNotificationTNT() && session.getWorldHelper().tntIsAround(mc.field_71439_g);
        boolean arrow = session.getNotificationArrow() && session.getWorldHelper().arrowIsAround(mc.field_71439_g);
        boolean bl = air = session.getNotificationAir() && mc.field_71439_g.func_70086_ai() <= 30 * session.getLowAir();
        if (lowHunger) {
            ++total;
        }
        if (lowHealth) {
            ++total;
        }
        if (tnt) {
            ++total;
        }
        if (arrow) {
            ++total;
        }
        if (air) {
            ++total;
        }
        if (total == 0) {
            return;
        }
        int between = 32 - 4 * total;
        int unitLength = 32 + between;
        int totalLength = total * unitLength;
        int drawY = c.y + (c.h - 32) / 2;
        int drawX = c.x + c.w / 2 - totalLength / 2 + between / 2;
        GlStateManager.func_227709_e_();
        if (session.getBlink()) {
            RenderSystem.color4f((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
        } else {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        mc.func_110434_K().func_110577_a(TextureLocations.GUI_TEXTURES);
        if (lowHunger) {
            this.renderNotification(mc, Notification.LOW_HUNGER, drawX, drawY, matrixStack);
            drawX += unitLength;
        }
        if (lowHealth) {
            this.renderNotification(mc, Notification.LOW_HEALTH, drawX, drawY, matrixStack);
            drawX += unitLength;
        }
        if (tnt) {
            this.renderNotification(mc, Notification.TNT, drawX, drawY, matrixStack);
            drawX += unitLength;
        }
        if (arrow) {
            this.renderNotification(mc, Notification.ARROW, drawX, drawY, matrixStack);
            drawX += unitLength;
        }
        if (air) {
            this.renderNotification(mc, Notification.AIR, drawX, drawY, matrixStack);
            drawX += unitLength;
        }
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderNotification(Minecraft mc, Notification notification, int drawX, int drawY, MatrixStack matrixStack) {
        mc.field_71456_v.func_238474_b_(matrixStack, drawX, drawY, 17, notification.getTextureIndex() * 32, notification.getTextureW(), 32);
    }
}

