/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.packet.basic;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import xaero.common.XaeroMinimapSession;
import xaero.common.server.player.ServerPlayerData;

public class HandshakePacket {
    public static final int NETWORK_COMPATIBILITY = 3;
    private final int networkVersion;

    public HandshakePacket(int networkVersion) {
        this.networkVersion = networkVersion;
    }

    public HandshakePacket() {
        this(3);
    }

    public void write(PacketBuffer u) {
        u.writeInt(this.networkVersion);
    }

    public static HandshakePacket read(PacketBuffer buffer) {
        return new HandshakePacket(buffer.readInt());
    }

    public static class ServerHandler
    implements BiConsumer<HandshakePacket, ServerPlayerEntity> {
        @Override
        public void accept(HandshakePacket message, ServerPlayerEntity player) {
            ServerPlayerData playerData = ServerPlayerData.get(player);
            playerData.setClientModNetworkVersion(message.networkVersion);
        }
    }

    public static class ClientHandler
    implements Consumer<HandshakePacket> {
        @Override
        public void accept(HandshakePacket message) {
            XaeroMinimapSession session = XaeroMinimapSession.getCurrentSession();
            if (session == null) {
                return;
            }
            session.getMinimapProcessor().setServerModNetworkVersion(message.networkVersion);
            session.getModMain().getMessageHandler().sendToServer((Object)new HandshakePacket());
        }
    }
}

