/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.effect;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import xaero.hud.pvp.module.effect.StatusEffectSession;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class StatusEffectRenderer
implements IModuleRenderer<StatusEffectSession> {
    @Override
    public void render(StatusEffectSession session, ModuleRenderContext c, MatrixStack matrixStack, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227709_e_();
        if (!mc.field_71439_g.func_70651_bq().isEmpty()) {
            this.renderEffects(session, matrixStack, c, mc);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderEffects(StatusEffectSession session, MatrixStack matrixStack, ModuleRenderContext c, Minecraft mc) {
        Collection effects;
        if (c.flippedVertically) {
            c.y = c.y + c.h - 30;
        }
        if ((effects = mc.field_71439_g.func_70651_bq()).isEmpty()) {
            return;
        }
        effects = Ordering.natural().sortedCopy((Iterable)effects);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableLighting();
        RenderSystem.enableBlend();
        if (session.isBlinkEnabled() && System.currentTimeMillis() - session.getLastBlink() > 500L) {
            session.setLastBlink(System.currentTimeMillis());
            session.setBlink(!session.getBlink());
        }
        if (session.isCentered()) {
            this.renderCentered(session, matrixStack, c, mc, effects);
            return;
        }
        this.renderNormal(session, matrixStack, c, mc, effects);
    }

    private void renderCentered(StatusEffectSession session, MatrixStack matrixStack, ModuleRenderContext c, Minecraft mc, Collection<EffectInstance> effects) {
        PotionSpriteUploader potionspriteuploader = mc.func_213248_ap();
        int columnWidth = 27;
        int defaultEffectAmount = 182 / columnWidth;
        if (effects.size() > defaultEffectAmount) {
            columnWidth = 182 / effects.size();
        }
        int totalSize = effects.size() * columnWidth;
        int firstColumn = c.x + c.w / 2 + totalSize / 2 * (c.flippedHorizontally ? 1 : -1);
        if (c.flippedHorizontally) {
            firstColumn -= columnWidth;
        }
        int currentX = firstColumn + (columnWidth - 18) / 2;
        int currentY = c.y + 7;
        for (EffectInstance effectInstance : effects) {
            int duration = effectInstance.func_76459_b();
            if (duration <= 200 && !session.getBlink() && session.isBlinkEnabled()) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            } else {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            Effect effect = effectInstance.func_188419_a();
            TextureAtlasSprite effectSprite = potionspriteuploader.func_215288_a(effect);
            if (effectSprite != null) {
                mc.func_110434_K().func_110577_a(effectSprite.func_229241_m_().func_229223_g_());
                AbstractGui.func_238470_a_((MatrixStack)matrixStack, (int)currentX, (int)currentY, (int)0, (int)18, (int)18, (TextureAtlasSprite)effectSprite);
            }
            String durationString = EffectUtils.func_188410_a((EffectInstance)effectInstance, (float)1.0f);
            int amplifier = effectInstance.func_76458_c();
            String levelString = amplifier > 0 ? "" + (effectInstance.func_76458_c() + 1) : "";
            AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)levelString, (int)currentX, (int)currentY, (int)0xFFFFFF);
            AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)durationString, (int)(currentX + 10 - mc.field_71466_p.func_78256_a(durationString) / 2), (int)(currentY + 15), (int)0xFFFFFF);
            RenderSystem.enableBlend();
            currentX += columnWidth * (c.flippedHorizontally ? -1 : 1);
        }
    }

    private void renderNormal(StatusEffectSession session, MatrixStack matrixStack, ModuleRenderContext c, Minecraft mc, Collection<EffectInstance> effects) {
        int rowHeight = 25;
        if (effects.size() > 6) {
            rowHeight = 135 / (effects.size() - 1);
        }
        PotionSpriteUploader potionspriteuploader = mc.func_213248_ap();
        for (EffectInstance effectInstance : effects) {
            String potionName;
            int duration = effectInstance.func_76459_b();
            if (duration <= 200 && !session.getBlink() && session.isBlinkEnabled()) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            } else {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            Effect effect = effectInstance.func_188419_a();
            TextureAtlasSprite effectSprite = potionspriteuploader.func_215288_a(effect);
            if (effectSprite != null) {
                mc.func_110434_K().func_110577_a(effectSprite.func_229241_m_().func_229223_g_());
                AbstractGui.func_238470_a_((MatrixStack)matrixStack, (int)(c.flippedHorizontally ? c.x + c.w - 24 : c.x + 6), (int)(c.y + 7), (int)0, (int)18, (int)18, (TextureAtlasSprite)effectSprite);
            }
            String durationString = EffectUtils.func_188410_a((EffectInstance)effectInstance, (float)1.0f);
            if (!session.shouldShowNames()) {
                potionName = durationString;
                durationString = null;
            } else {
                potionName = I18n.func_135052_a((String)effect.func_76393_a(), (Object[])new Object[0]);
                if (effectInstance.func_76458_c() >= 1 && effectInstance.func_76458_c() <= 9) {
                    potionName = potionName + ' ' + I18n.func_135052_a((String)("enchantment.level." + (effectInstance.func_76458_c() + 1)), (Object[])new Object[0]);
                }
            }
            int amplifier = effectInstance.func_76458_c();
            String levelString = amplifier > 0 ? "" + (effectInstance.func_76458_c() + 1) : "";
            AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)levelString, (int)(c.flippedHorizontally ? c.x + c.w - 24 : c.x + 6), (int)(c.y + 7), (int)0xFFFFFF);
            AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)potionName, (int)(c.flippedHorizontally ? c.x + c.w - 28 - mc.field_71466_p.func_78256_a(potionName) : c.x + 10 + 18), (int)(c.y + 7), (int)0xFFFFFF);
            if (durationString != null) {
                AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)durationString, (int)(c.flippedHorizontally ? c.x + c.w - 28 - mc.field_71466_p.func_78256_a(durationString) : c.x + 10 + 18), (int)(c.y + 7 + 10), (int)0xFFFFFF);
            }
            RenderSystem.enableBlend();
            c.y = c.y + (c.flippedVertically ? -rowHeight : rowHeight);
        }
    }
}

