/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.element.render.map;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.vector.Vector3d;
import xaero.common.HudMod;
import xaero.common.minimap.element.render.MinimapElementRendererHandler;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.MinimapElementRenderer;
import xaero.hud.minimap.element.render.MinimapElementRendererHandler;

public class MinimapElementMapRendererHandler
extends MinimapElementRendererHandler {
    private double ps;
    private double pc;
    private double zoom;
    private float halfWView;

    protected MinimapElementMapRendererHandler(HudMod modMain, List<MinimapElementRenderer<?, ?>> renderers) {
        super(modMain, renderers, MinimapElementRenderLocation.IN_MINIMAP, 19490);
    }

    public void prepareRender(double ps, double pc, double zoom, float halfWView) {
        this.ps = ps;
        this.pc = pc;
        this.zoom = zoom;
        this.halfWView = halfWView;
    }

    @Override
    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(E element, double elementX, double elementY, double elementZ, RR renderer, RRC context, int elementIndex, double optionalDepth, MinimapElementRenderInfo renderInfo, MatrixStack matrixStack, IRenderTypeBuffer.Impl vanillaBufferSource) {
        Vector3d renderPos = renderInfo.renderPos;
        double offx = elementX - renderPos.field_72450_a;
        double offz = elementZ - renderPos.field_72449_c;
        matrixStack.func_227860_a_();
        double zoomedOffX = offx * this.zoom;
        double zoomedOffZ = offz * this.zoom;
        double translateX = this.ps * zoomedOffX - this.pc * zoomedOffZ;
        double translateY = this.pc * zoomedOffX + this.ps * zoomedOffZ;
        int roundedX = (int)Math.round(translateX);
        int roundedY = (int)Math.round(translateY);
        boolean outOfBounds = (float)Math.abs(roundedX) > this.halfWView || (float)Math.abs(roundedY) > this.halfWView;
        double partialX = translateX - (double)roundedX;
        double partialY = translateY - (double)roundedY;
        matrixStack.func_227861_a_((double)roundedX, (double)roundedY, 0.0);
        boolean result = renderer.renderElement(element, false, outOfBounds, optionalDepth, 1.0f, partialX, partialY, renderInfo, matrixStack, vanillaBufferSource);
        matrixStack.func_227865_b_();
        return result;
    }

    @Override
    protected void beforeRender(MatrixStack matrixStack, MinimapElementRenderInfo renderInfo, IRenderTypeBuffer.Impl vanillaBufferSource) {
    }

    @Override
    protected void afterRender(MatrixStack matrixStack, MinimapElementRenderInfo renderInfo, IRenderTypeBuffer.Impl vanillaBufferSource) {
    }

    public static final class Builder
    extends MinimapElementRendererHandler.Builder {
        @Override
        public MinimapElementMapRendererHandler build() {
            return (MinimapElementMapRendererHandler)super.build();
        }

        @Override
        protected MinimapElementMapRendererHandler buildInternally(List<MinimapElementRenderer<?, ?>> renderers) {
            return new xaero.common.minimap.element.render.map.MinimapElementMapRendererHandler(HudMod.INSTANCE, renderers);
        }

        @Override
        protected Builder setDefault() {
            super.setDefault();
            return this;
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

