/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.armor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.HandSide;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import xaero.hud.minimap.common.config.MinimapConfigConstants;
import xaero.hud.pvp.module.armor.ArmorStatusCachedComponents;
import xaero.hud.pvp.module.armor.ArmorStatusInventoryHelper;
import xaero.hud.pvp.module.armor.ArmorStatusSession;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class ArmorStatusRenderer
implements IModuleRenderer<ArmorStatusSession> {
    public static final int LINE_HEIGHT = 19;
    private int restoresLabelIndex;
    private int durabilityLabelIndex;
    private int labelCountLabelIndex;
    private int enchantsLabelIndex;
    private boolean renderedOffhand;
    private final ArmorStatusInventoryHelper inventoryHelper = new ArmorStatusInventoryHelper();

    @Override
    public void render(ArmorStatusSession session, ModuleRenderContext c, MatrixStack matrixStack, float partialTicks) {
        RenderSystem.enableDepthTest();
        this.durabilityLabelIndex = 0;
        this.labelCountLabelIndex = 0;
        this.restoresLabelIndex = 0;
        this.enchantsLabelIndex = 0;
        this.renderedOffhand = false;
        if (!session.isCentered()) {
            this.renderClassic(session, matrixStack, c);
        } else {
            this.renderCentered(session, matrixStack, c);
        }
        if (this.renderedOffhand) {
            session.onOffhandItemRender();
        }
        RenderSystem.disableDepthTest();
    }

    private void renderClassic(ArmorStatusSession session, MatrixStack matrixStack, ModuleRenderContext c) {
        Minecraft mc = Minecraft.func_71410_x();
        int iconX = c.x + (c.flippedHorizontally ? c.w - 3 : 3);
        int iconY = c.y + 3;
        if (!c.flippedVertically) {
            iconY = this.renderClassicArmor(iconX, iconY, mc.field_71439_g, session, matrixStack, c);
        }
        iconY = this.renderClassicHeldItems(iconX, iconY, mc.field_71439_g, session, matrixStack, c);
        if (c.flippedVertically) {
            iconY = this.renderClassicArmor(iconX, iconY, mc.field_71439_g, session, matrixStack, c);
        }
    }

    private int renderClassicHeldItems(int iconX, int iconY, ClientPlayerEntity player, ArmorStatusSession session, MatrixStack matrixStack, ModuleRenderContext c) {
        ITextComponent lastLabel;
        ITextComponent firstLabel;
        ItemStack main;
        EquipmentSlotType bowHand = this.inventoryHelper.getBowHand(player);
        ItemStack arrows = bowHand != null && session.getArchery() ? this.inventoryHelper.getArrowStack((PlayerEntity)player) : null;
        ItemStack off = session.getDisplayOffHand() ? player.func_184582_a(EquipmentSlotType.OFFHAND) : null;
        ItemStack itemStack = main = session.getDisplayMainHand() ? player.field_71071_by.func_70448_g() : null;
        if (off != null) {
            this.renderedOffhand = true;
        }
        if (off == arrows) {
            off = null;
        }
        if (main == arrows) {
            main = null;
        }
        if (c.flippedVertically) {
            int totalHeldItems = 0;
            if (off != null) {
                ++totalHeldItems;
            }
            if (main != null) {
                ++totalHeldItems;
            }
            if (arrows != null) {
                ++totalHeldItems;
            }
            iconY += 19 * (3 - totalHeldItems);
        }
        ITextComponent arrowLabel = arrows == null ? null : this.getArrowCountLabel(arrows, player);
        ItemStack first = c.flippedVertically ? arrows : off;
        Object object = firstLabel = c.flippedVertically ? arrowLabel : null;
        if (first != null) {
            this.renderItemWithInfo(session, matrixStack, first, firstLabel, iconX, iconY, c.flippedHorizontally, !c.flippedVertically, !c.flippedVertically);
            iconY += 19;
        }
        if (main != null) {
            this.renderItemWithInfo(session, matrixStack, main, null, iconX, iconY, c.flippedHorizontally, true, false);
            iconY += 19;
        }
        ItemStack last = c.flippedVertically ? off : arrows;
        ITextComponent iTextComponent = lastLabel = c.flippedVertically ? null : arrowLabel;
        if (last != null) {
            this.renderItemWithInfo(session, matrixStack, last, lastLabel, iconX, iconY, c.flippedHorizontally, c.flippedVertically, c.flippedVertically);
            iconY += 19;
        }
        return iconY;
    }

    private int renderClassicArmor(int iconX, int iconY, ClientPlayerEntity player, ArmorStatusSession session, MatrixStack matrixStack, ModuleRenderContext c) {
        for (int i = 3; i >= 0; --i) {
            ItemStack itemStack = (ItemStack)player.field_71071_by.field_70460_b.get(i);
            if (!itemStack.func_190926_b()) {
                this.renderItemWithInfo(session, matrixStack, itemStack, null, iconX, iconY, c.flippedHorizontally, true, false);
            }
            iconY += 19;
        }
        return iconY;
    }

    private void renderCentered(ArmorStatusSession session, MatrixStack matrixStack, ModuleRenderContext c) {
        ItemStack main;
        int line;
        int slot;
        Minecraft mc = Minecraft.func_71410_x();
        PlayerInventory inventory = mc.field_71439_g.field_71071_by;
        int leftArmorSlotStart = c.flippedHorizontally ? 0 : 2;
        int rightArmorSlotStart = c.flippedHorizontally ? 2 : 0;
        int armorStartLine = c.flippedVertically ? 1 : 0;
        int armorStepDirection = c.flippedVertically ? -1 : 1;
        for (slot = leftArmorSlotStart; slot < leftArmorSlotStart + 2; ++slot) {
            line = armorStartLine + armorStepDirection * (slot - leftArmorSlotStart);
            this.renderItemWithInfo(session, matrixStack, (ItemStack)inventory.field_70460_b.get(slot), null, c.x + c.w / 2 - 94, c.y + 3 + 19 * line, true, true, false);
        }
        for (slot = rightArmorSlotStart; slot < rightArmorSlotStart + 2; ++slot) {
            line = armorStartLine + armorStepDirection * (slot - rightArmorSlotStart);
            this.renderItemWithInfo(session, matrixStack, (ItemStack)inventory.field_70460_b.get(slot), null, c.x + c.w / 2 + 94, c.y + 3 + 19 * line, false, true, false);
        }
        EquipmentSlotType bowHand = this.inventoryHelper.getBowHand(mc.field_71439_g);
        ItemStack arrows = bowHand != null && session.getArchery() ? this.inventoryHelper.getArrowStack((PlayerEntity)mc.field_71439_g) : null;
        ItemStack off = session.getDisplayOffHand() ? mc.field_71439_g.func_184582_a(EquipmentSlotType.OFFHAND) : null;
        ItemStack itemStack = main = session.getDisplayMainHand() ? inventory.func_70448_g() : null;
        if (off != null) {
            this.renderedOffhand = true;
        }
        if (off == arrows) {
            off = null;
        }
        if (main == arrows) {
            main = null;
        }
        boolean mainOnLeft = mc.field_71474_y.field_186715_A == HandSide.LEFT;
        int iconY = c.y + c.h / 2 > c.screenHeight / 2 ? c.y + 3 - 19 : c.y + c.h;
        int heldItemsCenteredPosition = session.getHeldItemsCenteredPosition();
        if (heldItemsCenteredPosition == 0) {
            if (off != null) {
                this.renderItemWithInfo(session, matrixStack, off, null, mainOnLeft ? c.screenWidth - 3 : 3, iconY, mainOnLeft, true, true);
            }
            if (main != null) {
                this.renderItemWithInfo(session, matrixStack, main, null, mainOnLeft ? 3 : c.screenWidth - 3, iconY, !mainOnLeft, true, false);
            }
        } else {
            if (off != null) {
                this.renderItemWithInfo(session, matrixStack, off, null, c.x + c.w / 2 + (mainOnLeft ? 94 : -94), iconY, !mainOnLeft, true, true);
            }
            if (main != null) {
                this.renderItemWithInfo(session, matrixStack, main, null, c.x + c.w / 2 + (mainOnLeft ? -94 : 94), iconY, mainOnLeft, true, false);
            }
        }
        if (arrows == null) {
            return;
        }
        int arrowY = c.y + c.h / 2 > c.screenHeight / 2 ? iconY - 19 : iconY + 19;
        boolean onTheRight = bowHand == EquipmentSlotType.MAINHAND && !mainOnLeft || bowHand == EquipmentSlotType.OFFHAND && mainOnLeft;
        ITextComponent arrowLabel = this.getArrowCountLabel(arrows, mc.field_71439_g);
        if (heldItemsCenteredPosition == 0) {
            this.renderItemWithInfo(session, matrixStack, arrows, arrowLabel, onTheRight ? c.screenWidth - 3 : 3, arrowY, onTheRight, false, false);
        } else {
            this.renderItemWithInfo(session, matrixStack, arrows, arrowLabel, c.x + c.w / 2 + (onTheRight ? 94 : -94), arrowY, !onTheRight, false, false);
        }
    }

    public void renderItemWithInfo(ArmorStatusSession session, MatrixStack matrixStack, ItemStack stack, ITextComponent customLabel, int x, int y, boolean flipped, boolean withSize, boolean keepNormalCount) {
        if (stack == null || stack.func_77973_b() == Items.field_190931_a) {
            return;
        }
        boolean enchanted = stack.func_77948_v();
        boolean fullCount = session.getShowFullCount();
        boolean enchants = session.getShowEnchants();
        ITextComponent label = customLabel;
        if (label == null) {
            label = this.getDamageLabel(stack, session, withSize && fullCount && keepNormalCount && stack.func_190916_E() > 1, flipped);
        }
        ITextComponent enchantsLabel = null;
        if (enchants) {
            enchantsLabel = this.getEnchantsLabel(enchanted ? stack.func_77986_q() : null, session.getEnchantsColor());
        }
        this.renderItemWithLabels(matrixStack, stack, label, enchantsLabel, x, y, flipped, withSize, fullCount);
    }

    public void renderItemWithLabels(MatrixStack matrixStack, ItemStack stack, ITextComponent label1, ITextComponent label2, int x, int y, boolean flipped, boolean withSize, boolean fullCount) {
        Minecraft mc = Minecraft.func_71410_x();
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        int iconX = x - (flipped ? 16 : 0);
        int iconY = y;
        int label1X = iconX + (flipped ? -3 - mc.field_71466_p.func_238414_a_((ITextProperties)label1) : 19);
        int label1Y = iconY;
        AbstractGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (ITextComponent)label1, (int)label1X, (int)label1Y, (int)0xFFFFFF);
        if (label2 != null) {
            int label2X = iconX + (flipped ? -3 - mc.field_71466_p.func_238414_a_((ITextProperties)label2) : 19);
            int label2Y = iconY + 9;
            AbstractGui.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (ITextComponent)label2, (int)label2X, (int)label2Y, (int)0xFFFFFF);
        }
        RenderHelper.func_227780_a_();
        mc.func_175599_af().field_77023_b -= 100.0f;
        mc.func_175599_af().func_180450_b(stack, iconX, iconY);
        mc.func_175599_af().field_77023_b += 100.0f;
        int size = 1;
        if (withSize) {
            size = stack.func_190916_E();
            if (fullCount) {
                size = this.inventoryHelper.getFullItemCount(stack.func_77973_b(), mc.field_71439_g);
            }
        }
        String sizeString = "" + size;
        if (size <= 1) {
            sizeString = "";
        }
        mc.func_175599_af().func_180453_a(mc.field_71466_p, stack, iconX, iconY, sizeString);
        RenderHelper.func_74518_a();
    }

    public ITextComponent getDamageLabel(ItemStack stack, ArmorStatusSession session, boolean includeCount, boolean flipped) {
        Food food;
        ITextComponent result = null;
        if (stack.func_77973_b().func_219971_r() && (food = stack.func_77973_b().func_219967_s()) != null && food.func_221466_a() > 0) {
            result = ArmorStatusCachedComponents.FOOD_RESTORES[this.restoresLabelIndex++].get((double)food.func_221466_a() / 2.0);
        }
        if (result == null && stack.func_77958_k() > 0) {
            result = ArmorStatusCachedComponents.DURABILITY[this.durabilityLabelIndex++].get(session.getDurabilityType(), stack.func_77958_k(), stack.func_77952_i());
        }
        if (result == null) {
            result = stack.func_200301_q();
        }
        if (includeCount) {
            result = ArmorStatusCachedComponents.LABEL_WITH_COUNT[this.labelCountLabelIndex++].get(result, stack.func_190916_E(), flipped);
        }
        return result;
    }

    private ITextComponent getEnchantsLabel(ListNBT enchants, int enchantColor) {
        if (enchants == null) {
            return null;
        }
        int color = MinimapConfigConstants.COLORS[enchantColor];
        return ArmorStatusCachedComponents.ENCHANTS[this.enchantsLabelIndex++].get(enchants, color);
    }

    public ITextComponent getArrowCountLabel(ItemStack used, ClientPlayerEntity player) {
        int count = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (!this.inventoryHelper.isArrows(stack)) continue;
            count += stack.func_190916_E();
        }
        ItemStack offhand = player.func_184582_a(EquipmentSlotType.OFFHAND);
        if (this.inventoryHelper.isArrows(offhand)) {
            count += offhand.func_190916_E();
        }
        return ArmorStatusCachedComponents.ARROW_COUNT.get(used.func_190916_E(), count);
    }
}

