/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.world.container;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import xaero.common.HudMod;
import xaero.common.file.SimpleBackup;
import xaero.common.minimap.waypoints.WaypointDimensionTypeInfo;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.minimap.waypoints.WaypointsSort;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointSession;
import xaero.hud.minimap.world.connection.MinimapWorldConnectionManager;
import xaero.hud.minimap.world.container.MinimapWorldContainer;
import xaero.hud.minimap.world.container.MinimapWorldContainerUtil;
import xaero.hud.minimap.world.container.config.RootConfig;
import xaero.hud.path.XaeroPath;

public class MinimapWorldRootContainer
extends WaypointWorldContainer {
    private final RootConfig config;
    private final Map<ResourceKey<Level>, WaypointDimensionTypeInfo> dimensionTypes;

    protected MinimapWorldRootContainer(HudMod modMain, MinimapSession session, XaeroPath path) {
        super(modMain, session, path, null);
        this.config = new RootConfig(MinimapWorldContainerUtil.isMultiplayer(path));
        this.dimensionTypes = new HashMap<ResourceKey<Level>, WaypointDimensionTypeInfo>();
    }

    public void updateConnectionsField(WaypointSession session) {
        this.config.resetSubWorldConnections(MinimapWorldContainerUtil.isMultiplayer(this.path));
    }

    public MinimapWorldConnectionManager getSubWorldConnections() {
        return this.config.getSubWorldConnections();
    }

    public WaypointDimensionTypeInfo getDimensionType(ResourceKey<Level> dimId) {
        WaypointDimensionTypeInfo dimensionType = this.dimensionTypes.get(dimId);
        if (dimensionType != null) {
            return dimensionType;
        }
        if (dimId == Level.f_46429_) {
            dimensionType = new WaypointDimensionTypeInfo(DimensionType.f_63841_.toString().replace(':', '$'), false, 0.1f, 256, 128, true, false, false, 0.5f, 8.0, false);
        } else if (dimId == Level.f_46428_) {
            dimensionType = new WaypointDimensionTypeInfo(DimensionType.f_63840_.toString().replace(':', '$'), true, 0.0f, 384, 384, false, true, false, 0.0f, 1.0, false);
        } else if (dimId == Level.f_46430_) {
            dimensionType = new WaypointDimensionTypeInfo(DimensionType.f_63842_.toString().replace(':', '$'), false, 0.0f, 256, 256, false, false, true, 0.0f, 1.0, true);
        } else {
            IntegratedServer integratedServer = Minecraft.m_91087_().m_91092_();
            if (integratedServer == null) {
                return null;
            }
            ServerLevel serverLevel = integratedServer.m_129880_(dimId);
            if (serverLevel == null) {
                return null;
            }
            dimensionType = this.getDimTypeInfo(serverLevel.m_6042_());
        }
        this.dimensionTypes.put(dimId, dimensionType);
        return dimensionType;
    }

    public double getDimensionScale(ResourceKey<Level> dimId) {
        WaypointDimensionTypeInfo dimType = this.getDimensionType(dimId);
        if (dimType == null) {
            return 1.0;
        }
        return dimType.getCoordinateScale();
    }

    public void updateDimensionType(ClientLevel level) {
        WaypointDimensionTypeInfo currentDimType;
        ResourceKey dimId = level.m_46472_();
        WaypointDimensionTypeInfo newDimType = this.getDimTypeInfo(level.m_6042_());
        if (Objects.equals(newDimType, currentDimType = this.dimensionTypes.get(dimId))) {
            return;
        }
        this.dimensionTypes.put((ResourceKey<Level>)dimId, newDimType);
        this.session.getWorldManagerIO().getRootConfigIO().save(this);
    }

    public void renameOldContainer(XaeroPath containerPath) {
        if (this.subContainers.isEmpty()) {
            return;
        }
        String dimensionPart = containerPath.getAtIndex(1).getLastNode();
        if (this.subContainers.containsKey(dimensionPart)) {
            return;
        }
        ResourceKey<Level> dimId = this.session.getDimensionHelper().getDimensionKeyForDirectoryName(dimensionPart);
        if (dimId == null) {
            return;
        }
        ResourceLocation dimKey = dimId.m_135782_();
        String dimKeyOldValidation = dimKey.m_135815_().replaceAll("[^a-zA-Z0-9_]+", "");
        XaeroPath customWorldPath = this.session.getWorldState().getCustomWorldPath();
        MinimapWorldContainer currentCustomContainer = customWorldPath == null ? null : this.session.getWorldManager().getWorld(customWorldPath).getContainer();
        for (Map.Entry subContainerEntry : this.subContainers.entrySet()) {
            String subKey = (String)subContainerEntry.getKey();
            if (!subKey.equals(dimKeyOldValidation)) continue;
            MinimapWorldContainer dimContainer = (MinimapWorldContainer)subContainerEntry.getValue();
            boolean currentlySelected = currentCustomContainer != null && currentCustomContainer.getPath().isSubOf(dimContainer.getPath());
            this.subContainers.put(dimensionPart, dimContainer);
            this.subContainers.remove(subKey);
            SimpleBackup.moveToBackup(dimContainer.getDirectoryPath());
            dimContainer.setPath(this.path.resolve(dimensionPart));
            if (currentlySelected) {
                this.session.getWorldState().setCustomWorldPath(dimContainer.getPath().resolve(customWorldPath.getSubPath(2)));
            }
            try {
                this.session.getWorldManagerIO().saveWorlds(this);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to rename a dimension! Can't continue.", e);
            }
            MinimapWorldConnectionManager connections = this.getSubWorldConnections();
            connections.renameDimension(subKey, dimensionPart);
            this.session.getWorldManagerIO().getRootConfigIO().save(this);
            return;
        }
    }

    public Iterable<Map.Entry<ResourceKey<Level>, WaypointDimensionTypeInfo>> getDimensionTypes() {
        return this.dimensionTypes.entrySet();
    }

    public void setDimensionType(ResourceKey<Level> dim, WaypointDimensionTypeInfo dimType) {
        this.dimensionTypes.put(dim, dimType);
    }

    @Override
    public MinimapWorldRootContainer getRoot() {
        return this;
    }

    public boolean isConfigLoaded() {
        return this.config.isLoaded();
    }

    public RootConfig getConfig() {
        return this.config;
    }

    @Deprecated
    public boolean isUsingMultiworldDetection() {
        return this.config.isUsingMultiworldDetection();
    }

    @Deprecated
    public void setUsingMultiworldDetection(boolean usingMultiworldDetection) {
        this.config.setUsingMultiworldDetection(usingMultiworldDetection);
    }

    @Deprecated
    public String getDefaultMultiworldId() {
        return this.config.getDefaultMultiworldId();
    }

    @Deprecated
    public void setDefaultMultiworldId(String defaultMultiworldId) {
        this.config.setDefaultMultiworldId(defaultMultiworldId);
    }

    @Deprecated
    public boolean isTeleportationEnabled() {
        return this.config.isTeleportationEnabled();
    }

    @Deprecated
    public void setTeleportationEnabled(boolean teleportation) {
        this.config.setTeleportationEnabled(teleportation);
    }

    @Deprecated
    public boolean isUsingDefaultTeleportCommand() {
        return this.config.isUsingDefaultTeleportCommand();
    }

    @Deprecated
    public void setUsingDefaultTeleportCommand(boolean usingDefaultTeleportCommand) {
        this.config.setUsingDefaultTeleportCommand(usingDefaultTeleportCommand);
    }

    @Deprecated
    public String getServerTeleportCommandFormat() {
        return this.config.getServerTeleportCommandFormat();
    }

    @Deprecated
    public String getServerTeleportCommandRotationFormat() {
        return this.config.getServerTeleportCommandRotationFormat();
    }

    @Deprecated
    public void setServerTeleportCommandFormat(String serverTeleportCommandFormat) {
        this.config.setServerTeleportCommandFormat(serverTeleportCommandFormat);
    }

    @Deprecated
    public void setServerTeleportCommandRotationFormat(String serverTeleportCommandRotationFormat) {
        this.config.setServerTeleportCommandRotationFormat(serverTeleportCommandRotationFormat);
    }

    @Deprecated
    public WaypointsSort getSortType() {
        return this.config.getSortType();
    }

    @Deprecated
    public void setSortType(WaypointsSort sortType) {
        this.config.setSortType(sortType);
    }

    @Deprecated
    public void toggleSortType() {
        this.config.toggleSortType();
    }

    @Deprecated
    public boolean isSortReversed() {
        return this.config.isSortReversed();
    }

    @Deprecated
    public void setSortReversed(boolean sortReversed) {
        this.config.setSortReversed(sortReversed);
    }

    @Deprecated
    public void toggleSortReversed() {
        this.config.toggleSortReversed();
    }

    @Deprecated
    public boolean isIgnoreServerLevelId() {
        return this.config.isIgnoreServerLevelId();
    }

    @Deprecated
    public void setIgnoreServerLevelId(boolean ignoreServerLevelId) {
        this.config.setIgnoreServerLevelId(ignoreServerLevelId);
    }

    @Deprecated
    public boolean isIgnoreHeightmaps() {
        return this.config.isIgnoreHeightmaps();
    }

    @Deprecated
    public void setIgnoreHeightmaps(boolean ignoreHeightmaps) {
        this.config.setIgnoreHeightmaps(ignoreHeightmaps);
    }

    private WaypointDimensionTypeInfo getDimTypeInfo(DimensionType dimType) {
        DimensionSpecialEffects effects = DimensionSpecialEffects.m_108876_((DimensionType)dimType);
        return new WaypointDimensionTypeInfo(dimType.m_63969_().toString().replace(':', '$'), dimType.m_63935_(), dimType.m_63902_(0), dimType.m_156733_(), dimType.m_63964_(), dimType.m_63969_().equals((Object)DimensionType.f_63841_), dimType.m_63969_().equals((Object)DimensionType.f_63840_), dimType.m_63969_().equals((Object)DimensionType.f_63842_), dimType.m_63904_(6000L), dimType.m_63959_(), effects.m_108884_());
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public String getName(String worldNode) {
        return super.getName(worldNode);
    }

    @Override
    public void removeName(String worldNode) {
        super.removeName(worldNode);
    }

    @Override
    public String getSubName() {
        return super.getSubName();
    }

    public static final class Builder {
        private HudMod modMain;
        private MinimapSession session;
        private XaeroPath path;

        private Builder() {
        }

        public Builder setDefault() {
            this.setModMain(null);
            this.setSession(null);
            this.setPath(null);
            return this;
        }

        public Builder setModMain(HudMod modMain) {
            this.modMain = modMain;
            return this;
        }

        public Builder setSession(MinimapSession session) {
            this.session = session;
            return this;
        }

        public Builder setPath(XaeroPath path) {
            this.path = path;
            return this;
        }

        public MinimapWorldRootContainer build() {
            if (this.modMain == null || this.session == null || this.path == null) {
                throw new IllegalStateException();
            }
            return new WaypointWorldRootContainer(this.modMain, this.session, this.path);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

