/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.tooltip;

import com.mojang.blaze3d.platform.Lighting;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.world.item.ItemStack;
import xaero.common.gui.GuiEditMode;
import xaero.hud.pvp.module.tooltip.ItemTooltipSession;
import xaero.hud.pvp.module.tooltip.TooltipScreenInstance;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;
import xaero.lib.common.reflection.util.ReflectionUtils;

public class ItemTooltipRenderer
implements IModuleRenderer<ItemTooltipSession> {
    public static final Method METHOD_renderTooltipInternal = ReflectionUtils.getMethodReflection(GuiGraphics.class, (String)"renderTooltipInternal", (String)"method_51435", (String)"(Lnet/minecraft/class_327;Ljava/util/List;IILnet/minecraft/class_8000;)V", (String)"m_280497_", (Class[])new Class[]{Font.class, List.class, Integer.TYPE, Integer.TYPE, ClientTooltipPositioner.class});

    @Override
    public void render(ItemTooltipSession session, ModuleRenderContext c, GuiGraphics guiGraphics, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack currentStack = mc.f_91074_.m_150109_().m_36056_();
        if (currentStack != session.getPreviousStack()) {
            session.setItemSwitchTime(System.currentTimeMillis());
            session.setPreviousStack(currentStack);
        }
        if (currentStack == null) {
            return;
        }
        if (currentStack.m_41619_()) {
            return;
        }
        if (!(mc.f_91080_ instanceof GuiEditMode) && System.currentTimeMillis() - session.getItemSwitchTime() > (long)((int)(session.getItemTooltipTime() * 1000.0))) {
            return;
        }
        TooltipScreenInstance screenInstance = session.getScreenInstance();
        screenInstance.setNecessaryFields(mc, session.isCentered(), c.flippedHorizontally, c.flippedVertically);
        screenInstance.f_96543_ = c.screenWidth;
        screenInstance.f_96544_ = c.screenHeight;
        List<ClientTooltipComponent> textLines = session.getTooltipHelper().getTooltipLines(mc, currentStack, c.screenWidth, c.screenHeight);
        if (textLines.size() >= session.getItemTooltipMinLines()) {
            int border = 5;
            int renderX = c.x + border;
            int renderY = c.y + border;
            int renderW = c.w - 2 * border;
            int renderH = c.h - 2 * border;
            if (session.isCentered()) {
                renderX += renderW / 2 - 3;
            } else if (c.flippedHorizontally) {
                renderX += renderW - 7;
            }
            if (c.flippedVertically) {
                renderY += renderH - 8;
            }
            int renderXWithOffset = renderX + 3;
            int renderYWithOffset = renderY + 4;
            ReflectionUtils.getReflectMethodValue((Object)guiGraphics, (Method)METHOD_renderTooltipInternal, (Object[])new Object[]{mc.f_91062_, textLines, renderXWithOffset, renderYWithOffset, screenInstance});
            Lighting.m_84931_();
        }
    }
}

