/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.notification;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import xaero.hud.pvp.module.notification.Notification;
import xaero.hud.pvp.module.notification.NotificationSession;
import xaero.hud.render.TextureLocations;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class NotificationRenderer
implements IModuleRenderer<NotificationSession> {
    @Override
    public void render(NotificationSession session, ModuleRenderContext c, GuiGraphics guiGraphics, float partialTicks) {
        boolean air;
        if (System.currentTimeMillis() - session.getLastBlink() > 500L) {
            session.setLastBlink(System.currentTimeMillis());
            session.setBlink(!session.getBlink());
        }
        Minecraft mc = Minecraft.getInstance();
        int total = 0;
        boolean lowHunger = session.getNotificationHunger() && (float)mc.player.getFoodData().getFoodLevel() <= 2.0f * (float)session.getLowHunger();
        boolean lowHealth = session.getNotificationHP() && mc.player.getHealth() <= 2.0f * (float)session.getLowHealth();
        boolean tnt = session.getNotificationTNT() && session.getWorldHelper().tntIsAround(mc.player);
        boolean arrow = session.getNotificationArrow() && session.getWorldHelper().arrowIsAround(mc.player);
        boolean bl = air = session.getNotificationAir() && mc.player.getAirSupply() <= 30 * session.getLowAir();
        if (lowHunger) {
            ++total;
        }
        if (lowHealth) {
            ++total;
        }
        if (tnt) {
            ++total;
        }
        if (arrow) {
            ++total;
        }
        if (air) {
            ++total;
        }
        if (total == 0) {
            return;
        }
        int between = 32 - 4 * total;
        int unitLength = 32 + between;
        int totalLength = total * unitLength;
        int drawY = c.y + (c.h - 32) / 2;
        int drawX = c.x + c.w / 2 - totalLength / 2 + between / 2;
        if (session.getBlink()) {
            RenderSystem.setShaderColor((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (lowHunger) {
            this.renderNotification(Notification.LOW_HUNGER, drawX, drawY, guiGraphics);
            drawX += unitLength;
        }
        if (lowHealth) {
            this.renderNotification(Notification.LOW_HEALTH, drawX, drawY, guiGraphics);
            drawX += unitLength;
        }
        if (tnt) {
            this.renderNotification(Notification.TNT, drawX, drawY, guiGraphics);
            drawX += unitLength;
        }
        if (arrow) {
            this.renderNotification(Notification.ARROW, drawX, drawY, guiGraphics);
            drawX += unitLength;
        }
        if (air) {
            this.renderNotification(Notification.AIR, drawX, drawY, guiGraphics);
            drawX += unitLength;
        }
        guiGraphics.flush();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderNotification(Notification notification, int drawX, int drawY, GuiGraphics guiGraphics) {
        guiGraphics.blit(TextureLocations.GUI_TEXTURES, drawX, drawY, 17, notification.getTextureIndex() * 32, notification.getTextureW(), 32);
    }
}

