/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import xaero.common.graphics.OpenGlHelper;
import xaero.common.icon.XaeroIconAtlas;
import xaero.lib.common.reflection.util.ReflectionUtils;

public class ImprovedFramebuffer
extends TextureTarget {
    private static Field MAIN_RENDER_TARGET_FIELD = ReflectionUtils.getFieldReflection(Minecraft.class, (String)"mainRenderTarget", (String)"field_1689", (String)"Lnet/minecraft/class_276;", (String)"f_91042_");
    private static RenderTarget mainRenderTargetBackup;
    private static GpuTextureView outputColorTextureOverrideBU;
    private static GpuTextureView outputDepthTextureOverrideBU;

    public ImprovedFramebuffer(int width, int height, boolean useDepthIn) {
        super(null, width, height, useDepthIn);
    }

    public void bindDefaultFramebuffer(Minecraft mc) {
        ImprovedFramebuffer.restoreMainRenderTarget();
    }

    public void bindRead() {
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)this.colorTextureView);
    }

    public void generateMipmaps() {
        OpenGlHelper.bindTexture(0, this.colorTexture);
        OpenGlHelper.generateMipmaps();
    }

    private void forceAsMainRenderTarget() {
        if (mainRenderTargetBackup == null) {
            mainRenderTargetBackup = (RenderTarget)ReflectionUtils.getReflectFieldValue((Object)Minecraft.getInstance(), (Field)MAIN_RENDER_TARGET_FIELD);
            outputColorTextureOverrideBU = RenderSystem.outputColorTextureOverride;
            outputDepthTextureOverrideBU = RenderSystem.outputDepthTextureOverride;
            RenderSystem.outputColorTextureOverride = null;
            RenderSystem.outputDepthTextureOverride = null;
        }
        ReflectionUtils.setReflectFieldValue((Object)Minecraft.getInstance(), (Field)MAIN_RENDER_TARGET_FIELD, (Object)((Object)this));
    }

    public static void restoreMainRenderTarget() {
        if (mainRenderTargetBackup != null) {
            ReflectionUtils.setReflectFieldValue((Object)Minecraft.getInstance(), (Field)MAIN_RENDER_TARGET_FIELD, (Object)mainRenderTargetBackup);
            if (RenderSystem.outputColorTextureOverride == null && RenderSystem.outputDepthTextureOverride == null) {
                RenderSystem.outputColorTextureOverride = outputColorTextureOverrideBU;
                RenderSystem.outputDepthTextureOverride = outputDepthTextureOverrideBU;
            }
            mainRenderTargetBackup = null;
            outputColorTextureOverrideBU = null;
            outputDepthTextureOverrideBU = null;
        }
    }

    public void bindAsMainTarget(boolean viewport) {
        this.forceAsMainRenderTarget();
    }

    public void setColorTexture(GpuTexture texture, GpuTextureView textureView) {
        this.colorTexture = texture;
        this.colorTextureView = textureView;
    }

    public void setColorTexture(XaeroIconAtlas atlas) {
        this.setColorTexture(atlas.getTextureId(), atlas.getTextureView());
    }

    public void setDepthTexture(GpuTexture depthTexture, GpuTextureView textureView) {
        this.depthTexture = depthTexture;
        this.depthTextureView = textureView;
    }

    public void closeColorTexture() {
        this.colorTextureView.close();
        this.colorTexture.close();
    }

    public void closeDepthTexture() {
        this.depthTextureView.close();
        this.depthTexture.close();
    }
}

