/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.render.MinimapPipRenderState;

public class MinimapPipRenderer<T extends MinimapPipRenderState>
extends PictureInPictureRenderer<T> {
    private final Class<T> stateClass;

    public MinimapPipRenderer(Class<T> stateClass, MultiBufferSource.BufferSource bufferSource) {
        super(bufferSource);
        this.stateClass = stateClass;
    }

    public Class<T> getRenderStateClass() {
        return this.stateClass;
    }

    public void prepare(T state, GuiRenderState guiRenderState, int guiScale) {
        if (((MinimapPipRenderState)state).prepared) {
            return;
        }
        ((MinimapPipRenderState)state).prepared = true;
        super.prepare(state, guiRenderState, guiScale);
    }

    protected void renderToTexture(T state, PoseStack poseStack) {
        MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession == null) {
            return;
        }
        int horizontalPadding = ((MinimapPipRenderState)state).getScaledHorizontalPadding();
        int verticalPadding = ((MinimapPipRenderState)state).getScaledVerticalPadding();
        minimapSession.getProcessor().onRender(horizontalPadding, verticalPadding, ((MinimapPipRenderState)state).getWidth(), ((MinimapPipRenderState)state).getHeight(), ((MinimapPipRenderState)state).getScale(), ((MinimapPipRenderState)state).getMinimapScale(), ((MinimapPipRenderState)state).getSize(), ((MinimapPipRenderState)state).getBoxSize(), ((MinimapPipRenderState)state).getPartial(), ((MinimapPipRenderState)state).getCvc(), ((MinimapPipRenderState)state).x1() - ((MinimapPipRenderState)state).x0(), ((MinimapPipRenderState)state).y1() - ((MinimapPipRenderState)state).y0());
    }

    protected String getTextureLabel() {
        return "minimap";
    }
}

