/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import java.nio.ByteBuffer;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class MinimapRendererHelper {
    public void drawMyTexturedModalRect(float x, float y, int textureX, int textureY, float width, float height, float factor) {
        this.drawMyTexturedModalRect(x, y, textureX, textureY, width, height, height, factor);
    }

    public void drawMyTexturedModalRect(float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        float f;
        float f1 = f = 1.0f / factor;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0.0f), (double)(y + height), 0.0, (double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)(((float)textureX + width) * f), (double)((float)(textureY + 0) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + 0.0f), 0.0, (double)(((float)textureX + width) * f), (double)(((float)textureY + theight) * f1));
        tessellator.func_78374_a((double)(x + 0.0f), (double)(y + 0.0f), 0.0, (double)((float)(textureX + 0) * f), (double)(((float)textureY + theight) * f1));
        tessellator.func_78381_a();
    }

    void drawTexturedElipseInsideRectangle(int sides, float x, float y, int textureX, int textureY, float width, float widthFactor) {
        this.drawTexturedElipseInsideRectangle(sides, x, y, textureX, textureY, width, width, widthFactor);
    }

    void drawTexturedElipseInsideRectangle(int sides, float x, float y, int textureX, int textureY, float width, float theight, float widthFactor) {
        float f;
        float f1 = f = 1.0f / widthFactor;
        Tessellator tessellator = Tessellator.field_78398_a;
        float halfWidth = width / 2.0f;
        double centerX = x + halfWidth;
        double centerY = y + halfWidth;
        float centerU = ((float)textureX + halfWidth) * f;
        float centerV = (float)(((double)textureY + (double)theight * 0.5) * (double)f1);
        double fullCircle = Math.PI * 2;
        float prevVertexLocalX = 0.0f;
        float prevVertexLocalY = 0.0f;
        float prevVertexLocalV = 0.0f;
        tessellator.func_78371_b(4);
        for (int i = 0; i <= sides; ++i) {
            double angle = (double)i / (double)sides * fullCircle;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            float vertexLocalX = halfWidth + (float)((double)halfWidth * sin);
            float vertexLocalY = (float)((double)halfWidth * (1.0 - cos));
            float vertexLocalV = (float)((double)theight * (1.0 - 0.5 * (1.0 - cos)));
            if (i > 0) {
                tessellator.func_78374_a((double)(x + vertexLocalX), (double)(y + vertexLocalY), 0.0, (double)(((float)textureX + vertexLocalX) * f), (double)(((float)textureY + vertexLocalV) * f1));
                tessellator.func_78374_a((double)(x + prevVertexLocalX), (double)(y + prevVertexLocalY), 0.0, (double)(((float)textureX + prevVertexLocalX) * f), (double)(((float)textureY + prevVertexLocalV) * f1));
                tessellator.func_78374_a(centerX, centerY, 0.0, (double)centerU, (double)centerV);
            }
            prevVertexLocalX = vertexLocalX;
            prevVertexLocalY = vertexLocalY;
            prevVertexLocalV = vertexLocalV;
        }
        tessellator.func_78381_a();
    }

    void drawTexturedElipseInsideRectangleFrame(int sides, float thickness, float x, float y, int textureX, int textureY, float width, float theight, float widthFactor) {
        float f;
        float f1 = f = 1.0f / widthFactor;
        Tessellator tessellator = Tessellator.field_78398_a;
        float halfWidth = width / 2.0f;
        double fullCircle = Math.PI * 2;
        float prevVertexLocalX = 0.0f;
        float prevVertexLocalY = 0.0f;
        float prevVertexLocalOuterX = 0.0f;
        float prevVertexLocalOuterY = 0.0f;
        tessellator.func_78371_b(7);
        float sectionOuterWidth = (float)(fullCircle / (double)sides * (double)(halfWidth + thickness));
        float sectionInnerWidth = (float)(fullCircle / (double)sides * (double)halfWidth);
        for (int i = 0; i <= sides; ++i) {
            double angle = (double)i / (double)sides * fullCircle;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            float vertexLocalX = halfWidth + (float)((double)halfWidth * sin);
            float vertexLocalY = (float)((double)halfWidth * (1.0 - cos));
            float vertexLocalOuterX = halfWidth + (float)((double)(halfWidth + thickness) * sin);
            float vertexLocalOuterY = (float)((double)halfWidth - (double)(halfWidth + thickness) * cos);
            if (i > 0) {
                tessellator.func_78374_a((double)(x + prevVertexLocalX), (double)(y + prevVertexLocalY), 0.0, (double)((float)textureX * f), (double)(((float)textureY + theight) * f1));
                tessellator.func_78374_a((double)(x + vertexLocalX), (double)(y + vertexLocalY), 0.0, (double)(((float)textureX + sectionInnerWidth) * f), (double)(((float)textureY + theight) * f1));
                tessellator.func_78374_a((double)(x + vertexLocalOuterX), (double)(y + vertexLocalOuterY), 0.0, (double)(((float)textureX + sectionOuterWidth) * f), (double)((float)textureY * f1));
                tessellator.func_78374_a((double)(x + prevVertexLocalOuterX), (double)(y + prevVertexLocalOuterY), 0.0, (double)((float)textureX * f), (double)((float)textureY * f1));
            }
            prevVertexLocalX = vertexLocalX;
            prevVertexLocalY = vertexLocalY;
            prevVertexLocalOuterX = vertexLocalOuterX;
            prevVertexLocalOuterY = vertexLocalOuterY;
        }
        tessellator.func_78381_a();
    }

    public void drawMyColoredRect(float x1, float y1, float x2, float y2) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)x1, (double)y2, 0.0);
        tessellator.func_78377_a((double)x2, (double)y2, 0.0);
        tessellator.func_78377_a((double)x2, (double)y1, 0.0);
        tessellator.func_78377_a((double)x1, (double)y1, 0.0);
        tessellator.func_78381_a();
    }

    public void drawRect1710(int p_73734_0_, int p_73734_1_, int p_73734_2_, int p_73734_3_, int p_73734_4_) {
        int j1;
        if (p_73734_0_ < p_73734_2_) {
            j1 = p_73734_0_;
            p_73734_0_ = p_73734_2_;
            p_73734_2_ = j1;
        }
        if (p_73734_1_ < p_73734_3_) {
            j1 = p_73734_1_;
            p_73734_1_ = p_73734_3_;
            p_73734_3_ = j1;
        }
        float f3 = (float)(p_73734_4_ >> 24 & 0xFF) / 255.0f;
        float f = (float)(p_73734_4_ >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(p_73734_4_ >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(p_73734_4_ & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)f, (float)f1, (float)f2, (float)f3);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)p_73734_0_, (double)p_73734_3_, 0.0);
        tessellator.func_78377_a((double)p_73734_2_, (double)p_73734_3_, 0.0);
        tessellator.func_78377_a((double)p_73734_2_, (double)p_73734_1_, 0.0);
        tessellator.func_78377_a((double)p_73734_0_, (double)p_73734_1_, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public void drawColoredLine(float x1, float y1, float x2, float y2) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(1);
        tessellator.func_78377_a((double)x1, (double)y1, 0.0);
        tessellator.func_78377_a((double)x2, (double)y2, 0.0);
        tessellator.func_78381_a();
    }

    public void drawMyColoredRect(float x1, float y1, float x2, float y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)x1, (double)y2, 0.0);
        tessellator.func_78377_a((double)x2, (double)y2, 0.0);
        tessellator.func_78377_a((double)x2, (double)y1, 0.0);
        tessellator.func_78377_a((double)x1, (double)y1, 0.0);
        tessellator.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    void bindTextureBuffer(ByteBuffer image, int width, int height, int par0) {
        GL11.glBindTexture((int)3553, (int)par0);
        GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)width, (int)height, (int)0, (int)6407, (int)5121, (ByteBuffer)image);
    }

    void putColor(byte[] bytes, int x, int y, int red, int green, int blue, int size) {
        int pixel = (y * size + x) * 3;
        bytes[pixel] = (byte)red;
        bytes[++pixel] = (byte)green;
        bytes[++pixel] = (byte)blue;
    }

    void gridOverlay(int[] result, int grid, int red, int green, int blue) {
        result[0] = (red * 3 + (grid >> 16 & 0xFF)) / 4;
        result[1] = (green * 3 + (grid >> 8 & 0xFF)) / 4;
        result[2] = (blue * 3 + (grid & 0xFF)) / 4;
    }

    void slimeOverlay(int[] result, int red, int green, int blue) {
        result[0] = (red + 82) / 2;
        result[1] = (green + 241) / 2;
        result[2] = (blue + 64) / 2;
    }

    public void defaultOrtho() {
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)512.0, (double)512.0, (double)0.0, (double)1000.0, (double)3000.0);
    }
}

