/*
 * Decompiled with CFR 0.152.
 */
package xaero.pvp.interfaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiEditMode;
import xaero.common.interfaces.IInterfaceLoader;
import xaero.common.interfaces.Interface;
import xaero.common.interfaces.InterfaceInstance;
import xaero.common.interfaces.InterfaceManager;
import xaero.common.interfaces.Preset;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.pvp.BetterPVP;
import xaero.pvp.interfaces.BPVPInterfaceHandler;
import xaero.pvp.notifications.Notification;
import xaero.pvp.notifications.NotificationHandler;
import xaero.pvp.settings.BPVPModSettings;

public class BPVPInterfaceLoader
implements IInterfaceLoader {
    private BetterPVP modMain;
    private Minecraft mc = Minecraft.func_71410_x();
    private RenderItem itemRenderer = new RenderItem();
    public static Random rand = new Random();
    public static long arrowWas = 0L;

    public BPVPInterfaceLoader(BetterPVP modMain) {
        this.modMain = modMain;
    }

    @Override
    public void loadPresets(InterfaceManager interfaces) {
        interfaces.addPreset(new Preset("gui.xaero_preset_fancy", new int[][]{{0, 0}, {0, 0}, {0, 0}, {0, 36}, {0, 0}, {0, 0}, {0, 128}}, new boolean[][]{{true, false, false}, {true, false, true}, {true, false, true}, {true, false, false}, {false, true, false}, {false, false, false}, {false, true, true}}));
        interfaces.addPreset(new Preset("gui.xaero_preset_classic", new int[][]{{0, 0}, {0, 10000}, {0, 10000}, {0, 0}, {0, 0}, {0, 10000}, {0, 186}}, new boolean[][]{{false, true, false}, {false, true, false}, {true, false, false}, {true, false, false}, {false, false, false}, {false, false, false}, {false, true, true}}));
        interfaces.addPreset(new Preset("gui.xaero_preset_social", new int[][]{{0, 0}, {0, 0}, {0, 10000}, {0, 41}, {0, 0}, {0, 10000}, {0, 78}}, new boolean[][]{{true, false, false}, {true, false, false}, {true, false, false}, {true, false, false}, {false, false, false}, {false, false, false}, {false, true, false}}));
    }

    @Override
    public void load(IXaeroMinimap main, InterfaceManager interfaces) {
        interfaces.add(new Interface(interfaces, "gui.xaero_potion_status", interfaces.getNextId(), 120, 165, 182, 36, ModOptions.SHOW_EFFECTS){

            @Override
            public InterfaceInstance createInterfaceInstance(XaeroMinimapSession minimapSession) {
                return new InterfaceInstance(this){

                    @Override
                    public void render(int width, int height, double scale, float partial) {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glEnable((int)3008);
                        if (!((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.func_70651_bq().isEmpty()) {
                            BPVPInterfaceLoader.this.displayDebuffEffects(this.inter, width, height);
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        }
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        super.render(width, height, scale, partial);
                    }
                };
            }
        });
        interfaces.add(new Interface(interfaces, "gui.xaero_armour_status", interfaces.getNextId(), 150, 98, 400, 41, ModOptions.SHOW_ARMOR){

            @Override
            public InterfaceInstance createInterfaceInstance(XaeroMinimapSession minimapSession) {
                return new InterfaceInstance(this){

                    @Override
                    public void render(int width, int height, double scale, float partial) {
                        GL11.glEnable((int)3008);
                        GL11.glEnable((int)2929);
                        if (!this.isCentered()) {
                            BPVPInterfaceLoader.this.drawClassicArmour(this.getX(), this.getY(), this.getW(scale), this.getH(scale), width, height, this.shouldFlip(width));
                        } else {
                            BPVPInterfaceLoader.this.drawCenteredArmour(this.getX(), this.getY(), this.getW(scale), this.getH(scale), width, height);
                        }
                        RenderHelper.func_74518_a();
                        GL11.glDisable((int)2929);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        super.render(width, height, scale, partial);
                    }
                };
            }
        });
        interfaces.add(new Interface(interfaces, "gui.xaero_xp_setting", interfaces.getNextId(), 50, 86, ModOptions.XP){

            @Override
            public InterfaceInstance createInterfaceInstance(XaeroMinimapSession minimapSession) {
                return new InterfaceInstance(this){
                    private NotificationHandler nh;
                    private int lastXPCheck;
                    public long xpDelay;
                    {
                        this.nh = new NotificationHandler();
                        this.lastXPCheck = 0;
                        this.xpDelay = 0L;
                    }

                    @Override
                    public void render(int width, int height, double scale, float partial) {
                        EntityClientPlayerMP player = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g;
                        if (System.currentTimeMillis() - this.xpDelay >= 1000L) {
                            this.xpDelay = System.currentTimeMillis();
                            int totalXP = player.field_71067_cb;
                            if (this.lastXPCheck != totalXP) {
                                String xp = (totalXP - this.lastXPCheck > 0 ? "\u00a7e+" : "\u00a7e") + (totalXP - this.lastXPCheck) + " XP";
                                this.nh.notifications.add(new Notification(xp, 5000, this.getX() + this.getW(scale) / 2 - ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71466_p.func_78256_a(xp) / 2, this.getY() + 39));
                                this.lastXPCheck = totalXP;
                            }
                        }
                        this.nh.drawNotifications();
                        super.render(width, height, scale, partial);
                    }
                };
            }
        });
        interfaces.add(new Interface(interfaces, "gui.xaero_notifications", interfaces.getNextId(), 200, 42, ModOptions.NOTIFICATIONS){

            @Override
            public InterfaceInstance createInterfaceInstance(XaeroMinimapSession minimapSession) {
                return new InterfaceInstance(this){

                    @Override
                    public void render(int width, int height, double scale, float partial) {
                        ArrayList<Integer> notifications = new ArrayList<Integer>();
                        if ((float)((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.func_71024_bL().func_75116_a() <= (float)(2 * ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().lowHunger) && BPVPInterfaceLoader.this.modMain.getBPVPSettings().getNotificationHunger()) {
                            notifications.add(0);
                        }
                        if (((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.func_110143_aJ() <= (float)(2 * ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().lowHealth) && BPVPInterfaceLoader.this.modMain.getBPVPSettings().getNotificationHP()) {
                            notifications.add(1);
                        }
                        if (BPVPInterfaceLoader.this.tntIsAround() && BPVPInterfaceLoader.this.modMain.getBPVPSettings().getNotificationTNT()) {
                            notifications.add(2);
                        }
                        if (BPVPInterfaceLoader.this.arrowIsAround() && BPVPInterfaceLoader.this.modMain.getBPVPSettings().getNotificationArrow()) {
                            notifications.add(3);
                        }
                        if (((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.func_70086_ai() <= 30 * ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().lowAir && BPVPInterfaceLoader.this.modMain.getBPVPSettings().getNotificationAir()) {
                            notifications.add(4);
                        }
                        int between = 32 - 4 * notifications.size();
                        int unitSize = 32 + between;
                        int length = notifications.size() * unitSize;
                        int drawY = this.getY() + (this.getH(scale) - 32) / 2;
                        GL11.glEnable((int)3008);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        if (length > 0) {
                            BPVPInterfaceLoader.this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
                            if (BPVPInterfaceHandler.blinking) {
                                GL11.glColor4f((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
                            }
                            for (int i = 0; i < notifications.size(); ++i) {
                                int n = (Integer)notifications.get(i);
                                int drawX = this.getX() + this.getW(scale) / 2 - length / 2 + i * unitSize + between / 2;
                                ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71456_v.func_73729_b(drawX, drawY, 17, n * 32, 32, 32);
                            }
                            BPVPInterfaceLoader.this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                        }
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        super.render(width, height, scale, partial);
                    }
                };
            }
        });
        interfaces.add(new MinimapInterface(this.modMain, interfaces.getNextId(), interfaces));
        interfaces.add(new Interface(interfaces, "gui.xaero_entity_info", interfaces.getNextId(), 148, 70, ModOptions.ENTITY_INFO){

            @Override
            public InterfaceInstance createInterfaceInstance(XaeroMinimapSession minimapSession) {
                return new InterfaceInstance(this){
                    EntityLivingBase e;
                    long lastFind;
                    {
                        this.e = null;
                        this.lastFind = 0L;
                    }

                    @Override
                    public void render(int width, int height, double scale, float partial) {
                        long time = System.currentTimeMillis();
                        MovingObjectPosition objectMouseOver = BPVPInterfaceLoader.this.getMouseOver((World)((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71441_e, ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoDistance, partial);
                        EntityClientPlayerMP playerEntity = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g;
                        if (objectMouseOver != null && objectMouseOver.field_72308_g != null && objectMouseOver.field_72308_g instanceof EntityLivingBase) {
                            EntityPlayer serverPlayerEntity;
                            WorldServer serverWorld;
                            this.e = (EntityLivingBase)objectMouseOver.field_72308_g;
                            if (BPVPInterfaceLoader.this.mc.func_71401_C() != null && (serverWorld = DimensionManager.getWorld((int)((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71441_e.field_73011_w.field_76574_g)) != null && (serverPlayerEntity = serverWorld.func_152378_a(((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.func_110124_au())) != null) {
                                playerEntity = serverPlayerEntity;
                                this.e = (EntityLivingBase)serverWorld.func_73045_a(this.e.func_145782_y());
                            }
                            this.lastFind = time;
                        }
                        if (this.e != null && !this.e.func_98034_c((EntityPlayer)playerEntity) && time - this.lastFind <= (long)(1000 * ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoStay)) {
                            try {
                                int healthOff;
                                boolean vertFlipped = this.getY() + this.getH(scale) / 2 > height / 2;
                                boolean flip = this.shouldFlip(width);
                                float resize = 1.0f;
                                if (this.e.field_70130_N > resize) {
                                    resize = this.e.field_70130_N;
                                }
                                if (this.e.field_70131_O > resize * 2.0f) {
                                    resize = this.e.field_70131_O / 2.0f;
                                }
                                int n = healthOff = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoShowEntityModel ? 55 : 5;
                                if (BPVPInterfaceLoader.this.mc.func_71401_C() != null && ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoEffects) {
                                    int effectsOffset = (int)BPVPInterfaceLoader.this.drawPotionEffects(this.e, this.getX() + (flip ? this.getW(scale) - 3 : 3), this.getY() + (vertFlipped ? this.getH(scale) - 5 : 5), vertFlipped ? this.getY() + this.getH(scale) : height - this.getY(), flip, vertFlipped, (int)scale);
                                    if (healthOff == 5 && effectsOffset != -1) {
                                        healthOff = 8 + effectsOffset;
                                    }
                                }
                                boolean armourDrawn = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoShowArmour && BPVPInterfaceLoader.this.drawArmourBar(this.e, this.getX() + (flip ? this.getW(scale) - healthOff : healthOff), this.getY() + 15 + (vertFlipped ? 31 : 0), flip, vertFlipped);
                                BPVPInterfaceLoader.this.drawHealthBar(this.e, this.getX() + (flip ? this.getW(scale) - healthOff : healthOff), this.getY() + 15 + (vertFlipped ? 31 : 0) + (armourDrawn ? 10 : 0) * (vertFlipped ? -1 : 1), flip, vertFlipped);
                                if (((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoShowEntityModel) {
                                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-500.0f);
                                    GL11.glEnable((int)2929);
                                    BPVPInterfaceLoader.this.drawEntityOnScreen(this.getX() + (flip ? this.getW(scale) - 25 : 25), this.getY() + 35, (int)(30.0f / resize), this.e, flip);
                                    GL11.glDisable((int)2929);
                                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)500.0f);
                                }
                                String name = this.e.func_70005_c_();
                                int xCoord = this.getX() + (flip ? this.getW(scale) - healthOff - ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71466_p.func_78256_a(name) : healthOff);
                                ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71466_p.func_78261_a(name, xCoord, this.getY() + 5 + (vertFlipped ? 52 : 0), 0xFFFFFF);
                            }
                            catch (Exception e) {
                                System.out.println("Please report this to Xaero96 on PlanetMinecraft/MinecraftForums!!!");
                                e.printStackTrace();
                            }
                        }
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        super.render(width, height, scale, partial);
                    }
                };
            }
        });
        interfaces.add(new Interface(interfaces, "gui.xaero_item_tooltip", interfaces.getNextId(), 150, 50, ModOptions.ITEM_TOOLTIP){

            @Override
            public InterfaceInstance createInterfaceInstance(XaeroMinimapSession minimapSession) {
                return new InterfaceInstance(this){
                    private GuiScreenAccess screenInstance;
                    private ItemStack previousStack;
                    private long itemSwitchTime;
                    {
                        this.screenInstance = new GuiScreenAccess();
                    }

                    @Override
                    public void render(int width, int height, double scale, float partial) {
                        ItemStack currentStack = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.field_71071_by.func_70448_g();
                        if (currentStack != this.previousStack) {
                            this.itemSwitchTime = System.currentTimeMillis();
                            this.previousStack = currentStack;
                        }
                        if (currentStack != null && (((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71462_r instanceof GuiEditMode || System.currentTimeMillis() - this.itemSwitchTime <= (long)(BPVPInterfaceLoader.this.modMain.getBPVPSettings().getItemTooltipTime() * 1000 / 2))) {
                            List textLines = currentStack.func_82840_a((EntityPlayer)((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g, ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71474_y.field_82882_x);
                            for (int i = 0; i < textLines.size(); ++i) {
                                if (i == 0) {
                                    textLines.set(i, currentStack.func_77953_t().field_77937_e + (String)textLines.get(i));
                                    continue;
                                }
                                textLines.set(i, EnumChatFormatting.GRAY + (String)textLines.get(i));
                            }
                            if (textLines.size() >= BPVPInterfaceLoader.this.modMain.getBPVPSettings().getItemTooltipMinLines()) {
                                int border = 5;
                                int renderX = this.getX() + border;
                                int renderY = this.getY() + border;
                                int renderW = this.getW(scale) - 2 * border;
                                int renderH = this.getH(scale) - 2 * border;
                                int screenWidth = width;
                                int screenHeight = height;
                                if (this.isCentered() || this.isFromRight() && !this.isFlipped() || !this.isFromRight() && this.isFlipped()) {
                                    int tooltipTextWidth = 0;
                                    for (String textLine : textLines) {
                                        int textLineWidth = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71466_p.func_78256_a(textLine);
                                        if (textLineWidth <= tooltipTextWidth) continue;
                                        tooltipTextWidth = textLineWidth;
                                    }
                                    int tooltipWidth = tooltipTextWidth + 8;
                                    if (this.isCentered()) {
                                        renderX += (renderW - tooltipWidth) / 2;
                                    } else {
                                        screenWidth = renderX + renderW;
                                        renderX += renderW - tooltipWidth;
                                    }
                                }
                                if (this.isFromBottom()) {
                                    int tooltipHeight = 16;
                                    if (textLines.size() > 1) {
                                        tooltipHeight += 2 + (textLines.size() - 1) * 10;
                                    }
                                    screenHeight = renderY + renderH + 2;
                                    renderY += renderH - tooltipHeight;
                                }
                                this.screenInstance.func_146280_a(BPVPInterfaceLoader.this.mc, screenWidth, screenHeight);
                                this.screenInstance.drawHoveringText(textLines, renderX - 8, renderY + 16, ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71466_p);
                                RenderHelper.func_74518_a();
                            }
                        }
                        super.render(width, height, scale, partial);
                    }
                };
            }
        });
    }

    public Vec3 getPositionEyes(Entity e, float p_174824_1_) {
        if (p_174824_1_ == 1.0f) {
            return Vec3.func_72443_a((double)e.field_70165_t, (double)(e.field_70163_u + (double)e.func_70047_e()), (double)e.field_70161_v);
        }
        double d0 = e.field_70169_q + (e.field_70165_t - e.field_70169_q) * (double)p_174824_1_;
        double d1 = e.field_70167_r + (e.field_70163_u - e.field_70167_r) * (double)p_174824_1_ + (double)e.func_70047_e();
        double d2 = e.field_70166_s + (e.field_70161_v - e.field_70166_s) * (double)p_174824_1_;
        return Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
    }

    public MovingObjectPosition getMouseOver(World world, double reach, float p_78473_1_) {
        EntityClientPlayerMP entity = this.mc.field_71439_g;
        if (entity != null && entity.field_70121_D != null && world != null) {
            List list;
            MovingObjectPosition objectMouseOver = entity.func_70614_a(reach, p_78473_1_);
            Vec3 playerEyes = this.getPositionEyes((Entity)entity, p_78473_1_);
            double d2 = reach;
            if (objectMouseOver != null) {
                d2 = objectMouseOver.field_72307_f.func_72438_d(playerEyes);
            }
            Vec3 lookVector = entity.func_70676_i(p_78473_1_);
            Vec3 farthestPoint = playerEyes.func_72441_c(lookVector.field_72450_a * d2, lookVector.field_72448_b * d2, lookVector.field_72449_c * d2);
            Entity pointedEntity = null;
            Vec3 entityHitPoint = null;
            float f1 = 1.0f;
            try {
                list = world.func_72839_b((Entity)entity, entity.field_70121_D.func_72321_a(lookVector.field_72450_a * d2, lookVector.field_72448_b * d2, lookVector.field_72449_c * d2).func_72314_b((double)f1, (double)f1, (double)f1));
            }
            catch (IndexOutOfBoundsException ioobe) {
                return null;
            }
            for (int i = 0; i < list.size(); ++i) {
                double d3;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L() || entity1.func_145782_y() == entity.func_145782_y()) continue;
                float f2 = entity1.func_70111_Y();
                AxisAlignedBB axisalignedbb = entity1.field_70121_D.func_72314_b((double)f2, (double)f2, (double)f2);
                MovingObjectPosition movingobjectposition = axisalignedbb.func_72327_a(playerEyes, farthestPoint);
                if (axisalignedbb.func_72318_a(playerEyes)) {
                    if (!(d2 >= 0.0)) continue;
                    pointedEntity = entity1;
                    entityHitPoint = movingobjectposition == null ? playerEyes : movingobjectposition.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (movingobjectposition == null || !((d3 = playerEyes.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity1 == entity.field_70154_o && !entity.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    pointedEntity = entity1;
                    entityHitPoint = movingobjectposition.field_72307_f;
                    continue;
                }
                pointedEntity = entity1;
                entityHitPoint = movingobjectposition.field_72307_f;
                d2 = d3;
            }
            if (pointedEntity != null && (d2 < reach || objectMouseOver == null)) {
                objectMouseOver = new MovingObjectPosition(pointedEntity, entityHitPoint);
            }
            return objectMouseOver;
        }
        return null;
    }

    public double drawPotionEffects(EntityLivingBase e, int x, int y, int h, boolean flip, boolean vertFlipped, int scale) {
        ArrayList effects = new ArrayList(e.func_70651_bq());
        if (effects.isEmpty()) {
            return -1.0;
        }
        int place = 0;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glEnable((int)3042);
        double pixelSize = (double)this.modMain.getBPVPSettings().entityInfoEffectsScale / (double)scale * (double)this.modMain.getBPVPSettings().getAutoMinimapScale() / 2.0;
        double effectSize = 25.0 * pixelSize;
        int perColumn = (int)((double)h / effectSize);
        for (PotionEffect pe : effects) {
            Potion p;
            GL11.glPushMatrix();
            GL11.glScaled((double)pixelSize, (double)pixelSize, (double)1.0);
            int column = place / perColumn;
            int row = place % perColumn;
            GL11.glTranslated((double)(flip ? (double)(-18 - 25 * column) : (double)(25 * column)), (double)(vertFlipped ? (double)(-18 - 25 * row) : (double)(25 * row)), (double)0.0);
            if (pe == null || (p = Potion.field_76425_a[pe.func_76456_a()]) == null) continue;
            if (p.func_76400_d()) {
                this.mc.func_110434_K().func_110577_a(BPVPInterfaceHandler.invtextures);
                int iconIndex = p.func_76392_e();
                if (pe.func_76459_b() <= 200 && !BPVPInterfaceHandler.blinking) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
                }
                this.mc.field_71456_v.func_73729_b(0, 0, 0 + iconIndex % 8 * 18, 198 + iconIndex / 8 * 18, 18, 18);
            }
            p.renderInventoryEffect(-6, -7, pe, this.mc);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ++place;
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        return effectSize * (double)(1 + effects.size() / perColumn) - 7.0 * pixelSize;
    }

    public boolean drawArmourBar(EntityLivingBase e, int x, int y, boolean flip, boolean vertFlipped) {
        this.mc.func_110434_K().func_110577_a(GuiIngame.field_110324_m);
        int k2 = e.func_70658_aO();
        if (k2 > 0) {
            if (this.modMain.getBPVPSettings().entityInfoArmourNumbers) {
                this.mc.field_71456_v.func_73729_b(x - (flip ? 8 : 0), y, 34, 9, 9, 9);
                this.mc.field_71466_p.func_78261_a(k2 + "/20", x + (flip ? -11 - this.mc.field_71466_p.func_78256_a(k2 + "/20") : 11), y, 0xFFFFFF);
            } else {
                for (int i3 = 0; i3 < 10; ++i3) {
                    int j3 = x + (flip ? -8 - i3 * 8 : i3 * 8);
                    if (i3 * 2 + 1 < k2) {
                        this.mc.field_71456_v.func_73729_b(j3, y, 34, 9, 9, 9);
                    }
                    if (i3 * 2 + 1 == k2) {
                        this.mc.field_71456_v.func_73729_b(j3, y, 25, 9, 9, 9);
                    }
                    if (i3 * 2 + 1 <= k2) continue;
                    this.mc.field_71456_v.func_73729_b(j3, y, 16, 9, 9, 9);
                }
            }
            return true;
        }
        return false;
    }

    public void drawHealthBar(EntityLivingBase e, int x, int y, boolean flip, boolean vertFlipped) {
        int health = MathHelper.func_76123_f((float)e.func_110143_aJ());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float maxHealth = MathHelper.func_76143_f((double)e.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e());
        float absorptionAmount = MathHelper.func_76123_f((float)e.func_110139_bj());
        if (this.modMain.getBPVPSettings().entityInfoHealthNumbers) {
            String text = health + "/" + (int)maxHealth;
            if (absorptionAmount > 0.0f) {
                text = text + "+" + absorptionAmount;
                health = 0;
                maxHealth = 0.0f;
                absorptionAmount = 2.0f;
            } else {
                health = 2;
                maxHealth = 2.0f;
                absorptionAmount = 0.0f;
            }
            this.mc.field_71466_p.func_78261_a(text, x + (flip ? -11 - this.mc.field_71466_p.func_78256_a(text) : 11), y, 0xFFFFFF);
        }
        this.mc.func_110434_K().func_110577_a(GuiIngame.field_110324_m);
        int regularHalvesToRender = (int)(maxHealth + 1.0f) / 2 * 2;
        int regularFilledHalves = health;
        int absorptionHalvesToRender = (int)(absorptionAmount + 1.0f) / 2 * 2;
        int absorptionFilledHalves = (int)absorptionAmount;
        int limit = this.modMain.getBPVPSettings().entityInfoMaxHearts * 2;
        if (regularHalvesToRender > limit) {
            regularHalvesToRender = limit;
            int n = regularFilledHalves = maxHealth == 0.0f ? 0 : Math.round((float)(health * regularHalvesToRender) / maxHealth);
        }
        if (absorptionHalvesToRender > limit) {
            absorptionHalvesToRender = absorptionFilledHalves = limit;
        }
        int totalHalvesToRender = regularHalvesToRender + absorptionHalvesToRender;
        int rows = MathHelper.func_76123_f((float)((float)totalHalvesToRender / 20.0f));
        int rowStep = Math.max(10 - (rows - 2), 3);
        boolean shake = maxHealth != 0.0f && (double)health <= (double)maxHealth * 0.4;
        int absorptionLeft = absorptionFilledHalves;
        for (int heartIndex = totalHalvesToRender / 2 - 1; heartIndex >= 0; --heartIndex) {
            int rowIndex = (int)Math.ceil((float)(heartIndex + 1) / 10.0f) - 1;
            int xcoord = heartIndex % 10 * 8;
            int heartX = x + (flip ? -xcoord - 9 : xcoord);
            int heartY = y + rowIndex * rowStep * (vertFlipped ? -1 : 1);
            if (shake) {
                heartY += rand.nextInt(2);
            }
            if (heartIndex == -1) {
                heartY -= 2;
            }
            int uScale = 0;
            this.drawMyTexturedModalRect(heartX, heartY, 25, 9 * uScale, 9, 9, flip);
            if (absorptionLeft > 0) {
                if (absorptionLeft == absorptionFilledHalves && absorptionFilledHalves % 2 == 1) {
                    this.drawMyTexturedModalRect(heartX, heartY, 169, 9 * uScale, 9, 9, flip);
                } else {
                    this.drawMyTexturedModalRect(heartX, heartY, 160, 9 * uScale, 9, 9, flip);
                }
                absorptionLeft -= 2;
                continue;
            }
            if (heartIndex * 2 + 1 < regularFilledHalves) {
                this.drawMyTexturedModalRect(heartX, heartY, 52, 9 * uScale, 9, 9, flip);
            }
            if (heartIndex * 2 + 1 != regularFilledHalves) continue;
            this.drawMyTexturedModalRect(heartX, heartY, 61, 9 * uScale, 9, 9, flip);
        }
    }

    public void drawMyTexturedModalRect(int p_73729_1_, int p_73729_2_, int p_73729_3_, int p_73729_4_, int p_73729_5_, int p_73729_6_, boolean flip) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(p_73729_1_ + 0), (double)(p_73729_2_ + p_73729_6_), 0.0, (double)((float)(p_73729_3_ + (flip ? p_73729_5_ : 0)) * f), (double)((float)(p_73729_4_ + p_73729_6_) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + p_73729_5_), (double)(p_73729_2_ + p_73729_6_), 0.0, (double)((float)(p_73729_3_ + (flip ? 0 : p_73729_5_)) * f), (double)((float)(p_73729_4_ + p_73729_6_) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + p_73729_5_), (double)(p_73729_2_ + 0), 0.0, (double)((float)(p_73729_3_ + (flip ? 0 : p_73729_5_)) * f), (double)((float)(p_73729_4_ + 0) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + 0), (double)(p_73729_2_ + 0), 0.0, (double)((float)(p_73729_3_ + (flip ? p_73729_5_ : 0)) * f), (double)((float)(p_73729_4_ + 0) * f1));
        tessellator.func_78381_a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawEntityOnScreen(int p_147046_0_, int p_147046_1_, int p_147046_2_, EntityLivingBase p_147046_5_, boolean flip) {
        double cos;
        if ((p_147046_5_ = (EntityLivingBase)this.mc.field_71441_e.func_73045_a(p_147046_5_.func_145782_y())) == null) {
            return;
        }
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)p_147046_0_, (float)p_147046_1_, (float)50.0f);
        GL11.glScalef((float)(-p_147046_2_), (float)p_147046_2_, (float)p_147046_2_);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = p_147046_5_.field_70761_aq;
        float f3 = p_147046_5_.field_70177_z;
        float f6 = p_147046_5_.field_70759_as;
        RenderHelper.func_74519_b();
        GL11.glRotatef((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float width = p_147046_5_.field_70130_N * (float)p_147046_2_ / 30.0f;
        if (width < 1.0f) {
            width = 1.0f;
        }
        if ((cos = Math.sqrt(2.0) / 2.0 / (double)width) > 1.0) {
            cos = 1.0;
        }
        float rotation = (float)Math.toDegrees(Math.acos(cos));
        GL11.glRotatef((float)((float)(flip ? 0 : 90) - rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        p_147046_5_.field_70761_aq = 0.0f;
        p_147046_5_.field_70177_z = 0.0f;
        p_147046_5_.field_70759_as = f6 - f2;
        GL11.glTranslatef((float)0.0f, (float)(-p_147046_5_.field_70131_O / 2.0f), (float)0.0f);
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        boolean hideGUIBU = this.mc.field_71474_y.field_74319_N;
        this.mc.field_71474_y.field_74319_N = true;
        try {
            RenderManager.field_78727_a.func_147940_a((Entity)p_147046_5_, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        }
        finally {
            this.mc.field_71474_y.field_74319_N = hideGUIBU;
        }
        GL11.glDisable((int)3042);
        p_147046_5_.field_70761_aq = f2;
        p_147046_5_.field_70177_z = f3;
        p_147046_5_.field_70759_as = f6;
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public void drawCenteredArmour(int x, int y, int w, int h, int width, int height) {
        int slot;
        for (slot = 2; slot < 4; ++slot) {
            this.drawItemWithEnchants(false, this.mc.field_71439_g.field_71071_by.field_70460_b[slot], x + w / 2 - 91 - 3, y + 3 + 19 - 19 * (slot - 2), true, false);
        }
        for (slot = 0; slot < 2; ++slot) {
            this.drawItemWithEnchants(false, this.mc.field_71439_g.field_71071_by.field_70460_b[slot], x + w / 2 + 91 + 3, y + 3 + 19 - 19 * slot, false, false);
        }
        int iconY = y > height / 2 ? y - 16 : y + h;
        boolean bow = this.hasABow();
        BPVPModSettings settings = this.modMain.getBPVPSettings();
        boolean showMainHand = this.mc.field_71439_g.field_71071_by.func_70448_g() != null && settings.armourStatusMainHand;
        int heldItemsCenteredPosition = settings.heldItemsCenteredPosition;
        if (heldItemsCenteredPosition == 0) {
            if (showMainHand) {
                this.drawItemWithEnchants(false, this.mc.field_71439_g.field_71071_by.func_70448_g(), width - 3, iconY, true, settings.showFullAmount);
            }
        } else if (showMainHand) {
            this.drawItemWithEnchants(false, this.mc.field_71439_g.field_71071_by.func_70448_g(), x + w / 2 + 94, iconY, false, settings.showFullAmount);
        }
        if (bow && settings.getArchery()) {
            ItemStack arrow = this.getArrowsStack((EntityPlayer)this.mc.field_71439_g);
            int arrowY = y > height / 2 ? iconY - 19 : iconY + 19;
            if (heldItemsCenteredPosition == 0) {
                this.drawItemWithEnchants(true, arrow, width - 3, arrowY, true, false);
            } else {
                this.drawItemWithEnchants(true, arrow, x + w / 2 + 94, arrowY, false, false);
            }
        }
    }

    public void drawClassicArmour(int x, int y, int w, int h, int width, int height, boolean flip) {
        ItemStack[] items = new ItemStack[5];
        String drawEnchants = null;
        boolean itemUp = y > height / 2;
        ItemStack heldStack = this.modMain.getBPVPSettings().armourStatusMainHand ? this.mc.field_71439_g.field_71071_by.func_70448_g() : null;
        items[0] = itemUp ? heldStack : this.mc.field_71439_g.field_71071_by.field_70460_b[3];
        items[1] = this.mc.field_71439_g.field_71071_by.field_70460_b[itemUp ? 3 : 2];
        items[2] = this.mc.field_71439_g.field_71071_by.field_70460_b[itemUp ? 2 : 1];
        items[3] = this.mc.field_71439_g.field_71071_by.field_70460_b[itemUp ? 1 : 0];
        items[4] = itemUp ? this.mc.field_71439_g.field_71071_by.field_70460_b[0] : heldStack;
        int iconX = x + (flip ? w - 3 : 3);
        for (int i = 0; i < items.length; ++i) {
            ItemStack stack = items[i];
            if (stack == null) continue;
            boolean enchanted = stack.func_77948_v();
            drawEnchants = this.drawEnchants(enchanted ? stack.func_77986_q() : null);
            String str = this.getDamageString(stack);
            if (!this.modMain.getBPVPSettings().getShowEnchants()) {
                drawEnchants = null;
            }
            this.drawItemWithName(false, stack, str, drawEnchants, iconX, y + 3 + 19 * i, flip, this.modMain.getBPVPSettings().showFullAmount && (itemUp && i == 0 || !itemUp && i == 4));
        }
        if (this.modMain.getBPVPSettings().getArchery() && this.hasABow()) {
            ItemStack arrow = this.getArrowsStack((EntityPlayer)this.mc.field_71439_g);
            int arrowY = itemUp ? y - 16 : y + h;
            this.drawItemWithEnchants(true, arrow, iconX, arrowY, flip, false);
        }
    }

    public void renderArrows(int bow, int iconY, int y, int height, int width) {
        if (this.modMain.getBPVPSettings().getArchery()) {
            ItemStack arrow = this.getArrowsStack((EntityPlayer)this.mc.field_71439_g);
            int arrowY = y > height / 2 ? iconY - 19 : iconY + 19;
            this.drawItemWithEnchants(true, arrow, bow == 0 ? width - 3 : 3, arrowY, bow == 0, false);
        }
    }

    private ItemStack getArrowsStack(EntityPlayer player) {
        if (this.isArrows(player.func_71045_bC())) {
            return player.func_71045_bC();
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isArrows(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    private boolean isArrows(ItemStack stack) {
        return stack != null && stack.func_77973_b() == Items.field_151032_g;
    }

    public void drawItemWithEnchants(boolean arrows, ItemStack stack, int x, int y, boolean flipped, boolean fullSize) {
        if (stack == null) {
            return;
        }
        boolean enchanted = stack.func_77948_v();
        String drawEnchants = this.drawEnchants(enchanted ? stack.func_77986_q() : null);
        String str = !arrows ? this.getDamageString(stack) : this.getArrowAmountString(stack);
        if (!this.modMain.getBPVPSettings().getShowEnchants()) {
            drawEnchants = null;
        }
        this.drawItemWithName(arrows, stack, str, drawEnchants, x, y, flipped, fullSize);
    }

    public void drawItemWithName(boolean arrows, ItemStack stack, String name, String name1, int x, int y, boolean flipped, boolean fullSize) {
        if (stack == null) {
            return;
        }
        int iconX = x - (flipped ? 16 : 0);
        int iconY = y;
        int stringX = iconX + (flipped ? -3 - this.mc.field_71466_p.func_78256_a(name) : 19);
        int stringY = iconY;
        int enchantX = iconX + (flipped ? -3 - this.mc.field_71466_p.func_78256_a(name1) : 19);
        int enchantY = iconY + 9;
        this.mc.field_71466_p.func_78261_a(name, stringX, stringY, 0xFFFFFF);
        if (name1 != null) {
            this.mc.field_71466_p.func_78261_a(name1, enchantX, enchantY, 0xFFFFFF);
        }
        RenderHelper.func_74520_c();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        this.itemRenderer.field_77023_b -= 1000.0f;
        this.itemRenderer.func_82406_b(this.mc.field_71466_p, this.mc.func_110434_K(), stack, iconX, iconY);
        this.itemRenderer.field_77023_b += 1000.0f;
        int size = stack.field_77994_a;
        String sizeString = "" + size;
        if (fullSize) {
            size = this.getFullItemAmount(stack.func_77973_b());
            sizeString = "" + size;
        }
        if (size <= 1 || arrows) {
            sizeString = "";
        }
        this.itemRenderer.func_94148_a(this.mc.field_71466_p, this.mc.func_110434_K(), stack, iconX, iconY, sizeString);
        RenderHelper.func_74518_a();
    }

    public boolean tntIsAround() {
        for (int i = 0; i < this.mc.field_71439_g.field_70170_p.field_72996_f.size(); ++i) {
            if (!(this.mc.field_71439_g.field_70170_p.field_72996_f.get(i) instanceof EntityTNTPrimed) && (!(this.mc.field_71439_g.field_70170_p.field_72996_f.get(i) instanceof EntityCreeper) || ((EntityCreeper)this.mc.field_71439_g.field_70170_p.field_72996_f.get(i)).func_70832_p() <= 0 && !((EntityCreeper)this.mc.field_71439_g.field_70170_p.field_72996_f.get(i)).func_146078_ca())) continue;
            Entity e = (Entity)this.mc.field_71439_g.field_70170_p.field_72996_f.get(i);
            if (!(e.field_70165_t - this.mc.field_71439_g.field_70165_t < 5.0) || !(e.field_70165_t - this.mc.field_71439_g.field_70165_t > -5.0) || !(e.field_70163_u - this.mc.field_71439_g.field_70163_u < 5.0) || !(e.field_70163_u - this.mc.field_71439_g.field_70163_u > -5.0) || !(e.field_70161_v - this.mc.field_71439_g.field_70161_v < 5.0) || !(e.field_70161_v - this.mc.field_71439_g.field_70161_v > -5.0)) continue;
            return true;
        }
        return false;
    }

    public boolean arrowIsAround() {
        if (System.currentTimeMillis() - arrowWas < 5000L) {
            return true;
        }
        for (int i = 0; i < this.mc.field_71439_g.field_70170_p.field_72996_f.size(); ++i) {
            Entity e = (Entity)this.mc.field_71439_g.field_70170_p.field_72996_f.get(i);
            if (!(e instanceof EntityArrow) || e.field_70142_S == e.field_70165_t && e.field_70137_T == e.field_70163_u && e.field_70136_U == e.field_70161_v || ((EntityArrow)e).field_70250_c == this.mc.field_71439_g || !(e.field_70165_t - this.mc.field_71439_g.field_70165_t < 5.0) || !(e.field_70165_t - this.mc.field_71439_g.field_70165_t > -5.0) || !(e.field_70163_u - this.mc.field_71439_g.field_70163_u < 5.0) || !(e.field_70163_u - this.mc.field_71439_g.field_70163_u > -5.0) || !(e.field_70161_v - this.mc.field_71439_g.field_70161_v < 5.0) || !(e.field_70161_v - this.mc.field_71439_g.field_70161_v > -5.0)) continue;
            arrowWas = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public int getFullItemAmount(Item item) {
        int toReturn = 0;
        for (int i = 0; i < this.mc.field_71439_g.field_71071_by.field_70462_a.length; ++i) {
            ItemStack stack = this.mc.field_71439_g.field_71071_by.field_70462_a[i];
            if (stack == null || stack.func_77973_b() != item) continue;
            toReturn += stack.field_77994_a;
        }
        return toReturn;
    }

    public String getArrowAmountString(ItemStack used) {
        String toReturn = null;
        int arrows = 0;
        for (int i = 0; i < this.mc.field_71439_g.field_71071_by.field_70462_a.length; ++i) {
            ItemStack stack = this.mc.field_71439_g.field_71071_by.field_70462_a[i];
            if (!this.isArrows(stack)) continue;
            arrows += stack.field_77994_a;
        }
        toReturn = used.field_77994_a + "/" + arrows;
        return toReturn;
    }

    public boolean hasABow() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.mc.field_71439_g.field_71071_by.field_70462_a[i];
            if (stack == null || !(stack.func_77973_b() instanceof ItemBow)) continue;
            return true;
        }
        return false;
    }

    public void displayDebuffEffects(Interface in, int width, int height) {
        block18: {
            Collection effects;
            int x = in.getX();
            int y = in.getY();
            int w = in.getW();
            int h = in.getH();
            boolean flippedVer = in.isFlipped();
            boolean flippedHor = in.shouldFlip(width);
            if (flippedVer) {
                y = y + h - 30;
            }
            if ((effects = this.mc.field_71439_g.func_70651_bq()).isEmpty()) break block18;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            if (!in.isCentered()) {
                int rowHeight = 25;
                if (effects.size() > 6) {
                    rowHeight = 135 / (effects.size() - 1);
                }
                for (PotionEffect effectInstance : effects) {
                    int duration = effectInstance.func_76459_b();
                    if (duration <= 200 && !BPVPInterfaceHandler.blinking && this.modMain.getBPVPSettings().potionEffectsBlink) {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                    } else {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    Potion effect = Potion.field_76425_a[effectInstance.func_76456_a()];
                    this.mc.func_110434_K().func_110577_a(BPVPInterfaceHandler.invtextures);
                    int effectX = flippedHor ? x + w - 24 : x + 6;
                    int effectY = y + 7;
                    if (effect.func_76400_d()) {
                        int iconIndex = effect.func_76392_e();
                        this.mc.field_71456_v.func_73729_b(effectX, effectY, 0 + iconIndex % 8 * 18, 198 + iconIndex / 8 * 18, 18, 18);
                    }
                    effect.renderInventoryEffect(effectX - 6, effectY - 7, effectInstance, this.mc);
                    String potionName = I18n.func_135052_a((String)effect.func_76393_a(), (Object[])new Object[0]);
                    if (effectInstance.func_76458_c() == 1) {
                        potionName = potionName + " II";
                    } else if (effectInstance.func_76458_c() == 2) {
                        potionName = potionName + " III";
                    } else if (effectInstance.func_76458_c() == 3) {
                        potionName = potionName + " IV";
                    }
                    String durationString = Potion.func_76389_a((PotionEffect)effectInstance);
                    if (!this.modMain.getBPVPSettings().getShowEffectNames()) {
                        potionName = durationString;
                        durationString = "";
                    }
                    this.mc.field_71466_p.func_78261_a(potionName, flippedHor ? x + w - 28 - this.mc.field_71466_p.func_78256_a(potionName) : x + 10 + 18, y + 6, 0xFFFFFF);
                    this.mc.field_71466_p.func_78261_a(durationString, flippedHor ? x + w - 28 - this.mc.field_71466_p.func_78256_a(durationString) : x + 10 + 18, y + 6 + 10, 0xFFFFFF);
                    y += flippedVer ? -rowHeight : rowHeight;
                }
            } else {
                int columnWidth = 27;
                int defaultEffectAmount = 182 / columnWidth;
                if (effects.size() > defaultEffectAmount) {
                    columnWidth = 182 / effects.size();
                }
                int totalSize = effects.size() * columnWidth;
                int currentX = x + w / 2 - totalSize / 2 + (columnWidth - 18) / 2;
                int currentY = in.getY() + 7;
                for (PotionEffect effectInstance : effects) {
                    int duration = effectInstance.func_76459_b();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (duration <= 200 && !BPVPInterfaceHandler.blinking && this.modMain.getBPVPSettings().potionEffectsBlink) {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                    }
                    Potion effect = Potion.field_76425_a[effectInstance.func_76456_a()];
                    this.mc.func_110434_K().func_110577_a(BPVPInterfaceHandler.invtextures);
                    if (effect.func_76400_d()) {
                        int iconIndex = effect.func_76392_e();
                        this.mc.field_71456_v.func_73729_b(currentX, currentY, 0 + iconIndex % 8 * 18, 198 + iconIndex / 8 * 18, 18, 18);
                    }
                    effect.renderInventoryEffect(currentX - 6, currentY - 7, effectInstance, this.mc);
                    String durationString = Potion.func_76389_a((PotionEffect)effectInstance);
                    int amplifier = effectInstance.func_76458_c();
                    String levelString = amplifier > 0 ? "" + (effectInstance.func_76458_c() + 1) : "";
                    this.mc.field_71466_p.func_78261_a(levelString, currentX, currentY, 0xFFFFFF);
                    this.mc.field_71466_p.func_78261_a(durationString, currentX + 10 - this.mc.field_71466_p.func_78256_a(durationString) / 2, currentY + 15, 0xFFFFFF);
                    currentX += columnWidth;
                }
            }
        }
    }

    public String getDamageString(ItemStack stack) {
        String toReturn = stack.func_77973_b().func_77653_i(stack);
        try {
            if (((ItemFood)stack.func_77973_b()).func_150905_g(stack) > 0) {
                return I18n.func_135052_a((String)"gui.xaero_restores", (Object[])new Object[0]) + " " + (double)((ItemFood)stack.func_77973_b()).func_150905_g(stack) / 2.0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stack.func_77958_k() == 0) {
            return toReturn;
        }
        if (this.modMain.getBPVPSettings().durability == 3) {
            return "";
        }
        int percent = (stack.func_77958_k() - stack.func_77952_i()) * 100 / stack.func_77958_k();
        if (this.modMain.getBPVPSettings().durability == 0) {
            toReturn = percent + "%";
        } else if (this.modMain.getBPVPSettings().durability == 1) {
            toReturn = stack.func_77958_k() - stack.func_77952_i() + 1 + "/" + (stack.func_77958_k() + 1);
        } else if (this.modMain.getBPVPSettings().durability == 2) {
            toReturn = stack.func_77958_k() - stack.func_77952_i() + 1 + "/" + (stack.func_77958_k() + 1) + " (" + percent + "%)";
        }
        if (percent <= 5) {
            toReturn = "\u00a7d" + toReturn;
        } else if (percent <= 25) {
            toReturn = "\u00a7c" + toReturn;
        } else if (percent <= 50) {
            toReturn = "\u00a76" + toReturn;
        } else if (percent <= 75) {
            toReturn = "\u00a7e" + toReturn;
        }
        return toReturn;
    }

    private String drawEnchants(NBTTagList etl) {
        if (etl == null) {
            return null;
        }
        String s = "";
        int count = etl.func_74745_c();
        for (int i = 0; i < count; ++i) {
            short short1 = etl.func_150305_b(i).func_74765_d("id");
            short short2 = etl.func_150305_b(i).func_74765_d("lvl");
            String e = "";
            if (Enchantment.field_77331_b[short1] != null) {
                e = Enchantment.field_77331_b[short1].func_77316_c((int)short2);
            }
            e = this.translateEchant(e, count);
            s = s + e + ", ";
        }
        if (s.length() >= 2) {
            s = s.substring(0, s.length() - 2);
        }
        return "\u00a7" + ModSettings.ENCHANT_COLORS[this.modMain.getBPVPSettings().enchantColor] + s;
    }

    private String translateEchant(String s, int count) {
        if (s == null || s.length() == 0) {
            return "";
        }
        if (count <= 1) {
            return s;
        }
        String[] words = s.split(" ");
        s = "";
        for (int i = 0; i < words.length; ++i) {
            String s1 = words[i];
            s = s + (i == words.length - 1 ? " " + s1 : (s1.length() > 2 ? s1.substring(0, 1).toUpperCase() : s1));
        }
        return s;
    }

    public static class GuiScreenAccess
    extends GuiScreen {
        public void drawHoveringText(List textLines, int x, int y, FontRenderer font) {
            super.drawHoveringText(textLines, x, y, font);
        }
    }
}

