/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.trace;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SpriteCoordinateExpander;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.lwjgl.opengl.GL11;
import xaero.common.core.IBufferSource;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.CustomRenderTypes;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.lib.client.graphics.XaeroRenderType;
import xaero.lib.common.reflection.util.ReflectionUtils;

public class EntityRenderTracer {
    public static boolean TRACING_MODEL_RENDERS;
    private Entity tracedEntity;
    private EntityRenderer tracedEntityRenderer;
    private Class<?> tracedEntityModelClass;
    private List<ModelRenderTrace> traceResultList;
    private ModelRenderTrace lastModelRenderDetected;
    private MultiBufferSource.BufferSource modelRenderDetectionRenderTypeBuffer;
    private Class<?> compositeRenderTypeClass;
    private Field enderDragonModelField;
    private Field stateField;
    private Class<?> textureStateShardClass;
    private Field compositeStateTextureStateField;
    private Field textureStateShardTextureField;
    private Field compositeStateDepthTestStateField;
    private Field compositeStateWriteMaskStateField;
    private Field compositeStateCullStateField;
    private Field compositeStateTransparencyStateField;
    private Field compositeStateShaderStateField;
    private Field renderBuffersBufferSourceField;
    private Field spriteCoordinateExpanderSpriteField;
    private Class<?> irisRenderLayerWrapperClass;
    private Method irisRenderLayerWrapperUnwrapMethod;

    public EntityRenderTracer() {
        this.initReflection();
        this.traceResultList = new ArrayList<ModelRenderTrace>();
    }

    public <T extends Entity> List<ModelRenderTrace> trace(PoseStack matrixStack, T entity, EntityRenderer<? super T> entityRenderer) {
        TRACING_MODEL_RENDERS = true;
        this.tracedEntity = entity;
        this.tracedEntityRenderer = entityRenderer;
        this.tracedEntityModelClass = null;
        this.traceResultList.clear();
        this.lastModelRenderDetected = null;
        PoseStack.Pose matrixEntryToRestore = matrixStack.last();
        matrixStack.pushPose();
        try {
            MultiBufferSource.BufferSource renderTypeBuffer = this.modelRenderDetectionRenderTypeBuffer = (MultiBufferSource.BufferSource)ReflectionUtils.getReflectFieldValue((Object)Minecraft.getInstance().renderBuffers(), (Field)this.renderBuffersBufferSourceField);
            ((IBufferSource)renderTypeBuffer).setXaero_lastRenderType(null);
            entityRenderer.render(entity, 0.0f, 1.0f, matrixStack, (MultiBufferSource)renderTypeBuffer, 0xF000F0);
            renderTypeBuffer.endBatch();
            OpenGLException.checkGLError();
        }
        catch (Throwable e) {
            this.traceResultList.clear();
            MinimapLogs.LOGGER.error("Exception when calling the full entity renderer for {} before prerendering the icon.", (Object)entity.getScoreboardName(), (Object)e);
        }
        TRACING_MODEL_RENDERS = false;
        this.tracedEntity = null;
        this.tracedEntityRenderer = null;
        while (matrixStack.last() != matrixEntryToRestore) {
            matrixStack.popPose();
        }
        while (GL11.glGetError() != 0) {
        }
        return this.traceResultList;
    }

    public void onModelRender(EntityModel<?> model, VertexConsumer vertexConsumer, int color) {
        this.lastModelRenderDetected = null;
        if (this.tracedEntityModelClass == null) {
            EntityModel currentMainModel = this.getEntityRendererModel(this.tracedEntityRenderer);
            Class<?> clazz = this.tracedEntityModelClass = currentMainModel == null ? null : currentMainModel.getClass();
            if (this.tracedEntityModelClass == null) {
                return;
            }
        }
        if (!model.getClass().isAssignableFrom(this.tracedEntityModelClass) && !this.tracedEntityModelClass.isAssignableFrom(model.getClass())) {
            return;
        }
        RenderType lastRenderType = this.getLastRenderType((MultiBufferSource)this.modelRenderDetectionRenderTypeBuffer);
        if (lastRenderType == null && this.traceResultList.isEmpty()) {
            ResourceLocation textureLocation = null;
            try {
                ResourceLocation textureLocationUnchecked;
                textureLocation = textureLocationUnchecked = this.tracedEntityRenderer.getTextureLocation(this.tracedEntity);
            }
            catch (Throwable t) {
                MinimapLogs.LOGGER.error("Couldn't fetch main entity texture when trying to use an alternative render type for an icon!", t);
            }
            if (textureLocation != null) {
                lastRenderType = model.renderType(textureLocation);
            }
        }
        if (lastRenderType == null) {
            return;
        }
        Object renderState = this.getRenderState(lastRenderType);
        if (renderState == null) {
            return;
        }
        Object renderTextureState = ReflectionUtils.getReflectFieldValue((Object)renderState, (Field)this.compositeStateTextureStateField);
        ResourceLocation texture = null;
        if (this.textureStateShardClass.isAssignableFrom(renderTextureState.getClass())) {
            texture = this.getRenderStateTextureStateTexture(renderTextureState);
        }
        Object renderTransparencyState = ReflectionUtils.getReflectFieldValue((Object)renderState, (Field)this.compositeStateTransparencyStateField);
        renderTransparencyState = this.fixAdditiveTransparency(renderTransparencyState);
        Object renderDepthTestState = ReflectionUtils.getReflectFieldValue((Object)renderState, (Field)this.compositeStateDepthTestStateField);
        Object renderWriteMaskState = ReflectionUtils.getReflectFieldValue((Object)renderState, (Field)this.compositeStateWriteMaskStateField);
        Object renderCullState = ReflectionUtils.getReflectFieldValue((Object)renderState, (Field)this.compositeStateCullStateField);
        Object renderShaderState = ReflectionUtils.getReflectFieldValue((Object)renderState, (Field)this.compositeStateShaderStateField);
        CustomRenderTypes.EntityIconLayerPhases layerPhases = new CustomRenderTypes.EntityIconLayerPhases(renderTextureState, renderTransparencyState, renderDepthTestState, renderWriteMaskState, renderCullState, renderShaderState);
        TextureAtlasSprite renderAtlasSprite = null;
        if (vertexConsumer instanceof SpriteCoordinateExpander) {
            renderAtlasSprite = (TextureAtlasSprite)ReflectionUtils.getReflectFieldValue((Object)vertexConsumer, (Field)this.spriteCoordinateExpanderSpriteField);
        }
        this.lastModelRenderDetected = new ModelRenderTrace(model, texture, renderAtlasSprite, layerPhases, color);
        this.traceResultList.add(this.lastModelRenderDetected);
    }

    private Object fixAdditiveTransparency(Object renderTransparencyState) {
        int blendSrcFactor;
        Object result = renderTransparencyState;
        ((RenderStateShard)renderTransparencyState).setupRenderState();
        int blendDestFactor = GL11.glGetInteger((int)32968);
        if (blendDestFactor == 1 && (blendSrcFactor = GL11.glGetInteger((int)32969)) != 0) {
            result = XaeroRenderType.getTransparencyPhase((int)blendSrcFactor, (int)blendDestFactor, (int)0, (int)1);
        }
        ((RenderStateShard)renderTransparencyState).clearRenderState();
        return result;
    }

    public void onModelPartRender(ModelPart modelRenderer, int color) {
        if (this.lastModelRenderDetected != null) {
            this.lastModelRenderDetected.addVisibleModelPart(modelRenderer, color);
        }
    }

    private RenderType getLastRenderType(MultiBufferSource renderTypeBuffer) {
        if (renderTypeBuffer instanceof IBufferSource) {
            IBufferSource xaeroBufferSource = (IBufferSource)renderTypeBuffer;
            return xaeroBufferSource.getXaero_lastRenderType();
        }
        return null;
    }

    private Object getRenderState(RenderType renderType) {
        while (renderType.getClass() == this.irisRenderLayerWrapperClass && this.irisRenderLayerWrapperUnwrapMethod != null) {
            renderType = (RenderType)ReflectionUtils.getReflectMethodValue((Object)renderType, (Method)this.irisRenderLayerWrapperUnwrapMethod, (Object[])new Object[0]);
        }
        if (renderType.getClass() == this.compositeRenderTypeClass) {
            return ReflectionUtils.getReflectFieldValue((Object)renderType, (Field)this.stateField);
        }
        return null;
    }

    private ResourceLocation getRenderStateTextureStateTexture(Object renderTextureState) {
        Object renderStateTextureObject = ReflectionUtils.getReflectFieldValue((Object)renderTextureState, (Field)this.textureStateShardTextureField);
        if (!(renderStateTextureObject instanceof Optional)) {
            return (ResourceLocation)renderStateTextureObject;
        }
        Optional optional = (Optional)renderStateTextureObject;
        return optional.orElse(null);
    }

    public <T extends Entity> EntityModel<T> getEntityRendererModel(EntityRenderer<? super T> entityRenderer) {
        if (entityRenderer instanceof LivingEntityRenderer) {
            return ((LivingEntityRenderer)entityRenderer).getModel();
        }
        if (entityRenderer instanceof EnderDragonRenderer) {
            return (EntityModel)ReflectionUtils.getReflectFieldValue(entityRenderer, (Field)this.enderDragonModelField);
        }
        return null;
    }

    private void initReflection() {
        this.enderDragonModelField = ReflectionUtils.getFieldReflection(EnderDragonRenderer.class, (String)"model", (String)"field_21008", (String)"Lnet/minecraft/class_895$class_625;", (String)"f_114183_");
        try {
            this.compositeRenderTypeClass = ReflectionUtils.getClassForName((String)"net.minecraft.class_1921$class_4687", (String)"net.minecraft.client.renderer.RenderType$CompositeRenderType");
            this.stateField = ReflectionUtils.getFieldReflection(this.compositeRenderTypeClass, (String)"state", (String)"field_21403", (String)"Lnet/minecraft/class_1921$class_4688;", (String)"f_110511_");
            Class compositeStateClass = ReflectionUtils.getClassForName((String)"net.minecraft.class_1921$class_4688", (String)"net.minecraft.client.renderer.RenderType$CompositeState");
            this.textureStateShardClass = ReflectionUtils.getClassForName((String)"net.minecraft.class_4668$class_4683", (String)"net.minecraft.client.renderer.RenderStateShard$TextureStateShard");
            this.compositeStateTextureStateField = ReflectionUtils.getFieldReflection((Class)compositeStateClass, (String)"textureState", (String)"field_21406", (String)"Lnet/minecraft/class_4668$class_5939;", (String)"f_110576_");
            this.textureStateShardTextureField = ReflectionUtils.getFieldReflection(this.textureStateShardClass, (String)"texture", (String)"field_21397", (String)"Ljava/util/Optional;", (String)"f_110328_");
            this.compositeStateTransparencyStateField = ReflectionUtils.getFieldReflection((Class)compositeStateClass, (String)"transparencyState", (String)"field_21407", (String)"Lnet/minecraft/class_4668$class_4685;", (String)"f_110577_");
            this.compositeStateDepthTestStateField = ReflectionUtils.getFieldReflection((Class)compositeStateClass, (String)"depthTestState", (String)"field_21411", (String)"Lnet/minecraft/class_4668$class_4672;", (String)"f_110581_");
            this.compositeStateWriteMaskStateField = ReflectionUtils.getFieldReflection((Class)compositeStateClass, (String)"writeMaskState", (String)"field_21419", (String)"Lnet/minecraft/class_4668$class_4686;", (String)"f_110589_");
            this.compositeStateCullStateField = ReflectionUtils.getFieldReflection((Class)compositeStateClass, (String)"cullState", (String)"field_21412", (String)"Lnet/minecraft/class_4668$class_4671;", (String)"f_110582_");
            this.compositeStateShaderStateField = ReflectionUtils.getFieldReflection((Class)compositeStateClass, (String)"shaderState", (String)"field_29461", (String)"Lnet/minecraft/class_4668$class_5942;", (String)"f_173274_");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        this.renderBuffersBufferSourceField = ReflectionUtils.getFieldReflection(RenderBuffers.class, (String)"bufferSource", (String)"field_46901", (String)"Lnet/minecraft/class_4597$class_4598;", (String)"f_110094_");
        this.spriteCoordinateExpanderSpriteField = ReflectionUtils.getFieldReflection(SpriteCoordinateExpander.class, (String)"sprite", (String)"field_21731", (String)"Lnet/minecraft/class_1058;", (String)"f_110796_");
        try {
            try {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderTypeWrapper");
            }
            catch (ClassNotFoundException e) {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderLayerWrapper");
            }
            this.irisRenderLayerWrapperUnwrapMethod = ReflectionUtils.getMethodReflection(this.irisRenderLayerWrapperClass, (String)"unwrap", (String)"unwrap", (String)"()Lnet/minecraft/class_1921;", (String)"unwrap", (Class[])new Class[0]);
            MinimapLogs.LOGGER.info("Old Iris detected and supported!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

