/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.render.pipeline;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.LogicOp;
import com.mojang.blaze3d.platform.PolygonMode;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.ShaderDefines;
import net.minecraft.resources.ResourceLocation;

public class RenderPipelineWrapper
extends RenderPipeline {
    private final RenderPipeline original;
    private Optional<ResourceLocation> vertexShaderOverride;
    private Optional<ResourceLocation> fragmentShaderOverride;
    private Optional<ShaderDefines> shaderDefinesOverride;
    private Optional<List<String>> samplersOverride;
    private Optional<List<RenderPipeline.UniformDescription>> uniformsOverride;
    private Optional<DepthTestFunction> depthTestFunctionOverride;
    private Optional<PolygonMode> polygonModeOverride;
    private Optional<Boolean> cullOverride;
    private Optional<LogicOp> colorLogicOverride;
    private Optional<Optional<BlendFunction>> blendFunctionOverride;
    private Optional<Boolean> writeColorOverride;
    private Optional<Boolean> writeAlphaOverride;
    private Optional<Boolean> writeDepthOverride;
    private Optional<VertexFormat> vertexFormatOverride;
    private Optional<VertexFormat.Mode> vertexFormatModeOverride;
    private Optional<Float> depthBiasScaleFactorOverride;
    private Optional<Float> depthBiasConstantOverride;
    private Optional<Integer> sortKeyOverride;

    public RenderPipelineWrapper(ResourceLocation location, RenderPipeline original) {
        super(location, null, null, null, null, null, null, null, null, false, false, false, false, null, null, null, 0.0f, 0.0f, 0);
        this.original = original;
    }

    public DepthTestFunction getDepthTestFunction() {
        if (this.depthTestFunctionOverride != null) {
            return this.depthTestFunctionOverride.get();
        }
        return this.original.getDepthTestFunction();
    }

    public PolygonMode getPolygonMode() {
        if (this.polygonModeOverride != null) {
            return this.polygonModeOverride.get();
        }
        return this.original.getPolygonMode();
    }

    public boolean isCull() {
        if (this.cullOverride != null) {
            return this.cullOverride.get();
        }
        return this.original.isCull();
    }

    public LogicOp getColorLogic() {
        if (this.colorLogicOverride != null) {
            return this.colorLogicOverride.get();
        }
        return this.original.getColorLogic();
    }

    public Optional<BlendFunction> getBlendFunction() {
        if (this.blendFunctionOverride != null) {
            return this.blendFunctionOverride.get();
        }
        return this.original.getBlendFunction();
    }

    public boolean isWriteColor() {
        if (this.writeColorOverride != null) {
            return this.writeColorOverride.get();
        }
        return this.original.isWriteColor();
    }

    public boolean isWriteAlpha() {
        if (this.writeAlphaOverride != null) {
            return this.writeAlphaOverride.get();
        }
        return this.original.isWriteAlpha();
    }

    public boolean isWriteDepth() {
        if (this.writeDepthOverride != null) {
            return this.writeDepthOverride.get();
        }
        return this.original.isWriteDepth();
    }

    public float getDepthBiasScaleFactor() {
        if (this.depthBiasScaleFactorOverride != null) {
            return this.depthBiasScaleFactorOverride.get().floatValue();
        }
        return this.original.getDepthBiasScaleFactor();
    }

    public float getDepthBiasConstant() {
        if (this.depthBiasConstantOverride != null) {
            return this.depthBiasConstantOverride.get().floatValue();
        }
        return this.original.getDepthBiasConstant();
    }

    public VertexFormat getVertexFormat() {
        if (this.vertexFormatOverride != null) {
            return this.vertexFormatOverride.get();
        }
        return this.original.getVertexFormat();
    }

    public VertexFormat.Mode getVertexFormatMode() {
        if (this.vertexFormatModeOverride != null) {
            return this.vertexFormatModeOverride.get();
        }
        return this.original.getVertexFormatMode();
    }

    public ResourceLocation getVertexShader() {
        if (this.vertexShaderOverride != null) {
            return this.vertexShaderOverride.get();
        }
        return this.original.getVertexShader();
    }

    public ResourceLocation getFragmentShader() {
        if (this.fragmentShaderOverride != null) {
            return this.fragmentShaderOverride.get();
        }
        return this.original.getFragmentShader();
    }

    public ShaderDefines getShaderDefines() {
        if (this.shaderDefinesOverride != null) {
            return this.shaderDefinesOverride.get();
        }
        return this.original.getShaderDefines();
    }

    public List<String> getSamplers() {
        if (this.samplersOverride != null) {
            return this.samplersOverride.get();
        }
        return this.original.getSamplers();
    }

    public List<RenderPipeline.UniformDescription> getUniforms() {
        if (this.uniformsOverride != null) {
            return this.uniformsOverride.get();
        }
        return this.original.getUniforms();
    }

    public int getSortKey() {
        if (this.sortKeyOverride != null) {
            return this.sortKeyOverride.get();
        }
        return this.original.getSortKey();
    }

    public boolean wantsDepthTexture() {
        if (this.depthTestFunctionOverride == null && this.depthBiasConstantOverride == null && this.depthBiasScaleFactorOverride == null && this.writeDepthOverride == null) {
            return this.original.wantsDepthTexture();
        }
        return this.getDepthTestFunction() != DepthTestFunction.NO_DEPTH_TEST || this.getDepthBiasConstant() != 0.0f || this.getDepthBiasScaleFactor() != 0.0f || this.isWriteDepth();
    }

    public void setVertexShaderOverride(ResourceLocation vertexShaderOverride) {
        this.vertexShaderOverride = Optional.of(vertexShaderOverride);
    }

    public void setFragmentShaderOverride(ResourceLocation fragmentShaderOverride) {
        this.fragmentShaderOverride = Optional.of(fragmentShaderOverride);
    }

    public void setShaderDefinesOverride(ShaderDefines shaderDefinesOverride) {
        this.shaderDefinesOverride = Optional.of(shaderDefinesOverride);
    }

    public void setSamplersOverride(List<String> samplersOverride) {
        this.samplersOverride = Optional.of(samplersOverride);
    }

    public void setUniformsOverride(List<RenderPipeline.UniformDescription> uniformsOverride) {
        this.uniformsOverride = Optional.of(uniformsOverride);
    }

    public void setDepthTestFunctionOverride(DepthTestFunction depthTestFunctionOverride) {
        this.depthTestFunctionOverride = Optional.of(depthTestFunctionOverride);
    }

    public void setPolygonModeOverride(PolygonMode polygonModeOverride) {
        this.polygonModeOverride = Optional.of(polygonModeOverride);
    }

    public void setCullOverride(Boolean cullOverride) {
        this.cullOverride = Optional.of(cullOverride);
    }

    public void setColorLogicOverride(LogicOp colorLogicOverride) {
        this.colorLogicOverride = Optional.of(colorLogicOverride);
    }

    public void setBlendFunctionOverride(Optional<BlendFunction> blendFunctionOverride) {
        this.blendFunctionOverride = Optional.of(blendFunctionOverride);
    }

    public void setWriteColorOverride(boolean writeColorOverride) {
        this.writeColorOverride = Optional.of(writeColorOverride);
    }

    public void setWriteAlphaOverride(boolean writeAlphaOverride) {
        this.writeAlphaOverride = Optional.of(writeAlphaOverride);
    }

    public void setWriteDepthOverride(boolean writeDepthOverride) {
        this.writeDepthOverride = Optional.of(writeDepthOverride);
    }

    public void setVertexFormatOverride(VertexFormat vertexFormatOverride) {
        this.vertexFormatOverride = Optional.of(vertexFormatOverride);
    }

    public void setVertexFormatModeOverride(VertexFormat.Mode vertexFormatModeOverride) {
        this.vertexFormatModeOverride = Optional.of(vertexFormatModeOverride);
    }

    public void setDepthBiasScaleFactorOverride(float depthBiasScaleFactorOverride) {
        this.depthBiasScaleFactorOverride = Optional.of(Float.valueOf(depthBiasScaleFactorOverride));
    }

    public void setDepthBiasConstantOverride(float depthBiasConstantOverride) {
        this.depthBiasConstantOverride = Optional.of(Float.valueOf(depthBiasConstantOverride));
    }

    public void setSortKeyOverride(int sortKeyOverride) {
        this.sortKeyOverride = Optional.of(sortKeyOverride);
    }
}

