/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import com.mojang.authlib.GameProfile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientChatEvent;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import xaero.common.HudMod;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.events.ClientEvents;

public class ClientEventsNeoForge
extends ClientEvents {
    public ClientEventsNeoForge(HudMod modMain) {
        super(modMain);
    }

    @SubscribeEvent
    public void handleGuiOpenEvent(ScreenEvent.Opening event) {
        Screen guiBefore = event.getNewScreen();
        Screen gui = this.handleGuiOpen(guiBefore);
        if (guiBefore != null && gui == null) {
            event.setCanceled(true);
            return;
        }
        event.setNewScreen(gui);
    }

    @SubscribeEvent
    public void handleRenderGameOverlayEventPre(RenderGuiEvent.Pre event) {
        this.handleRenderGameOverlayEventPre(event.getGuiGraphics(), event.getPartialTick().getGameTimeDeltaPartialTick(true));
    }

    @SubscribeEvent
    public void handleRenderGameOverlayEventPost(RenderGuiEvent.Post event) {
        this.handleRenderGameOverlayEventPost();
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPreLayer(RenderGuiLayerEvent.Pre event) {
        if (event.getName().equals((Object)VanillaGuiLayers.EFFECTS) && this.handleRenderStatusEffectOverlay(event.getGuiGraphics())) {
            event.setCanceled(true);
        }
        if (event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR) && this.handleRenderCrosshairOverlay(event.getGuiGraphics())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPostLayer(RenderGuiLayerEvent.Post event) {
        if (event.getName().equals((Object)VanillaGuiLayers.EFFECTS)) {
            XaeroMinimapCore.onRenderStatusEffectOverlayPost(event.getGuiGraphics());
        }
    }

    @SubscribeEvent
    public void handleClientSendChatEvent(ClientChatEvent e) {
        if (this.handleClientSendChatEvent(e.getMessage())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleClientChatReceivedEvent(ClientChatReceivedEvent e) {
        GameProfile gameProfile;
        if (e.getMessage() == null) {
            return;
        }
        Component text = e.getMessage();
        PlayerInfo playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(e.getSender());
        GameProfile gameProfile2 = gameProfile = playerInfo == null ? null : playerInfo.getProfile();
        if (gameProfile != null && this.handleClientPlayerChatReceivedEvent(e.getBoundChatType(), text, gameProfile)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleRenderSolidBlocks(RenderLevelStageEvent.AfterOpaqueBlocks event) {
        XaeroMinimapCore.onWorldModelViewMatrix(event.getModelViewMatrix());
    }

    @SubscribeEvent
    public void handleDrawScreenEventPost(ScreenEvent.Render.Post event) {
        this.handleDrawScreenEventPost(event.getScreen());
    }

    @SubscribeEvent
    public void worldUnload(LevelEvent.Unload event) {
        this.worldUnload(event.getLevel());
    }

    @SubscribeEvent
    public void handleClientTickEventStart(ClientTickEvent.Pre event) {
        this.handleClientTickStart();
    }

    @SubscribeEvent
    public void handlePlayerTickEventStart(PlayerTickEvent.Pre event) {
        this.handlePlayerTickStart(event.getEntity());
    }

    @SubscribeEvent
    public void handleRenderTickEventStart(RenderFrameEvent.Pre event) {
        this.handleRenderTickStart();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleBossHealthRender(CustomizeGuiOverlayEvent.BossEventProgress event) {
        XaeroMinimapCore.onBossHealthRender(event.getY() + event.getIncrement());
    }
}

